/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHBrowserModelAdaptor {
    public static final int ALL_EXPERIMENTS = -1;
    public static final int ALL_CHROMOSOMES = -1;
    public static final int CLONE_VALUES_P_SCORE = 0;
    public static final int CLONE_VALUES_DYE_SWAP = 1;
    public static final int CLONE_VALUES_LOG_AVERAGE_INVERTED = 2;
    public static final int CLONE_VALUES_LOG_DYE_SWAP = 3;
    public static final int CLONE_VALUES_RATIOS = 4;
    public static final int CLONE_VALUES_LOG_RATIOS = 5;
    int cloneValueType;
    EventListenerList listenerList = new EventListenerList();
    int[] mapCloneToIndex;
    int[] mapIndexToClone;
    int[] experimentIndices;
    int chromosomeIndex;
    int numClones;
    IData data;

    public CGHBrowserModelAdaptor(IData data, int experimentIndex, int chromosomeIndex, int cloneValueType) {
        this.data = data;
        this.setExperimentIndex(experimentIndex);
        this.setChromosomeIndex(chromosomeIndex);
        this.cloneValueType = cloneValueType;
        this.setNumClones(data.getNumDataPointsInChrom(chromosomeIndex));
    }

    public void generateIndices() {
        int i;
        this.mapCloneToIndex = new int[this.numClones];
        int[] mapTmpIndexToClone = new int[this.numClones];
        ISlideData[] sampleData = new ISlideData[this.experimentIndices.length];
        for (int i2 = 0; i2 < this.experimentIndices.length; ++i2) {
            sampleData[i2] = (ISlideData)this.data.getFeaturesList().get(this.experimentIndices[i2]);
        }
        int chartIndex = 0;
        for (i = 0; i < this.numClones; ++i) {
            boolean isMissing = true;
            for (int sampleIndex = 0; sampleIndex < sampleData.length; ++sampleIndex) {
                if (sampleData[sampleIndex].isMissingData(this.getDataCloneIndex(i))) continue;
                isMissing = false;
                break;
            }
            if (isMissing) {
                this.mapCloneToIndex[i] = -1;
                continue;
            }
            this.mapCloneToIndex[i] = chartIndex;
            mapTmpIndexToClone[chartIndex] = i;
            ++chartIndex;
        }
        this.mapIndexToClone = new int[chartIndex];
        for (i = 0; i < this.mapIndexToClone.length; ++i) {
            this.mapIndexToClone[i] = mapTmpIndexToClone[i];
        }
    }

    public int getSeriesSize() {
        return this.mapIndexToClone.length;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public int getDataCloneIndex(int index) {
        if (this.chromosomeIndex == -1) {
            return index;
        }
        return this.data.getCloneIndex(index, this.chromosomeIndex);
    }

    public int getCloneIndex(int coordinateIndex) {
        return this.getDataCloneIndex(this.mapIndexToClone[coordinateIndex]);
    }

    public int getIndexOf(int cloneIndex) {
        return this.mapCloneToIndex[cloneIndex];
    }

    public int[] getMapCloneToIndex() {
        return this.mapCloneToIndex;
    }

    public void setMapCloneToIndex(int[] mapCloneToIndex) {
        this.mapCloneToIndex = mapCloneToIndex;
    }

    public int[] getMapIndexToClone() {
        return this.mapIndexToClone;
    }

    public void setMapIndexToClone(int[] mapIndexToClone) {
        this.mapIndexToClone = mapIndexToClone;
    }

    public int[] getExperimentIndices() {
        return this.experimentIndices;
    }

    public void setExperimentIndices(int[] experimentIndices) {
        this.experimentIndices = experimentIndices;
    }

    public int getChromosomeIndex() {
        return this.chromosomeIndex;
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.chromosomeIndex = chromosomeIndex;
        this.numClones = chromosomeIndex == -1 ? this.data.getFeaturesSize() : this.data.getNumDataPointsInChrom(chromosomeIndex);
        this.generateIndices();
        this.fireDataChanged();
    }

    public int getNumClones() {
        return this.numClones;
    }

    public void setNumClones(int numClones) {
        this.numClones = numClones;
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData data) {
        this.data = data;
    }

    public void setExperimentIndex(int experimentIndex) {
        System.out.println("CGHBrowserModelAdaptor.setExperimentIndex experimentIndex: " + experimentIndex);
        if (experimentIndex == -1) {
            this.experimentIndices = new int[this.data.getFeaturesCount()];
            for (int i = 0; i < this.experimentIndices.length; ++i) {
                this.experimentIndices[i] = i;
            }
        } else {
            this.experimentIndices = new int[1];
            this.experimentIndices[0] = experimentIndex;
        }
        this.generateIndices();
        this.fireDataChanged();
    }

    public void fireDataChanged() {
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ChangeListener)listeners[i]).stateChanged(new ChangeEvent(new Object()));
        }
    }

    public int getCloneValueType() {
        return this.cloneValueType;
    }

    public void setCloneValueType(int cloneValueType) {
        this.cloneValueType = cloneValueType;
        this.fireDataChanged();
    }
}

