/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import java.awt.Color;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHAnnotationsModel {
    int chromosomeIndex;
    IData data;

    public CGHAnnotationsModel(IFramework framework, int chromosomeIndex) {
        this.data = framework.getData();
        this.chromosomeIndex = chromosomeIndex;
    }

    public int getNumAnnotations() {
        try {
            return this.data.getAnnotations()[this.chromosomeIndex].length;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public ICGHDataRegion getAnnotationAt(int index) {
        return this.data.getAnnotations()[this.chromosomeIndex][index];
    }

    public Color getAnnotationColorAt(int index) {
        ICGHDataRegion dataRegion = this.getAnnotationAt(index);
        if (dataRegion instanceof CGHClone) {
            return Color.yellow;
        }
        if (dataRegion instanceof FlankingRegion) {
            return Color.cyan;
        }
        if (dataRegion instanceof IGeneData) {
            return Color.white;
        }
        return Color.magenta;
    }
}

