/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataGenerator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cluster.gui.IData;

public class FlankingRegionCalculator {
    ArrayList experiments;
    IData data;
    int copyDeterminationType = 0;
    int experimentIndex;

    public void calculateFlankingRegions() {
        Iterator it = this.experiments.iterator();
        int counter = 0;
        while (it.hasNext()) {
            this.experimentIndex = counter++;
            this.calculateSampleFlankingRegions(this.experimentIndex, (ISlideData)it.next());
        }
    }

    private void calculateSampleFlankingRegions(int experimentIndex, ISlideData flank) {
        Vector[] sampleFlankingRegions = new Vector[this.data.getNumChromosomes()];
        for (int i = 0; i < sampleFlankingRegions.length; ++i) {
            sampleFlankingRegions[i] = this.calculateChromosomeSampleFlankingRegions(experimentIndex, i);
        }
        flank.setFlankingRegions(sampleFlankingRegions);
    }

    private Vector calculateChromosomeSampleFlankingRegions(int experimentIndex, int chromosomeIndex) {
        Vector<FlankingRegion> flankingRegions = new Vector<FlankingRegion>();
        int numDataPts = this.data.getNumDataPointsInChrom(chromosomeIndex);
        for (int cloneIndex = 0; cloneIndex < numDataPts; ++cloneIndex) {
            int copyNumber = this.getCopyNumberDetermination(experimentIndex, cloneIndex, chromosomeIndex);
            if (copyNumber == -11 || copyNumber == -10) continue;
            int flankingRegionStart = this.findFlankingRegionStart(experimentIndex, cloneIndex, chromosomeIndex);
            CGHClone flankingRegionStartClone = this.findFlankingRegionStartClone(cloneIndex, chromosomeIndex);
            FlankingRegion curFlankingRegion = new FlankingRegion();
            if (copyNumber < -1) {
                curFlankingRegion.setType(1);
                curFlankingRegion.setSpecifier(3);
                cloneIndex = this.calculateFlankingRegionEnd(experimentIndex, cloneIndex, chromosomeIndex, copyNumber);
            } else if (copyNumber < 0) {
                if (copyNumber != -1) {
                    System.out.println("FLCalc copy num < 0 = " + copyNumber);
                }
                curFlankingRegion.setType(1);
                curFlankingRegion.setSpecifier(2);
                cloneIndex = this.calculateFlankingRegionEnd(experimentIndex, cloneIndex, chromosomeIndex, copyNumber);
            } else if (copyNumber > 1) {
                curFlankingRegion.setType(0);
                curFlankingRegion.setSpecifier(5);
                cloneIndex = this.calculateFlankingRegionEnd(experimentIndex, cloneIndex, chromosomeIndex, copyNumber);
            } else if (copyNumber > 0) {
                curFlankingRegion.setType(0);
                curFlankingRegion.setSpecifier(4);
                cloneIndex = this.calculateFlankingRegionEnd(experimentIndex, cloneIndex, chromosomeIndex, copyNumber);
            }
            int flankingRegionStop = this.findFlankingRegionStop(cloneIndex, chromosomeIndex);
            CGHClone flankingRegionStopClone = this.findFlankingRegionStopClone(cloneIndex, chromosomeIndex);
            curFlankingRegion.setStart(flankingRegionStart);
            curFlankingRegion.setStop(flankingRegionStop);
            curFlankingRegion.setChromosome(chromosomeIndex);
            curFlankingRegion.setStartClone(flankingRegionStartClone);
            curFlankingRegion.setStopClone(flankingRegionStopClone);
            flankingRegions.add(curFlankingRegion);
        }
        return flankingRegions;
    }

    private int findFlankingRegionStart(int experimentIndex, int cloneIndex, int chromosomeIndex) {
        if (cloneIndex == 0) {
            return 0;
        }
        while (this.getCopyNumberDetermination(experimentIndex, cloneIndex - 1, chromosomeIndex) == -10 && --cloneIndex != 0) {
        }
        if (cloneIndex != 0) {
            return this.data.getCloneAt(cloneIndex - 1, chromosomeIndex).getStop();
        }
        return this.data.getCloneAt(cloneIndex, chromosomeIndex).getStart();
    }

    private CGHClone findFlankingRegionStartClone(int cloneIndex, int chromosomeIndex) {
        return this.data.getCloneAt(cloneIndex, chromosomeIndex);
    }

    private int findFlankingRegionStop(int cloneIndex, int chromosomeIndex) {
        if (cloneIndex + 1 < this.data.getNumDataPointsInChrom(chromosomeIndex)) {
            return this.data.getCloneAt(cloneIndex + 1, chromosomeIndex).getStart();
        }
        return this.data.getCloneAt(cloneIndex, chromosomeIndex).getStop();
    }

    private CGHClone findFlankingRegionStopClone(int cloneIndex, int chromosomeIndex) {
        return this.data.getCloneAt(cloneIndex, chromosomeIndex);
    }

    private int calculateFlankingRegionEnd(int experimentIndex, int cloneIndex, int chromosomeIndex, int flCopyNumber) {
        int copyNumber = 0;
        int numDataPts = this.data.getNumDataPointsInChrom(chromosomeIndex);
        while (cloneIndex + 1 < numDataPts && this.getCopyNumberDetermination(experimentIndex, cloneIndex + 1, chromosomeIndex) == flCopyNumber) {
            ++cloneIndex;
        }
        copyNumber = this.getCopyNumberDetermination(experimentIndex, cloneIndex + 1, chromosomeIndex);
        if (cloneIndex + 1 >= numDataPts) {
            return cloneIndex;
        }
        if (copyNumber == -10) {
            return this.calculateFlankingRegionEnd(experimentIndex, cloneIndex + 1, chromosomeIndex, flCopyNumber);
        }
        return cloneIndex;
    }

    private int getCopyNumberDetermination(int experimentIndex, int cloneIndex, int chromosomeIndex) {
        if (this.copyDeterminationType == 0) {
            return ((MultipleArrayData)this.data).getCopyNumberDetermination(experimentIndex, cloneIndex, chromosomeIndex);
        }
        if (this.copyDeterminationType == 1) {
            return ((MultipleArrayData)this.data).getCopyNumberDeterminationByLogCloneDistribution(experimentIndex, this.data.getCloneIndex(cloneIndex, chromosomeIndex));
        }
        if (this.copyDeterminationType == 2) {
            return ((MultipleArrayData)this.data).getCopyNumberDeterminationByThresholdOrCloneDistribution(experimentIndex, this.data.getCloneIndex(cloneIndex, chromosomeIndex));
        }
        return -11;
    }

    public ArrayList getExperiments() {
        return this.experiments;
    }

    public void setExperiments(ArrayList experiments) {
        this.experiments = experiments;
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData dat) {
        this.data = dat;
    }

    public int getCopyDeterminationType() {
        return this.copyDeterminationType;
    }

    public void setCopyDeterminationType(int copyDeterminationType) {
        this.copyDeterminationType = copyDeterminationType;
    }
}

