/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataGenerator;

import java.util.Vector;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cluster.gui.IData;

public class ComparisonFlankingRegionCalculator {
    MultipleArrayData data;
    int[] cloneIndices;
    int[] comparisonIndices;
    int frCloneIndex = 0;
    int comparisonPointer;
    int[] experimentIndices;

    public Vector calculateFlankingRegions(IData data, int[] cloneIndices, int[] comparisonIndices, int experimentIndices) {
        int[] indices = new int[]{experimentIndices};
        return this.calculateFlankingRegions(data, cloneIndices, comparisonIndices, indices);
    }

    public Vector calculateFlankingRegions(IData data, int[] cloneIndices, int[] comparisonIndices, int[] experimentIndices) {
        this.frCloneIndex = 0;
        this.data = (MultipleArrayData)data;
        this.experimentIndices = experimentIndices;
        this.comparisonIndices = comparisonIndices;
        this.cloneIndices = cloneIndices;
        this.comparisonPointer = 0;
        Vector flankingRegions = new Vector();
        for (int chrom = 0; chrom < data.getNumChromosomes(); ++chrom) {
            flankingRegions.addAll(this.calculateChromosomeFlankingRegions(chrom));
        }
        return flankingRegions;
    }

    private Vector calculateChromosomeFlankingRegions(int chromosomeIndex) {
        Vector<FlankingRegion> flankingRegions = new Vector<FlankingRegion>();
        for (int cloneIndex = this.data.getChromosomeStartIndex(chromosomeIndex); cloneIndex <= this.data.getChromosomeEndIndex(chromosomeIndex); ++cloneIndex) {
            if (this.frCloneIndex >= this.cloneIndices.length || cloneIndex != this.cloneIndices[this.frCloneIndex]) continue;
            int flankingRegionStart = this.findFlankingRegionStart(cloneIndex, this.data.getChromosomeStartIndex(chromosomeIndex));
            CGHClone flankingRegionStartClone = this.findFlankingRegionStartClone(cloneIndex);
            FlankingRegion curFlankingRegion = new FlankingRegion();
            cloneIndex = this.calculateFlankingRegionEnd(cloneIndex, this.data.getChromosomeEndIndex(chromosomeIndex));
            int flankingRegionStop = this.findFlankingRegionStop(cloneIndex, this.data.getChromosomeEndIndex(chromosomeIndex));
            CGHClone flankingRegionStopClone = this.findFlankingRegionStopClone(cloneIndex);
            curFlankingRegion.setStart(flankingRegionStart);
            curFlankingRegion.setStop(flankingRegionStop);
            curFlankingRegion.setChromosome(chromosomeIndex);
            curFlankingRegion.setStartClone(flankingRegionStartClone);
            curFlankingRegion.setStopClone(flankingRegionStopClone);
            flankingRegions.add(curFlankingRegion);
            ++this.frCloneIndex;
        }
        return flankingRegions;
    }

    private int findFlankingRegionStart(int cloneIndex, int chromosomeStartIndex) {
        while (cloneIndex >= chromosomeStartIndex && this.isBad(cloneIndex - 1)) {
            --cloneIndex;
        }
        if (cloneIndex <= chromosomeStartIndex) {
            return 0;
        }
        return this.data.getCloneAt(cloneIndex - 1).getStop();
    }

    private CGHClone findFlankingRegionStartClone(int cloneIndex) {
        return this.data.getCloneAt(cloneIndex);
    }

    private int calculateFlankingRegionEnd(int cloneIndex, int chromosomeEndIndex) {
        while (cloneIndex + 1 <= chromosomeEndIndex) {
            if (this.frCloneIndex + 1 < this.cloneIndices.length && cloneIndex + 1 == this.cloneIndices[this.frCloneIndex + 1]) {
                ++cloneIndex;
                ++this.frCloneIndex;
                continue;
            }
            if (!this.isBad(cloneIndex + 1)) break;
            ++cloneIndex;
        }
        return cloneIndex;
    }

    private int findFlankingRegionStop(int cloneIndex, int chromosomeEndIndex) {
        if (cloneIndex + 1 < chromosomeEndIndex) {
            return this.data.getCloneAt(cloneIndex + 1).getStart();
        }
        return this.data.getCloneAt(cloneIndex).getStop();
    }

    private CGHClone findFlankingRegionStopClone(int cloneIndex) {
        return this.data.getCloneAt(cloneIndex);
    }

    private boolean isBad(int cloneIndex) {
        for (int i = 0; i < this.experimentIndices.length; ++i) {
            if (this.data.getCopyNumberDetermination(this.experimentIndices[i], cloneIndex) == -10) continue;
            return false;
        }
        return !this.comparatorExists(cloneIndex);
    }

    private boolean comparatorExists(int cloneIndex) {
        if (this.comparisonIndices == null) {
            return false;
        }
        this.comparisonPointer = 0;
        while (this.comparisonPointer < this.comparisonIndices.length && this.comparisonIndices[this.comparisonPointer] < cloneIndex) {
            ++this.comparisonPointer;
        }
        return this.comparisonPointer < this.comparisonIndices.length && this.comparisonIndices[this.comparisonPointer] == cloneIndex;
    }
}

