/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataGenerator.CharmDataGenerator;

import java.util.ArrayList;
import java.util.Collections;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class Chromosome
implements Comparable {
    private ArrayList genes;
    private int chromosomeNumber;
    public int numEdges;
    private float[] curr_ratios;
    private int[] curr_geneindex;
    private int[] map_geneindex;
    private String curr_exp;
    private boolean curr_includeNaNs;
    private float size;
    private float maxsize;
    private float maxGeneValue;
    IFramework framework;
    IData data;

    public Chromosome(int chromosomenum, IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        this.chromosomeNumber = chromosomenum;
        this.genes = new ArrayList();
        this.size = 1.0f;
        this.maxsize = 1.0f;
    }

    public Chromosome(int chromosomenum) {
        this.chromosomeNumber = chromosomenum;
        this.genes = new ArrayList();
        this.size = 1.0f;
        this.maxsize = 1.0f;
    }

    public void setSize(float input_size) {
        this.size = input_size;
    }

    public void setMaxSize(float input_max) {
        this.maxsize = input_max;
    }

    public int getRatiosLength(String exp, boolean includeNaNs) {
        int returnLen;
        if (exp.equals(this.curr_exp) && (includeNaNs && this.curr_includeNaNs || !includeNaNs && !this.curr_includeNaNs)) {
            returnLen = this.curr_ratios.length;
        } else {
            float[] temp = this.getRatioArray(exp, includeNaNs);
            returnLen = temp.length;
        }
        return returnLen;
    }

    public int mapExcludeNaNIndexToRealIndex(String exp, int index) {
        if (!exp.equals(this.curr_exp) || this.curr_includeNaNs) {
            float[] temp_ratios = new float[this.genes.size()];
            int[] temp_gene_indicies = new int[this.genes.size()];
            int[] temp_map_geneindices = new int[this.genes.size()];
            int ct = 0;
            int total_ct = 0;
            for (int i = 0; i < this.genes.size(); ++i) {
                float curr = ((CGHClone)this.genes.get(i)).getRatio();
                if (!Double.isNaN(curr)) {
                    temp_ratios[ct] = curr;
                    temp_gene_indicies[ct] = i;
                    temp_map_geneindices[total_ct] = ct++;
                }
                ++total_ct;
            }
            this.curr_ratios = new float[ct];
            this.curr_geneindex = new int[ct];
            this.map_geneindex = new int[total_ct];
            System.arraycopy(temp_gene_indicies, 0, this.curr_geneindex, 0, ct);
            System.arraycopy(temp_map_geneindices, 0, this.map_geneindex, 0, total_ct);
            System.arraycopy(temp_ratios, 0, this.curr_ratios, 0, ct);
        }
        this.curr_exp = exp;
        this.curr_includeNaNs = false;
        return this.curr_geneindex[index];
    }

    public int mapRealIndexToExcludeNaNIndex(String exp, int index) {
        if (!exp.equals(this.curr_exp) || this.curr_includeNaNs) {
            double[] temp_ratios = new double[this.genes.size()];
            int[] temp_gene_indicies = new int[this.genes.size()];
            int[] temp_map_geneindices = new int[this.genes.size()];
            int ct = 0;
            int total_ct = 0;
            for (int i = 0; i < this.genes.size(); ++i) {
                float curr = ((CGHClone)this.genes.get(i)).getRatio();
                if (!Double.isNaN(curr)) {
                    temp_ratios[ct] = curr;
                    temp_gene_indicies[ct] = i;
                    temp_map_geneindices[total_ct] = ct++;
                }
                ++total_ct;
            }
            this.curr_ratios = new float[ct];
            this.curr_geneindex = new int[ct];
            this.map_geneindex = new int[total_ct];
            System.arraycopy(temp_gene_indicies, 0, this.curr_geneindex, 0, ct);
            System.arraycopy(temp_map_geneindices, 0, this.map_geneindex, 0, total_ct);
            System.arraycopy(temp_ratios, 0, this.curr_ratios, 0, ct);
        }
        this.curr_exp = exp;
        this.curr_includeNaNs = false;
        return this.map_geneindex[index];
    }

    public float[] getRatioArray(String exp, boolean includeNaNs) {
        if (!(exp.equals(this.curr_exp) && (includeNaNs && this.curr_includeNaNs || !includeNaNs && !this.curr_includeNaNs))) {
            float[] temp_ratios = new float[this.genes.size()];
            int[] temp_gene_indicies = new int[this.genes.size()];
            int[] temp_map_geneindices = new int[this.genes.size()];
            int ct = 0;
            int total_ct = 0;
            for (int i = 0; i < this.genes.size(); ++i) {
                float curr = ((CGHClone)this.genes.get(i)).getRatio();
                if (!Float.isNaN(curr) || includeNaNs) {
                    temp_ratios[ct] = curr;
                    temp_gene_indicies[ct] = i;
                    temp_map_geneindices[total_ct] = ct++;
                }
                ++total_ct;
            }
            this.curr_ratios = new float[ct];
            this.curr_geneindex = new int[ct];
            this.map_geneindex = new int[total_ct];
            System.arraycopy(temp_gene_indicies, 0, this.curr_geneindex, 0, ct);
            System.arraycopy(temp_map_geneindices, 0, this.map_geneindex, 0, total_ct);
            System.arraycopy(temp_ratios, 0, this.curr_ratios, 0, ct);
        }
        this.curr_exp = exp;
        this.curr_includeNaNs = includeNaNs;
        return this.curr_ratios;
    }

    public int numGenes() {
        return this.genes.size();
    }

    public int getNumber() {
        return this.chromosomeNumber;
    }

    public void sortGenes() {
        Collections.sort(this.genes);
    }

    public float getSize() {
        return this.size;
    }

    public double maxSize() {
        return this.maxsize;
    }

    public float getMaxGeneValue() {
        return this.maxGeneValue;
    }

    public void setMaxGeneValue(float max) {
        this.maxGeneValue = max;
    }

    public int compareTo(Object other) {
        Chromosome otherchromo = (Chromosome)other;
        if (this.chromosomeNumber < otherchromo.getNumber()) {
            return -1;
        }
        if (this.chromosomeNumber > otherchromo.getNumber()) {
            return 1;
        }
        return 0;
    }
}

