/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataGenerator;

import java.util.ArrayList;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHCopyNumberCalculator {
    public static final int BAD_CLONE = -10;
    public static final int NO_COPY_CHANGE = -11;
    MultipleArrayData data;
    IFramework framework;
    float ampThresh;
    float delThresh;
    float ampThresh2Copy;
    float delThresh2Copy;
    float cloneDistributionPThresh;

    public CGHCopyNumberCalculator(MultipleArrayData data) {
        this.data = data;
    }

    public void onCopyDeterminationChanged(ICGHCloneValueMenu menu) {
        this.ampThresh = menu.getAmpThresh();
        this.delThresh = menu.getDelThresh();
        this.ampThresh2Copy = menu.getAmpThresh2Copy();
        this.delThresh2Copy = menu.getDelThresh2Copy();
        this.cloneDistributionPThresh = menu.getClonePThresh();
    }

    public int getCopyNumberDetermination(int experiment, int clone, int chromosome) {
        return this.getCopyNumberDetermination(experiment, this.data.getCloneIndex(clone, chromosome));
    }

    public int getCopyNumberDetermination(int experiment, int clone) {
        ArrayList featuresList = this.data.getFeaturesList();
        ISlideData sampleData = (ISlideData)featuresList.get(experiment);
        return this.getCopyNumberDetermination(sampleData, clone);
    }

    public int getCopyNumberDetermination(ISlideData sampleData, int clone, int chromosome) {
        return this.getCopyNumberDetermination(sampleData, this.data.getCloneIndex(clone, chromosome));
    }

    public int getCopyNumberDetermination(ISlideData sampleData, int clone) {
        int copyNumber = this.determineCopyNumber(sampleData, clone);
        if (copyNumber == -10) {
            return -10;
        }
        if (copyNumber == -11) {
            return -11;
        }
        if (copyNumber == -2 || copyNumber == -1) {
            return -1;
        }
        if (copyNumber == 2 || copyNumber == 1) {
            return 1;
        }
        return -11;
    }

    public int determineCopyNumber(ISlideData slide, int clone) {
        return this.determineCopyNumberByThreshold(slide, clone);
    }

    public int determineCopyNumberByThreshold(ISlideData slide, int clone) {
        float ratio = slide.getRatio(clone, 0);
        if (Float.isNaN(ratio)) {
            return -10;
        }
        if (ratio < this.delThresh2Copy) {
            return -2;
        }
        if (ratio < this.delThresh) {
            return -1;
        }
        if (ratio > this.ampThresh2Copy) {
            return 2;
        }
        if (ratio > this.ampThresh) {
            return 1;
        }
        return -11;
    }

    public int getCopyNumberDeterminationByLogCloneDistribution(int experiment, int clone) {
        int cy3CopyNumber = this.determineCopyNumberByLogCloneDistribution(experiment, clone, 0);
        int cy5CopyNumber = this.determineCopyNumberByLogCloneDistribution(experiment, clone, 1);
        if (cy3CopyNumber == -10 || cy5CopyNumber == -10) {
            return -10;
        }
        if (cy3CopyNumber == cy5CopyNumber) {
            return cy3CopyNumber;
        }
        return -11;
    }

    public int determineCopyNumberByLogCloneDistribution(int experiment, int clone) {
        float pValue = this.data.getPValueByLogCloneDistribution(experiment, clone);
        if (Float.isNaN(pValue)) {
            return -10;
        }
        if (pValue > this.cloneDistributionPThresh) {
            return 1;
        }
        if (pValue < 1.0f - this.cloneDistributionPThresh) {
            return -1;
        }
        return -11;
    }

    public int determineCopyNumberByLogCloneDistribution(int experiment, int clone, int testDye) {
        float pValue = this.data.getPValueByLogCloneDistribution(experiment, clone);
        if (Float.isNaN(pValue)) {
            return -10;
        }
        if (testDye == 0) {
            if (pValue > this.cloneDistributionPThresh) {
                return 1;
            }
            if (pValue < 1.0f - this.cloneDistributionPThresh) {
                return -1;
            }
        } else {
            if (pValue > this.cloneDistributionPThresh) {
                return -1;
            }
            if (pValue < 1.0f - this.cloneDistributionPThresh) {
                return 1;
            }
        }
        return -11;
    }

    public int getCopyNumberDeterminationByThresholdOrCloneDistribution(int experiment, int clone) {
        int threshCopyNumber = this.getCopyNumberDetermination(experiment, clone);
        int distCopyNumber = this.getCopyNumberDeterminationByLogCloneDistribution(experiment, clone);
        if (threshCopyNumber == -10) {
            return distCopyNumber;
        }
        if (distCopyNumber == -10) {
            return threshCopyNumber;
        }
        if (threshCopyNumber == -11) {
            return distCopyNumber;
        }
        if (distCopyNumber == -11) {
            return threshCopyNumber;
        }
        if (distCopyNumber < 0 && threshCopyNumber < 0) {
            return Math.min(distCopyNumber, threshCopyNumber);
        }
        if (distCopyNumber > 0 && threshCopyNumber > 0) {
            return Math.max(distCopyNumber, threshCopyNumber);
        }
        return -10;
    }

    public MultipleArrayData getData() {
        return this.data;
    }

    public void setData(MultipleArrayData data) {
        this.data = data;
    }
}

