/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.RegionAlterations;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegions;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegionsComparator;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public abstract class RegionAlterations
extends NumberOfAlterationsCalculator {
    @Override
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        MultipleArrayData data = (MultipleArrayData)framework.getData();
        Vector allAlterationRegions = new Vector();
        for (int chromIndex = 0; chromIndex < data.getNumChromosomes(); ++chromIndex) {
            AlterationRegions curAlterationRegions = new AlterationRegions(chromIndex);
            Vector<Object> curFlankingRegions = new Vector<Object>(data.getFeaturesCount());
            Iterator featuresIt = data.getFeaturesList().iterator();
            while (featuresIt.hasNext()) {
                Vector curFrs = ((ISlideData)featuresIt.next()).getFlankingRegions()[chromIndex];
                curFlankingRegions.add(curFrs.clone());
            }
            int[] indices = new int[data.getFeaturesCount()];
            for (int i = 0; i < data.getFeaturesCount(); ++i) {
                indices[i] = 0;
            }
            boolean more = true;
            while (more) {
                Vector expRegions;
                int i;
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    Vector expRegions2 = (Vector)curFlankingRegions.get(i2);
                    while (indices[i2] < expRegions2.size() && ((FlankingRegion)expRegions2.get(indices[i2])).getType() != this.getFlankingRegionType()) {
                        int n = i2;
                        indices[n] = indices[n] + 1;
                    }
                }
                int minStartIndex = this.getMinStartIndex(curFlankingRegions, indices);
                int minEndIndex = this.getMinEndIndex(curFlankingRegions, indices, minStartIndex);
                for (i = 0; i < indices.length; ++i) {
                    expRegions = (Vector)curFlankingRegions.get(i);
                    if (indices[i] >= expRegions.size()) continue;
                    FlankingRegion fr = (FlankingRegion)expRegions.get(indices[i]);
                    int start = fr.getStart();
                    int stop = fr.getStop();
                    if (start != minStartIndex) continue;
                    AlterationRegion curAlterationRegion = curAlterationRegions.getAlterationRegion(minStartIndex, minEndIndex, this.getFlankingRegionType(), data.getFeaturesCount());
                    curAlterationRegion.incrementAlterations();
                    curAlterationRegion.getAlteredExperiments().add(new Integer(i));
                    if (stop == minEndIndex) {
                        int n = i;
                        indices[n] = indices[n] + 1;
                        continue;
                    }
                    FlankingRegion tmp = new FlankingRegion(minEndIndex, fr.getStop(), this.getFlankingRegionType(), chromIndex);
                    expRegions.set(indices[i], tmp);
                }
                more = false;
                for (i = 0; i < indices.length; ++i) {
                    expRegions = (Vector)curFlankingRegions.get(i);
                    if (indices[i] >= expRegions.size()) continue;
                    more = true;
                }
            }
            allAlterationRegions.addAll(curAlterationRegions.getAlterationRegions());
        }
        Collections.sort(allAlterationRegions, new AlterationRegionsComparator());
        return this.createResultsTree(allAlterationRegions);
    }

    private int getMinStartIndex(Vector flankingRegions, int[] indices) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            Vector expRegions = (Vector)flankingRegions.get(i);
            if (indices[i] >= expRegions.size()) continue;
            min = Math.min(min, ((FlankingRegion)expRegions.get(indices[i])).getStart());
        }
        return min;
    }

    private int getMinEndIndex(Vector flankingRegions, int[] indices, int minStartIndex) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            Vector expRegions = (Vector)flankingRegions.get(i);
            if (indices[i] >= expRegions.size()) continue;
            int start = ((FlankingRegion)expRegions.get(indices[i])).getStart();
            if (start == minStartIndex) {
                start = ((FlankingRegion)expRegions.get(indices[i])).getStop();
            }
            min = Math.min(min, start);
        }
        return min;
    }

    public abstract int getFlankingRegionType();
}

