/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.AlterationParametersViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfAlterationsDataModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfAlterationsViewer;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;

public abstract class NumberOfAlterationsCalculator
implements IClusterGUI {
    public IFramework framework;
    public IData data;
    public String nodeName = "";

    public abstract DefaultMutableTreeNode execute(IFramework var1) throws AlgorithmException;

    public DefaultMutableTreeNode createResultsTree2(Collection results) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Parameters", this.createParametersViewer())));
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results", this.createResultsViewer(results))));
        return root;
    }

    public DefaultMutableTreeNode createResultsTree(Collection results) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results", this.createResultsViewer(results))));
        this.addGeneralInfo(root);
        return root;
    }

    public DefaultMutableTreeNode createResultsTree(Collection results, String file) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results", this.createResultsViewer(results))));
        this.addGeneralInfo(root);
        return root;
    }

    public DefaultMutableTreeNode createResultsTree(Collection results, boolean addInfo) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Results", this.createResultsViewer(results))));
        if (addInfo) {
            this.addGeneralInfo(root);
        }
        return root;
    }

    private IViewer createResultsViewer(Collection results) {
        AlterationRegion[] alterationRegions = new AlterationRegion[results.size()];
        Iterator it = results.iterator();
        int i = 0;
        while (it.hasNext()) {
            AlterationRegion alterationRegion = (AlterationRegion)it.next();
            alterationRegions[i++] = alterationRegion;
        }
        NumberOfAlterationsDataModel dataModel = new NumberOfAlterationsDataModel();
        dataModel.setAlterationRegions(alterationRegions);
        NumberOfAlterationsViewer viewer = new NumberOfAlterationsViewer();
        viewer.setData(this.framework.getData());
        viewer.setDataModel(dataModel);
        return viewer;
    }

    public IViewer createParametersViewer() {
        return new AlterationParametersViewer(this.framework);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root) {
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Amplification Threshold: " + menu.getAmpThresh()));
        node.add(new DefaultMutableTreeNode("Deletion Threshold: " + menu.getDelThresh()));
        node.add(new DefaultMutableTreeNode("Amplification 2 Copy Threshold: " + menu.getAmpThresh2Copy()));
        node.add(new DefaultMutableTreeNode("Deletion 2 Copy Threshold: " + menu.getDelThresh2Copy()));
        root.add(node);
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData dat) {
        this.data = dat;
    }

    public IFramework getFramework() {
        return this.framework;
    }

    public void setFramework(IFramework framework) {
        this.framework = framework;
    }
}

