/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.GeneAlterations;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.GeneAmplifications;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.GeneDeletions;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataObj.GeneDataSet;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class LoadGeneList
extends NumberOfAlterationsCalculator {
    @Override
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.data = framework.getData();
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir") + "/data");
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(framework.getFrame());
        if (returnVal == 0) {
            return this.loadGeneList(chooser.getSelectedFile(), this.data.getCGHSpecies());
        }
        return null;
    }

    public DefaultMutableTreeNode execute(IFramework framework, File file) throws AlgorithmException {
        this.framework = framework;
        this.data = framework.getData();
        if (file != null) {
            return this.loadGeneList(file, this.data.getCGHSpecies());
        }
        return null;
    }

    public DefaultMutableTreeNode loadGeneList(File file, int species) {
        Vector vecGeneData = null;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Vector<String> geneNames = new Vector<String>();
            while ((line = reader.readLine()) != null) {
                geneNames.add(line.trim());
            }
            GeneDataSet geneDataSet = new GeneDataSet();
            geneDataSet.loadGeneDataByGeneNames(geneNames, species);
            vecGeneData = geneDataSet.getGeneData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("GeneAlterations");
            GeneAlterations alts = new GeneAmplifications();
            alts.setVecGeneData(vecGeneData);
            alts.setData(this.data);
            alts.setAddGenInfo(false);
            root.add(alts.execute(this.framework));
            alts = new GeneDeletions();
            alts.setVecGeneData(vecGeneData);
            alts.setData(this.data);
            alts.setAddGenInfo(false);
            root.add(alts.execute(this.framework));
            this.addGeneralInfo(root, file.getAbsolutePath());
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, String path) {
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Amplification Threshold: " + menu.getAmpThresh()));
        node.add(new DefaultMutableTreeNode("Deletion Threshold: " + menu.getDelThresh()));
        node.add(new DefaultMutableTreeNode("Amplification 2 Copy Threshold: " + menu.getAmpThresh2Copy()));
        node.add(new DefaultMutableTreeNode("Deletion 2 Copy Threshold: " + menu.getDelThresh2Copy()));
        node.add(new DefaultMutableTreeNode("File: " + path));
        root.add(node);
    }
}

