/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegionsComparator;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.GeneDataSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.RefGeneLinkData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public abstract class GeneAlterations
extends NumberOfAlterationsCalculator {
    private Vector vecGeneData = null;
    private boolean addGenInfo = true;

    public GeneAlterations() {
    }

    public GeneAlterations(IFramework framework) {
        this.framework = framework;
    }

    @Override
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.data = framework.getData();
        if (this.vecGeneData == null) {
            this.vecGeneData = this.getAllGenes();
        }
        if (this.vecGeneData == null) {
            return null;
        }
        Iterator it = this.vecGeneData.iterator();
        Vector<AlterationRegion> alterationRegions = new Vector<AlterationRegion>();
        while (it.hasNext()) {
            RefGeneLinkData curGeneData = (RefGeneLinkData)it.next();
            int numAlterations = this.getNumAlterations(curGeneData);
            AlterationRegion curAlterationRegion = new AlterationRegion();
            curAlterationRegion.setDataRegion(curGeneData);
            curAlterationRegion.setNumAlterations(numAlterations);
            curAlterationRegion.setNumSamples(framework.getData().getFeaturesCount());
            alterationRegions.add(curAlterationRegion);
        }
        Collections.sort(alterationRegions, new AlterationRegionsComparator());
        if (!this.addGenInfo) {
            return this.createResultsTree(alterationRegions, this.addGenInfo);
        }
        return this.createResultsTree(alterationRegions);
    }

    public int getNumAlterations(ICGHDataRegion geneData) {
        int deletions = 0;
        int chromosomeIndex = geneData.getChromosomeIndex();
        int geneStart = geneData.getStart();
        int geneEnd = geneData.getStop();
        if (chromosomeIndex < 0) {
            return 0;
        }
        if (this.framework == null) {
            System.out.println("gene alterations null framework");
        }
        Iterator featuresIt = this.framework.getData().getFeaturesList().iterator();
        block0: while (featuresIt.hasNext()) {
            Vector expFrs = ((ISlideData)featuresIt.next()).getFlankingRegions()[chromosomeIndex];
            for (FlankingRegion fr : expFrs) {
                int frStart = fr.getStart();
                int frStop = fr.getStop();
                if ((geneStart >= frStop || geneStart <= frStart) && (geneEnd >= frStop || geneStart <= frStart) || fr.getType() != this.getAlterationType()) continue;
                ++deletions;
                continue block0;
            }
        }
        return deletions;
    }

    protected abstract int getAlterationType();

    private Vector getAllGenes() {
        GeneDataSet geneDataSet = new GeneDataSet();
        geneDataSet.loadAllGenes(this.data.getCGHSpecies());
        Vector vecGeneData = geneDataSet.getGeneData();
        return vecGeneData;
    }

    public Vector getVecGeneData() {
        return this.vecGeneData;
    }

    public void setVecGeneData(Vector vecGeneData) {
        this.vecGeneData = vecGeneData;
    }

    public void setAddGenInfo(boolean val) {
        this.addGenInfo = val;
    }
}

