/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.CloneAlterations;

import java.util.Collections;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegionsComparator;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public abstract class CloneAlterations
extends NumberOfAlterationsCalculator {
    @Override
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.data = framework.getData();
        Vector<AlterationRegion> alterationRegions = new Vector<AlterationRegion>();
        for (int i = 0; i < this.framework.getData().getFeaturesSize(); ++i) {
            CGHClone curClone = this.framework.getData().getCloneAt(i);
            int numAlterations = this.getNumAlterations(i);
            AlterationRegion curAlterationRegion = new AlterationRegion();
            curAlterationRegion.setDataRegion(curClone);
            curAlterationRegion.setNumAlterations(numAlterations);
            curAlterationRegion.setNumSamples(this.framework.getData().getFeaturesCount());
            alterationRegions.add(curAlterationRegion);
        }
        Collections.sort(alterationRegions, new AlterationRegionsComparator());
        return this.createResultsTree(alterationRegions);
    }

    public int getNumAlterations(int cloneIndex) {
        int numAlterations = 0;
        for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
            int copyNumber = this.data.getCopyNumberDetermination(i, cloneIndex);
            if (!this.isAltered(copyNumber)) continue;
            ++numAlterations;
        }
        return numAlterations;
    }

    protected abstract boolean isAltered(int var1);
}

