/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.util.Arrays;

public class Statistics {
    public static double getMean(double[] arr) {
        double sum = 0.0;
        int size = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (Double.isNaN(arr[i])) continue;
            sum += arr[i];
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        return sum / (double)size;
    }

    public static float getMean(float[] arr) {
        float sum = 0.0f;
        int size = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (Float.isNaN(arr[i])) continue;
            sum += arr[i];
            ++size;
        }
        if (size == 0) {
            return 0.0f;
        }
        return sum / (float)size;
    }

    public static double getMean(int[] arr) {
        double sum = 0.0;
        int size = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (Double.isNaN(arr[i])) continue;
            sum += (double)arr[i];
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        return sum / (double)size;
    }

    public static double getMean(double[] arr, int start, int end) {
        double sum = 0.0;
        int size = 0;
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        for (int i = start; i < end; ++i) {
            sum += arr[i];
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        return sum / (double)size;
    }

    public static float getMean(float[] arr, int start, int end) {
        float sum = 0.0f;
        int size = 0;
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        for (int i = start; i < end; ++i) {
            sum += arr[i];
            ++size;
        }
        if (size == 0) {
            return 0.0f;
        }
        return sum / (float)size;
    }

    public static double getVariance(double[] arr, int start, int end) {
        double mean = Statistics.getMean(arr, start, end);
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        double sum_of_diffs = 0.0;
        for (int i = start; i < end; ++i) {
            sum_of_diffs += Math.pow(Math.abs(arr[i] - mean), 2.0);
        }
        int number = end - start - 1;
        if (number == 0) {
            return 0.0;
        }
        return sum_of_diffs / (double)number;
    }

    public static float getVariance(float[] arr, int start, int end) {
        float mean = Statistics.getMean(arr, start, end);
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        float sum_of_diffs = 0.0f;
        for (int i = start; i < end; ++i) {
            sum_of_diffs = (float)((double)sum_of_diffs + Math.pow(Math.abs(arr[i] - mean), 2.0));
        }
        int number = end - start - 1;
        if (number == 0) {
            return 0.0f;
        }
        return sum_of_diffs / (float)number;
    }

    public static double getVariance(double[] arr, int start, int end, double mean) {
        double sum_of_diffs = 0.0;
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        for (int i = start; i < end; ++i) {
            sum_of_diffs += Math.pow(Math.abs(arr[i] - mean), 2.0);
        }
        int number = end - start - 1;
        if (number == 0) {
            return 0.0;
        }
        return sum_of_diffs / (double)number;
    }

    public static float getVariance(float[] arr, int start, int end, float mean) {
        float sum_of_diffs = 0.0f;
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        for (int i = start; i < end; ++i) {
            sum_of_diffs = (float)((double)sum_of_diffs + Math.pow(Math.abs(arr[i] - mean), 2.0));
        }
        int number = end - start - 1;
        if (number == 0) {
            return 0.0f;
        }
        return sum_of_diffs / (float)number;
    }

    public static double getMedian(double[] inputArr) {
        double[] arr = new double[inputArr.length];
        System.arraycopy(inputArr, 0, arr, 0, arr.length);
        if (arr.length > 8) {
            Arrays.sort(arr);
        } else {
            for (int i = 0; i < arr.length; ++i) {
                int min = i;
                for (int j = i + 1; j < arr.length; ++j) {
                    if (!(arr[j] < arr[min])) continue;
                    min = j;
                }
                double temp = arr[min];
                arr[min] = arr[i];
                arr[i] = temp;
            }
        }
        return Statistics.getMedianOfSorted(arr);
    }

    public static float getMedian(float[] inputArr) {
        float[] arr = new float[inputArr.length];
        System.arraycopy(inputArr, 0, arr, 0, arr.length);
        if (arr.length > 8) {
            Arrays.sort(arr);
        } else {
            for (int i = 0; i < arr.length; ++i) {
                int min = i;
                for (int j = i + 1; j < arr.length; ++j) {
                    if (!(arr[j] < arr[min])) continue;
                    min = j;
                }
                float temp = arr[min];
                arr[min] = arr[i];
                arr[i] = temp;
            }
        }
        return Statistics.getMedianOfSorted(arr);
    }

    public static double getMedian(double[] inputArr, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > inputArr.length) {
            end = inputArr.length;
        }
        double[] arr = new double[end - start];
        System.arraycopy(inputArr, start, arr, 0, arr.length);
        if (arr.length > 8) {
            Arrays.sort(arr);
        } else {
            for (int i = 0; i < arr.length; ++i) {
                int min = i;
                for (int j = i + 1; j < arr.length; ++j) {
                    if (!(arr[j] < arr[min])) continue;
                    min = j;
                }
                double temp = arr[min];
                arr[min] = arr[i];
                arr[i] = temp;
            }
        }
        return Statistics.getMedianOfSorted(arr);
    }

    public static float getMedian(float[] inputArr, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > inputArr.length) {
            end = inputArr.length;
        }
        float[] arr = new float[end - start];
        System.arraycopy(inputArr, start, arr, 0, arr.length);
        if (arr.length > 8) {
            Arrays.sort(arr);
        } else {
            for (int i = 0; i < arr.length; ++i) {
                int min = i;
                for (int j = i + 1; j < arr.length; ++j) {
                    if (!(arr[j] < arr[min])) continue;
                    min = j;
                }
                float temp = arr[min];
                arr[min] = arr[i];
                arr[i] = temp;
            }
        }
        return Statistics.getMedianOfSorted(arr);
    }

    public static double getMedianOfSorted(double[] arr) {
        if (arr.length == 0) {
            return 0.0;
        }
        double median = 0.0;
        median = arr.length % 2 == 0 ? (arr[arr.length / 2] + arr[arr.length / 2 - 1]) / 2.0 : arr[arr.length / 2];
        return median;
    }

    public static float getMedianOfSorted(float[] arr) {
        if (arr.length == 0) {
            return 0.0f;
        }
        float median = 0.0f;
        median = arr.length % 2 == 0 ? (arr[arr.length / 2] + arr[arr.length / 2 - 1]) / 2.0f : arr[arr.length / 2];
        return median;
    }

    public static double getMedianOfSorted(double[] arr, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length) {
            end = arr.length;
        }
        double median = 0.0;
        median = (end - start) % 2 == 0 ? (arr[(start + end) / 2] + arr[(start + end) / 2 - 1]) / 2.0 : arr[(start + end) / 2];
        return median;
    }

    public static double getPercentile(double[] arr, double target) {
        target = Math.abs(target);
        int numGreater = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(target >= Math.abs(arr[i]))) continue;
            ++numGreater;
        }
        return (double)numGreater / (double)arr.length;
    }

    public static float getPercentile(float[] arr, float target) {
        target = Math.abs(target);
        int numGreater = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(target >= Math.abs(arr[i]))) continue;
            ++numGreater;
        }
        return (float)numGreater / (float)arr.length;
    }

    public static double getGaussianDensity(double x, double mean, double stdev) {
        double exponent = -1.0 * Math.pow(x - mean, 2.0) / (2.0 * Math.pow(stdev, 2.0));
        double denom = Math.sqrt(Math.PI * 2 * Math.pow(stdev, 2.0));
        double coeff = 1.0 / denom;
        if (Double.isNaN(coeff * Math.exp(exponent))) {
            return 0.0;
        }
        return coeff * Math.exp(exponent);
    }

    public static float getGaussianDensity(float x, float mean, float stdev) {
        double exponent = -1.0 * Math.pow(x - mean, 2.0) / (2.0 * Math.pow(stdev, 2.0));
        double denom = Math.sqrt(Math.PI * 2 * Math.pow(stdev, 2.0));
        double coeff = 1.0 / denom;
        if (Double.isNaN(coeff * Math.exp(exponent))) {
            return 0.0f;
        }
        return (float)(coeff * Math.exp(exponent));
    }

    public static double getSum(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    public static float getSum(float[] arr) {
        float sum = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    public static double getMax(double[] arr) {
        double currMax = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(Math.abs(arr[i]) > currMax)) continue;
            currMax = Math.abs(arr[i]);
        }
        return currMax;
    }

    public static float getMax(float[] arr) {
        float currMax = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            if (!(Math.abs(arr[i]) > currMax)) continue;
            currMax = Math.abs(arr[i]);
        }
        return currMax;
    }

    public static double getFactorial(int n) {
        double total = 1.0;
        for (int i = n; i > 1; --i) {
            total *= (double)i;
        }
        return total;
    }

    public static double getBinomialCDF(int x, int total) {
        double result = 0.0;
        double coeff = 0.0;
        for (int i = 0; i < x; ++i) {
            coeff = Statistics.getFactorial(total) / (Statistics.getFactorial(i + 1) * Statistics.getFactorial(total - i - 1));
            result += coeff * Math.pow(0.5, total);
        }
        return result;
    }

    static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (z >= 0.0) {
            return ans;
        }
        return -ans;
    }

    public static double getNormalCDF(double z) {
        return 0.5 * (1.0 + Statistics.erf(z / Math.sqrt(2.0)));
    }

    public static float getNormalCDF(float z) {
        return 0.5f * (1.0f + (float)Statistics.erf((double)z / Math.sqrt(2.0)));
    }

    public static void main(String[] args) {
        int[] array = new int[]{4, 5, 2, 6};
        double result = Statistics.getBinomialCDF(13, 25);
        System.out.println("RESULT = " + result);
        System.out.println("RESULT = " + result + " ORIG. ARRAY: ");
        for (int i = 0; i < array.length; ++i) {
            System.out.println(array[i]);
        }
    }
}

