/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Statistics;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;

public class SigTestThread {
    private int NUM_PERMUTATIONS = 100;
    private int MAX_PERMUTE_VAL = 1500;
    private int PRECISION_THRESH = 10;
    private int curr_permutation;
    private boolean use_median;
    private boolean use_coeff;
    private boolean use_rankvar;
    private boolean use_rankmean;
    private float[] data;
    private int ChrNum;
    private String experiment;
    private SegmentInfo segInfo;
    private float orig_mean;
    private boolean stop;
    private boolean threadState_running;
    private boolean threadState_hasRun;

    public SigTestThread(float[] geneRatiosOfExprChr, int Chr, String exp, SegmentInfo currSeg) {
        this.data = geneRatiosOfExprChr;
        this.ChrNum = Chr;
        this.experiment = exp;
        this.segInfo = currSeg;
        this.orig_mean = 0.0f;
        this.use_rankvar = false;
        this.use_rankmean = false;
        this.use_coeff = false;
        this.use_median = false;
        this.stop = false;
        this.curr_permutation = 0;
        this.threadState_running = false;
        this.threadState_hasRun = false;
    }

    public boolean isRunning() {
        return this.threadState_running;
    }

    public boolean hasRun() {
        return this.threadState_hasRun;
    }

    public String getDescription() {
        return new String(this.experiment + ", Chrom: " + this.ChrNum);
    }

    public void setTests(boolean sign, boolean rank_mean, boolean rank_var, boolean coeff) {
        this.use_coeff = coeff;
        this.use_rankmean = rank_mean;
        this.use_rankvar = rank_var;
    }

    public void setNumberPermutations(int number) {
        this.NUM_PERMUTATIONS = number;
    }

    private double[] getRanks(double[] rankarray) {
        int i;
        int neg;
        double[] sortdata = new double[this.data.length];
        System.arraycopy(this.data, 0, sortdata, 0, this.data.length);
        Arrays.sort(sortdata);
        for (neg = 0; neg < sortdata.length && sortdata[neg] < 0.0; ++neg) {
        }
        int ct = 0;
        if (neg > 0) {
            for (i = neg; i > 0; --i) {
                rankarray[ct] = -1 * i;
                ++ct;
            }
        }
        i = 1;
        while (ct < rankarray.length) {
            rankarray[ct] = i;
            ++ct;
            ++i;
        }
        double[] orig_ranks = new double[this.segInfo.getEnd() - this.segInfo.getStart()];
        int count = 0;
        for (int i2 = this.segInfo.getStart(); i2 < this.segInfo.getEnd(); ++i2) {
            int index = Arrays.binarySearch(sortdata, (double)this.data[i2]);
            orig_ranks[count] = rankarray[index];
            ++count;
        }
        return orig_ranks;
    }

    public void runPermuteTest() {
        float realmean;
        this.orig_mean = realmean = Statistics.getMean(this.data, this.segInfo.getStart(), this.segInfo.getEnd());
        int windowsize = this.segInfo.getEnd() - this.segInfo.getStart() + 1;
        float[] random_data = new float[this.data.length];
        System.arraycopy(this.data, 0, random_data, 0, this.data.length);
        float[] random_maxmeans = new float[this.NUM_PERMUTATIONS];
        boolean precision_reached = false;
        this.segInfo.setNumPermutations(0);
        int mean_beats = 0;
        this.curr_permutation = 0;
        while (this.curr_permutation < this.NUM_PERMUTATIONS && !precision_reached && !this.stop) {
            int curr_start;
            for (int j = random_data.length - 1; j > 0; --j) {
                int random_index = (int)(Math.random() * (double)j);
                float temp = random_data[random_index];
                random_data[random_index] = random_data[j];
                random_data[j] = temp;
            }
            float curr_mean = Statistics.getMean(random_data, curr_start, curr_start + windowsize);
            float rand_max = 0.0f;
            for (curr_start = 0; curr_start < Math.min(this.data.length - windowsize, this.MAX_PERMUTE_VAL); ++curr_start) {
                curr_mean -= random_data[curr_start] / (float)windowsize;
                if ((curr_mean += random_data[curr_start + windowsize] / (float)windowsize) < 0.0f && curr_mean < rand_max) {
                    rand_max = curr_mean;
                    continue;
                }
                if (!(curr_mean > 0.0f) || !(curr_mean > rand_max)) continue;
                rand_max = curr_mean;
            }
            random_maxmeans[this.curr_permutation] = rand_max;
            if (realmean > 0.0f && rand_max > realmean || realmean < 0.0f && rand_max < realmean) {
                ++mean_beats;
            }
            if (mean_beats > this.PRECISION_THRESH) {
                precision_reached = true;
            }
            ++this.curr_permutation;
        }
        this.segInfo.setNumPermutations(this.curr_permutation);
        this.segInfo.setDataMean(this.orig_mean);
        float maxMean = Statistics.getMean(random_maxmeans, 0, this.curr_permutation - 1);
        float maxVar = Statistics.getVariance(random_maxmeans, 0, this.curr_permutation - 1, maxMean);
        float pvalue = 1.0f;
        pvalue = realmean > 0.0f ? 1.0f - Statistics.getNormalCDF((realmean - maxMean) / (float)Math.pow(maxVar, 0.5)) : Statistics.getNormalCDF((realmean - maxMean) / (float)Math.pow(maxVar, 0.5));
        this.segInfo.setStatistic(new String("Mean"), pvalue);
    }

    public void runPermuteTestOld() {
        float realmean;
        int mean_beats = 0;
        int windowsize = this.segInfo.getEnd() - this.segInfo.getStart() + 1;
        this.orig_mean = realmean = Statistics.getMean(this.data, this.segInfo.getStart(), this.segInfo.getEnd());
        float[] random_data = new float[this.data.length];
        System.arraycopy(this.data, 0, random_data, 0, this.data.length);
        boolean precision_reached = false;
        this.segInfo.setNumPermutations(0);
        this.curr_permutation = 0;
        while (this.curr_permutation < this.NUM_PERMUTATIONS && !precision_reached && !this.stop) {
            for (int j = random_data.length - 1; j > 0; --j) {
                int random_index = (int)(Math.random() * (double)j);
                float temp = random_data[random_index];
                random_data[random_index] = random_data[j];
                random_data[j] = temp;
            }
            boolean meanbeat = false;
            for (int curr_start = 0; curr_start < this.data.length - windowsize && !meanbeat; ++curr_start) {
                double random_mean = Statistics.getMean(random_data, curr_start, curr_start + windowsize);
                if (meanbeat || !(realmean > 0.0f && random_mean > (double)realmean) && (!(realmean < 0.0f) || !(random_mean < (double)realmean))) continue;
                ++mean_beats;
                meanbeat = true;
            }
            if (mean_beats > this.PRECISION_THRESH) {
                precision_reached = true;
                this.curr_permutation = this.NUM_PERMUTATIONS;
            }
            this.segInfo.setNumPermutations(this.segInfo.getNumPermutations() + 1);
            ++this.curr_permutation;
        }
        int num_permutations_performed = this.segInfo.getNumPermutations();
        this.segInfo.setStatistic(new String("Mean"), (float)mean_beats / (float)num_permutations_performed);
        this.segInfo.setDataMean(this.orig_mean);
    }

    public void runSignTest() {
        float thresh = this.getThreshhold(this.data);
        int totalbeats = 0;
        int overbeats = 0;
        int underbeats = 0;
        float pval_over = 1.0f;
        float pval_under = 1.0f;
        for (int i = this.segInfo.getStart(); i <= this.segInfo.getEnd(); ++i) {
            if (this.data[i] > thresh) {
                ++totalbeats;
                ++overbeats;
            }
            if (!(this.data[i] < -1.0f * thresh)) continue;
            ++totalbeats;
            ++underbeats;
        }
        if (totalbeats > 15) {
            pval_over = 1.0f - Statistics.getNormalCDF((float)(2 * overbeats - totalbeats) / (float)Math.pow(totalbeats, 0.5));
            pval_under = 1.0f - Statistics.getNormalCDF((float)(2 * underbeats - totalbeats) / (float)Math.pow(totalbeats, 0.5));
        } else if (totalbeats > 0) {
            pval_over = (float)(1.0 - Statistics.getBinomialCDF(overbeats, totalbeats));
            pval_under = (float)(1.0 - Statistics.getBinomialCDF(underbeats, totalbeats));
        } else {
            pval_under = 1.0f;
            pval_over = 1.0f;
        }
        this.segInfo.setStatistic(new String("Sign pos"), pval_over);
        this.segInfo.setStatistic(new String("Sign neg"), pval_under);
    }

    public double getThreshhold_old(double[] data) {
        double[] sortdata = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            sortdata[i] = Math.abs(data[i]);
        }
        Arrays.sort(sortdata);
        double init_percent = 0.2;
        int currsize = (int)(init_percent * (double)data.length);
        int sizediff = 10;
        double curr_mean = 0.0;
        while (sizediff > 1 && (double)currsize / (double)data.length < 0.95) {
            double curr_stdev = Math.pow(Statistics.getVariance(data, 0, currsize), 0.5);
            curr_mean = Statistics.getMean(sortdata, 0, currsize);
            int newsize = currsize;
            for (newsize = currsize; newsize < (int)((double)sortdata.length * 0.95) && sortdata[newsize] <= curr_mean + 2.0 * curr_stdev; ++newsize) {
            }
            sizediff = newsize - currsize;
            currsize = newsize;
        }
        return curr_mean;
    }

    public float getThreshhold(float[] data) {
        float[] sortdata = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            sortdata[i] = Math.abs(data[i]);
        }
        Arrays.sort(sortdata);
        float init_percent = 0.75f;
        int currsize = (int)(init_percent * (float)data.length);
        return sortdata[currsize];
    }

    public void printResults() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.experiment, true));
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCurrentPermutation() {
        return this.curr_permutation;
    }
}

