/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class RunCharmProgressPanel
extends JDialog
implements ActionListener {
    private JProgressBar progress;
    private JLabel description;
    private static final String DESCRIPTION = "Description: ";

    public RunCharmProgressPanel(Frame parent, String title, DialogListener listener) {
        super(parent, title);
        this.description = new JLabel();
        this.setDescription("");
        this.progress = new JProgressBar(0, 100);
        this.progress.setString("");
        this.progress.setStringPainted(true);
        this.progress.setPreferredSize(new Dimension(310, 30));
        JPanel progressPanel = this.createProgressPanel(this.description, this.progress);
        progressPanel.setBackground(Color.white);
        JPanel btnsPanel = this.createBtnsPanel((ActionListener)listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)new HeaderImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)progressPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener((WindowListener)listener);
        this.setResizable(false);
        this.pack();
    }

    @Override
    public void show() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setIndeterminate(true);
        super.show();
    }

    public void setDescription(String text) {
        if (text == null) {
            text = "";
        }
        this.description.setText(DESCRIPTION + text);
    }

    private JPanel createProgressPanel(JLabel description, JProgressBar progress) {
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.setPreferredSize(new Dimension(350, 80));
        progressPanel.add((Component)this.progress, "First");
        progressPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        progressPanel.setPreferredSize(new Dimension(400, 65));
        progressPanel.setOpaque(true);
        return progressPanel;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        cancelButton.setPreferredSize(new Dimension(80, 25));
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        cancelButton.setFocusPainted(false);
        panel.add((Component)cancelButton, "Center");
        this.getRootPane().setDefaultButton(cancelButton);
        return panel;
    }

    public RunCharmProgressPanel() {
    }

    public void setIndeterminate(boolean b) {
        this.progress.setIndeterminate(b);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("cancel")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progress.setIndeterminate(true);
        }
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            this.gp = new GradientPaint(0.0f, dim.height / 2, this.backgroundColor, dim.width, dim.height / 2, this.fadeColor);
            g2.setPaint(this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel iconLabel = new JLabel(GUIFactory.getIcon((String)"dialog_banner2.gif"));
            iconLabel.setOpaque(false);
            iconLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

