/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.util.Arrays;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Statistics;

public class Edge {
    public static final int MAX_ROI = 20;
    public static final float PERCENT_WINDOW_SIZE = 0.5f;
    public static final float START_LIKELIHOOD = -1000000.0f;
    public static final int MIN_WINDOW = 2;
    private int position;
    private int roi_left;
    private int roi_right;
    private int left_window;
    private int right_window;
    private float left_mean;
    private float left_var;
    private float right_mean;
    private float right_var;
    private float[] left_posterior;
    private float[] right_posterior;
    private float[] left_geneprobs;
    private float[] right_geneprobs;
    private float left_prior;
    private float right_prior;
    private boolean reset;
    private boolean improving;
    private float likelihood;

    public Edge(int pos) {
        this.position = pos;
        this.right_var = 0.0f;
        this.right_mean = 0.0f;
        this.left_var = 0.0f;
        this.left_mean = 0.0f;
        this.right_window = 0;
        this.left_window = 0;
        this.roi_right = 0;
        this.roi_left = 0;
        this.right_prior = 0.0f;
        this.left_prior = 0.0f;
        this.reset = false;
    }

    public void setLeftWindow(int size) {
        this.left_window = size;
    }

    public void setRightWindow(int size) {
        this.right_window = size;
    }

    public void setInfluenceWindow(int datalength) {
        int roi_size;
        int half = this.position - this.left_window == 0 ? this.left_window : (int)((float)this.left_window * 0.5f);
        if (half < (roi_size = 20)) {
            roi_size = half;
        }
        if ((half = this.position + this.right_window == datalength ? this.right_window - 1 : (int)((float)this.right_window * 0.5f)) < roi_size) {
            roi_size = half;
        }
        this.roi_left = this.position - roi_size;
        this.roi_right = this.position + roi_size + 1;
    }

    public void setLeftDistribution(float mean, float var) {
        this.left_mean = mean;
        this.left_var = var;
    }

    public void setRightDistribution(float mean, float var) {
        this.right_mean = mean;
        this.right_var = var;
    }

    public void initializePosterior() {
        this.left_posterior = new float[this.roi_right - this.roi_left];
        this.right_posterior = new float[this.roi_right - this.roi_left];
        Arrays.fill(this.left_posterior, 0, this.position - this.roi_left, 1.0f);
        Arrays.fill(this.right_posterior, this.position - this.roi_left, this.roi_right - this.roi_left, 1.0f);
    }

    public void setPosteriors(float[] left, float[] right) {
        this.left_posterior = left;
        this.right_posterior = right;
    }

    public void setGeneProbabilities(float[] left, float[] right) {
        this.left_geneprobs = left;
        this.right_geneprobs = right;
    }

    public void initializePriors(int length_edges) {
        this.right_prior = this.left_prior = 0.5f / (float)length_edges;
    }

    public void setPriors(float left, float right) {
        this.left_prior = left;
        this.right_prior = right;
    }

    public void updateDistributions(float[] data) {
        float left_weighted = 0.0f;
        float right_weighted = 0.0f;
        float post_sum_left = Statistics.getSum(this.left_posterior);
        float post_sum_right = Statistics.getSum(this.right_posterior);
        int count = 0;
        for (int i = this.roi_left; i < this.roi_right; ++i) {
            right_weighted += this.right_posterior[count] * data[i];
            left_weighted += this.left_posterior[count] * data[i];
            ++count;
        }
        this.left_mean = left_weighted / post_sum_left;
        this.right_mean = right_weighted / post_sum_right;
        if (Float.isNaN(this.left_mean)) {
            this.left_mean = Statistics.getMean(data, this.roi_left, this.position);
        }
        if (Double.isNaN(this.right_mean)) {
            this.right_mean = Statistics.getMean(data, this.position, this.roi_right);
        }
        int ct = 0;
        float left_weighted_var = 0.0f;
        float right_weighted_var = 0.0f;
        for (int i = this.roi_left; i < this.roi_right; ++i) {
            left_weighted_var = (float)((double)left_weighted_var + Math.pow(Math.abs(data[i] - this.left_mean), 2.0) * (double)this.left_posterior[ct]);
            right_weighted_var = (float)((double)right_weighted_var + Math.pow(Math.abs(data[i] - this.right_mean), 2.0) * (double)this.right_posterior[ct]);
            ++ct;
        }
        this.left_var = left_weighted_var / post_sum_left;
        this.right_var = right_weighted_var / post_sum_right;
        if (Double.isNaN(this.left_var)) {
            this.left_var = Statistics.getVariance(data, this.roi_left, this.position);
        }
        if (Double.isNaN(this.right_var)) {
            this.right_var = Statistics.getVariance(data, this.position, this.roi_right);
        }
    }

    public void updateProbabilities(float[] data) {
        for (int i = 0; i < this.left_posterior.length; ++i) {
            float gene_prob = this.left_prior * this.left_geneprobs[i] + this.right_prior * this.right_geneprobs[i];
            this.left_posterior[i] = this.left_geneprobs[i] * this.left_prior / gene_prob;
            this.right_posterior[i] = this.right_geneprobs[i] * this.right_prior / gene_prob;
            if (Double.isNaN(this.left_posterior[i])) {
                this.left_posterior[i] = 0.0f;
            }
            if (!Double.isNaN(this.right_posterior[i])) continue;
            this.right_posterior[i] = 0.0f;
        }
        this.left_prior = Statistics.getSum(this.left_posterior) / (float)data.length;
        this.right_prior = Statistics.getSum(this.right_posterior) / (float)data.length;
    }

    public int adjustPosition() {
        double min_val = 1.0E9;
        int best_position = this.position;
        int count = 0;
        int change = 0;
        for (int pos = this.roi_left; pos < this.roi_right; ++pos) {
            int i;
            float obj_val = 0.0f;
            double cutoff = 1.0E-5;
            for (i = 0; i < count; ++i) {
                if ((double)this.left_posterior[i] > cutoff) {
                    obj_val = (float)((double)obj_val - Math.log(this.left_posterior[i]));
                    obj_val = (float)((double)obj_val + Math.log(this.right_posterior[i]));
                    continue;
                }
                obj_val = (float)((double)obj_val - Math.log(cutoff));
            }
            for (i = count; i < this.right_posterior.length; ++i) {
                if ((double)this.right_posterior[i] > cutoff) {
                    obj_val = (float)((double)obj_val - Math.log(this.right_posterior[i]));
                    obj_val = (float)((double)obj_val + Math.log(this.left_posterior[i]));
                    continue;
                }
                obj_val = (float)((double)obj_val - Math.log(cutoff));
            }
            if ((double)obj_val < min_val) {
                min_val = obj_val;
                best_position = pos;
            }
            ++count;
        }
        if (best_position != this.position && best_position > 0) {
            change = Math.abs(this.position - best_position);
            this.position = best_position;
        }
        return change;
    }

    public void setReset(boolean should_reset) {
        this.reset = should_reset;
    }

    public void resetLikelihood() {
        this.likelihood = -1000000.0f;
        this.improving = true;
    }

    public boolean shouldRemove(float[] data, float snr_thresh) {
        int i;
        if (this.left_window <= 2 || this.position + this.right_window == data.length && this.right_window <= 2) {
            return true;
        }
        int leftbound = this.position - this.left_window;
        int rightbound = this.position + this.right_window;
        float left_median = Statistics.getMedian(data, leftbound, this.position);
        float right_median = Statistics.getMedian(data, this.position, rightbound);
        float deviation = 0.0f;
        for (i = leftbound; i < this.position; ++i) {
            deviation += Math.abs(data[i] - left_median);
        }
        for (i = this.position; i < rightbound; ++i) {
            deviation += Math.abs(data[i] - right_median);
        }
        float snr_ratio = Math.abs(left_median - right_median) / (deviation / (float)(this.left_window + this.right_window));
        return snr_ratio < snr_thresh;
    }

    public float updateLikelihood() {
        float[] maxprobs = new float[this.left_geneprobs.length];
        for (int i = 0; i < this.left_geneprobs.length; ++i) {
            maxprobs[i] = Math.max(this.left_geneprobs[i], this.right_geneprobs[i]);
        }
        float new_likelihood = 0.0f;
        for (int i = 0; i < maxprobs.length; ++i) {
            if (!(maxprobs[i] > 0.0f)) continue;
            new_likelihood = (float)((double)new_likelihood + Math.log(maxprobs[i]));
        }
        float improvement = new_likelihood - this.likelihood;
        this.improving = (double)improvement > 1.0E-4;
        this.likelihood = new_likelihood;
        return improvement;
    }

    public boolean isImproving() {
        return this.improving;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public float leftPosteriorAt(int index) {
        return this.left_posterior[index];
    }

    public float rightPosteriorAt(int index) {
        return this.right_posterior[index];
    }

    public float leftGeneprobAt(int index) {
        return this.left_geneprobs[index];
    }

    public float rightGeneprobAt(int index) {
        return this.right_geneprobs[index];
    }

    public int getPosition() {
        return this.position;
    }

    public int getLeftROI() {
        return this.roi_left;
    }

    public int getRightROI() {
        return this.roi_right;
    }

    public float getLeftMean() {
        return this.left_mean;
    }

    public float getRightMean() {
        return this.right_mean;
    }

    public float getLeftVar() {
        return this.left_var;
    }

    public float getRightVar() {
        return this.right_var;
    }

    public float getLeftStd() {
        return (float)Math.pow(this.left_var, 0.5);
    }

    public float getRightStd() {
        return (float)Math.pow(this.right_var, 0.5);
    }

    public int getRightWindow() {
        return this.right_window;
    }

    public int getLeftWindow() {
        return this.left_window;
    }

    public float[] getLeftGeneprobs() {
        return this.left_geneprobs;
    }

    public float[] getRightGeneprobs() {
        return this.right_geneprobs;
    }

    public float[] getLeftPosteriors() {
        return this.left_posterior;
    }

    public float[] getRightPosteriors() {
        return this.right_posterior;
    }

    public float getLeftPrior() {
        return this.left_prior;
    }

    public float getRightPrior() {
        return this.right_prior;
    }

    public void printData() {
        System.out.println("Edge: " + this.position);
    }
}

