/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Edge;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.SigTestThread;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Statistics;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.CharmDataGenerator.Chromosome;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.DatasetContainer;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ResultContainer;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;

public class ChARMRunner_NotUsed
extends Thread {
    public static final int MEDIAN_WINDOW = 5;
    public static final int SMOOTH_WINDOW = 3;
    public static final int ADJACENT_DIST = 2;
    public static final float INIT_SNR = 0.5f;
    public static final float MAX_SNR = 0.75f;
    public static final double PERCENT_EDGES = 0.2;
    private static int NUM_THREADS = 4;
    private static int NUM_PERMUTATIONS = 200;
    private static double MERGE_SNR_THRESH = 1.5;
    private DatasetContainer dataset;
    private Timer timer;
    private TimerListener timerListener;
    private Vector runningThreadVect;
    private Vector waitingThreadVect;
    private Vector finishedThreadVect;
    private int numPermutes;
    private int numEdges;
    private boolean isThreaded;
    private ArrayList chromExpRunList;
    private ResultContainer resultSet;
    private boolean threadState_running;
    private boolean threadState_stopflag;
    private double threadState_progress;
    private int threadState_totalThreads;
    private HashMap progressHash = new HashMap();

    public ChARMRunner_NotUsed(DatasetContainer data) {
        this.dataset = data;
        this.runningThreadVect = new Vector();
        this.waitingThreadVect = new Vector();
        this.finishedThreadVect = new Vector();
        this.threadState_running = false;
        this.threadState_stopflag = false;
        this.numPermutes = NUM_PERMUTATIONS;
    }

    private float adjustEdgePositions(ArrayList edges, float[] data) {
        int total_changes = 0;
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            this.setWindowSizes(edges, data);
            this.updateRoiParameters(curredge, data);
            total_changes += curredge.adjustPosition();
        }
        this.setWindowSizes(edges, data);
        for (int j = 0; j < edges.size(); ++j) {
            Edge curredge = (Edge)edges.get(j);
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
        }
        float convergence_measure = (float)total_changes / (float)edges.size();
        return convergence_measure;
    }

    public void setNumberPermutations(int num) {
        this.numPermutes = num;
    }

    private int cleanEdges(int[] edges) {
        Arrays.sort(edges);
        int edge_count = 0;
        for (int count = 0; count < edges.length - 1; ++count) {
            if (edges[count] == -1) continue;
            if (edges[count + 1] - edges[count] <= 2) {
                int i = count;
                while (i + 1 < edges.length && edges[i + 1] - edges[i] <= 2) {
                    ++i;
                }
                edges[edge_count] = edges[(i + count + 1) / 2];
                count = i;
                ++edge_count;
            } else {
                edges[edge_count] = edges[count];
                ++edge_count;
            }
            if (count + 1 != edges.length - 1) continue;
            edges[edge_count] = edges[count + 1];
            ++edge_count;
        }
        Arrays.fill(edges, edge_count, edges.length, -1);
        return edge_count;
    }

    private ArrayList emEdges(int[] edgeEstimates, float[] data) {
        int i;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (i = 0; i < edgeEstimates.length && edgeEstimates[i] != -1; ++i) {
            edges.add(new Edge(edgeEstimates[i]));
        }
        this.setWindowSizes(edges, data);
        for (i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
        }
        float snr_thresh = 0.5f;
        int zerocount = 0;
        int maxcount = 20;
        int count = 0;
        ArrayList<Edgedata> edgedata = new ArrayList<Edgedata>();
        for (int i2 = 0; i2 < edges.size(); ++i2) {
            edgedata.add(new Edgedata());
        }
        while (zerocount < 5 && edges.size() > 0 && count < maxcount) {
            Edge curr_edge;
            Edgedata curr_edgedata;
            int i3;
            int iter = 0;
            int max_iterations = 40;
            float improvement = 1.0f;
            for (i3 = 0; i3 < edges.size(); ++i3) {
                Edge curredge = (Edge)edges.get(i3);
                curredge.resetLikelihood();
            }
            while (iter < max_iterations && (double)improvement > 1.0E-6) {
                for (i3 = 0; i3 < edges.size(); ++i3) {
                    curr_edgedata = (Edgedata)edgedata.get(i3);
                    curr_edge = (Edge)edges.get(i3);
                    if (!curr_edge.isImproving()) continue;
                    curr_edgedata.left_geneprobs = curr_edge.getLeftGeneprobs();
                    curr_edgedata.right_geneprobs = curr_edge.getRightGeneprobs();
                    curr_edgedata.left_posterior = curr_edge.getLeftPosteriors();
                    curr_edgedata.right_posterior = curr_edge.getRightPosteriors();
                    curr_edgedata.left_mean = curr_edge.getLeftMean();
                    curr_edgedata.left_var = curr_edge.getLeftVar();
                    curr_edgedata.right_mean = curr_edge.getRightMean();
                    curr_edgedata.right_var = curr_edge.getRightVar();
                    curr_edgedata.left_prior = curr_edge.getLeftPrior();
                    curr_edgedata.right_prior = curr_edge.getRightPrior();
                }
                this.updateWindowsParameters(edges, data);
                this.updateWindowsMemberships(edges, data);
                improvement = this.updateLikelihood(edges);
                ++iter;
            }
            for (i3 = 0; i3 < edges.size(); ++i3) {
                curr_edgedata = (Edgedata)edgedata.get(i3);
                curr_edge = (Edge)edges.get(i3);
                curr_edge.setGeneProbabilities(curr_edgedata.left_geneprobs, curr_edgedata.right_geneprobs);
                curr_edge.setPosteriors(curr_edgedata.left_posterior, curr_edgedata.right_posterior);
                curr_edge.setPriors(curr_edgedata.left_prior, curr_edgedata.right_prior);
                curr_edge.setLeftDistribution(curr_edgedata.left_mean, curr_edgedata.left_var);
                curr_edge.setRightDistribution(curr_edgedata.right_mean, curr_edgedata.right_var);
            }
            float convergence = this.adjustEdgePositions(edges, data);
            if (convergence == 0.0f) {
                ++zerocount;
            }
            this.mergeWindows(edges, data, snr_thresh);
            ++count;
        }
        snr_thresh = 0.75f;
        this.mergeWindows(edges, data, snr_thresh);
        return edges;
    }

    public double getProgress() {
        return this.threadState_progress;
    }

    public void stopRun() {
        this.threadState_stopflag = true;
    }

    private int[] estimateEdges(float[] peaks) {
        float thresh = 0.95f;
        int num_edges = this.numEdges;
        int[] edges = new int[num_edges];
        Arrays.fill(edges, -1);
        int curr_edge = 0;
        while (curr_edge < num_edges && (double)thresh >= 0.7) {
            for (int i = 0; i < peaks.length; ++i) {
                if (!(Statistics.getPercentile(peaks, peaks[i]) > thresh)) continue;
                if (curr_edge >= edges.length) {
                    edges = this.resizeArray(edges);
                }
                edges[curr_edge] = i;
                ++curr_edge;
            }
            curr_edge = this.cleanEdges(edges);
            thresh = (float)((double)thresh - 0.02);
        }
        int[] estimates = new int[curr_edge];
        System.arraycopy(edges, 0, estimates, 0, curr_edge);
        return estimates;
    }

    private void initializeEdge(Edge curredge, float[] data) {
        curredge.setInfluenceWindow(data.length);
        float mean = Statistics.getMean(data, curredge.getLeftROI(), curredge.getPosition());
        float var = Statistics.getVariance(data, curredge.getLeftROI(), curredge.getPosition());
        curredge.setLeftDistribution(mean, var);
        mean = Statistics.getMean(data, curredge.getPosition(), curredge.getRightROI());
        var = Statistics.getVariance(data, curredge.getPosition(), curredge.getRightROI());
        curredge.setRightDistribution(mean, var);
        curredge.initializePosterior();
        this.updateGeneProbabilities(curredge, data);
    }

    private void mergeWindows(ArrayList edges, float[] data, float thresh) {
        int ct = 0;
        while (ct < edges.size()) {
            Edge curredge = (Edge)edges.get(ct);
            if (curredge.shouldRemove(data, thresh)) {
                if (ct > 0) {
                    Edge prevedge = (Edge)edges.get(ct - 1);
                    prevedge.setReset(true);
                }
                if (ct < edges.size() - 1) {
                    Edge nextedge = (Edge)edges.get(ct + 1);
                    nextedge.setReset(true);
                }
                edges.remove(ct);
                continue;
            }
            ++ct;
        }
        this.setWindowSizes(edges, data);
        for (int j = 0; j < edges.size(); ++j) {
            Edge curredge = (Edge)edges.get(j);
            if (!curredge.shouldReset()) continue;
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
            curredge.setReset(false);
        }
    }

    @Override
    public void run() {
        ArrayList chromExps = this.chromExpRunList;
        for (int m = 0; m < chromExps.size(); ++m) {
            ArrayList currSet = (ArrayList)chromExps.get(m);
            Chromosome currChrom = (Chromosome)currSet.get(0);
            String currExp = (String)currSet.get(1);
            float[] data = currChrom.getRatioArray(currExp, false);
            float[] peaks = this.filterData(data);
            this.numEdges = Math.max((int)Math.ceil((double)peaks.length * 0.2), 10);
            int[] edgeEstimates = this.estimateEdges(peaks);
            ArrayList edges = this.emEdges(edgeEstimates, data);
            int[] final_edges = new int[edges.size()];
            for (int i = 0; i < edges.size(); ++i) {
                final_edges[i] = ((Edge)edges.get(i)).getPosition();
            }
            ArrayList segments = this.getWindowsFromEdges(final_edges, data.length);
            this.mergeWindows(segments, data);
            for (int i = 0; i < segments.size(); ++i) {
                ((SegmentInfo)segments.get(i)).setBonferroniCorrection(segments.size());
                this.resultSet.addSegment((SegmentInfo)segments.get(i), currExp, currChrom.getNumber());
            }
        }
        this.runSignificanceTests(this.resultSet, this.isThreaded);
    }

    private ArrayList getWindowsFromEdges(int[] edges, int datlength) {
        SegmentInfo curr_window;
        int last = 0;
        ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
        for (int i = 0; i < edges.length; ++i) {
            curr_window = new SegmentInfo();
            curr_window.setStart(last);
            curr_window.setEnd(edges[i] - 1);
            segments.add(curr_window);
            last = edges[i];
        }
        curr_window = new SegmentInfo();
        curr_window.setStart(last);
        curr_window.setEnd(datlength - 1);
        segments.add(curr_window);
        return segments;
    }

    public ResultContainer getResultSet() {
        return this.resultSet;
    }

    private void runSignificanceTests(ResultContainer results, boolean threaded) {
    }

    private void updateGeneProbabilities(Edge curredge, float[] data) {
        int j;
        float[] leftgeneprob = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] rightgeneprob = new float[leftgeneprob.length];
        int count = 0;
        for (j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            leftgeneprob[count] = Statistics.getGaussianDensity(data[j], curredge.getLeftMean(), curredge.getLeftStd());
            ++count;
        }
        count = 0;
        for (j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            rightgeneprob[count] = Statistics.getGaussianDensity(data[j], curredge.getRightMean(), curredge.getRightStd());
            ++count;
        }
        curredge.setGeneProbabilities(leftgeneprob, rightgeneprob);
    }

    private int[] resizeArray(int[] arr) {
        int[] newArr = new int[arr.length * 2 + 1];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        Arrays.fill(newArr, arr.length, newArr.length, -1);
        return newArr;
    }

    private void setWindowSizes(ArrayList edges, float[] data) {
        int i;
        int lastedge = 0;
        for (i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            int windowsize = curredge.getPosition() - lastedge;
            curredge.setLeftWindow(windowsize);
            if (i > 0) {
                Edge prevedge = (Edge)edges.get(i - 1);
                prevedge.setRightWindow(windowsize);
            }
            lastedge = curredge.getPosition();
        }
        if (i > 0) {
            Edge finaledge = (Edge)edges.get(i - 1);
            finaledge.setRightWindow(data.length - finaledge.getPosition());
        }
    }

    private float updateLikelihood(ArrayList edges) {
        float total_improvement = 0.0f;
        for (int i = 0; i < edges.size(); ++i) {
            total_improvement += ((Edge)edges.get(i)).updateLikelihood();
        }
        return total_improvement;
    }

    private void updateWindowsParameters(ArrayList edges, float[] data) {
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            if (!curredge.isImproving()) continue;
            curredge.updateDistributions(data);
        }
    }

    private void updateWindowsMemberships(ArrayList edges, float[] data) {
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            if (!curredge.isImproving()) continue;
            this.updateGeneProbabilities(curredge, data);
            curredge.updateProbabilities(data);
        }
    }

    private void updateRoiParameters(Edge curredge, float[] data) {
        int old_roi_left = curredge.getLeftROI();
        int old_roi_right = curredge.getRightROI();
        curredge.setInfluenceWindow(data.length);
        float[] left_newpost = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] right_newpost = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] left_newgeneprobs = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] right_newgeneprobs = new float[curredge.getRightROI() - curredge.getLeftROI()];
        int oldct = 0;
        int newct = 0;
        for (int j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            if (j >= old_roi_left && j < old_roi_right) {
                left_newpost[newct] = curredge.leftPosteriorAt(oldct);
                right_newpost[newct] = curredge.rightPosteriorAt(oldct);
                left_newgeneprobs[newct] = curredge.leftGeneprobAt(oldct);
                right_newgeneprobs[newct] = curredge.rightGeneprobAt(oldct);
                ++oldct;
            } else {
                right_newgeneprobs[newct] = 0.0f;
                left_newgeneprobs[newct] = 0.0f;
                right_newpost[newct] = 0.0f;
                left_newpost[newct] = 0.0f;
            }
            ++newct;
        }
        curredge.setPosteriors(left_newpost, right_newpost);
        curredge.setGeneProbabilities(left_newgeneprobs, right_newgeneprobs);
    }

    private float[] filterData(float[] ratios) {
        int i;
        float[] medians = new float[ratios.length];
        if (ratios.length < 2) {
            float[] newArray = new float[ratios.length];
            System.arraycopy(ratios, 0, newArray, 0, ratios.length);
            return newArray;
        }
        for (int i2 = 0; i2 < ratios.length; ++i2) {
            medians[i2] = Statistics.getMedian(ratios, i2 - 2, i2 + 2);
        }
        float[] means = new float[medians.length];
        for (int i3 = 0; i3 < means.length; ++i3) {
            means[i3] = Statistics.getMean(medians, i3 - 1, i3 + 1);
        }
        float[] diff = new float[means.length];
        for (i = 0; i < diff.length - 1; ++i) {
            int lower = i > 0 ? i - 1 : 0;
            diff[i] = means[i + 1] - means[lower];
        }
        diff[i] = i > 0 ? means[i] - means[i - 1] : means[i];
        return diff;
    }

    private void mergeWindows(ArrayList windowArray, float[] data) {
        for (int i = 1; i < windowArray.size(); ++i) {
            SegmentInfo currLeft = (SegmentInfo)windowArray.get(i - 1);
            SegmentInfo currRight = (SegmentInfo)windowArray.get(i);
            float leftMean = Statistics.getMean(data, currLeft.getStart(), currLeft.getEnd() + 1);
            float leftVar = Statistics.getVariance(data, currLeft.getStart(), currLeft.getEnd() + 1);
            float rightMean = Statistics.getMean(data, currRight.getStart(), currRight.getEnd() + 1);
            float rightVar = Statistics.getVariance(data, currRight.getStart(), currRight.getEnd() + 1);
            double snr = (double)Math.abs(leftMean - rightMean) / Math.sqrt(leftVar / (float)currLeft.getSize() + rightVar / (float)currRight.getSize());
            if (!(snr < MERGE_SNR_THRESH)) continue;
            currLeft.setEnd(currRight.getEnd());
            currLeft.resetSegment();
            windowArray.remove(i);
            --i;
        }
    }

    private class TimerListener
    extends TimerTask {
        private TimerListener() {
        }

        @Override
        public void run() {
            SigTestThread currElement;
            int numDone;
            Enumeration runningThreadEnum;
            int currSize = ChARMRunner_NotUsed.this.runningThreadVect.size();
            if (currSize > 0) {
                runningThreadEnum = ChARMRunner_NotUsed.this.runningThreadVect.elements();
                numDone = 0;
                while (runningThreadEnum.hasMoreElements()) {
                    currElement = (SigTestThread)runningThreadEnum.nextElement();
                    if (!currElement.hasRun()) continue;
                    ++numDone;
                    ChARMRunner_NotUsed.this.runningThreadVect.remove(currElement);
                    ChARMRunner_NotUsed.this.finishedThreadVect.add(currElement);
                    if ((Integer)ChARMRunner_NotUsed.this.progressHash.get(currElement.getDescription()) == 1) {
                        System.out.println("Finished " + currElement.getDescription());
                    }
                    ChARMRunner_NotUsed.this.progressHash.put(currElement.getDescription(), new Integer((Integer)ChARMRunner_NotUsed.this.progressHash.get(currElement.getDescription()) - 1));
                }
            }
            for (currSize = ChARMRunner_NotUsed.this.runningThreadVect.size(); currSize < NUM_THREADS && ChARMRunner_NotUsed.this.waitingThreadVect.size() > 0; ++currSize) {
                SigTestThread currThread = (SigTestThread)ChARMRunner_NotUsed.this.waitingThreadVect.get(ChARMRunner_NotUsed.this.waitingThreadVect.size() - 1);
                ChARMRunner_NotUsed.this.waitingThreadVect.remove(currThread);
                ChARMRunner_NotUsed.this.runningThreadVect.add(currThread);
            }
            ChARMRunner_NotUsed.this.threadState_progress = ((double)ChARMRunner_NotUsed.this.finishedThreadVect.size() + 0.0) / (double)ChARMRunner_NotUsed.this.threadState_totalThreads;
            if (ChARMRunner_NotUsed.this.threadState_stopflag) {
                if (currSize > 0) {
                    runningThreadEnum = ChARMRunner_NotUsed.this.runningThreadVect.elements();
                    numDone = 0;
                    while (runningThreadEnum.hasMoreElements()) {
                        currElement = (SigTestThread)runningThreadEnum.nextElement();
                    }
                }
                this.cancel();
            }
            if (currSize == 0 && ChARMRunner_NotUsed.this.waitingThreadVect.size() == 0) {
                this.cancel();
                ChARMRunner_NotUsed.this.threadState_running = false;
            }
        }
    }

    private static class Edgedata {
        public float left_mean;
        public float left_var;
        public float right_mean;
        public float right_var;
        public float[] left_posterior;
        public float[] right_posterior;
        public float[] left_geneprobs;
        public float[] right_geneprobs;
        public float left_prior;
        public float right_prior;
    }
}

