/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Edge;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.PValue;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.RunCharmProgressPanel;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.SigTestThread;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.Statistics;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ResultContainer;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.CharmGUI;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GraphViewPanel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDialogs.CharmAnalyzeDialog;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class ChARM
implements IClusterGUI {
    boolean packFrame = false;
    Timer charmProgressTimer;
    public static final int MEDIAN_WINDOW = 5;
    public static final int SMOOTH_WINDOW = 3;
    public static final float PERCENT_EDGES = 0.2f;
    public static final int ADJACENT_DIST = 2;
    public static final float INIT_SNR = 0.5f;
    public static final float MAX_SNR = 0.75f;
    private static float MERGE_SNR_THRESH = 1.5f;
    private ArrayList selectedExps;
    private ArrayList displayExps;
    private IData data;
    private IFramework frame;
    private int[][] chrIndices;
    private int[] exprInidces;
    private int numEdges = 0;
    private DefaultMutableTreeNode resultRoot;
    private DefaultMutableTreeNode viewerNode;
    private DefaultMutableTreeNode paramNode;
    private CharmAnalyzeDialog analyzeData;
    private PValue currPvalueCutoff;
    private int pvalTestType;
    private ArrayList exprNames;
    private ArrayList graphSelectedGenes;
    private ArrayList graphSelectedWindows;
    private String graphSelectedExp;
    private int graphSelectedChrom;
    private HashMap stateVariableHash;
    private String graphMode;
    private CharmGUI charmViewer;
    private ResultContainer resultSet;
    private RunCharmProgressPanel runProgressPanel;
    private boolean isDone = false;
    private boolean isCanceled = false;

    public ChARM() {
        System.out.println("ChARM constructor");
        this.selectedExps = new ArrayList();
        this.displayExps = new ArrayList();
        this.stateVariableHash = new HashMap();
        this.currPvalueCutoff = new PValue(0.05, 0.001);
    }

    public PValue getPvalueCutoff() {
        return this.currPvalueCutoff;
    }

    public void setPValueCutoff(PValue p) {
        this.currPvalueCutoff = p;
    }

    public void setPValueTestType(int type) {
        this.pvalTestType = type;
    }

    public int getPValueTestType() {
        return this.pvalTestType;
    }

    public ArrayList getSelectedExperiments() {
        return this.displayExps;
    }

    public void setSelectedExperiments(ArrayList exprs) {
        this.displayExps = exprs;
    }

    public ArrayList getExperimentList() {
        return this.selectedExps;
    }

    public int[] getExprIndices() {
        return this.exprInidces;
    }

    public void setExprIndices(int[] ind) {
        this.exprInidces = ind;
    }

    public int[][] getChrIndices() {
        return this.chrIndices;
    }

    public void setChrIndices(int[][] ind) {
        this.chrIndices = ind;
    }

    public void setExperimentList(ArrayList exprs) {
        this.selectedExps = exprs;
    }

    public ResultContainer getSelectedResultSets() {
        return this.resultSet;
    }

    public void setSelectedResultSets(ResultContainer result) {
        if (result == null) {
            System.out.println("getSelectedResultSets(): result null");
        }
        this.resultSet = result;
    }

    public CharmGUI getCharmGUI() {
        return this.charmViewer;
    }

    public void setCharmGUI(CharmGUI gui) {
        if (gui == null) {
            System.out.println("getCharmGUI(): gui is null");
        }
        this.charmViewer = gui;
    }

    public ArrayList getPredictionSegments(String exp, int chromosome) {
        ArrayList tempList = this.resultSet.getSegmentsMeetingCriteria(exp, chromosome, this.currPvalueCutoff, this.pvalTestType);
        return tempList;
    }

    public ArrayList getAllPredictionSegments(String exp, int chromosome) {
        ArrayList windowArray = new ArrayList();
        ArrayList tempList = this.getPredictionSegments(exp, chromosome);
        windowArray.addAll(tempList);
        return windowArray;
    }

    public int printVisiblePredictionWindows(String filename) {
        int status = 0;
        int returnStatus = 0;
        this.resultSet.printHeaderToFile(filename, false);
        status = this.resultSet.printToFile(filename, true, this.currPvalueCutoff, this.pvalTestType);
        return returnStatus;
    }

    public void setGraphMode(String mode) {
        this.graphMode = mode;
    }

    public String getGraphMode() {
        return this.graphMode;
    }

    public void setGraphSelectionGenes(String currExp, int chromNum, ArrayList geneList) {
        this.graphSelectedGenes = geneList;
        this.graphSelectedExp = currExp;
        this.graphSelectedChrom = chromNum;
        this.setStateVariable("Graph Selection Type", "gene");
        if (this.charmViewer == null) {
            System.out.println("setGraphSelectionGenes().charmViewer is null");
        }
        this.charmViewer.updateViewResults();
    }

    public void setGraphSelectionSegments(String currExp, int chromNum, ArrayList windowList) {
        this.graphSelectedWindows = windowList;
        this.graphSelectedExp = currExp;
        this.graphSelectedChrom = chromNum;
        this.setStateVariable("Graph Selection Type", "window");
        this.charmViewer.updateViewResults();
    }

    public void clearGraphSelection() {
        this.graphSelectedGenes = null;
        this.graphSelectedWindows = null;
        this.graphSelectedExp = null;
        this.graphSelectedChrom = 0;
        this.setStateVariable("Graph Selection Type", "none");
        this.charmViewer.updateViewResults();
    }

    public ArrayList getGraphSelectionGenes() {
        return this.graphSelectedGenes;
    }

    public void setGraphSelectionGenes(ArrayList genes) {
        this.graphSelectedGenes = genes;
    }

    public ArrayList getGraphSelectionWindows() {
        return this.graphSelectedWindows;
    }

    public void setGraphSelectionWindows(ArrayList genes) {
        this.graphSelectedWindows = genes;
    }

    public String getGraphSelectionExperiment() {
        return this.graphSelectedExp;
    }

    public void getGraphSelectionExperiment(String exp) {
        this.graphSelectedExp = exp;
    }

    public int getGraphSelectionChromosome() {
        return this.graphSelectedChrom;
    }

    public void getGraphSelectionChromosome(int chr) {
        this.graphSelectedChrom = chr;
    }

    public GraphViewPanel getGraphPanel() {
        return this.charmViewer.getGraphViewPanel();
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData dat) {
        this.data = dat;
    }

    public IFramework getFramework() {
        return this.frame;
    }

    public void setStateVariable(String variable, String state) {
        this.stateVariableHash.put(variable, state);
    }

    public String getStateVariable(String variable) {
        String state = new String(" ");
        if (this.stateVariableHash.containsKey(variable)) {
            state = (String)this.stateVariableHash.get(variable);
        }
        return state;
    }

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.data = framework.getData();
        this.frame = framework;
        this.chrIndices = this.data.getChromosomeIndices();
        this.numEdges = 0;
        System.out.println("ChARM ChARM Analyze Execute Method");
        JPanel dummyPanel = new JPanel();
        ArrayList featuresList = this.data.getFeaturesList();
        this.exprNames = new ArrayList();
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            this.exprNames.add(name);
        }
        this.analyzeData = new CharmAnalyzeDialog(this.exprNames);
        this.analyzeData.setLocationRelativeTo(dummyPanel);
        this.analyzeData.setVisible(true);
        if (this.analyzeData.getExitStatus() != 1) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CharmListener listener = new CharmListener();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    ChARM.this.runProgressPanel = new RunCharmProgressPanel(ChARM.this.frame.getFrame(), "ChARM Execution", listener);
                    ChARM.this.runProgressPanel.show();
                    ChARM.this.runChARM();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ChARM.this.runProgressPanel.dispose();
            }
        });
        thread.start();
        while (!this.isDone || this.isCanceled) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException x) {}
        }
        if (this.isCanceled) {
            return null;
        }
        this.updateCharmViewer();
        return this.createResultNode();
    }

    private void runChARM() {
        String currExpr;
        int m;
        this.exprInidces = this.analyzeData.getSelectedExperimentsIndices();
        for (m = 0; m < this.exprInidces.length; ++m) {
            currExpr = (String)this.exprNames.get(this.exprInidces[m]);
            this.selectedExps.add(currExpr);
        }
        this.displayExps.add(this.selectedExps.get(0));
        this.initCharmViewer();
        this.resultSet = new ResultContainer(this.data, this.selectedExps);
        for (m = 0; m < this.exprInidces.length; ++m) {
            currExpr = (String)this.exprNames.get(this.exprInidces[m]);
            for (int chr = 0; chr < this.chrIndices.length; ++chr) {
                float[] geneRatiosOfExpr = this.getRatioArrayNoNa(this.exprInidces[m], chr);
                float[] peaks = this.filterData(geneRatiosOfExpr);
                this.numEdges = Math.max((int)Math.ceil((float)peaks.length * 0.2f), 10);
                int[] edgeEstimates = this.estimateEdges(peaks, this.numEdges);
                ArrayList edges = this.emEdges(edgeEstimates, geneRatiosOfExpr);
                int[] final_edges = new int[edges.size()];
                for (int i = 0; i < edges.size(); ++i) {
                    final_edges[i] = ((Edge)edges.get(i)).getPosition();
                }
                ArrayList segments = this.getWindowsFromEdges(final_edges, geneRatiosOfExpr.length);
                this.mergeWindows(segments, geneRatiosOfExpr);
                for (int i = 0; i < segments.size(); ++i) {
                    ((SegmentInfo)segments.get(i)).setBonferroniCorrection(segments.size());
                    this.resultSet.addSegment((SegmentInfo)segments.get(i), currExpr, chr + 1);
                }
            }
        }
        this.runSignificanceTests(this.resultSet, this.chrIndices, this.exprInidces);
        this.isDone = true;
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initCharmViewer() {
        this.charmViewer = new CharmGUI(this.frame, this, this.exprInidces);
        this.charmViewer.updateExpOptions();
        this.charmViewer.getJTabbedPane1().setSelectedIndex(1);
        this.charmViewer.getTogglePredictionsButton().setEnabled(true);
        this.charmViewer.getTogglePredictionsButton().setSelected(true);
    }

    public void updateCharmViewer() {
        System.out.println("In execute() charmViewer constructed");
        this.charmViewer.getGraphViewPanel().initializePredictionNodes(this.getSelectedExperiments());
        this.charmViewer.getTogglePredictionsButton().setEnabled(true);
        this.charmViewer.getTogglePredictionsButton().setSelected(true);
        this.setStateVariable("Prediction Plot Toggle", "on");
        this.charmViewer.getJTabbedPane1().setSelectedIndex(1);
        this.charmViewer.getGraphViewPanel().updateGraph();
        this.charmViewer.validate();
        this.charmViewer.show();
    }

    private DefaultMutableTreeNode createResultNode() {
        this.resultRoot = new DefaultMutableTreeNode("ChARM");
        this.viewerNode = new DefaultMutableTreeNode(new LeafInfo("ChARM Viewer", (IViewer)this.charmViewer));
        this.resultRoot.add(this.viewerNode);
        this.paramNode = new DefaultMutableTreeNode("General Information");
        for (int i = 0; i < this.selectedExps.size(); ++i) {
            this.paramNode.add(new DefaultMutableTreeNode("Experiment: " + this.selectedExps.get(i)));
        }
        this.resultRoot.add(this.paramNode);
        return this.resultRoot;
    }

    private void runSignificanceTests(ResultContainer results, int[][] chrIndices, int[] exprInidces) {
        for (int i = chrIndices.length; i != 0; --i) {
            int curChr = i - 1;
            for (int j = 0; j < this.selectedExps.size(); ++j) {
                String currExp = (String)this.selectedExps.get(j);
                System.out.println("Cur Chr: " + curChr + ", Cur Expr" + currExp);
                ArrayList currWindows = results.getSegments(currExp, curChr + 1);
                float[] geneRatiosOfExpr = this.getRatioArrayNoNa(exprInidces[j], curChr);
                for (int k = 0; k < currWindows.size(); ++k) {
                    SigTestThread tester = new SigTestThread(geneRatiosOfExpr, curChr + 1, currExp, (SegmentInfo)currWindows.get(k));
                    tester.setTests(true, true, false, false);
                    tester.runPermuteTest();
                    tester.runSignTest();
                }
            }
        }
    }

    private ArrayList getWindowsFromEdges(int[] edges, int datlength) {
        SegmentInfo currSeg;
        int last = 0;
        ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
        for (int i = 0; i < edges.length; ++i) {
            currSeg = new SegmentInfo();
            currSeg.setStart(last);
            currSeg.setEnd(edges[i] - 1);
            segments.add(currSeg);
            last = edges[i];
        }
        currSeg = new SegmentInfo();
        currSeg.setStart(last);
        currSeg.setEnd(datlength - 1);
        segments.add(currSeg);
        return segments;
    }

    private float[] filterData(float[] ratios) {
        int i;
        float[] medians = new float[ratios.length];
        if (ratios.length < 2) {
            float[] newArray = new float[ratios.length];
            System.arraycopy(ratios, 0, newArray, 0, ratios.length);
            return newArray;
        }
        for (int i2 = 0; i2 < ratios.length; ++i2) {
            medians[i2] = Statistics.getMedian(ratios, i2 - 2, i2 + 2);
        }
        float[] means = new float[medians.length];
        for (int i3 = 0; i3 < means.length; ++i3) {
            means[i3] = Statistics.getMean(medians, i3 - 1, i3 + 1);
        }
        float[] diff = new float[means.length];
        for (i = 0; i < diff.length - 1; ++i) {
            int lower = i > 0 ? i - 1 : 0;
            diff[i] = means[i + 1] - means[lower];
        }
        diff[i] = i > 0 ? means[i] - means[i - 1] : means[i];
        return diff;
    }

    private int[] estimateEdges(float[] peaks, int numEdges) {
        float thresh = 0.95f;
        int num_edges = numEdges;
        int[] edges = new int[num_edges];
        Arrays.fill(edges, -1);
        int curr_edge = 0;
        while (curr_edge < num_edges && (double)thresh >= 0.7) {
            for (int i = 0; i < peaks.length; ++i) {
                if (!(Statistics.getPercentile(peaks, peaks[i]) > thresh)) continue;
                if (curr_edge >= edges.length) {
                    edges = this.resizeArray(edges);
                }
                edges[curr_edge] = i;
                ++curr_edge;
            }
            curr_edge = this.cleanEdges(edges);
            thresh = (float)((double)thresh - 0.02);
        }
        int[] estimates = new int[curr_edge];
        System.arraycopy(edges, 0, estimates, 0, curr_edge);
        return estimates;
    }

    private int[] resizeArray(int[] arr) {
        int[] newArr = new int[arr.length * 2 + 1];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        Arrays.fill(newArr, arr.length, newArr.length, -1);
        return newArr;
    }

    private int cleanEdges(int[] edges) {
        Arrays.sort(edges);
        int edge_count = 0;
        for (int count = 0; count < edges.length - 1; ++count) {
            if (edges[count] == -1) continue;
            if (edges[count + 1] - edges[count] <= 2) {
                int i = count;
                while (i + 1 < edges.length && edges[i + 1] - edges[i] <= 2) {
                    ++i;
                }
                edges[edge_count] = edges[(i + count + 1) / 2];
                count = i;
                ++edge_count;
            } else {
                edges[edge_count] = edges[count];
                ++edge_count;
            }
            if (count + 1 != edges.length - 1) continue;
            edges[edge_count] = edges[count + 1];
            ++edge_count;
        }
        Arrays.fill(edges, edge_count, edges.length, -1);
        return edge_count;
    }

    private ArrayList emEdges(int[] edgeEstimates, float[] data) {
        int i;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (i = 0; i < edgeEstimates.length && edgeEstimates[i] != -1; ++i) {
            edges.add(new Edge(edgeEstimates[i]));
        }
        this.setWindowSizes(edges, data);
        for (i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
        }
        float snr_thresh = 0.5f;
        int zerocount = 0;
        int maxcount = 20;
        int count = 0;
        ArrayList<Edgedata> edgedata = new ArrayList<Edgedata>();
        for (int i2 = 0; i2 < edges.size(); ++i2) {
            edgedata.add(new Edgedata());
        }
        while (zerocount < 5 && edges.size() > 0 && count < maxcount) {
            Edge curr_edge;
            Edgedata curr_edgedata;
            int i3;
            int iter = 0;
            int max_iterations = 40;
            float improvement = 1.0f;
            for (i3 = 0; i3 < edges.size(); ++i3) {
                Edge curredge = (Edge)edges.get(i3);
                curredge.resetLikelihood();
            }
            while (iter < max_iterations && (double)improvement > 1.0E-6) {
                for (i3 = 0; i3 < edges.size(); ++i3) {
                    curr_edgedata = (Edgedata)edgedata.get(i3);
                    curr_edge = (Edge)edges.get(i3);
                    if (!curr_edge.isImproving()) continue;
                    curr_edgedata.left_geneprobs = curr_edge.getLeftGeneprobs();
                    curr_edgedata.right_geneprobs = curr_edge.getRightGeneprobs();
                    curr_edgedata.left_posterior = curr_edge.getLeftPosteriors();
                    curr_edgedata.right_posterior = curr_edge.getRightPosteriors();
                    curr_edgedata.left_mean = curr_edge.getLeftMean();
                    curr_edgedata.left_var = curr_edge.getLeftVar();
                    curr_edgedata.right_mean = curr_edge.getRightMean();
                    curr_edgedata.right_var = curr_edge.getRightVar();
                    curr_edgedata.left_prior = curr_edge.getLeftPrior();
                    curr_edgedata.right_prior = curr_edge.getRightPrior();
                }
                this.updateWindowsParameters(edges, data);
                this.updateWindowsMemberships(edges, data);
                improvement = this.updateLikelihood(edges);
                ++iter;
            }
            for (i3 = 0; i3 < edges.size(); ++i3) {
                curr_edgedata = (Edgedata)edgedata.get(i3);
                curr_edge = (Edge)edges.get(i3);
                curr_edge.setGeneProbabilities(curr_edgedata.left_geneprobs, curr_edgedata.right_geneprobs);
                curr_edge.setPosteriors(curr_edgedata.left_posterior, curr_edgedata.right_posterior);
                curr_edge.setPriors(curr_edgedata.left_prior, curr_edgedata.right_prior);
                curr_edge.setLeftDistribution(curr_edgedata.left_mean, curr_edgedata.left_var);
                curr_edge.setRightDistribution(curr_edgedata.right_mean, curr_edgedata.right_var);
            }
            double convergence = this.adjustEdgePositions(edges, data);
            if (convergence == 0.0) {
                ++zerocount;
            }
            this.mergeWindows(edges, data, snr_thresh);
            ++count;
        }
        snr_thresh = 0.75f;
        this.mergeWindows(edges, data, snr_thresh);
        return edges;
    }

    private void initializeEdge(Edge curredge, float[] data) {
        curredge.setInfluenceWindow(data.length);
        float mean = Statistics.getMean(data, curredge.getLeftROI(), curredge.getPosition());
        float var = Statistics.getVariance(data, curredge.getLeftROI(), curredge.getPosition());
        curredge.setLeftDistribution(mean, var);
        mean = Statistics.getMean(data, curredge.getPosition(), curredge.getRightROI());
        var = Statistics.getVariance(data, curredge.getPosition(), curredge.getRightROI());
        curredge.setRightDistribution(mean, var);
        curredge.initializePosterior();
        this.updateGeneProbabilities(curredge, data);
    }

    private void updateGeneProbabilities(Edge curredge, float[] data) {
        int j;
        float[] leftgeneprob = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] rightgeneprob = new float[leftgeneprob.length];
        int count = 0;
        for (j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            leftgeneprob[count] = Statistics.getGaussianDensity(data[j], curredge.getLeftMean(), curredge.getLeftStd());
            ++count;
        }
        count = 0;
        for (j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            rightgeneprob[count] = Statistics.getGaussianDensity(data[j], curredge.getRightMean(), curredge.getRightStd());
            ++count;
        }
        curredge.setGeneProbabilities(leftgeneprob, rightgeneprob);
    }

    private void setWindowSizes(ArrayList edges, float[] data) {
        int i;
        int lastedge = 0;
        for (i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            int windowsize = curredge.getPosition() - lastedge;
            curredge.setLeftWindow(windowsize);
            if (i > 0) {
                Edge prevedge = (Edge)edges.get(i - 1);
                prevedge.setRightWindow(windowsize);
            }
            lastedge = curredge.getPosition();
        }
        if (i > 0) {
            Edge finaledge = (Edge)edges.get(i - 1);
            finaledge.setRightWindow(data.length - finaledge.getPosition());
        }
    }

    private void updateWindowsParameters(ArrayList edges, float[] data) {
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            if (!curredge.isImproving()) continue;
            curredge.updateDistributions(data);
        }
    }

    private void updateWindowsMemberships(ArrayList edges, float[] data) {
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            if (!curredge.isImproving()) continue;
            this.updateGeneProbabilities(curredge, data);
            curredge.updateProbabilities(data);
        }
    }

    private float updateLikelihood(ArrayList edges) {
        float total_improvement = 0.0f;
        for (int i = 0; i < edges.size(); ++i) {
            total_improvement += ((Edge)edges.get(i)).updateLikelihood();
        }
        return total_improvement;
    }

    private float adjustEdgePositions(ArrayList edges, float[] data) {
        int total_changes = 0;
        for (int i = 0; i < edges.size(); ++i) {
            Edge curredge = (Edge)edges.get(i);
            this.setWindowSizes(edges, data);
            this.updateRoiParameters(curredge, data);
            total_changes += curredge.adjustPosition();
        }
        this.setWindowSizes(edges, data);
        for (int j = 0; j < edges.size(); ++j) {
            Edge curredge = (Edge)edges.get(j);
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
        }
        float convergence_measure = (float)total_changes / (float)edges.size();
        return convergence_measure;
    }

    private void mergeWindows(ArrayList edges, float[] data, float thresh) {
        int ct = 0;
        while (ct < edges.size()) {
            Edge curredge = (Edge)edges.get(ct);
            if (curredge.shouldRemove(data, thresh)) {
                if (ct > 0) {
                    Edge prevedge = (Edge)edges.get(ct - 1);
                    prevedge.setReset(true);
                }
                if (ct < edges.size() - 1) {
                    Edge nextedge = (Edge)edges.get(ct + 1);
                    nextedge.setReset(true);
                }
                edges.remove(ct);
                continue;
            }
            ++ct;
        }
        this.setWindowSizes(edges, data);
        for (int j = 0; j < edges.size(); ++j) {
            Edge curredge = (Edge)edges.get(j);
            if (!curredge.shouldReset()) continue;
            this.initializeEdge(curredge, data);
            curredge.initializePriors(edges.size());
            curredge.setReset(false);
        }
    }

    private void mergeWindows(ArrayList windowArray, float[] data) {
        for (int i = 1; i < windowArray.size(); ++i) {
            SegmentInfo currLeft = (SegmentInfo)windowArray.get(i - 1);
            SegmentInfo currRight = (SegmentInfo)windowArray.get(i);
            float leftMean = Statistics.getMean(data, currLeft.getStart(), currLeft.getEnd() + 1);
            float leftVar = Statistics.getVariance(data, currLeft.getStart(), currLeft.getEnd() + 1);
            float rightMean = Statistics.getMean(data, currRight.getStart(), currRight.getEnd() + 1);
            float rightVar = Statistics.getVariance(data, currRight.getStart(), currRight.getEnd() + 1);
            float snr = Math.abs(leftMean - rightMean) / (float)Math.sqrt(leftVar / (float)currLeft.getSize() + rightVar / (float)currRight.getSize());
            if (!(snr < MERGE_SNR_THRESH)) continue;
            currLeft.setEnd(currRight.getEnd());
            currLeft.resetSegment();
            windowArray.remove(i);
            --i;
        }
    }

    private void updateRoiParameters(Edge curredge, float[] data) {
        int old_roi_left = curredge.getLeftROI();
        int old_roi_right = curredge.getRightROI();
        curredge.setInfluenceWindow(data.length);
        float[] left_newpost = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] right_newpost = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] left_newgeneprobs = new float[curredge.getRightROI() - curredge.getLeftROI()];
        float[] right_newgeneprobs = new float[curredge.getRightROI() - curredge.getLeftROI()];
        int oldct = 0;
        int newct = 0;
        for (int j = curredge.getLeftROI(); j < curredge.getRightROI(); ++j) {
            if (j >= old_roi_left && j < old_roi_right) {
                left_newpost[newct] = curredge.leftPosteriorAt(oldct);
                right_newpost[newct] = curredge.rightPosteriorAt(oldct);
                left_newgeneprobs[newct] = curredge.leftGeneprobAt(oldct);
                right_newgeneprobs[newct] = curredge.rightGeneprobAt(oldct);
                ++oldct;
            } else {
                right_newgeneprobs[newct] = 0.0f;
                left_newgeneprobs[newct] = 0.0f;
                right_newpost[newct] = 0.0f;
                left_newpost[newct] = 0.0f;
            }
            ++newct;
        }
        curredge.setPosteriors(left_newpost, right_newpost);
        curredge.setGeneProbabilities(left_newgeneprobs, right_newgeneprobs);
    }

    public void addSelectedExperiment(String exp) {
        this.displayExps.add(exp);
    }

    public void removeSelectedExperiment(String exp) {
        if (this.displayExps.contains(exp)) {
            this.displayExps.remove(exp);
        }
    }

    public void addSelectedExperiments(ArrayList exps) {
        this.displayExps.addAll(exps);
    }

    public float[] getRatioArrayNoNa(int exprInd, int chrInd) {
        int[][] chrIndices = this.data.getChromosomeIndices();
        int st = chrIndices[chrInd][0];
        int end = chrIndices[chrInd][1];
        ArrayList<Float> tempRatios = new ArrayList<Float>();
        for (int ii = st; ii < end; ++ii) {
            float tmp = this.data.getLogAverageInvertedValue(exprInd, ii);
            if (Float.isNaN(tmp)) continue;
            tempRatios.add(new Float(tmp));
        }
        Object[] objs = tempRatios.toArray();
        float[] ratios = new float[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            ratios[i] = ((Float)objs[i]).floatValue();
        }
        return ratios;
    }

    private class CharmListener
    extends DialogListener {
        private CharmListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                ChARM.this.isCanceled = true;
                ChARM.this.runProgressPanel.dispose();
            }
        }

        public void windowClosing(WindowEvent e) {
            ChARM.this.isCanceled = true;
            ChARM.this.runProgressPanel.dispose();
        }
    }

    private static class Edgedata {
        public float left_mean;
        public float left_var;
        public float right_mean;
        public float right_var;
        public float[] left_posterior;
        public float[] right_posterior;
        public float[] left_geneprobs;
        public float[] right_geneprobs;
        public float left_prior;
        public float right_prior;

        Edgedata() {
        }
    }
}

