/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHAlgorithms.AlterationsComparator;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.AlterationsComparator.ExperimentsComparatorInitDlg;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.AlterationsComparator.TwoExperimentAlterationComparator;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.ComparisonFlankingRegionCalculator;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.AlterationParametersViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.DataRegionsDataModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfAlterationsViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GroupExperimentsPanel;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;

public class CompareExperiments
extends NumberOfAlterationsCalculator {
    IData data;
    int[] deletionsAOnly;
    int[] deletionsBOnly;
    int[] deletionsAandB;
    int[] amplificationsAOnly;
    int[] amplificationsBOnly;
    int[] amplificationsAandB;
    String exprA;
    String exprB;

    @Override
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        ComparisonFlankingRegionCalculator frCalc = new ComparisonFlankingRegionCalculator();
        this.framework = framework;
        this.data = framework.getData();
        ExperimentsComparatorInitDlg initDlg = new ExperimentsComparatorInitDlg(framework.getFrame(), this.data.getFeaturesList());
        if (initDlg.showModal() != 0) {
            return null;
        }
        GroupExperimentsPanel gPanel = initDlg.getGroupExperimentsPanel();
        int[] groupAssignments = gPanel.getGroupAssignments();
        this.nodeName = "CompareExperiments";
        this.exprA = this.data.getSampleName(groupAssignments[0]);
        this.exprB = this.data.getSampleName(groupAssignments[1]);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        TwoExperimentAlterationComparator comparator = new TwoExperimentAlterationComparator();
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], -1);
        DefaultMutableTreeNode deletionsNode = new DefaultMutableTreeNode("Deletions");
        DefaultMutableTreeNode cloneDeletionsNode = new DefaultMutableTreeNode("Clone Deletions");
        this.deletionsAOnly = comparator.getAOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.deletionsAOnly))));
        this.deletionsBOnly = comparator.getBOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.deletionsBOnly))));
        this.deletionsAandB = comparator.getAAndB();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.deletionsAandB))));
        DefaultMutableTreeNode regionDeletionsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        deletionsNode.add(cloneDeletionsNode);
        deletionsNode.add(regionDeletionsNode);
        root.add(deletionsNode);
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], 1);
        DefaultMutableTreeNode amplificationsNode = new DefaultMutableTreeNode("Amplifications");
        DefaultMutableTreeNode cloneAmplificationsNode = new DefaultMutableTreeNode("Clone Amplifications");
        this.amplificationsAOnly = comparator.getAOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.amplificationsAOnly))));
        this.amplificationsBOnly = comparator.getBOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.amplificationsBOnly))));
        this.amplificationsAandB = comparator.getAAndB();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.amplificationsAandB))));
        DefaultMutableTreeNode regionAmplificationsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        amplificationsNode.add(cloneAmplificationsNode);
        amplificationsNode.add(regionAmplificationsNode);
        root.add(amplificationsNode);
        this.addGeneralInfo(root);
        return root;
    }

    public DefaultMutableTreeNode execute(IFramework framework, int[] groupAssignments) throws AlgorithmException {
        ComparisonFlankingRegionCalculator frCalc = new ComparisonFlankingRegionCalculator();
        this.framework = framework;
        this.data = framework.getData();
        this.nodeName = "CompareExperiments";
        this.exprA = this.data.getSampleName(groupAssignments[0]);
        this.exprB = this.data.getSampleName(groupAssignments[1]);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        TwoExperimentAlterationComparator comparator = new TwoExperimentAlterationComparator();
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], -1);
        DefaultMutableTreeNode deletionsNode = new DefaultMutableTreeNode("Deletions");
        DefaultMutableTreeNode cloneDeletionsNode = new DefaultMutableTreeNode("Clone Deletions");
        this.deletionsAOnly = comparator.getAOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.deletionsAOnly))));
        this.deletionsBOnly = comparator.getBOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.deletionsBOnly))));
        this.deletionsAandB = comparator.getAAndB();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.deletionsAandB))));
        DefaultMutableTreeNode regionDeletionsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        deletionsNode.add(cloneDeletionsNode);
        deletionsNode.add(regionDeletionsNode);
        root.add(deletionsNode);
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], 1);
        DefaultMutableTreeNode amplificationsNode = new DefaultMutableTreeNode("Amplifications");
        DefaultMutableTreeNode cloneAmplificationsNode = new DefaultMutableTreeNode("Clone Amplifications");
        this.amplificationsAOnly = comparator.getAOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.amplificationsAOnly))));
        this.amplificationsBOnly = comparator.getBOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.amplificationsBOnly))));
        this.amplificationsAandB = comparator.getAAndB();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.amplificationsAandB))));
        DefaultMutableTreeNode regionAmplificationsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        amplificationsNode.add(cloneAmplificationsNode);
        amplificationsNode.add(regionAmplificationsNode);
        root.add(amplificationsNode);
        this.addGeneralInfo(root);
        return root;
    }

    public DefaultMutableTreeNode execute2(IFramework framework) throws AlgorithmException {
        ComparisonFlankingRegionCalculator frCalc = new ComparisonFlankingRegionCalculator();
        this.framework = framework;
        this.data = framework.getData();
        ExperimentsComparatorInitDlg initDlg = new ExperimentsComparatorInitDlg(framework.getFrame(), this.data.getFeaturesList());
        if (initDlg.showModal() != 0) {
            return null;
        }
        GroupExperimentsPanel gPanel = initDlg.getGroupExperimentsPanel();
        int[] groupAssignments = gPanel.getGroupAssignments();
        this.nodeName = this.data.getSampleName(groupAssignments[0]) + " vs. " + this.data.getSampleName(groupAssignments[1]);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.nodeName);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Parameters", this.createParametersViewer())));
        TwoExperimentAlterationComparator comparator = new TwoExperimentAlterationComparator();
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], -1);
        DefaultMutableTreeNode deletionsNode = new DefaultMutableTreeNode("Deletions");
        DefaultMutableTreeNode cloneDeletionsNode = new DefaultMutableTreeNode("Clone Deletions");
        this.deletionsAOnly = comparator.getAOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.deletionsAOnly))));
        this.deletionsBOnly = comparator.getBOnly();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.deletionsBOnly))));
        this.deletionsAandB = comparator.getAAndB();
        cloneDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.deletionsAandB))));
        DefaultMutableTreeNode regionDeletionsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionDeletionsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        deletionsNode.add(cloneDeletionsNode);
        deletionsNode.add(regionDeletionsNode);
        root.add(deletionsNode);
        comparator.compareExperiments(this.data, groupAssignments[0], groupAssignments[1], 1);
        DefaultMutableTreeNode amplificationsNode = new DefaultMutableTreeNode("Amplifications");
        DefaultMutableTreeNode cloneAmplificationsNode = new DefaultMutableTreeNode("Clone Amplifications");
        this.amplificationsAOnly = comparator.getAOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(this.amplificationsAOnly))));
        this.amplificationsBOnly = comparator.getBOnly();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(this.amplificationsBOnly))));
        this.amplificationsAandB = comparator.getAAndB();
        cloneAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(this.amplificationsAandB))));
        DefaultMutableTreeNode regionAmplificationsNode = new DefaultMutableTreeNode("Region Amplifications");
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAOnly(), comparator.getBOnly(), groupAssignments[0])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("B Only", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getBOnly(), comparator.getAOnly(), groupAssignments[1])))));
        regionAmplificationsNode.add(new DefaultMutableTreeNode(new LeafInfo("A and B", this.createComparisonViewer(frCalc.calculateFlankingRegions(this.data, comparator.getAAndB(), null, groupAssignments)))));
        amplificationsNode.add(cloneAmplificationsNode);
        amplificationsNode.add(regionAmplificationsNode);
        root.add(amplificationsNode);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Summary", this.createSummaryViewer())));
        return root;
    }

    private IViewer createComparisonViewer(Vector dataRegions) {
        ICGHDataRegion[] alterationRegions = dataRegions.toArray(new ICGHDataRegion[0]);
        DataRegionsDataModel dataModel = new DataRegionsDataModel(alterationRegions);
        NumberOfAlterationsViewer viewer = new NumberOfAlterationsViewer();
        viewer.setData(this.data);
        viewer.setDataModel(dataModel);
        return viewer;
    }

    private IViewer createComparisonViewer(int[] cloneIndices) {
        ICGHDataRegion[] alterationRegions = new ICGHDataRegion[cloneIndices.length];
        for (int i = 0; i < cloneIndices.length; ++i) {
            alterationRegions[i] = this.data.getCloneAt(cloneIndices[i]);
        }
        DataRegionsDataModel dataModel = new DataRegionsDataModel(alterationRegions);
        NumberOfAlterationsViewer viewer = new NumberOfAlterationsViewer();
        viewer.setData(this.data);
        viewer.setDataModel(dataModel);
        return viewer;
    }

    private IViewer createSummaryViewer() {
        StringBuffer sb = new StringBuffer();
        sb.append("Deletions A Only " + this.deletionsAOnly.length + "\n");
        sb.append("Deletions B Only " + this.deletionsBOnly.length + "\n");
        sb.append("Deletions A and B " + this.deletionsAandB.length + "\n\n");
        sb.append("Amplifications A Only " + this.amplificationsAOnly.length + "\n");
        sb.append("Amplifications B Only " + this.amplificationsBOnly.length + "\n");
        sb.append("Amplifications A and B " + this.amplificationsAandB.length + "\n\n");
        return new AlterationParametersViewer(sb.toString());
    }

    private void addGeneralInfo(DefaultMutableTreeNode root) {
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Amplification Threshold: " + menu.getAmpThresh()));
        node.add(new DefaultMutableTreeNode("Deletion Threshold: " + menu.getDelThresh()));
        node.add(new DefaultMutableTreeNode("Amplification 2 Copy Threshold: " + menu.getAmpThresh2Copy()));
        node.add(new DefaultMutableTreeNode("Deletion 2 Copy Threshold: " + menu.getDelThresh2Copy()));
        node.add(new DefaultMutableTreeNode("Experiment A: " + this.exprA));
        node.add(new DefaultMutableTreeNode("Experiment B: " + this.exprB));
        node.add(new DefaultMutableTreeNode("Deletions A Only: " + this.deletionsAOnly.length));
        node.add(new DefaultMutableTreeNode("Deletions B Only: " + this.deletionsBOnly.length));
        node.add(new DefaultMutableTreeNode("Deletions A and B: " + this.deletionsAandB.length));
        node.add(new DefaultMutableTreeNode("Amplifications A Only: " + this.amplificationsAOnly.length));
        node.add(new DefaultMutableTreeNode("Amplifications B Only: " + this.amplificationsBOnly.length));
        node.add(new DefaultMutableTreeNode("Amplifications A and B: " + this.amplificationsAandB.length));
        root.add(node);
    }
}

