/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.util.CSVReader;
import org.tigr.util.StringSplitter;

public class RnaseqAnnotationParser {
    Vector columnNames = new Vector();
    Hashtable<String, ArrayList<MevAnnotation>> annoHash;
    int num_of_skippedLines = 0;

    public static RnaseqAnnotationParser createAnnotationFileParser(File file) throws IOException {
        RnaseqAnnotationParser newParser = new RnaseqAnnotationParser();
        newParser.loadAnnotation(file);
        return newParser;
    }

    private RnaseqAnnotationParser() {
    }

    private void loadAnnotation(File annotationFile) throws IOException {
        String[] currentLine;
        this.columnNames = this.getColumnHeader(annotationFile);
        String _temp = "";
        int numLines = this.getCountOfLines(annotationFile);
        this.annoHash = new Hashtable(numLines);
        BufferedReader reader = new BufferedReader(new FileReader(annotationFile));
        CSVReader csvreader = new CSVReader(reader, '\t', '\"');
        csvreader.readNext();
        int fakeCloneID = 1;
        while ((currentLine = csvreader.readNext()) != null) {
            MevAnnotation annotationObj = new MevAnnotation();
            String probeID = "";
            for (int i = 0; i < this.columnNames.size(); ++i) {
                _temp = currentLine[i];
                String field = (String)this.columnNames.get(i);
                int index = this.columnNames.indexOf(field);
                if ((field.equalsIgnoreCase("PROBE_ID") || field.equalsIgnoreCase("CLONE_ID")) && index == i) {
                    probeID = _temp;
                    annotationObj.setCloneID(String.valueOf(fakeCloneID++));
                    continue;
                }
                if (field.equalsIgnoreCase("REFSEQ_ACC") && index == i) {
                    annotationObj.setRefSeqTxAcc(new String[]{_temp});
                    annotationObj.setGenBankAcc(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("CHR") && index == i) {
                    annotationObj.setProbeChromosome(this.parseChr(_temp));
                    continue;
                }
                if (field.equalsIgnoreCase("TX_START") && index == i) {
                    try {
                        annotationObj.setProbeTxStartBP(_temp);
                    }
                    catch (Exception e) {
                        System.out.println("Bad rec Id: " + probeID);
                        e.printStackTrace();
                    }
                    continue;
                }
                if (field.equalsIgnoreCase("TX_END") && index == i) {
                    try {
                        annotationObj.setProbeTxEndBP(_temp);
                    }
                    catch (Exception e) {
                        System.out.println("Bad rec Id: " + probeID);
                        e.printStackTrace();
                    }
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_TITLE") && index == i) {
                    annotationObj.setGeneTitle(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_SYMBOL") && index == i) {
                    if (_temp == null) {
                        _temp = "";
                    }
                    annotationObj.setGeneSymbol(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("ENTREZ_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "";
                    }
                    annotationObj.setLocusLinkID(_temp);
                    continue;
                }
                if (!field.equalsIgnoreCase("PROTEIN_ACC") || index != i) continue;
                if (_temp == null) {
                    _temp = "";
                }
                annotationObj.setRefSeqProtAcc(new String[]{_temp});
            }
            try {
                annotationObj.setProbeCytoband(annotationObj.getChrLocation() + ":" + annotationObj.getProbeTxStartBP() + "-" + annotationObj.getProbeTxEndBP() + " (" + annotationObj.getProbeStrand());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            annotationObj.setGoTerms(new String[]{""});
            annotationObj.setUnigeneID("");
            annotationObj.setTgiTC("");
            if (probeID != null) {
                if (this.annoHash.containsKey(probeID)) {
                    this.annoHash.get(probeID).add(annotationObj);
                    continue;
                }
                ArrayList<MevAnnotation> annotationObjList = new ArrayList<MevAnnotation>();
                annotationObjList.add(annotationObj);
                this.annoHash.put(probeID, annotationObjList);
                continue;
            }
            String eMsg = "<html>Probe ID Missing..This is a REQUIRED field <br><html>The following descriptor was found for this probe<br> " + annotationObj.getProbeDesc();
            JOptionPane.showMessageDialog(null, eMsg, "Error", 1);
        }
    }

    private String parseChr(String temp) {
        if (temp.toLowerCase().startsWith("chr")) {
            temp = temp.substring(3);
        }
        if (temp.length() > 2) {
            try {
                return String.valueOf(Integer.parseInt(temp.substring(0, 2)));
            }
            catch (NumberFormatException nfe) {
                return temp.substring(0, 1);
            }
        }
        return temp.toUpperCase();
    }

    public Hashtable<String, ArrayList<MevAnnotation>> getAnnotation() {
        return this.annoHash;
    }

    private Vector<String> getColumnHeader(File targetFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(targetFile));
        StringSplitter split = new StringSplitter('\t');
        String currentLine = reader.readLine();
        currentLine = currentLine.trim();
        split.init(currentLine);
        int columnNumber = 0;
        Vector<String> columnNames = new Vector<String>(split.countTokens());
        while (split.hasMoreTokens()) {
            String _temp = split.nextToken().trim();
            _temp = _temp.replace('\"', ' ');
            if ((_temp = this.removeAllSpaces(_temp)).contains("PROBE_ID")) {
                columnNames.add(columnNumber, "PROBE_ID");
            } else if (_temp.equalsIgnoreCase("UNIGENE_ID")) {
                columnNames.add(columnNumber, "UNIGENE_ID");
            } else if (_temp.contentEquals("GENE_TITLE")) {
                columnNames.add(columnNumber, "GENE_TITLE");
            } else if (_temp.contentEquals("GENE_SYMBOL")) {
                columnNames.add(columnNumber, "GENE_SYMBOL");
            } else if (_temp.contentEquals("CYTOBAND")) {
                columnNames.add(columnNumber, "CHR:TX_START-TX_END(STRAND)");
            } else if (_temp.contentEquals("ENTREZ_ID")) {
                columnNames.add(columnNumber, "ENTREZ_ID");
            } else if (_temp.equalsIgnoreCase("PROTEIN_ACC")) {
                columnNames.add(columnNumber, "PROTEIN_ACC");
            } else if (_temp.equalsIgnoreCase("CHR")) {
                columnNames.add(columnNumber, "CHR");
            } else if (_temp.equalsIgnoreCase("TX_END")) {
                columnNames.add(columnNumber, "TX_END");
            } else if (_temp.equalsIgnoreCase("TX_START")) {
                columnNames.add(columnNumber, "TX_START");
            } else if (_temp.equalsIgnoreCase("REFSEQ_ACC")) {
                columnNames.add(columnNumber, "REFSEQ_ACC");
            } else if (_temp.equalsIgnoreCase("GENBANK_ACC")) {
                columnNames.add(columnNumber, "GENBANK_ACC");
            } else {
                columnNames.add(columnNumber, _temp);
            }
            ++columnNumber;
        }
        reader.close();
        return columnNames;
    }

    private Vector<String> parseGoTerms(String _temp, String delim) {
        Vector<String> terms = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, delim);
        while (tokens.hasMoreTokens()) {
            terms.add(tokens.nextToken().trim());
        }
        return terms;
    }

    private void setAlignmentInfo(String temp, MevAnnotation obj) {
        if (!temp.trim().startsWith("chr")) {
            obj.setProbeStrand("NA");
            obj.setProbeChromosome("NA");
            try {
                obj.setProbeTxStartBP("-1");
                obj.setProbeTxEndBP("-1");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        int index = temp.indexOf("(");
        String strand = temp.substring(index + 1, index + 2).trim();
        String _temp = temp.substring(0, index).trim();
        int chrInd = _temp.indexOf(":");
        String chr = _temp.substring(0, chrInd);
        chr = chr.substring(3, chr.length());
        int txInd = _temp.indexOf("-");
        String txSt = _temp.substring(chrInd + 1, txInd);
        String txEnd = _temp.substring(txInd + 1, _temp.length());
        obj.setProbeStrand(strand);
        obj.setProbeChromosome(chr);
        try {
            obj.setProbeTxStartBP(txSt);
            obj.setProbeTxEndBP(txEnd);
        }
        catch (Exception e) {
            System.out.println("Contains Illegal Char: " + txSt + ", " + txEnd);
            e.printStackTrace();
        }
    }

    public int getCountOfLines(File f) {
        int numLines = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while (reader.readLine() != null) {
                ++numLines;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numLines;
    }

    public String removeAllSpaces(String str) {
        String newString = new String();
        StringSplitter split = new StringSplitter(' ');
        split.init(str);
        while (split.hasMoreTokens()) {
            newString = newString + split.nextToken().trim();
        }
        return newString;
    }

    public static void main(String[] args) {
        try {
            AffymetrixAnnotationParser aap = AffymetrixAnnotationParser.createAnnotationFileParser(new File("C:/Users/sarita/Desktop/HG-U133A_2.csv"));
            Hashtable<Object, Object> temp = new Hashtable();
            temp = aap.getAffyAnnotation();
            System.out.println("SIze of hashtable is:" + temp.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

