/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.annotation.AnnotationConstants;
import org.tigr.microarray.mev.annotation.InsufficientArgumentsException;
import org.tigr.microarray.mev.annotation.URLNotFoundException;
import org.tigr.util.StringSplitter;

public class PublicURL {
    private static boolean urlLoaded = false;
    private static Hashtable<String, String> urlHash;
    public static AnnotationConstants urlConsts;

    public static String getURL(String URLKey, String[] params) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        int i;
        String temp;
        if (!PublicURL.isUrlLoaded()) {
            throw new URLNotFoundException("No URLs were loaded");
        }
        String urlTemplate = urlHash.get(URLKey.trim());
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        if (URLKey.equals("GO_TERMS")) {
            temp = params[0];
            for (i = 1; i < params.length; ++i) {
                temp = temp + " " + params[i];
            }
            params = new String[]{temp};
        } else if (!(URLKey.equals("TGI_GC") || URLKey.equals("TGI_ORTH") || URLKey.equals("TGI_TC") || URLKey.equals("CHR_LOCATION"))) {
            temp = params[0];
            for (i = 1; i < params.length; ++i) {
                temp = temp + "," + params[i];
            }
            params = new String[]{temp};
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        if (paramSites.size() != params.length) {
            String _temp = "For field " + URLKey + ": " + paramSites.size() + " params required. " + params.length + " params returned.";
            throw new InsufficientArgumentsException(_temp);
        }
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], params, indx);
        return formedURL;
    }

    protected static String fillParameters(String template, String[] params, Integer[] indices) {
        String formedURL = "";
        int startIndex = 0;
        for (int i = 0; i < indices.length; ++i) {
            String _tmp = template.substring(startIndex, indices[i]);
            formedURL = formedURL + _tmp + params[i];
            startIndex = indices[i] + "FIELD".length();
        }
        return formedURL;
    }

    private static boolean checkParamTypeAndOrder(String[] providedParams, String[] requiredParams) {
        for (int i = 0; i < providedParams.length; ++i) {
            String _temp = requiredParams[i];
            String _tmp = providedParams[i];
            try {
                if (_temp.equals("int")) {
                    Integer.parseInt(_tmp);
                    continue;
                }
                if (_temp.equals("float")) {
                    Float.parseFloat(_tmp);
                    continue;
                }
                if (_temp.equals("double")) {
                    Double.parseDouble(_tmp);
                    continue;
                }
                if (!_temp.equals("String")) continue;
            }
            catch (Exception e) {
                System.out.println("Possible Class Cast or Conversion Exception");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected static Vector<Integer> getParamIndices(String str, String withinStr) {
        int fromIndex = 0;
        int hitIndex = 0;
        Vector<Integer> indices = new Vector<Integer>();
        while (hitIndex != -1) {
            hitIndex = withinStr.indexOf(str, fromIndex);
            if (hitIndex == -1) continue;
            indices.add(new Integer(hitIndex));
            fromIndex = hitIndex + 1;
        }
        return indices;
    }

    public static String getURL_NCBI_Gene(String geneName) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_GENE");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{geneName}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_Protein(String proteinName) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_PROTEIN");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{proteinName}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_UniGene(String UniGeneID) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_UNIGENE");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{UniGeneID}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_MapViewer(String chr, String species, int startBP, int endBP) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_MAPVIEWER");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        String[] _paramDataTypes = _TemplateChop[1].split(":");
        String[] _paramDesc = _TemplateChop[2].split(":");
        String[] params = new String[]{chr, species, String.valueOf(startBP), String.valueOf(endBP)};
        if (!PublicURL.checkParamTypeAndOrder(params, _paramDataTypes)) {
            int i;
            String _temp = "";
            String _tmp = "";
            for (i = 0; i < _paramDesc.length; ++i) {
                _temp = _temp + _paramDesc[i] + " ";
            }
            for (i = 0; i < params.length; ++i) {
                _tmp = _tmp + params[i] + " ";
            }
            throw new IllegalArgumentException("Expected argument(s): " + _temp + ". Given argument(s): " + _tmp);
        }
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], params, indx);
        return formedURL;
    }

    public static String getURL_NCBI_GenBank(String genBankID) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_GENBANK");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{genBankID}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_Snp(String Snp) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_SNP");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{Snp}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_Genome(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_GENOME");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_Pubmed(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("NCBI_PUBMED");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_NCBI_Generic(String anyTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("GENERIC");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{anyTerm}, indx);
        return formedURL;
    }

    public static String getURL_UCSC_Browser(int taxID, String dbBld, int startBP, int endBP) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("UCSC_BROWSER");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        String[] _paramDataTypes = _TemplateChop[1].split(":");
        String[] _paramDesc = _TemplateChop[2].split(":");
        String[] params = new String[]{String.valueOf(taxID), dbBld, String.valueOf(startBP), String.valueOf(endBP)};
        if (!PublicURL.checkParamTypeAndOrder(params, _paramDataTypes)) {
            int i;
            String _temp = "";
            String _tmp = "";
            for (i = 0; i < _paramDesc.length; ++i) {
                _temp = _temp + _paramDesc[i] + " ";
            }
            for (i = 0; i < params.length; ++i) {
                _tmp = _tmp + params[i] + " ";
            }
            throw new IllegalArgumentException("Expected argument(s): " + _temp + ". Given argument(s): " + _tmp);
        }
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], params, indx);
        return formedURL;
    }

    public static String getURL_EBI_GO(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("EBI_GO");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_KEGG(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("KEGG");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_GenMAPP(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("GENMAPP");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_Pfam(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("PFAM");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{searchTerm}, indx);
        return formedURL;
    }

    public static String getURL_TGI_orth(String searchTerm) throws InsufficientArgumentsException, URLNotFoundException, IllegalArgumentException {
        String urlTemplate = urlHash.get("TGI_ORTH");
        if (urlTemplate == null) {
            throw new URLNotFoundException();
        }
        String species = searchTerm.substring(0, searchTerm.indexOf(95));
        String TC = searchTerm.substring(searchTerm.indexOf(95) + 1);
        Vector<Integer> paramSites = PublicURL.getParamIndices("FIELD", urlTemplate);
        String[] _TemplateChop = urlTemplate.split("\\|");
        Integer[] indx = new Integer[paramSites.size()];
        paramSites.toArray(indx);
        String formedURL = PublicURL.fillParameters(_TemplateChop[0], new String[]{species, TC}, indx);
        return formedURL;
    }

    public static boolean isUrlLoaded() {
        return urlLoaded;
    }

    public static void clearURLs() {
        urlHash = null;
        urlLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadURLs(File configFile) throws FileNotFoundException {
        Hashtable<String, String> tempHash = new Hashtable<String, String>();
        FileReader fr = null;
        BufferedReader buff = null;
        try {
            fr = new FileReader(configFile);
            buff = new BufferedReader(fr);
            StringSplitter st = new StringSplitter('\t');
            boolean eof = false;
            while (!eof) {
                String line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st.init(line);
                String _tempKey = st.nextToken();
                String _tempURL = st.nextToken();
                st.nextToken();
                tempHash.put(_tempKey.trim(), _tempURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            try {
                if (buff != null) {
                    buff.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception e1) {}
        }
        if (tempHash.size() < 1) {
            return -1;
        }
        if (urlHash == null) {
            urlHash = tempHash;
        } else {
            urlHash.putAll(tempHash);
        }
        urlLoaded = true;
        return 0;
    }

    public static boolean hasUrlForKey(String key) {
        if (urlHash == null) {
            return false;
        }
        return urlHash.get(key.trim()) != null;
    }

    static {
        urlConsts = new AnnotationConstants();
    }
}

