/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cgh.DBObj.DSqlHandler;

public class MevAnnotation
implements IAnnotation,
Comparable {
    private Hashtable<String, Object> annotHash;

    public MevAnnotation() {
        this.annotHash = new Hashtable();
    }

    private MevAnnotation(Hashtable<String, Object> newhash) {
        this.annotHash = newhash;
    }

    public int compareTo(Object arg0) {
        MevAnnotation _Itemp = (MevAnnotation)arg0;
        try {
            if (this.getProbeChromosomeAsInt() == -1) {
                return -1;
            }
            if (this.getProbeChromosomeAsInt() > _Itemp.getProbeChromosomeAsInt()) {
                return -1;
            }
            if (this.getProbeChromosomeAsInt() < _Itemp.getProbeChromosomeAsInt()) {
                return 1;
            }
            if (this.getProbeChromosomeAsInt() == _Itemp.getProbeChromosomeAsInt()) {
                if (this.getProbeTxStartBP() > _Itemp.getProbeTxEndBP()) {
                    return -1;
                }
                if (this.getProbeTxStartBP() < _Itemp.getProbeTxEndBP()) {
                    return 1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public String[] getRefSeqTxAcc() {
        String[] _temp = (String[])this.annotHash.get("REFSEQ_ACC");
        if (_temp == null) {
            _temp = new String[]{"NA"};
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getGenBankAcc() {
        String _temp = (String)this.annotHash.get("GENBANK_ACC");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getGeneID() {
        String _temp = (String)this.annotHash.get("ENTREZ_ID");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getEntrezGeneID() {
        String _temp = (String)this.annotHash.get("ENTREZ_ID");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getLocusLinkID() {
        String _temp = (String)this.annotHash.get("ENTREZ_ID");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getGeneSymbol() {
        String _temp = (String)this.annotHash.get("GENE_SYMBOL");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getGeneTitle() {
        String _temp = (String)this.annotHash.get("GENE_TITLE");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getProbeCytoband() {
        String _temp = (String)this.annotHash.get("CHR:TX_START-TX_END(STRAND)");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    public String getChrLocation() {
        String _temp = (String)this.annotHash.get("CHR:TX_START-TX_END(STRAND)");
        if (_temp == null) {
            String chrLocation = "";
            String chr = "chr" + this.getProbeChromosome();
            if (chr.equals("NA")) {
                return "NA";
            }
            chrLocation = chr + ":";
            try {
                int start = this.getProbeTxStartBP();
                int end = this.getProbeTxEndBP();
                chrLocation = chrLocation + start + "-" + end;
            }
            catch (Exception e) {
                // empty catch block
            }
            return chrLocation;
        }
        return _temp;
    }

    @Override
    public String getCloneID() {
        return (String)this.annotHash.get("PROBE_ID");
    }

    @Override
    public String getProbeChromosome() {
        String _temp = (String)this.annotHash.get("CHR");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public int getProbeChromosomeAsInt() throws Exception {
        String _temp = (String)this.annotHash.get("CHR");
        if (_temp == null) {
            return -1;
        }
        return Integer.parseInt((String)this.annotHash.get("CHR"));
    }

    @Override
    public String getProbeStrand() {
        String _temp = (String)this.annotHash.get("STRAND");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public int getProbeTxStartBP() throws Exception {
        String _temp = (String)this.annotHash.get("TX_START");
        if (_temp == null) {
            return -1;
        }
        return Integer.parseInt((String)this.annotHash.get("TX_START"));
    }

    @Override
    public int getProbeTxEndBP() throws Exception {
        String _temp = (String)this.annotHash.get("TX_END");
        if (_temp == null) {
            return -1;
        }
        return Integer.parseInt((String)this.annotHash.get("TX_END"));
    }

    @Override
    public String getProbeSequence() {
        String _temp = (String)this.annotHash.get("SEQUENCE");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String[] getRefSeqProtAcc() {
        String[] _temp = (String[])this.annotHash.get("PROTEIN_ACC");
        if (_temp == null) {
            _temp = new String[]{"NA"};
            return _temp;
        }
        return _temp;
    }

    @Override
    public int getProbeTxLengthInBP() throws Exception {
        String _temp = (String)this.annotHash.get("TX_END");
        if (_temp == null) {
            _temp = "NA";
            return Integer.parseInt(_temp);
        }
        return Integer.parseInt((String)this.annotHash.get("TX_END")) - Integer.parseInt((String)this.annotHash.get("TX_START"));
    }

    @Override
    public int getProbeCdsStartBP() throws Exception {
        return Integer.parseInt((String)this.annotHash.get("CDS_START"));
    }

    @Override
    public int getProbeCdsEndBP() throws Exception {
        return Integer.parseInt((String)this.annotHash.get("CDS_END"));
    }

    @Override
    public int getProbeCdsLengthInBP() throws Exception {
        return Integer.parseInt((String)this.annotHash.get("CDS_END")) - Integer.parseInt((String)this.annotHash.get("CDS_START"));
    }

    @Override
    public String[] getBioCartaPathways() {
        String[] _temp = (String[])this.annotHash.get("BIO_CARTA");
        if (_temp == null) {
            _temp = new String[]{"NA"};
            return _temp;
        }
        return _temp;
    }

    @Override
    public String[] getKeggPathways() {
        String[] _temp = (String[])this.annotHash.get("KEGG");
        if (_temp == null) {
            _temp = new String[]{"NA"};
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getProbeDesc() {
        String _temp = (String)this.annotHash.get("DESC");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getUnigeneID() {
        String _temp = (String)this.annotHash.get("UNIGENE_ID");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public String[] getGoTerms() {
        String[] _temp = (String[])this.annotHash.get("GO_TERMS");
        if (_temp == null) {
            _temp = new String[]{"NA"};
            return _temp;
        }
        return _temp;
    }

    @Override
    public String getTgiTC() {
        String _temp = (String)this.annotHash.get("TGI_TC");
        if (_temp == null) {
            _temp = "NA";
            return _temp;
        }
        return _temp;
    }

    @Override
    public void setCloneID(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("PROBE_ID", _tmp);
    }

    @Override
    public void setEntrezGeneID(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("ENTREZ_ID", _tmp);
    }

    @Override
    public void setGenBankAcc(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("GENBANK_ACC", _tmp);
    }

    @Override
    public void setGeneID(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("ENTREZ_ID", _tmp);
    }

    @Override
    public void setGeneSymbol(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("GENE_SYMBOL", _tmp);
    }

    @Override
    public void setGeneTitle(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("GENE_TITLE", _tmp);
    }

    @Override
    public void setLocusLinkID(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("ENTREZ_ID", _tmp);
    }

    @Override
    public void setProbeCdsEndBP(String _temp) throws Exception {
        String _tmp = _temp;
        this.annotHash.put("CDS_END", _tmp);
    }

    @Override
    public void setProbeCdsStartBP(String _temp) throws Exception {
        String _tmp = _temp;
        this.annotHash.put("CDS_START", _tmp);
    }

    @Override
    public void setProbeChromosome(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("CHR", _tmp);
    }

    @Override
    public void setProbeCytoband(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("CHR:TX_START-TX_END(STRAND)", _tmp);
    }

    @Override
    public void setProbeDesc(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("DESC", _tmp);
    }

    @Override
    public void setProbeStrand(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("STRAND", _tmp);
    }

    @Override
    public void setProbeTxEndBP(String _temp) throws Exception {
        String _tmp = _temp;
        this.annotHash.put("TX_END", _tmp);
    }

    @Override
    public void setProbeTxStartBP(String _temp) throws Exception {
        String _tmp = _temp;
        this.annotHash.put("TX_START", _tmp);
    }

    @Override
    public void setProbeSequence(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("SEQUENCE", _tmp);
    }

    @Override
    public void setUnigeneID(String _temp) {
        String _tmp = _temp;
        this.annotHash.put("UNIGENE_ID", _tmp);
    }

    @Override
    public void setRefSeqProtAcc(String[] _temp) {
        this.annotHash.put("PROTEIN_ACC", _temp);
    }

    @Override
    public void setRefSeqTxAcc(String[] _temp) {
        this.annotHash.put("REFSEQ_ACC", _temp);
    }

    @Override
    public void setBioCartaPathways(String[] _temp) {
        this.annotHash.put("BIO_CARTA", _temp);
    }

    @Override
    public void setKeggPathways(String[] _temp) {
        this.annotHash.put("KEGG", _temp);
    }

    @Override
    public void setGoTerms(String[] _temp) {
        this.annotHash.put("GO_TERMS", _temp);
    }

    @Override
    public void setTgiTC(String _temp) {
        this.annotHash.put("TGI_TC", _temp);
    }

    public static Vector<String[]> getGenomeAnnotation(String[] colNames, int chr, int st_bp, int end_bp) throws SQLException {
        Vector<String[]> annoVec = new Vector<String[]>();
        if (MevAnnotation.validateColNames(colNames).booleanValue()) {
            String db = "Hs_RefGenesMapped";
            String sql = "SELECT ";
            for (int j = 0; j < colNames.length; ++j) {
                sql = j < colNames.length - 1 ? sql + colNames[j] + ", " : sql + colNames[j] + " ";
            }
            sql = sql + "FROM \"" + db + "\"";
            sql = sql + " WHERE CHR = " + CGHUtility.encap("chr" + chr);
            sql = sql + " AND TX_START >= " + st_bp + " AND TX_END <= " + end_bp;
            DSqlHandler objPersist = new DSqlHandler();
            ResultSet rs = objPersist.fetchItemsCSV(sql);
            while (rs.next()) {
                String[] results = new String[colNames.length];
                for (int i = 0; i < colNames.length; ++i) {
                    results[i] = rs.getString(colNames[i]);
                }
                annoVec.add(results);
            }
        } else {
            throw new SQLException("Invalid Column Names");
        }
        return annoVec;
    }

    private static String getDBNameBySpecies(String species) {
        String dbName = "";
        if (species.equals("HS")) {
            dbName = "Hs_RefGenesMapped";
        }
        if (species.equals("MM")) {
            dbName = "Mm_RefGenesMapped";
        }
        return dbName;
    }

    private static Boolean validateColNames(String[] _temp) {
        Boolean ret = false;
        Class<?> c = fieldConsts.getClass();
        Field[] fields = c.getFields();
        for (int i = 0; i < _temp.length; ++i) {
            for (int j = 0; j < fields.length; ++j) {
                if (!_temp[i].equals(fields[j].getName())) continue;
                ret = true;
                break;
            }
            if (!ret.booleanValue()) break;
        }
        return ret;
    }

    @Override
    public String[] getAttribute(String attr) {
        if (attr == "CHR_LOCATION") {
            return new String[]{this.getChrLocation()};
        }
        if (this.annotHash.get(attr) instanceof String) {
            String temp = (String)this.annotHash.get(attr);
            String[] _temp = new String[]{temp};
            if (temp == null) {
                _temp[0] = "NA";
            }
            return _temp;
        }
        String[] _temp = (String[])this.annotHash.get(attr);
        if (_temp == null) {
            _temp = new String[]{"NA"};
        }
        return _temp;
    }

    @Override
    public AnnoAttributeObj getAttributeObj(String attr) {
        String[] _temp;
        if (attr.equals("CHR_LOCATION")) {
            return new AnnoAttributeObj("CHR_LOCATION", new String[]{this.getChrLocation()});
        }
        try {
            _temp = (String[])this.annotHash.get(attr);
        }
        catch (ClassCastException cce) {
            _temp = new String[]{(String)this.annotHash.get(attr)};
        }
        if (_temp == null) {
            _temp = new String[]{"NA"};
            AnnoAttributeObj _tempAttr = new AnnoAttributeObj(attr, _temp);
            return _tempAttr;
        }
        AnnoAttributeObj _tempAttr = new AnnoAttributeObj(attr, _temp);
        return _tempAttr;
    }

    @Override
    public IAnnotation clone() {
        Hashtable<String, Object> newhash = new Hashtable<String, Object>(this.annotHash);
        return new MevAnnotation(newhash);
    }
}

