/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GenomeAnnoDialog
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    private JCheckBox[] annoFieldBoxes;
    private JTextField startBP;
    private JTextField endBP;
    private JComboBox chromosome;
    private Frame parent;
    private JDialog genomeAnnoDlg;
    private JButton ncbiMap;
    private JButton ucscMap;

    public GenomeAnnoDialog(Frame parent, String[] availableFields) {
        super(parent, "Genome Annotation Field Selection", true);
        this.parent = parent;
        Listener listener = new Listener();
        this.addWindowListener((WindowListener)((Object)listener));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        ParameterPanel parameters = new ParameterPanel("Genome annotation");
        parameters.setLayout((LayoutManager)new GridLayout(0, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets.bottom = 5;
        String[] cols = availableFields;
        this.annoFieldBoxes = new JCheckBox[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this.annoFieldBoxes[i] = new JCheckBox(cols[i]);
            this.annoFieldBoxes[i].setFocusPainted(false);
            this.annoFieldBoxes[i].setBackground(Color.white);
            this.annoFieldBoxes[i].setForeground(UIManager.getColor("Label.foreground"));
            this.annoFieldBoxes[i].setActionCommand(cols[i]);
            this.annoFieldBoxes[i].addActionListener((ActionListener)((Object)listener));
            parameters.add((Component)this.annoFieldBoxes[i], (Object)gbc);
        }
        ParameterPanel coordinates = new ParameterPanel();
        coordinates.setLayout((LayoutManager)new GridLayout(0, 3));
        String[] chrs = new String[]{"Select Chr", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        this.chromosome = new JComboBox<String>(chrs);
        coordinates.add((Component)this.chromosome, (Object)gbc);
        this.startBP = new JTextField("Enter Start BP (in KB)");
        coordinates.add((Component)this.startBP, (Object)gbc);
        this.endBP = new JTextField("Enter End BP (in KB)");
        coordinates.add((Component)this.endBP, (Object)gbc);
        ParameterPanel urlsPanel = new ParameterPanel("URL Demo");
        urlsPanel.setLayout((LayoutManager)new GridLayout(0, 2));
        this.ncbiMap = new JButton("NCBI MapViewer");
        this.ncbiMap.setActionCommand("ncbi-map");
        this.ncbiMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("ncbi-map");
                try {
                    String taxId = "9606";
                    String chr = String.valueOf(GenomeAnnoDialog.this.chromosome.getSelectedIndex());
                    String st = String.valueOf(Integer.parseInt(GenomeAnnoDialog.this.startBP.getText()));
                    String end = String.valueOf(Integer.parseInt(GenomeAnnoDialog.this.endBP.getText()));
                    String[] params = new String[]{taxId, chr, st, end};
                    String url = PublicURL.getURL("NCBI_MAPVIEWER", params);
                    System.out.println("1: " + url);
                    BrowserLauncher.openURL((String)url);
                    GenomeAnnoDialog.this.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        urlsPanel.add((Component)this.ncbiMap, (Object)gbc);
        this.ucscMap = new JButton("UCSC Browser");
        this.ucscMap.setActionCommand("ucsc-map");
        this.ucscMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("ucsc-map");
                try {
                    String hg = "hg18";
                    String chr = "chr" + String.valueOf(GenomeAnnoDialog.this.chromosome.getSelectedIndex());
                    String st = String.valueOf(Integer.parseInt(GenomeAnnoDialog.this.startBP.getText()));
                    String end = String.valueOf(Integer.parseInt(GenomeAnnoDialog.this.endBP.getText()));
                    String[] params = new String[]{hg, chr, st, end};
                    String url = PublicURL.getURL("UCSC_BROWSER", params);
                    System.out.println("1: " + url);
                    BrowserLauncher.openURL((String)url);
                    GenomeAnnoDialog.this.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        urlsPanel.add((Component)this.ucscMap, (Object)gbc);
        contentPanel.add((Component)coordinates, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)urlsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)parameters, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setActionListeners((ActionListener)((Object)listener));
        this.addContent(contentPanel);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return 1;
    }

    private void showGenomeAnnotationQueryResult() {
        Vector<String> colsSelected = new Vector<String>();
        Vector<String[]> resultSet = null;
        int end = -1;
        for (int i = 0; i < this.annoFieldBoxes.length; ++i) {
            if (!this.annoFieldBoxes[i].isSelected()) continue;
            colsSelected.add(this.annoFieldBoxes[i].getText().trim());
        }
        String[] colArgs = colsSelected.toArray(new String[1]);
        int chr = this.chromosome.getSelectedIndex();
        int st = Integer.parseInt(this.startBP.getText());
        end = Integer.parseInt(this.endBP.getText());
        try {
            resultSet = MevAnnotation.getGenomeAnnotation(colArgs, chr, st, end);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        System.out.println("ResultSet size " + resultSet.size());
        TableDataModel tableData = null;
        if (resultSet != null && resultSet.size() > 0) {
            Object[][] annoInfo = new Object[resultSet.size()][colArgs.length];
            for (int i = 0; i < resultSet.size(); ++i) {
                for (int j = 0; j < colArgs.length; ++j) {
                    annoInfo[i][j] = resultSet.get(i)[j];
                }
            }
            tableData = new TableDataModel(annoInfo, colArgs);
        } else {
            Object[][] info = new String[1][colArgs.length];
            for (int i = 0; i < resultSet.size(); ++i) {
                info[0][i] = colArgs[i];
            }
            tableData = new TableDataModel(info, colArgs);
        }
        this.genomeAnnoDlg = new JDialog(this.parent, "Results", false);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel genelistPanel = new JPanel();
        genelistPanel.setLayout(new BoxLayout(genelistPanel, 1));
        JTable geneTable = new JTable();
        geneTable.setSelectionMode(2);
        geneTable.setModel(tableData);
        JScrollPane genescroll = new JScrollPane(geneTable);
        genelistPanel.add(genescroll);
        contentPanel.add(genelistPanel);
        JPanel buttPanel = new JPanel();
        buttPanel.setLayout(new BoxLayout(buttPanel, 1));
        JButton closeWin = new JButton("Close Window");
        closeWin.setActionCommand("close-window");
        closeWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("HoHo");
                GenomeAnnoDialog.this.genomeAnnoDlg.dispose();
            }
        });
        buttPanel.add(closeWin);
        c.fill = 2;
        c.ipady = 0;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.anchor = 15;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 1;
        contentPanel.add((Component)buttPanel, c);
        this.genomeAnnoDlg.add(contentPanel);
        this.genomeAnnoDlg.validate();
        this.genomeAnnoDlg.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.genomeAnnoDlg.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.genomeAnnoDlg.setVisible(true);
    }

    public static void main(String[] args) {
        GenomeAnnoDialog dlg = new GenomeAnnoDialog(new JFrame(), new String[]{"PROBE_ID", "TX_END", "ENTREZ_ID", "PROTEIN_ACC", "CYTOBAND"});
        if (dlg.showModal() == 0) {
            System.out.println("ok");
        }
        System.exit(0);
    }

    private class TableDataModel
    extends AbstractTableModel {
        Object[][] data;
        String[] columnNames;

        TableDataModel(Object[][] dataModel, String[] cols) {
            this.data = dataModel;
            this.columnNames = cols;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                System.out.println("OK");
                GenomeAnnoDialog.this.showGenomeAnnotationQueryResult();
                GenomeAnnoDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GenomeAnnoDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)GenomeAnnoDialog.this), (String)"Genome Annotation Dialog");
            }
        }

        public void windowClosing(WindowEvent e) {
            GenomeAnnoDialog.this.dispose();
        }
    }
}

