/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.util.StringSplitter;

public class AnnotationStateSavingParser {
    String[] fieldNames = new String[0];
    Vector columnNames = new Vector();

    public Vector<IAnnotation> readSavedAnnotation(File iAnnotFile) throws Exception {
        String currentLine;
        Vector<IAnnotation> annovEC = new Vector<IAnnotation>();
        BufferedReader reader = new BufferedReader(new FileReader(iAnnotFile));
        StringSplitter ss = new StringSplitter('\t');
        boolean counter = false;
        this.columnNames = this.getColumnHeader(iAnnotFile);
        String _temp = "NA";
        while ((currentLine = reader.readLine()) != null) {
            MevAnnotation annotationObj = new MevAnnotation();
            String cloneID = "";
            while (currentLine.startsWith("#")) {
                currentLine = reader.readLine();
            }
            ss.init(currentLine);
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (ss.hasMoreTokens()) {
                    _temp = ss.nextToken();
                }
                String field = (String)this.columnNames.get(i);
                int index = this.columnNames.indexOf(field);
                Vector<Object> _tmpGo = new Vector();
                if (field.equalsIgnoreCase("PROBE_ID") && index == i) {
                    cloneID = _temp;
                    annotationObj.setCloneID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENBANK_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGenBankAcc(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("UNIGENE_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setUnigeneID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_TITLE") && index == i) {
                    if (_temp == "") {
                        _temp = "NA";
                    }
                    annotationObj.setGeneTitle(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_SYMBOL") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGeneSymbol(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("CHR:TX_START-TX_END(STRAND)") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    this.setAlignmentInfo(_temp, annotationObj);
                    continue;
                }
                if (field.equalsIgnoreCase("ENTREZ_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setLocusLinkID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("REFSEQ_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    String[] mRnaRefSeqs = this.parsemRnaIds(_temp);
                    annotationObj.setRefSeqTxAcc(mRnaRefSeqs);
                    continue;
                }
                if (field.equalsIgnoreCase("GO_TERMS") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    _tmpGo = this.parseGoTerms(_temp, "///");
                    annotationObj.setGoTerms(_tmpGo.toArray(new String[_tmpGo.size()]));
                    continue;
                }
                if (!field.equalsIgnoreCase("TGI_TC") || index != i) continue;
                if (_temp == null) {
                    _temp = "NA";
                }
                annotationObj.setTgiTC(_temp);
            }
            annovEC.add(annotationObj);
        }
        reader.close();
        return annovEC;
    }

    private Vector getColumnHeader(File targetFile) throws Exception {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(targetFile));
        StringSplitter split = new StringSplitter(' ');
        StringSplitter ss = new StringSplitter('\t');
        Vector<String> columnNames = new Vector<String>();
        while ((currentLine = reader.readLine()).contains("#")) {
            if (!currentLine.contains("# Fields:")) continue;
            while ((currentLine = reader.readLine()).contains("#")) {
                split.init(currentLine);
                split.nextToken();
                split.nextToken();
                split.nextToken();
                split.nextToken();
                String temp = split.nextToken();
                int index = Integer.parseInt(temp.substring(0, temp.indexOf(".")));
                String ann = split.nextToken();
                columnNames.add(index - 1, ann);
            }
            break block0;
        }
        return columnNames;
    }

    private Vector<String> parseGoTerms(String _temp, String delim) {
        Vector<String> terms = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, delim);
        while (tokens.hasMoreTokens()) {
            terms.add(tokens.nextToken().trim());
        }
        return terms;
    }

    private String[] parsemRnaIds(String _temp) {
        Vector<String> mrna = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, "///");
        while (tokens.hasMoreTokens()) {
            mrna.add(tokens.nextToken().trim());
        }
        String[] strArray = new String[mrna.size()];
        mrna.toArray(strArray);
        return strArray;
    }

    private void setAlignmentInfo(String temp, MevAnnotation obj) {
        if (!temp.trim().startsWith("chr")) {
            obj.setProbeStrand("na");
            obj.setProbeChromosome("na");
            try {
                obj.setProbeTxStartBP("-1");
                obj.setProbeTxEndBP("-1");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        int index = temp.indexOf("(");
        String strand = temp.substring(index + 1, index + 2).trim();
        String _temp = temp.substring(0, index).trim();
        int chrInd = _temp.indexOf(":");
        String chr = _temp.substring(0, chrInd);
        chr = chr.substring(3, chr.length());
        int txInd = _temp.indexOf("-");
        String txSt = _temp.substring(chrInd + 1, txInd);
        String txEnd = _temp.substring(txInd + 1, _temp.length());
        obj.setProbeStrand(strand);
        obj.setProbeChromosome(chr);
        try {
            obj.setProbeTxStartBP(txSt);
            obj.setProbeTxEndBP(txEnd);
        }
        catch (Exception e) {
            System.out.println("Contains Illegal Char: " + txSt + ", " + txEnd);
        }
    }

    public void writeAnnotationFile(Vector IAnnotations, PrintWriter writer) throws Exception {
        String[] fieldNames = new String[]{"PROBE_ID", "GENBANK_ACC", "REFSEQ_ACC", "ENTREZ_ID", "UNIGENE_ID", "GENE_SYMBOL", "GENE_TITLE", "CHR:TX_START-TX_END(STRAND)", "GO_TERMS", "TGI_TC"};
        writer.write("#");
        writer.println();
        writer.write("# Fields:");
        writer.println();
        writer.write("#    1. PROBE_ID");
        writer.println();
        writer.write("#    2. GENBANK_ACC");
        writer.println();
        writer.write("#    3. REFSEQ_ACC");
        writer.println();
        writer.write("#    4. ENTREZ_ID");
        writer.println();
        writer.write("#    5. UNIGENE_ID");
        writer.println();
        writer.write("#    6. GENE_SYMBOL");
        writer.println();
        writer.write("#    7. GENE_TITLE");
        writer.println();
        writer.write("#    8. CHR:TX_START-TX_END(STRAND)");
        writer.println();
        writer.write("#    9. GO_TERMS");
        writer.println();
        writer.write("#    10. TGI_TC");
        writer.println();
        for (int i = 0; i < IAnnotations.size(); ++i) {
            MevAnnotation _obj = (MevAnnotation)IAnnotations.get(i);
            for (int index = 0; index < fieldNames.length; ++index) {
                int j;
                String[] _temp;
                String[] _temparray;
                String _tempStr;
                String _tempRefSeq = "";
                String _tmpGO = "";
                if (index == 0) {
                    writer.write(_obj.getCloneID());
                    writer.write(9);
                    continue;
                }
                if (index == 1) {
                    _tempStr = _obj.getGenBankAcc();
                    if (_tempStr != "NA") {
                        writer.write(_obj.getGenBankAcc());
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 2) {
                    _temparray = _obj.getRefSeqTxAcc();
                    if (_temparray[0] != "NA") {
                        _temp = _obj.getRefSeqTxAcc();
                        for (j = 0; j < _temp.length; ++j) {
                            _tempRefSeq = _tempRefSeq.concat(_temp[j]);
                            if (j >= _temp.length - 1) continue;
                            _tempRefSeq = _tempRefSeq.concat("///");
                        }
                        writer.write(_tempRefSeq);
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 3) {
                    _tempStr = _obj.getEntrezGeneID();
                    if (_tempStr != "NA") {
                        writer.write(_obj.getEntrezGeneID());
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 4) {
                    _tempStr = _obj.getUnigeneID();
                    if (_tempStr != "NA") {
                        writer.write(_obj.getUnigeneID());
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 5) {
                    _tempStr = _obj.getGeneSymbol();
                    if (_tempStr != "NA") {
                        writer.write(_obj.getGeneSymbol());
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 6) {
                    _tempStr = _obj.getGeneTitle();
                    if (_tempStr != "NA") {
                        writer.write(_obj.getGeneTitle());
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 7) {
                    _tempStr = _obj.getProbeChromosome();
                    if (_tempStr != "NA") {
                        writer.write("chr" + _obj.getProbeChromosome() + ":" + _obj.getProbeTxStartBP() + "-" + _obj.getProbeTxEndBP() + "(" + _obj.getProbeStrand() + ")");
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index == 8) {
                    _temparray = _obj.getGoTerms();
                    if (_temparray[0] != null) {
                        _temp = _obj.getGoTerms();
                        for (j = 0; j < _temp.length; ++j) {
                            _tmpGO = _tmpGO.concat(_temp[j]);
                            if (j >= _temp.length - 1) continue;
                            _tmpGO = _tmpGO.concat("///");
                        }
                        writer.write(_tmpGO);
                        writer.write(9);
                        continue;
                    }
                    writer.write("NA");
                    writer.write(9);
                    continue;
                }
                if (index != 9) continue;
                _tempStr = _obj.getTgiTC();
                if (_tempStr != "NA") {
                    writer.write(_obj.getTgiTC());
                    writer.println();
                    continue;
                }
                writer.write("NA");
                writer.println();
            }
        }
        writer.close();
    }
}

