/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.annotation.IChipAnnotation;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.annotation.MevChipAnnotation;
import org.tigr.util.StringSplitter;

public class AnnotationFileReader {
    String[] fieldNames = new String[0];
    Vector<String> columnNames = new Vector();
    Hashtable<String, MevAnnotation> annoHash;
    IChipAnnotation chipAnnotation = new MevChipAnnotation();

    public static AnnotationFileReader createAnnotationFileReader(File affyFile) throws IOException {
        AnnotationFileReader newReader = new AnnotationFileReader();
        newReader.loadAffyAnnotation(affyFile);
        return newReader;
    }

    private AnnotationFileReader() {
    }

    public void setAnnotation(String[] newAnnotation) {
        this.fieldNames = newAnnotation;
    }

    public String[] getAvailableAnnotations() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String[] getAnnotation() {
        return this.fieldNames;
    }

    public IChipAnnotation getAffyChipAnnotation() {
        return this.chipAnnotation;
    }

    public Hashtable<String, MevAnnotation> getAffyAnnotation() {
        return this.annoHash;
    }

    private void loadAffyAnnotation(File affyFIle) throws IOException {
        String currentLine;
        int numLines = this.getCountOfLines(affyFIle);
        BufferedReader reader = new BufferedReader(new FileReader(affyFIle));
        this.annoHash = new Hashtable(numLines);
        this.chipAnnotation.setAnnFileName(affyFIle.getAbsolutePath());
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        this.columnNames = this.getColumnHeader(affyFIle);
        String _temp = "NA";
        Vector _tmpGO = new Vector();
        String orgName = "";
        String chipType = "";
        while ((currentLine = reader.readLine()) != null) {
            MevAnnotation annotationObj = new MevAnnotation();
            String probeID = "";
            while (currentLine.startsWith("#")) {
                StringSplitter split = new StringSplitter(':');
                split.init(currentLine);
                if (counter == 0) {
                    split.nextToken();
                    chipType = split.nextToken();
                    chipType = chipType.substring(chipType.indexOf(32) + 1);
                } else if (counter == 1) {
                    split.nextToken();
                    orgName = split.nextToken();
                    orgName = orgName.substring(orgName.indexOf(32) + 1);
                }
                this.chipAnnotation.setChipType(chipType);
                this.chipAnnotation.setSpeciesName(orgName);
                ++counter;
                currentLine = reader.readLine();
            }
            counter = 0;
            ss.init(currentLine);
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (ss.hasMoreTokens()) {
                    _temp = ss.nextToken();
                }
                String field = this.columnNames.get(i);
                int index = this.columnNames.indexOf(field);
                Vector<Object> _tmpGo = new Vector();
                if ((field.equalsIgnoreCase("PROBE_ID") || field.equalsIgnoreCase("CLONE_ID")) && index == i) {
                    probeID = _temp;
                    annotationObj.setCloneID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENBANK_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGenBankAcc(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("UNIGENE_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setUnigeneID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_TITLE") && index == i) {
                    if (_temp == "") {
                        _temp = "NA";
                    }
                    annotationObj.setGeneTitle(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_SYMBOL") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGeneSymbol(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("CHR:TX_START-TX_END(STRAND)") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    this.setAlignmentInfo(_temp, annotationObj);
                    continue;
                }
                if (field.equalsIgnoreCase("ENTREZ_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setLocusLinkID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("REFSEQ_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    String[] mRnaRefSeqs = this.parsemRnaIds(_temp);
                    annotationObj.setRefSeqTxAcc(mRnaRefSeqs);
                    continue;
                }
                if (field.equalsIgnoreCase("GO_TERMS") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    _tmpGo = this.parseGoTerms(_temp, "///");
                    annotationObj.setGoTerms(_tmpGo.toArray(new String[_tmpGo.size()]));
                    continue;
                }
                if (!field.equalsIgnoreCase("TGI_TC") || index != i) continue;
                if (_temp == null) {
                    _temp = "NA";
                }
                annotationObj.setTgiTC(_temp);
            }
            if (probeID != null) {
                this.annoHash.put(probeID, annotationObj);
            } else {
                String eMsg = "<html>Probe ID Missing..This is a REQUIRED field <br><html>The following descriptor was found for this probe<br> " + annotationObj.getProbeDesc();
                JOptionPane.showMessageDialog(null, eMsg, "Error", 1);
            }
            ++counter;
        }
        reader.close();
    }

    private Vector getColumnHeader(File targetFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(targetFile));
        StringSplitter split = new StringSplitter(' ');
        StringSplitter ss = new StringSplitter('\t');
        Vector<String> columnNames = new Vector<String>();
        Pattern pattern = Pattern.compile("# *Fields:*", 2);
        while ((currentLine = reader.readLine()) != null) {
            while (!pattern.matcher(currentLine).find()) {
                currentLine = reader.readLine();
            }
            if (!pattern.matcher(currentLine).find()) continue;
            while ((currentLine = reader.readLine()).startsWith("#")) {
                split.init(currentLine);
                split.nextToken();
                split.nextToken();
                split.nextToken();
                split.nextToken();
                String temp = split.nextToken();
                int index = Integer.parseInt(temp.substring(0, temp.indexOf(".")));
                String ann = split.nextToken();
                columnNames.add(index - 1, ann);
            }
            break block0;
        }
        reader.close();
        return columnNames;
    }

    private Vector<String> parseGoTerms(String _temp, String delim) {
        Vector<String> terms = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, delim);
        while (tokens.hasMoreTokens()) {
            terms.add(tokens.nextToken().trim());
        }
        return terms;
    }

    private void setAlignmentInfo(String temp, MevAnnotation obj) {
        if (!temp.trim().startsWith("chr")) {
            obj.setProbeStrand("NA");
            obj.setProbeChromosome("NA");
            try {
                obj.setProbeTxStartBP("-1");
                obj.setProbeTxEndBP("-1");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        int index = temp.indexOf("(");
        String strand = temp.substring(index + 1, index + 2).trim();
        String _temp = temp.substring(0, index).trim();
        int chrInd = _temp.indexOf(":");
        String chr = _temp.substring(0, chrInd);
        chr = chr.substring(3, chr.length());
        int txInd = _temp.indexOf("-");
        String txSt = _temp.substring(chrInd + 1, txInd);
        String txEnd = _temp.substring(txInd + 1, _temp.length());
        obj.setProbeStrand(strand);
        obj.setProbeChromosome(chr);
        try {
            obj.setProbeTxStartBP(txSt);
            obj.setProbeTxEndBP(txEnd);
        }
        catch (Exception e) {
            System.out.println("Contains Illegal Char: " + txSt + ", " + txEnd);
        }
    }

    private String[] parseProteinIds(String _temp) {
        Vector<String> prots = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, "///");
        while (tokens.hasMoreTokens()) {
            prots.add(tokens.nextToken().trim());
        }
        String[] strArray = new String[prots.size()];
        prots.toArray(strArray);
        return strArray;
    }

    private String[] parsemRnaIds(String _temp) {
        Vector<String> mrna = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, "///");
        while (tokens.hasMoreTokens()) {
            mrna.add(tokens.nextToken().trim());
        }
        String[] strArray = new String[mrna.size()];
        mrna.toArray(strArray);
        return strArray;
    }

    public int getCountOfLines(File f) {
        int numLines = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while (reader.readLine() != null) {
                ++numLines;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numLines;
    }
}

