/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.util.CSVReader;
import org.tigr.util.StringSplitter;

public class AffymetrixAnnotationParser {
    Vector columnNames = new Vector();
    Hashtable<String, MevAnnotation> annoHash;
    int num_of_skippedLines = 0;

    public static AffymetrixAnnotationParser createAnnotationFileParser(File affyFile) throws IOException {
        AffymetrixAnnotationParser newParser = new AffymetrixAnnotationParser();
        newParser.loadAffyAnnotation(affyFile);
        return newParser;
    }

    private AffymetrixAnnotationParser() {
    }

    private void loadAffyAnnotation(File annotationFile) throws IOException {
        String[] currentLine;
        boolean counter = false;
        this.columnNames = this.getColumnHeader(annotationFile);
        String _temp = "NA";
        Vector<String> _tmpGo = new Vector<String>();
        int numLines = this.getCountOfLines(annotationFile);
        this.annoHash = new Hashtable(numLines);
        BufferedReader reader = new BufferedReader(new FileReader(annotationFile));
        CSVReader csvreader = new CSVReader(reader, ',', '\"', this.get_Lines_To_Skip());
        while ((currentLine = csvreader.readNext()) != null) {
            MevAnnotation annotationObj = new MevAnnotation();
            String probeID = "";
            _tmpGo = new Vector();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                _temp = currentLine[i];
                String field = (String)this.columnNames.get(i);
                int index = this.columnNames.indexOf(field);
                if ((field.equalsIgnoreCase("PROBE_ID") || field.equalsIgnoreCase("CLONE_ID")) && index == i) {
                    probeID = _temp;
                    annotationObj.setCloneID(_temp);
                    System.out.println("clone id:" + probeID + ":" + index);
                    continue;
                }
                if (field.equalsIgnoreCase("GENBANK_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGenBankAcc(_temp);
                    System.out.println("Genbank acc:" + _temp + ":" + index);
                    continue;
                }
                if (field.equalsIgnoreCase("UNIGENE_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setUnigeneID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_TITLE") && index == i) {
                    if (_temp == "") {
                        _temp = "NA";
                    }
                    annotationObj.setGeneTitle(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("GENE_SYMBOL") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setGeneSymbol(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("CHR:TX_START-TX_END(STRAND)") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    this.setAlignmentInfo(_temp, annotationObj);
                    continue;
                }
                if (field.equalsIgnoreCase("ENTREZ_ID") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    annotationObj.setLocusLinkID(_temp);
                    continue;
                }
                if (field.equalsIgnoreCase("PROTEIN_ACC") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    String[] proteinAcc = this.parseProteinIds(_temp);
                    annotationObj.setRefSeqProtAcc(proteinAcc);
                    continue;
                }
                if (field.equalsIgnoreCase("GeneOntologyMolecularFunction") && index == i || field.equalsIgnoreCase("GeneOntologyCellularComponent") && index == i || field.equalsIgnoreCase("GeneOntologyBiologicalProcess") && index == i) {
                    if (_temp == null) {
                        _temp = "NA";
                    }
                    Vector<String> temp = this.parseGoTerms(_temp, "///");
                    _tmpGo.addAll(this.parseGoTerms(_temp, "///"));
                    continue;
                }
                if (!field.equalsIgnoreCase("TGI_TC") || index != i) continue;
                if (_temp == null) {
                    _temp = "NA";
                }
                annotationObj.setTgiTC(_temp);
            }
            annotationObj.setGoTerms(_tmpGo.toArray(new String[_tmpGo.size()]));
            if (probeID != null) {
                this.annoHash.put(probeID, annotationObj);
                continue;
            }
            String eMsg = "<html>Probe ID Missing..This is a REQUIRED field <br><html>The following descriptor was found for this probe<br> " + annotationObj.getProbeDesc();
            JOptionPane.showMessageDialog(null, eMsg, "Error", 1);
        }
    }

    public Hashtable<String, MevAnnotation> getAffyAnnotation() {
        return this.annoHash;
    }

    private Vector getColumnHeader(File targetFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(targetFile));
        StringSplitter split = new StringSplitter(',');
        while ((currentLine = reader.readLine()).contains("#")) {
            ++this.num_of_skippedLines;
        }
        this.set_Lines_To_Skip(this.num_of_skippedLines + 1);
        currentLine = currentLine.trim();
        split.init(currentLine);
        int columnNumber = 0;
        Vector<String> columnNames = new Vector<String>(split.countTokens());
        while (split.hasMoreTokens()) {
            String _temp = split.nextToken().trim();
            _temp = _temp.replace('\"', ' ');
            if ((_temp = this.removeAllSpaces(_temp)).contains("ProbeSetID")) {
                columnNames.add(columnNumber, "PROBE_ID");
            } else if (_temp.equalsIgnoreCase("UniGeneID")) {
                columnNames.add(columnNumber, "UNIGENE_ID");
            } else if (_temp.contentEquals("GeneTitle")) {
                columnNames.add(columnNumber, "GENE_TITLE");
            } else if (_temp.contentEquals("GeneSymbol")) {
                columnNames.add(columnNumber, "GENE_SYMBOL");
            } else if (_temp.contentEquals("Alignments")) {
                columnNames.add(columnNumber, "CHR:TX_START-TX_END(STRAND)");
            } else if (_temp.contentEquals("EntrezGene")) {
                columnNames.add(columnNumber, "ENTREZ_ID");
            } else if (_temp.equalsIgnoreCase("RefSeqProteinID")) {
                columnNames.add(columnNumber, "PROTEIN_ACC");
            } else if (_temp.equalsIgnoreCase("GeneOntologyBiologicalProcess")) {
                columnNames.add(columnNumber, "GeneOntologyBiologicalProcess");
            } else if (_temp.equalsIgnoreCase("GeneOntologyCellularComponent")) {
                columnNames.add(columnNumber, "GeneOntologyCellularComponent");
            } else if (_temp.equalsIgnoreCase("GeneOntologyMolecularFunction")) {
                columnNames.add(columnNumber, "GeneOntologyMolecularFunction");
            } else {
                columnNames.add(columnNumber, "No element");
            }
            _temp = new String();
            ++columnNumber;
        }
        reader.close();
        return columnNames;
    }

    private int get_Lines_To_Skip() {
        return this.num_of_skippedLines;
    }

    private void set_Lines_To_Skip(int skip_these_lines) {
        this.num_of_skippedLines = skip_these_lines;
    }

    private Vector<String> parseGoTerms(String _temp, String delim) {
        Vector<String> terms = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, delim);
        while (tokens.hasMoreTokens()) {
            terms.add(tokens.nextToken().trim());
        }
        return terms;
    }

    private void setAlignmentInfo(String temp, MevAnnotation obj) {
        if (!temp.trim().startsWith("chr")) {
            obj.setProbeStrand("NA");
            obj.setProbeChromosome("NA");
            try {
                obj.setProbeTxStartBP("-1");
                obj.setProbeTxEndBP("-1");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        int index = temp.indexOf("(");
        String strand = temp.substring(index + 1, index + 2).trim();
        String _temp = temp.substring(0, index).trim();
        int chrInd = _temp.indexOf(":");
        String chr = _temp.substring(0, chrInd);
        chr = chr.substring(3, chr.length());
        int txInd = _temp.indexOf("-");
        String txSt = _temp.substring(chrInd + 1, txInd);
        String txEnd = _temp.substring(txInd + 1, _temp.length());
        obj.setProbeStrand(strand);
        obj.setProbeChromosome(chr);
        try {
            obj.setProbeTxStartBP(txSt);
            obj.setProbeTxEndBP(txEnd);
        }
        catch (Exception e) {
            System.out.println("Contains Illegal Char: " + txSt + ", " + txEnd);
        }
    }

    private String[] parsemRnaIds(String _temp) {
        Vector<String> mrna = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, "///");
        while (tokens.hasMoreTokens()) {
            mrna.add(tokens.nextToken().trim());
        }
        String[] strArray = new String[mrna.size()];
        mrna.toArray(strArray);
        return strArray;
    }

    private String[] parseProteinIds(String _temp) {
        Vector<String> prots = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(_temp, "///");
        while (tokens.hasMoreTokens()) {
            prots.add(tokens.nextToken().trim());
        }
        String[] strArray = new String[prots.size()];
        prots.toArray(strArray);
        return strArray;
    }

    public int getCountOfLines(File f) {
        int numLines = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while (reader.readLine() != null) {
                ++numLines;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numLines;
    }

    public String removeAllSpaces(String str) {
        String newString = new String();
        StringSplitter split = new StringSplitter(' ');
        split.init(str);
        while (split.hasMoreTokens()) {
            newString = newString + split.nextToken().trim();
        }
        return newString;
    }

    public static void main(String[] args) {
        try {
            AffymetrixAnnotationParser aap = AffymetrixAnnotationParser.createAnnotationFileParser(new File("C:/Users/sarita/Desktop/HG-U133A_2.csv"));
            Hashtable<Object, Object> temp = new Hashtable();
            temp = aap.getAffyAnnotation();
            System.out.println("SIze of hashtable is:" + temp.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

