/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class VarianceFilterDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox enableFilterBox;
    private JTextField valueField;
    private JRadioButton percentButton;
    private JRadioButton numberButton;
    private JRadioButton sdValueButton;
    private JLabel valueLabel;

    public VarianceFilterDialog(JFrame parent) {
        super(parent, "Variance Filter", true);
        Listener listener = new Listener();
        ParameterPanel panel = new ParameterPanel("Filter Settings");
        panel.setLayout((LayoutManager)new GridBagLayout());
        this.enableFilterBox = new JCheckBox("Enable Variance Filter", true);
        this.enableFilterBox.setOpaque(false);
        this.enableFilterBox.setFocusPainted(false);
        this.enableFilterBox.setActionCommand("enable-box-command");
        this.enableFilterBox.addActionListener(listener);
        ButtonGroup group = new ButtonGroup();
        this.percentButton = new JRadioButton("Percentage of Highest SD Genes (1-100)", true);
        this.percentButton.setFocusPainted(false);
        this.percentButton.setOpaque(false);
        group.add(this.percentButton);
        this.numberButton = new JRadioButton("Number of Desired High SD Genes");
        this.numberButton.setFocusPainted(false);
        this.numberButton.setOpaque(false);
        group.add(this.numberButton);
        this.sdValueButton = new JRadioButton("SD Cutoff Value", true);
        this.sdValueButton.setFocusPainted(false);
        this.sdValueButton.setOpaque(false);
        group.add(this.sdValueButton);
        this.valueLabel = new JLabel("Value: ");
        this.valueField = new JTextField("50", 10);
        this.valueField.selectAll();
        panel.add((Component)this.enableFilterBox, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
        panel.add((Component)this.percentButton, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.numberButton, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.sdValueButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.valueLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 30, 0), 0, 0));
        panel.add((Component)this.valueField, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(20, 10, 30, 0), 0, 0));
        this.addContent((Component)panel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void enableControls(boolean enable) {
        this.percentButton.setEnabled(enable);
        this.numberButton.setEnabled(enable);
        this.sdValueButton.setEnabled(enable);
        this.valueField.setEnabled(enable);
        this.valueLabel.setEnabled(enable);
    }

    private void resetControls() {
        this.enableFilterBox.setSelected(true);
        this.percentButton.setSelected(true);
        this.valueField.setText("50");
        this.valueField.selectAll();
        this.enableControls(true);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.enableFilterBox.isSelected()) {
            props.setProperty("Filter Enabled", "true");
            if (this.percentButton.isSelected()) {
                props.setProperty("Filter Mode", "percent mode");
            } else if (this.numberButton.isSelected()) {
                props.setProperty("Filter Mode", "number of genes mode");
            } else {
                props.setProperty("Filter Mode", "sd value mode");
            }
            props.setProperty("Value", this.valueField.getText());
        } else {
            props.setProperty("Filter Enabled", "false");
        }
        return props;
    }

    private boolean validateValues() {
        boolean valid = true;
        if (this.percentButton.isSelected()) {
            float value;
            try {
                Float.parseFloat(this.valueField.getText());
            }
            catch (NumberFormatException nfe) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format.", "Input Format Error", 0);
            }
            if (valid && ((value = Float.parseFloat(this.valueField.getText())) <= 0.0f || value > 100.0f)) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is 0 < x <= 100)", "Input Format Error", 0);
            }
        } else if (this.numberButton.isSelected()) {
            int value;
            try {
                Integer.parseInt(this.valueField.getText());
            }
            catch (NumberFormatException nfe) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format. Value should be an integer.", "Input Format Error", 0);
            }
            if (valid && (value = Integer.parseInt(this.valueField.getText())) <= 0) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is x > 0)", "Input Format Error", 0);
            }
        } else {
            float value;
            try {
                Float.parseFloat(this.valueField.getText());
            }
            catch (NumberFormatException nfe) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format.", "Input Format Error", 0);
            }
            if (valid && (value = Float.parseFloat(this.valueField.getText())) < 0.0f) {
                valid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is x >= 0)", "Input Format Error", 0);
            }
        }
        return valid;
    }

    public static void main(String[] args) {
        VarianceFilterDialog d = new VarianceFilterDialog(new JFrame());
        d.showModal();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                if (!VarianceFilterDialog.this.validateValues()) {
                    return;
                }
                this.onOk();
            } else if (command.equals("cancel-command")) {
                VarianceFilterDialog.this.result = 2;
                VarianceFilterDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                VarianceFilterDialog.this.resetControls();
            } else if (command.equals("enable-box-command")) {
                VarianceFilterDialog.this.enableControls(VarianceFilterDialog.this.enableFilterBox.isSelected());
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)VarianceFilterDialog.this), (String)"Variance Filter Dialog");
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            VarianceFilterDialog.this.result = -1;
            VarianceFilterDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        private void onOk() {
            try {
                VarianceFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                VarianceFilterDialog.this.result = 2;
            }
            VarianceFilterDialog.this.dispose();
        }
    }
}

