/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class Thumbnail
extends JFrame {
    private Canvas canvas;

    public Thumbnail(IFramework framework, WindowListener windowListener) {
        super("Thumbnail");
        this.addWindowListener(windowListener);
        Listener listener = new Listener();
        this.canvas = this.createCanvas(framework, listener);
        this.getContentPane().add((Component)this.canvas, "Center");
        this.setSize(100, 200);
    }

    public void onDataChanged(IData data) {
        this.canvas.onDataChanged(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.canvas.onMenuChanged(menu);
    }

    private Canvas createCanvas(IFramework framework, MouseListener listener) {
        Canvas canvas = new Canvas(framework);
        canvas.setBackground(Color.white);
        canvas.addMouseListener(listener);
        return canvas;
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Thumbnail.this.canvas.setContentPosition(event.getY());
        }
    }

    private class Canvas
    extends JPanel {
        private IFramework framework;
        private IData data;
        private int elementHeight = 5;
        private float maxRatio;
        private float minRatio;

        public Canvas(IFramework framework) {
            this.framework = framework;
            this.data = framework.getData();
            this.maxRatio = framework.getDisplayMenu().getMaxRatioScale();
            this.minRatio = framework.getDisplayMenu().getMinRatioScale();
        }

        public void onDataChanged(IData data) {
            this.data = data;
            this.repaint();
        }

        public void onMenuChanged(IDisplayMenu menu) {
            this.elementHeight = menu.getElementSize().height;
            this.maxRatio = menu.getMaxRatioScale();
            this.minRatio = menu.getMinRatioScale();
            this.repaint();
        }

        private void setContentPosition(int mouseY) {
            this.framework.setContentLocation(0, this.elementHeight * this.data.getFeaturesSize() * mouseY / this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int COLUMNS = this.data.getFeaturesCount();
            int ROWS = this.data.getFeaturesSize();
            float width = (float)this.getWidth() / (float)COLUMNS;
            float height = (float)this.getHeight() / (float)ROWS;
            int eHeight = (int)height > 0 ? (int)height : 1;
            for (int column = 0; column < COLUMNS; ++column) {
                int[] indices = this.data.getSortedIndices(column);
                for (int row = 0; row < ROWS; ++row) {
                    int x = Math.round(width * (float)column);
                    int y = Math.round(height * (float)row);
                    float ratio = this.data.getRatio(column, indices[row], 1);
                    this.drawElement(g, x, y, Math.round(width), eHeight, ratio);
                }
            }
        }

        private void drawElement(Graphics g, int x, int y, int width, int height, float ratio) {
            Color holdColor;
            if (ratio > 0.0f) {
                ratio = (ratio = Math.abs(ratio / this.maxRatio)) > 1.0f ? 1.0f : ratio;
                holdColor = new Color(ratio, 0.0f, 0.0f);
            } else if (ratio < 0.0f) {
                ratio = (ratio = Math.abs(ratio / this.minRatio)) > 1.0f ? 1.0f : ratio;
                holdColor = new Color(0.0f, ratio, 0.0f);
            } else {
                holdColor = new Color(128, 128, 128);
            }
            g.setColor(holdColor);
            g.fillRect(x, y, width, height);
        }
    }
}

