/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.util.StringTokenizer;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.remote.RemoteAlgorithm;
import org.tigr.remote.communication.CommunicatorFactory;
import org.tigr.util.ConfMap;

public class TMEVAlgorithmFactory
implements AlgorithmFactory {
    private ConfMap cfg;
    private AlgorithmFactory localFactory;
    private boolean isRemoteEnabled = false;

    public TMEVAlgorithmFactory(ConfMap cfg) {
        this.cfg = cfg;
        String className = cfg.getString("algorithm.factory.class");
        if (className == null || className.equals("null")) {
            className = "org.tigr.microarray.mev.cluster.algorithm.impl.AlgorithmFactoryImpl";
            System.out.println("Local factory not available, check the 'algorithm.factory.class' key in properties file.");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(className, true, cl);
            this.localFactory = (AlgorithmFactory)clazz.newInstance();
        }
        catch (Exception e) {
            System.out.println("Local factory not available, check the 'algorithm.factory.class' key in properties file.");
            e.printStackTrace();
        }
        try {
            CommunicatorFactory.init(cfg);
            this.isRemoteEnabled = true;
        }
        catch (Exception e) {
            System.out.println("Failed to configure remote execution.");
            e.printStackTrace();
        }
    }

    public Algorithm getAlgorithm(String name) throws AlgorithmException {
        if (name == null) {
            throw new AlgorithmException("Algorithm name expected.");
        }
        if (this.isRemote(name)) {
            if (this.isRemoteEnabled) {
                return new RemoteAlgorithm(name);
            }
            throw new AlgorithmException("Remote execution not available.");
        }
        if (this.localFactory == null) {
            throw new AlgorithmException("Local execution not available.");
        }
        return this.localFactory.getAlgorithm(name);
    }

    private boolean isRemote(String name) {
        String remoute = this.cfg.getString("algorithm.remote");
        if (remoute == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(remoute, ":");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (!str.trim().toUpperCase().equals(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

