/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.SessionOptions;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEVAlgorithmFactory;
import org.tigr.microarray.mev.annotation.AnnotationURLsFileDefinition;
import org.tigr.microarray.mev.annotation.InvalidAnnMappingFileException;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.gui.IGUIFactory;
import org.tigr.microarray.mev.file.FileLoadInfo;
import org.tigr.microarray.mev.file.InvalidFileArgumentsException;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.util.ConfMap;
import org.tigr.util.StringSplitter;
import org.tigr.util.awt.ImageScreen;

public class TMEV {
    public static final int SYSTEM = 1000;
    public static final int DB_AVAILABLE = 1001;
    public static final int DB_LOGIN = 1002;
    public static final int DATA_AVAILABLE = 1003;
    public static final int SPOTFIRE_AVAILABLE = 1004;
    public static final int DATA_TYPE_TWO_DYE = 1;
    public static final int DATA_TYPE_AFFY = 2;
    public static final String LAST_LOADED_ARRAY = "last-loaded-array";
    public static final String LAST_LOADED_SPECIES = "last-loaded-species";
    public static final String PROMPT_TO_SAVE_ANALYSIS = "prompt-for-save";
    public static final String PROMPT_TO_GET_ONLINE = "prompt-to-get-online";
    public static final String ALLOWED_ONLINE = "allow-internet-connections";
    public static final String CUSTOM_ANNOTATION_URLS_FILE = "annotation-urls-mapping-file";
    public static final String CURRENT_DATA_PATH = "current-data-path";
    public static final String CURRENT_ANNOTATION_PATH = "current-annotation-path";
    public static final int ANALYSIS_LOADED = 101;
    public static final String ELEMENT_SIZE_WIDTH = "last-selected-element-width";
    public static final String ELEMENT_SIZE_HEIGHT = "last-selected-element-height";
    public static final String COLOR_SCHEME_INDEX = "last-selected-color-scheme-index";
    public static final String COLOR_SCHEME_POSITIVE = "last-selected-color-scheme-positive";
    public static final String COLOR_SCHEME_NEGATIVE = "last-selected-color-scheme-negative";
    public static final String COLOR_SCHEME_NEUTRAL = "last-selected-color-scheme-neutral";
    public static final String COLOR_SCHEME_DOUBLE = "last-selected-color-scheme-double-gradient";
    private static Connection connection;
    private static AlgorithmFactory algorithmFactory;
    private static IGUIFactory guiFactory;
    private static int coordinatePairCount;
    private static int intensityCount;
    private static int headerRowCount;
    private static int headerColumnCount;
    private static int uniqueIDIndex;
    private static int nameIndex;
    private static boolean indicesAdjusted;
    private static String[] databases;
    public static boolean permitSavePrompt;
    private static int dataType;
    private static String os;
    public static boolean activeSave;
    public static String rPath;
    private static IResourceManager resourceManager;
    public static boolean cloneDistributionsLogState;
    public static int browserDefaultDyeSwapValue;
    public static int browserDefaultNoDyeSwapValue;
    public static int defaultCloneValue;
    public static int defaultFlankingRegionValue;
    public static final int CGH_SPECIES_HS = 0;
    public static final int CGH_SPECIES_MM = 1;
    public static final int CGH_SPECIES_Undef = -100;
    public static boolean GAGGLE_CONNECT_ON_STARTUP;
    public static String PROPERTY_CONFIG_FILES;
    private static File mevUserDir;
    private static File mevPropertiesFile;
    private static ConfMap props;
    private static Properties buildProps;
    private static SessionOptions so;

    public static void main(String[] args) {
        so = TMEV.parseArgs(args);
        if (so.sendHelpText()) {
            System.out.println(so.getHelpText());
            System.exit(0);
        }
        if (so.isConnectToGaggle()) {
            GAGGLE_CONNECT_ON_STARTUP = true;
        }
        mevUserDir = new File(System.getProperty("user.home"), ".mev");
        mevPropertiesFile = new File(mevUserDir, "mev.properties");
        try {
            String Java3DVersion;
            String Java3DVendor;
            String Java3DTitle;
            TMEV.loadBuildProperties();
            System.out.println("MultiExperimentViewer - version " + TMEV.getVersion() + " - " + System.getProperty("os.name"));
            InformationPanel info = new InformationPanel();
            try {
                Java3DTitle = info.getJava3DRunTimeEnvironment();
                Java3DVendor = info.getJava3DVendor();
                Java3DVersion = info.getJava3DVersion();
            }
            catch (Exception e) {
                Java3DTitle = "not installed";
                Java3DVendor = "not available";
                Java3DVersion = "not available";
            }
            os = System.getProperty("os.name");
            System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
            System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
            System.out.println("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
            System.out.println("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
            System.out.println("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
            System.out.println("Java 3D Runtime Environment: " + Java3DTitle);
            System.out.println("Java 3D Runtime Environment vendor: " + Java3DVendor);
            System.out.println("Java 3D Runtime Environment version:" + Java3DVersion);
            System.out.println("Operating System name: " + os);
            System.out.println("Operating System version: " + System.getProperty("os.version"));
            System.out.println("Operating System architecture: " + System.getProperty("os.arch"));
            System.out.println("MeV Build: " + buildProps.getProperty("BUILD-REVISION", "unknown"));
            System.out.println("MeV Revision Date: " + buildProps.getProperty("REVISION-DATE", "unknown"));
            System.out.println("MeV Branch: " + buildProps.getProperty("BUILD-BRANCH-URL", "unknown"));
            TMEV.loadProperties();
            TMEV.setupFiles();
            TMEV.configure();
            ImageScreen is = new ImageScreen();
            is.showImageScreen(3000L);
            Manager manager = new Manager();
            try {
                resourceManager = new FileResourceManager(new File(mevUserDir, "repository"));
            }
            catch (RepositoryInitializationError rie) {
                JOptionPane.showMessageDialog(null, "MeV was unable to create a repository for support data files at the location \n" + mevUserDir.getAbsolutePath() + "repository.\n" + "MeV will be able to load expression data and do analyses, \nbut will not be able to automatically retrieve support data files from the internet for you. ", "Error creating Support File Repository", 2);
                rie.printStackTrace();
            }
            if (resourceManager != null) {
                try {
                    File _urlsFile = resourceManager.getSupportFile(new AnnotationURLsFileDefinition(), true);
                    TMEV.loadAnnotationsURLs(_urlsFile);
                }
                catch (SupportFileAccessError sfae) {
                }
                catch (NullPointerException npe) {}
            } else {
                File _urlsFile = TMEV.getConfigurationFile("annotation_URLs.txt");
                TMEV.loadAnnotationsURLs(_urlsFile);
            }
            if (TMEV.getSettingForOption(CUSTOM_ANNOTATION_URLS_FILE, null) != null) {
                try {
                    String _urlfilename = TMEV.getSettingForOption(CUSTOM_ANNOTATION_URLS_FILE, null);
                    TMEV.loadAnnotationsURLs(new File(_urlfilename));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (os.indexOf("Apple") != -1 || os.indexOf("Mac") != -1) {
                manager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            if (so.getDataFile() != null && so.getFileType() != null) {
                try {
                    FileLoadInfo fileInfo = new FileLoadInfo(so);
                    Manager.createNewMultipleArrayViewer(fileInfo);
                }
                catch (InvalidFileArgumentsException ifae) {
                    ShowThrowableDialog.show(new JFrame(), "", true, 64, ifae, "MeV was unable to understand the arguments supplied to it: \n" + so.toString());
                    Manager.createNewMultipleArrayViewer();
                }
            } else {
                Manager.createNewMultipleArrayViewer();
            }
        }
        catch (Exception e) {
            ShowThrowableDialog.show(new JFrame(), "Error downloading file", false, e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "An error was encountered during file download.  " + e.getMessage(), "Data Download Error", 2);
            Manager.createNewMultipleArrayViewer();
        }
    }

    public static String getVersion() {
        String temp = buildProps.getProperty("PACKAGE-MAJOR-VERSION", "unknown") + "." + buildProps.getProperty("PACKAGE-MINOR-VERSION", "unknown") + "." + buildProps.getProperty("PACKAGE-MICRO-VERSION", "unknown");
        if (temp.contains("unknown")) {
            return "unknown";
        }
        return temp;
    }

    public static void loadAnnotationsURLs(File urlsFile) throws FileNotFoundException, InvalidAnnMappingFileException {
        if (PublicURL.loadURLs(urlsFile) != 0) {
            throw new InvalidAnnMappingFileException();
        }
    }

    private static SessionOptions parseArgs(String[] args) {
        SessionOptions so = new SessionOptions();
        CmdLineParser parser = new CmdLineParser((Object)so);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -cp CLASSPATH org.tigr.microarray.mev.TMEV [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
        }
        return so;
    }

    public static IResourceManager getResourceManager() {
        return resourceManager;
    }

    private static void writeProperties() {
        try {
            if (mevUserDir.exists()) {
                if (mevUserDir.isDirectory() && mevUserDir.canRead() && mevPropertiesFile.exists() && mevPropertiesFile.canRead()) {
                    FileOutputStream propsout = new FileOutputStream(mevPropertiesFile);
                    props.store((OutputStream)propsout, "MeV Properties");
                    propsout.close();
                }
            } else {
                mevUserDir.mkdir();
                mevPropertiesFile.createNewFile();
                FileOutputStream propsout = new FileOutputStream(mevPropertiesFile);
                props.store((OutputStream)propsout, "MeV Properties");
                propsout.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Cannot store properties to file " + mevPropertiesFile.toString());
        }
    }

    private static void setupFiles() {
        if (mevUserDir.exists() && mevUserDir.isDirectory() && mevUserDir.canRead()) {
            String configfilelist = props.getProperty(PROPERTY_CONFIG_FILES);
            StringSplitter ss = new StringSplitter(',');
            Vector<String> filenames = new Vector<String>();
            ss.init(configfilelist);
            while (ss.hasMoreTokens()) {
                String temp = ss.nextToken();
                filenames.add(temp);
            }
            for (String filename : filenames) {
                try {
                    InputStream in = TMEV.class.getClassLoader().getResourceAsStream(filename);
                    if (in == null) continue;
                    DataInputStream dis = new DataInputStream(in);
                    FileOutputStream fos = new FileOutputStream(new File(mevUserDir, filename.substring(filename.lastIndexOf(47) + 1)));
                    while (dis.available() != 0) {
                        fos.write(dis.readByte());
                    }
                    in.close();
                    fos.close();
                }
                catch (IOException ioe) {
                    System.out.println("Couldn't copy file " + filename + " from classpath to " + mevUserDir);
                    ioe.printStackTrace();
                }
            }
        }
    }

    private static void loadBuildProperties() {
        try {
            InputStream in = TMEV.class.getClassLoader().getResourceAsStream("org/tigr/microarray/mev/build.properties");
            if (in != null) {
                buildProps.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadProperties() throws IOException {
        props = new ConfMap();
        try {
            InputStream in = TMEV.class.getClassLoader().getResourceAsStream("org/tigr/microarray/mev/default.properties");
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException ioe) {
            System.out.println("Could not load default properties from org/tigr/microarray/mev/default.properties");
        }
        if (mevUserDir.exists()) {
            if (mevUserDir.isDirectory() && mevUserDir.canRead()) {
                if (mevPropertiesFile.exists() && mevPropertiesFile.canRead()) {
                    FileInputStream in2 = new FileInputStream(mevPropertiesFile);
                    props.load((InputStream)in2);
                    ((InputStream)in2).close();
                } else {
                    mevPropertiesFile.createNewFile();
                }
            }
        } else {
            mevUserDir.mkdir();
            mevPropertiesFile.createNewFile();
        }
        TMEV.writeProperties();
    }

    public static boolean readPreferencesFile(File inputFile) {
        StringTokenizer ss;
        BufferedReader reader = null;
        boolean returnValue = true;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            returnValue = false;
        }
        try {
            String currentLine;
            indicesAdjusted = false;
            while ((currentLine = reader.readLine()) != null) {
                currentLine.trim();
                if (currentLine.startsWith("//") || currentLine.length() == 0) continue;
                ss = new StringTokenizer(currentLine, "\t");
                String key = ss.nextToken();
                if (ss.hasMoreTokens()) {
                    props.put((Object)key, (Object)ss.nextToken());
                    continue;
                }
                props.put((Object)key, (Object)new String(""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String elementInfo = TMEV.getSettingForOption("Element Info");
            ss = new StringTokenizer(elementInfo, ":");
            coordinatePairCount = Integer.parseInt(ss.nextToken());
            intensityCount = Integer.parseInt(ss.nextToken());
            String headerInfo = TMEV.getSettingForOption("Headers");
            ss = new StringTokenizer(headerInfo, ":");
            headerRowCount = Integer.parseInt(ss.nextToken());
            headerColumnCount = Integer.parseInt(ss.nextToken());
            String uniqueIDString = TMEV.getSettingForOption("Unique ID");
            uniqueIDIndex = Integer.parseInt(uniqueIDString);
            String nameString = TMEV.getSettingForOption("Spot Name");
            nameIndex = Integer.parseInt(nameString);
            String dbs = TMEV.getSettingForOption("Database Names");
            ss = new StringTokenizer(dbs, ":");
            databases = new String[ss.countTokens()];
            int i = 0;
            while (ss.hasMoreTokens()) {
                TMEV.databases[i] = ss.nextToken();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }

    public static String getSettingForOption(String option, String defaultValue) {
        try {
            if (!props.containsKey((Object)option)) {
                return defaultValue;
            }
            return (String)props.get((Object)option);
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public static String getSettingForOption(String option) {
        String setting = "";
        try {
            setting = (String)props.get((Object)option);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return setting;
    }

    public static void storeProperty(String key, String value) {
        props.setProperty(key, value);
        TMEV.writeProperties();
    }

    public static boolean connect(String username, String password) {
        try {
            System.err.println("jdbc.drivers " + System.getProperty("jdbc.drivers"));
            Enumeration<Driver> en = DriverManager.getDrivers();
            while (en.hasMoreElements()) {
                System.err.println("jdbc.driver " + en.nextElement());
            }
            String drivers = System.getProperty("jdbc.drivers");
            if (drivers != null) {
                StringTokenizer st = new StringTokenizer(drivers, ":");
                while (st.hasMoreTokens()) {
                    try {
                        Class.forName(st.nextToken());
                    }
                    catch (Exception ex) {}
                }
            }
            String server = new String(TMEV.getSettingForOption("Database Server Name"));
            Properties connectionProperties = new Properties();
            connectionProperties.put("user", username);
            connectionProperties.put("password", password);
            connectionProperties.put("APPLICATIONNAME", "TIGR MultiExperimentViewer");
            DriverManager.setLoginTimeout(2200);
            connection = DriverManager.getConnection(server, connectionProperties);
            return true;
        }
        catch (Exception e) {
            System.out.println("Exception (TMEV.connect()): " + e);
            return false;
        }
    }

    public static int getCoordinatePairCount() {
        return coordinatePairCount;
    }

    public static int getIntensityCount() {
        return intensityCount;
    }

    public static int getHeaderRowCount() {
        return headerRowCount;
    }

    public static int getHeaderColumnCount() {
        return headerColumnCount;
    }

    public static String[] getDatabases() {
        return databases;
    }

    public static int getUniqueIDIndex() {
        return uniqueIDIndex;
    }

    public static int getNameIndex() {
        return nameIndex;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static int getDataType() {
        return dataType;
    }

    public static void setDataType(int dataType) {
        TMEV.dataType = dataType;
    }

    public static void setIndicesAdjusted(boolean state) {
        indicesAdjusted = state;
    }

    public static boolean indicesAdjusted() {
        return indicesAdjusted;
    }

    public static void setUniqueIDIndex(int index) {
        uniqueIDIndex = index < 0 ? 0 : index;
    }

    public static void setNameIndex(int index) {
        nameIndex = index < 0 ? 0 : index;
    }

    public static void setPermitPrompt(boolean permitPrompt) {
        if (permitSavePrompt != permitPrompt) {
            permitSavePrompt = permitPrompt;
            TMEV.storeProperty(PROMPT_TO_SAVE_ANALYSIS, new Boolean(permitPrompt).toString());
        }
    }

    public static void configure() {
        ConfMap cfg = props;
        try {
            String guiFactoryClassName = cfg.getString("gui.factory.class");
            if (guiFactoryClassName == null || guiFactoryClassName.equals("null")) {
                guiFactoryClassName = "org.tigr.microarray.mev.cluster.gui.impl.GUIFactory";
                System.out.println("GUI Factory class name not found in properties. Using default value.");
            }
            Class<?> clazz = Class.forName(guiFactoryClassName);
            guiFactory = (IGUIFactory)clazz.newInstance();
            algorithmFactory = new TMEVAlgorithmFactory(cfg);
            permitSavePrompt = cfg.getBoolean(PROMPT_TO_SAVE_ANALYSIS, true);
            TMEV.setDataPath(cfg.getProperty(CURRENT_DATA_PATH));
            String sPath = cfg.getString("rserve-path");
            rPath = sPath != null && !sPath.equals("") ? sPath : "localhost:6311";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getRPath() {
        return rPath;
    }

    public static String getDataPath() {
        File f = new File(TMEV.getSettingForOption(CURRENT_DATA_PATH));
        if (!f.isDirectory()) {
            return f.getParent();
        }
        return TMEV.getSettingForOption(CURRENT_DATA_PATH);
    }

    public static void updateRPath(String rPath) {
        if (rPath == null) {
            return;
        }
        TMEV.storeProperty("rserve-path", rPath);
    }

    public static void updateDataPath(String newDataPath) {
        if (newDataPath == null) {
            return;
        }
        TMEV.setDataPath(newDataPath);
    }

    public static void setDataPath(String newPath) {
        if (!new File(newPath).isDirectory()) {
            TMEV.storeProperty(CURRENT_DATA_PATH, new File(newPath).getParent());
        }
        TMEV.storeProperty(CURRENT_DATA_PATH, new File(newPath).getAbsolutePath());
    }

    public static AlgorithmFactory getAlgorithmFactory() {
        return algorithmFactory;
    }

    public static IGUIFactory getGUIFactory() {
        return guiFactory;
    }

    public static void quit() {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public static File getConfigurationFile(String fileName) {
        return new File(mevUserDir, fileName);
    }

    public static File getFile(String fileName) {
        return new File(fileName);
    }

    public static String getOSName() {
        return os;
    }

    public static void pause() {
        System.out.println("Press any key to continue...........");
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            stdin.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        indicesAdjusted = false;
        permitSavePrompt = true;
        dataType = 1;
        os = "";
        activeSave = false;
        rPath = "127.0.0.1:6311";
        cloneDistributionsLogState = true;
        browserDefaultDyeSwapValue = 1;
        browserDefaultNoDyeSwapValue = 5;
        defaultCloneValue = 1;
        defaultFlankingRegionValue = 0;
        GAGGLE_CONNECT_ON_STARTUP = false;
        PROPERTY_CONFIG_FILES = "config-files";
        buildProps = new Properties();
    }
}

