/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;

public class SpotInformationData
implements Serializable {
    public static final long serialVersionUID = 100010201090001L;
    private String[] columnHeaders;
    private String[][] spotData;

    public SpotInformationData(String[] columnHeaders, String[][] spotData) {
        this.columnHeaders = columnHeaders;
        this.spotData = spotData;
    }

    public String[] getSpotInformationArray(int index) {
        if (index < 0 || index > this.spotData.length) {
            return null;
        }
        return this.spotData[index];
    }

    public String getSpotInformation(String key, int index) {
        int columnIndex = this.getColumnIndex(key);
        if (this.isLegalColumn(columnIndex)) {
            return this.spotData[index][columnIndex];
        }
        return null;
    }

    private int getColumnIndex(String key) {
        for (int i = 0; i < this.columnHeaders.length; ++i) {
            if (!this.columnHeaders[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    private boolean isLegalColumn(int col) {
        return col >= 0 && col < this.spotData[0].length;
    }

    public String[] getSpotInformationHeader() {
        return this.columnHeaders;
    }

    public int getSize() {
        return this.spotData.length;
    }
}

