/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import org.tigr.microarray.mev.ArrayElement;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.annotation.MevAnnotation;

public class SlideDataElement
extends ArrayElement
implements ISlideDataElement {
    protected String UID;
    protected int[] rows;
    protected int[] columns;
    protected float[] currentIntensity;
    protected float[] trueIntensity;
    protected String[] extraFields;
    protected boolean isNull = false;
    protected boolean isNonZero = true;
    protected float pvalue = 0.0f;
    protected int flags = 0;
    MevAnnotation annotation;

    private SlideDataElement(int[] rows, int[] cols, String[] extraFields, String uid) {
        this.rows = rows;
        this.columns = cols;
        this.extraFields = extraFields;
        this.UID = uid;
        this.currentIntensity = new float[2];
        this.trueIntensity = new float[2];
    }

    public SlideDataElement(int[] rows, int[] cols, String[] extraFields, String uid, boolean isNull, boolean isNonZero) {
        this(rows, cols, extraFields, uid);
        this.isNull = isNull;
        this.isNonZero = isNonZero;
    }

    public SlideDataElement(int[] rows, int[] columns, float[] currentIntensities, float[] trueIntensities, String[] values) {
        this.rows = this.copyArray(rows);
        this.columns = this.copyArray(columns);
        this.currentIntensity = this.copyArray(currentIntensities);
        this.trueIntensity = this.copyArray(trueIntensities);
        this.extraFields = this.copyArray(values);
    }

    public SlideDataElement() {
        this.currentIntensity = new float[2];
        this.trueIntensity = new float[2];
    }

    public SlideDataElement(String UID, int[] rows, int[] columns, float[] intensities, String[] values) {
        this.UID = UID;
        this.rows = this.copyArray(rows);
        this.columns = this.copyArray(columns);
        this.currentIntensity = this.copyArray(intensities);
        this.trueIntensity = this.copyArray(intensities);
        this.extraFields = this.copyArray(values);
    }

    public SlideDataElement(String UID, int[] rows, int[] columns, float[] intensities, String[] values, MevAnnotation mevAnno) {
        this(UID, rows, columns, intensities, values);
        this.setElementAnnotation(mevAnno);
    }

    public SlideDataElement(int[] rows, int[] columns, float[] intensities, String[] values) {
        this("", rows, columns, intensities, values);
    }

    public SlideDataElement(ISlideDataElement sde) {
        this.UID = sde.getUID();
        this.rows = sde.getRows();
        this.columns = sde.getColumns();
        this.currentIntensity = this.copyArray(sde.getCurrentIntensity());
        this.trueIntensity = this.copyArray(sde.getTrueIntensity());
        this.extraFields = sde.getExtraFields();
    }

    @Override
    public ISlideDataElement clone() {
        return new SlideDataElement(this);
    }

    public void setRows(int[] r) {
        this.rows = this.copyArray(r);
    }

    public void setColumns(int[] c) {
        this.columns = this.copyArray(c);
    }

    public String[] getValues() {
        return this.extraFields;
    }

    @Override
    public void setExtraFields(String[] values) {
        if (values == null) {
            return;
        }
        if (this.extraFields == null) {
            this.extraFields = values;
        } else {
            int i;
            String[] newFields = new String[this.extraFields.length + values.length];
            for (i = 0; i < this.extraFields.length; ++i) {
                newFields[i] = this.extraFields[i];
            }
            for (i = 0; i < values.length; ++i) {
                newFields[i + this.extraFields.length] = values[i];
            }
            this.extraFields = new String[newFields.length];
            this.extraFields = newFields;
        }
    }

    private String[] copyArray(String[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private int[] copyArray(int[] array) {
        if (array == null) {
            return null;
        }
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private float[] copyArray(float[] array) {
        if (array == null) {
            return null;
        }
        float[] result = new float[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @Override
    public int[] getRows() {
        return this.rows;
    }

    @Override
    public int[] getColumns() {
        return this.columns;
    }

    @Override
    public String[] getExtraFields() {
        if (this.extraFields == null) {
            return new String[0];
        }
        return this.extraFields;
    }

    @Override
    public float[] getCurrentIntensity() {
        return this.currentIntensity;
    }

    @Override
    public float[] getTrueIntensity() {
        return this.trueIntensity;
    }

    @Override
    public void setRow(int rowType, int value) {
        switch (rowType) {
            case 0: {
                this.rows[0] = value;
                break;
            }
            case 1: {
                this.rows[1] = value;
                break;
            }
            case 2: {
                this.rows[2] = value;
            }
        }
    }

    @Override
    public void setColumn(int columnType, int value) {
        switch (columnType) {
            case 0: {
                this.columns[0] = value;
                break;
            }
            case 1: {
                this.columns[1] = value;
                break;
            }
            case 2: {
                this.columns[2] = value;
            }
        }
    }

    @Override
    public int getRow(int rowType) {
        int targetRow = -1;
        switch (rowType) {
            case 0: {
                targetRow = this.rows[0];
                break;
            }
            case 1: {
                targetRow = this.rows[1];
                break;
            }
            case 2: {
                targetRow = this.rows[2];
            }
        }
        return targetRow;
    }

    @Override
    public int getColumn(int columnType) {
        int targetColumn = -1;
        switch (columnType) {
            case 0: {
                targetColumn = this.columns[0];
                break;
            }
            case 1: {
                targetColumn = this.columns[1];
                break;
            }
            case 2: {
                targetColumn = this.columns[2];
            }
        }
        return targetColumn;
    }

    @Override
    public int getLocation(int positionType, int features) {
        int location = -1;
        switch (positionType) {
            case 0: {
                location = this.columns[0] + (this.rows[0] - 1) * features;
                break;
            }
            case 1: {
                location = this.columns[1] + (this.rows[1] - 1) * features;
                break;
            }
            case 2: {
                location = this.columns[2] + (this.rows[2] - 1) * features;
            }
        }
        return location;
    }

    @Override
    public float getIntensity(int intensityType) {
        float targetIntensity = -1.0f;
        switch (intensityType) {
            case 0: {
                targetIntensity = this.currentIntensity[0];
                break;
            }
            case 1: {
                targetIntensity = this.currentIntensity[1];
            }
        }
        return targetIntensity;
    }

    @Override
    public void setIntensity(int intensityType, float value) {
        switch (intensityType) {
            case 0: {
                this.currentIntensity[0] = value;
                break;
            }
            case 1: {
                this.currentIntensity[1] = value;
            }
        }
    }

    public void setCurrentIntensity(int intensityType, float value) {
        switch (intensityType) {
            case 0: {
                this.currentIntensity[0] = value;
                break;
            }
            case 1: {
                this.currentIntensity[1] = value;
            }
        }
    }

    @Override
    public void setTrueIntensity(int intensityType, float value) {
        switch (intensityType) {
            case 0: {
                this.trueIntensity[0] = value;
                break;
            }
            case 1: {
                this.trueIntensity[1] = value;
            }
        }
    }

    @Override
    public float getTrueIntensity(int intensityType) {
        float targetIntensity = -1.0f;
        switch (intensityType) {
            case 0: {
                try {
                    targetIntensity = this.trueIntensity[0];
                }
                catch (NullPointerException npe) {
                    targetIntensity = 0.0f;
                }
                catch (ArrayIndexOutOfBoundsException aioob) {
                    targetIntensity = 0.0f;
                }
                break;
            }
            case 1: {
                try {
                    targetIntensity = this.trueIntensity[1];
                }
                catch (NullPointerException npe) {
                    targetIntensity = 0.0f;
                }
                catch (ArrayIndexOutOfBoundsException aioob) {
                    targetIntensity = 0.0f;
                }
                break;
            }
        }
        return targetIntensity;
    }

    @Override
    public float getRatio(int intensityIndex1, int intensityIndex2, int logState) {
        return this.getRatio(intensityIndex1, intensityIndex2, logState, this.isNonZero);
    }

    public float getRatio(int intensityIndex1, int intensityIndex2, int logState, boolean nonZero) {
        float ratio;
        if (nonZero) {
            if (this.getIntensity(intensityIndex1) == 0.0f && this.getIntensity(intensityIndex2) == 0.0f) {
                return Float.NaN;
            }
            ratio = this.getIntensity(intensityIndex1) == 0.0f ? 1.0f / this.getIntensity(intensityIndex2) : (this.getIntensity(intensityIndex2) == 0.0f ? this.getIntensity(intensityIndex1) / 1.0f : this.getIntensity(intensityIndex1) / this.getIntensity(intensityIndex2));
        } else {
            if (this.getIntensity(intensityIndex1) == 0.0f) {
                return Float.NaN;
            }
            if (this.getIntensity(intensityIndex2) == 0.0f) {
                return Float.NaN;
            }
            ratio = this.getIntensity(intensityIndex1) / this.getIntensity(intensityIndex2);
        }
        if (logState == 1) {
            ratio = (float)(Math.log(ratio) / Math.log(2.0));
        }
        return ratio;
    }

    public double getTrueRatio(int intensityIndex1, int intensityIndex2, int logState) {
        return this.getTrueRatio(intensityIndex1, intensityIndex2, logState, this.isNonZero);
    }

    public double getTrueRatio(int intensityIndex1, int intensityIndex2, int logState, boolean nonZero) {
        double ratio;
        if (nonZero) {
            if (this.getTrueIntensity(intensityIndex1) == 0.0f && this.getTrueIntensity(intensityIndex2) == 0.0f) {
                return Double.NaN;
            }
            ratio = this.getTrueIntensity(intensityIndex1) == 0.0f ? 1.0 / (double)this.getTrueIntensity(intensityIndex2) : (this.getTrueIntensity(intensityIndex2) == 0.0f ? (double)this.getTrueIntensity(intensityIndex1) / 1.0 : (double)this.getTrueIntensity(intensityIndex1) / (double)this.getTrueIntensity(intensityIndex2));
        } else {
            if (this.getTrueIntensity(intensityIndex1) == 0.0f) {
                return Double.NaN;
            }
            if (this.getTrueIntensity(intensityIndex2) == 0.0f) {
                return Double.NaN;
            }
            ratio = (double)this.getTrueIntensity(intensityIndex1) / (double)this.getTrueIntensity(intensityIndex2);
        }
        if (logState == 1) {
            ratio = (float)(Math.log(ratio) / Math.log(2.0));
        }
        return ratio;
    }

    public float getIntensityMean(int intensityType) {
        return 0.0f;
    }

    @Override
    public void setNonZero(boolean state) {
        this.isNonZero = state;
    }

    @Override
    public void setDetection(String value) {
    }

    @Override
    public String getDetection() {
        return "";
    }

    @Override
    public void setPvalue(float value) {
        this.pvalue = value;
    }

    @Override
    public float getPvalue() {
        return this.pvalue;
    }

    @Override
    public void setGenePixFlags(int value) {
        this.flags = value;
    }

    @Override
    public int getGenePixFlags() {
        return this.flags;
    }

    @Override
    public boolean isNonZero() {
        return this.isNonZero;
    }

    public void setIsNull(boolean state) {
        this.isNull = state;
    }

    @Override
    public boolean getIsNull() {
        return this.isNull;
    }

    @Override
    public boolean hasNoZeros() {
        return this.getTrueIntensity(0) != 0.0f && this.getTrueIntensity(1) != 0.0f;
    }

    public String getAttributeString(int number) {
        String retVal = "";
        int coordinatePairs = TMEV.getCoordinatePairCount() * 2;
        int intensities = TMEV.getIntensityCount();
        int extraFields = this.extraFields.length;
        retVal = number < coordinatePairs ? (number % 2 == 0 ? String.valueOf(this.rows[number / 2]) : String.valueOf(this.columns[(number + 1) / 2])) : (number < coordinatePairs + intensities ? String.valueOf(this.currentIntensity[number - coordinatePairs]) : (number < coordinatePairs + intensities + extraFields ? this.getFieldAt(number - (coordinatePairs + intensities)) : ""));
        return retVal;
    }

    @Override
    public String getFieldAt(int index) {
        if (this.extraFields[index] == null || this.extraFields[index].length() == 0 || this.extraFields[index].trim().length() == 0 || this.extraFields == null || index < 0 || index > this.extraFields.length - 1) {
            return "";
        }
        return this.extraFields[index];
    }

    @Override
    public ISlideDataElement copy() {
        return new SlideDataElement(this);
    }

    public String toString() {
        return "SDE " + this.getRow(0) + ", " + this.getColumn(0);
    }

    @Override
    public void setUID(String uid) {
        this.UID = uid;
    }

    @Override
    public String getUID() {
        return this.UID;
    }

    @Override
    public IAnnotation getElementAnnotation() {
        return this.annotation;
    }

    @Override
    public void setElementAnnotation(IAnnotation annotation) {
        this.annotation = (MevAnnotation)annotation;
    }
}

