/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.CGHSlideDataElement;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.AnnotationFieldConstants;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.midas.engine.IterativeLinReg;
import org.tigr.midas.engine.IterativeLogMean;
import org.tigr.midas.engine.RatioStats;
import org.tigr.midas.engine.TotInt;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.util.Xcon;
import org.tigr.util.math.LinearEquation;

public class SlideData
implements ISlideData,
ISlideMetaData {
    private Vector allSlideDataElements;
    private String slideDataName;
    private String slideFileName;
    private SpotInformationData spotInfoData;
    private int normalizedState = 0;
    private int sortState = 0;
    private int rows;
    private int columns;
    private boolean isNonZero = true;
    private boolean abbrName = false;
    private int dataType = 0;
    private String[] fieldNames = new String[0];
    private String sampleLabelKey = "Default Slide Name";
    private Hashtable sampleLabels;
    private Vector sampleLabelKeys;
    private SampleAnnotation sampAnnotation;
    private boolean isSampleAnnotationLoaded = false;
    private String[] loadedAnnotationFields;
    private Vector[] flankingRegions;

    public boolean isCGHData() {
        return this.allSlideDataElements.get(0) instanceof CGHSlideDataElement;
    }

    public SlideData(int rows, int columns, SampleAnnotation sampAnn) {
        this.allSlideDataElements = new Vector(rows * columns);
        this.rows = rows;
        this.columns = columns;
        this.sampAnnotation = sampAnn;
    }

    public SlideData(ISlideData original) {
        this.allSlideDataElements = new Vector();
        this.rows = original.getSlideMetaData().getRows();
        this.columns = original.getSlideMetaData().getColumns();
        this.sortState = original.getSortState();
        this.normalizedState = original.getNormalizedState();
        this.slideDataName = original.getSlideDataName();
        for (int i = 0; i < original.getSize(); ++i) {
            this.addElement(original.getSlideDataElement(i).copy());
        }
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = original.getSlideDataKeys();
        this.sampleLabels = original.getSlideDataLabels();
        this.fieldNames = this.fieldNames == null ? new String[0] : ((SlideData)original).getOldModelFieldNames();
        this.updateFilledAnnFields();
    }

    public SlideData(int rows, int columns) {
        this.allSlideDataElements = new Vector(rows * columns);
        this.rows = rows;
        this.columns = columns;
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
        if (this.fieldNames == null) {
            this.fieldNames = new String[0];
        }
        this.updateFilledAnnFields();
    }

    public SlideData(int size) {
        this.allSlideDataElements = new Vector(size);
        this.rows = -1;
        this.columns = -1;
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
        if (this.fieldNames == null) {
            this.fieldNames = new String[0];
        }
        this.updateFilledAnnFields();
    }

    public SlideData() {
        this.allSlideDataElements = new Vector();
        if (this.fieldNames == null) {
            this.fieldNames = new String[0];
        }
        this.updateFilledAnnFields();
    }

    public SlideData(String slideDataName, Vector sampleLabelKeys, String sampleLabelKey, Hashtable sampleLabels, String slideFileName, Boolean isNonZero, Integer rows, Integer columns, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, String[] fieldNames, Integer dataType) throws IOException {
        this();
        this.rows = rows;
        this.columns = columns;
        this.slideDataName = slideDataName;
        this.sampleLabelKeys = sampleLabelKeys;
        this.sampleLabelKey = sampleLabelKey;
        this.sampleLabels = sampleLabels;
        this.slideFileName = slideFileName;
        this.normalizedState = normalizedState;
        this.sortState = sortState;
        this.spotInfoData = spotInfoData;
        this.isNonZero = isNonZero;
        this.fieldNames = fieldNames;
        this.dataType = dataType;
        this.updateFilledAnnFields();
    }

    public String[] getOldModelFieldNames() {
        return this.fieldNames;
    }

    @Override
    public SampleAnnotation getSampleAnnotation() {
        return this.sampAnnotation;
    }

    @Override
    public void setSampleAnnotation(SampleAnnotation sampAnn) {
        this.sampAnnotation = sampAnn;
    }

    @Override
    public String getSampleLabelKey() {
        return this.sampleLabelKey;
    }

    public Vector getAllElements() {
        return this.allSlideDataElements;
    }

    public void setAllElements(Vector v) {
        this.allSlideDataElements = v;
    }

    public void add(SlideDataElement newElement) {
        this.allSlideDataElements.add(newElement);
    }

    public int size() {
        return this.allSlideDataElements.size();
    }

    public Object elementAt(int i) {
        return this.allSlideDataElements.elementAt(i);
    }

    public void addElement(Object o) {
        this.allSlideDataElements.addElement(o);
    }

    public void add(Object o) {
        this.allSlideDataElements.add(o);
    }

    public Object set(int index, Object element) {
        return this.allSlideDataElements.set(index, element);
    }

    public void setElementAt(Object element, int index) {
        this.allSlideDataElements.setElementAt(element, index);
    }

    public void insertElementAt(Object o, int i) {
        this.allSlideDataElements.insertElementAt(o, i);
    }

    @Override
    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    @Override
    public void appendFieldNames(String[] fieldNames) {
        if (this.fieldNames == null || fieldNames == null) {
            this.fieldNames = fieldNames;
        } else {
            String[] newNames = new String[this.fieldNames.length + fieldNames.length];
            System.arraycopy(this.fieldNames, 0, newNames, 0, this.fieldNames.length);
            System.arraycopy(fieldNames, 0, newNames, this.fieldNames.length, fieldNames.length);
            this.fieldNames = new String[newNames.length];
            this.fieldNames = newNames;
        }
    }

    @Override
    public void clearFieldNames() {
        this.fieldNames = null;
    }

    @Override
    public void setDataType(int type) {
        this.dataType = type;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void setSpotInformationData(String[] columnHeaders, String[][] spotInfoData) {
        this.spotInfoData = new SpotInformationData(columnHeaders, spotInfoData);
    }

    public void setSpotInformationData(SpotInformationData spotInfoData) {
        this.spotInfoData = spotInfoData;
    }

    public String[] getOldFieldNames() {
        return this.fieldNames;
    }

    @Override
    public String[] getFieldNames() {
        ArrayList allAnns = new ArrayList();
        Collections.addAll(allAnns, this.fieldNames);
        Collections.addAll(allAnns, this.loadedAnnotationFields);
        return allAnns.toArray(new String[0]);
    }

    @Override
    public void updateFilledAnnFields() {
        HashMap<String, String> filledFields = new HashMap<String, String>();
        Field[] temp = AnnotationFieldConstants.class.getFields();
        block0: for (int i = 0; i < temp.length; ++i) {
            String thisFieldName = temp[i].getName();
            for (int j = 0; j < this.allSlideDataElements.size(); ++j) {
                IAnnotation anno = ((ISlideDataElement)this.allSlideDataElements.get(j)).getElementAnnotation();
                if (anno == null || anno.getAttribute(thisFieldName).length > 0 && anno.getAttribute(thisFieldName)[0].equals("NA")) continue;
                filledFields.put(thisFieldName, "");
                continue block0;
            }
        }
        this.loadedAnnotationFields = filledFields.keySet().toArray(new String[filledFields.keySet().size()]);
    }

    @Override
    public SpotInformationData getSpotInformationData() {
        return this.spotInfoData;
    }

    @Override
    public ISlideDataElement getSlideDataElement(int index) {
        return (ISlideDataElement)this.elementAt(index);
    }

    @Override
    public boolean hasNoZeros(int index) {
        ISlideDataElement sde = (ISlideDataElement)this.elementAt(index);
        return sde.hasNoZeros();
    }

    @Override
    public ISlideDataElement toSlideDataElement(int index) {
        return ((ISlideDataElement)this.elementAt(index)).copy();
    }

    @Override
    public float getCY3(int index) {
        ISlideDataElement sde = (ISlideDataElement)this.elementAt(index);
        if (this.normalizedState == 0) {
            return sde.getTrueIntensity(0);
        }
        return sde.getIntensity(0);
    }

    @Override
    public float getCY5(int index) {
        ISlideDataElement sde = (ISlideDataElement)this.elementAt(index);
        if (this.normalizedState == 0) {
            return sde.getTrueIntensity(1);
        }
        return sde.getIntensity(1);
    }

    @Override
    public void setIntensities(int index, float cy3, float cy5) {
        ISlideDataElement sde = (ISlideDataElement)this.elementAt(index);
        sde.setTrueIntensity(0, cy3);
        sde.setTrueIntensity(1, cy5);
    }

    @Override
    public float getRatio(int index, int logState) {
        return this.getRatio(this.getCY5(index), this.getCY3(index), logState);
    }

    public final float getRatio(float numerator, float denominator, int logState) {
        float ratio;
        if (this.dataType == 1 || this.dataType == 6) {
            return numerator;
        }
        if (denominator < 0.0f || numerator < 0.0f) {
            return numerator;
        }
        if (this.isNonZero) {
            if (denominator == 0.0f && numerator == 0.0f) {
                return Float.NaN;
            }
            ratio = numerator == 0.0f ? 1.0f / denominator : (denominator == 0.0f ? numerator : numerator / denominator);
        } else {
            if (denominator <= 0.0f) {
                return Float.NaN;
            }
            if (numerator <= 0.0f) {
                return Float.NaN;
            }
            ratio = numerator / denominator;
        }
        if (logState == 1) {
            ratio = (float)(Math.log(ratio) / Math.log(2.0));
        }
        return ratio;
    }

    @Override
    public ISlideMetaData getSlideMetaData() {
        return this;
    }

    @Override
    public void addSlideDataElement(ISlideDataElement element) {
        this.addElement(element);
    }

    @Override
    public String getValueAt(int index, int valueType) {
        ISlideDataElement sde = (ISlideDataElement)this.elementAt(index);
        return sde.getFieldAt(valueType);
    }

    @Override
    public String[] getAnnotationValue(int index, String attr) {
        ISlideDataElement element = this.getSlideDataElement(index);
        IAnnotation annot = element.getElementAnnotation();
        if (annot != null && annot.getAttribute(attr) != null && annot.getAttribute(attr).length > 0 && !annot.getAttribute(attr)[0].equalsIgnoreCase("NA")) {
            return annot.getAttribute(attr);
        }
        int attribIndex = Arrays.asList(this.getOldFieldNames()).indexOf(attr);
        if (attribIndex != -1) {
            return new String[]{element.getFieldAt(attribIndex)};
        }
        return new String[]{"NA"};
    }

    @Override
    public AnnoAttributeObj getAnnotationObj(int index, String attr) {
        ISlideDataElement element = this.getSlideDataElement(index);
        IAnnotation annot = element.getElementAnnotation();
        if (annot != null && annot.getAttribute(attr) != null && annot.getAttribute(attr).length > 0 && !annot.getAttribute(attr)[0].equalsIgnoreCase("NA")) {
            return annot.getAttributeObj(attr);
        }
        String[] allFields = this.getFieldNames();
        String[] values = new String[]{"NA"};
        for (int i = 0; i < allFields.length; ++i) {
            if (!allFields[i].equals(attr)) continue;
            try {
                if (element != null && element.getFieldAt(i) != null && element.getFieldAt(i).trim().length() != 0 && element.getFieldAt(i).length() != 0) {
                    values = new String[]{element.getFieldAt(i)};
                    continue;
                }
                values = new String[]{"NA"};
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                values = new String[]{"NA"};
            }
        }
        return new AnnoAttributeObj(attr, values);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public void setNonZero(boolean state) {
        this.isNonZero = state;
    }

    @Override
    public int getRow(int spot) {
        return this.getSlideDataElement(spot).getRow(0);
    }

    @Override
    public int getColumn(int spot) {
        return this.getSlideDataElement(spot).getColumn(0);
    }

    public boolean isNonZero() {
        return this.isNonZero;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public void setSlideDataName(String slideDataName) {
        this.slideDataName = slideDataName;
        if (this.isSampleAnnotationLoaded) {
            if (!this.getSampleAnnotation().getSampleAnnoHash().containsKey("Default Slide Name")) {
                this.getSampleAnnotation().setAnnotation("Default Slide Name", this.slideDataName);
            }
        } else {
            String key;
            this.sampleLabelKey = key = "Default Slide Name";
            this.sampleLabelKeys.addElement(key);
            this.sampleLabels.put(key, slideDataName);
        }
    }

    @Override
    public void setSlideDataLabels(Vector keys, Hashtable namesHash) {
        this.sampleLabelKeys = keys;
        this.sampleLabels = namesHash;
    }

    @Override
    public void toggleNameLength() {
        this.abbrName = !this.abbrName;
    }

    @Override
    public String getSlideDataName() {
        String name = "";
        name = this.isSampleAnnotationLoaded ? this.getSampleAnnotation().getAnnotation(this.sampleLabelKey) : (String)this.sampleLabels.get(this.sampleLabelKey);
        if (name == null) {
            return " ";
        }
        if (!this.abbrName) {
            return name;
        }
        if (name.length() < 26) {
            return name;
        }
        return name.substring(0, 25) + "...";
    }

    @Override
    public String getFullSlideDataName() {
        String name = "";
        name = this.isSampleAnnotationLoaded ? this.getSampleAnnotation().getAnnotation(this.sampleLabelKey) : (String)this.sampleLabels.get(this.sampleLabelKey);
        if (name == null) {
            return " ";
        }
        return name;
    }

    @Override
    public void setSlideFileName(String slideFileName) {
        this.slideFileName = slideFileName;
    }

    @Override
    public String getSlideFileName() {
        if (!this.abbrName) {
            return this.slideFileName;
        }
        if (this.slideFileName.length() < 26) {
            return this.slideFileName;
        }
        return this.slideFileName.substring(0, 25) + "...";
    }

    @Override
    public void setNormalizedState(int normalizedState) {
        this.normalizedState = normalizedState;
    }

    @Override
    public int getNormalizedState() {
        return this.normalizedState;
    }

    public void setSortState(int sortState) {
        this.sortState = sortState;
    }

    @Override
    public int getSortState() {
        return this.sortState;
    }

    public String getNormalizationString() {
        return SlideData.normalizationString(this.normalizedState);
    }

    public static String normalizationString(int normalization) {
        String normalizationString;
        switch (normalization) {
            case 0: {
                normalizationString = "No Normalization";
                break;
            }
            case 1: {
                normalizationString = "Total Intensity";
                break;
            }
            case 2: {
                normalizationString = "Least Squares";
                break;
            }
            case 3: {
                normalizationString = "Linear Regression";
                break;
            }
            case 4: {
                normalizationString = "Ratio Statistics";
                break;
            }
            case 5: {
                normalizationString = "Ratio Statistics";
                break;
            }
            case 6: {
                normalizationString = "Iterative Log";
                break;
            }
            case 7: {
                normalizationString = "Lowess";
                break;
            }
            case 101: {
                normalizationString = "Total Intensity (list)";
                break;
            }
            case 102: {
                normalizationString = "Least Squares (list)";
                break;
            }
            case 103: {
                normalizationString = "Linear Regression (list)";
                break;
            }
            case 104: {
                normalizationString = "Ratio Statistics - 95% CI (list)";
                break;
            }
            case 105: {
                normalizationString = "Ratio Statistics - 99% CI (list)";
                break;
            }
            case 106: {
                normalizationString = "Iterative Log (list)";
                break;
            }
            case 107: {
                normalizationString = "Lowess (list)";
                break;
            }
            default: {
                normalizationString = "No Normalization";
            }
        }
        return normalizationString;
    }

    @Override
    public float getMaxCY3() {
        return this.getMaxIntensity(0);
    }

    @Override
    public float getMaxCY5() {
        return this.getMaxIntensity(1);
    }

    @Override
    public float getMaxIntensity(int intensityType) {
        float maxIntensity = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            float intensity = this.normalizedState == 0 ? this.getSlideDataElement(i).getTrueIntensity(intensityType) : this.getSlideDataElement(i).getIntensity(intensityType);
            maxIntensity = Math.max(maxIntensity, intensity);
        }
        return maxIntensity;
    }

    public float getMinIntensity(int intensityType) {
        return this.getMinIntensity(intensityType, true);
    }

    @Override
    public float getMinIntensity(int intensityType, boolean acceptZeros) {
        float minIntensity = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float intensity = this.normalizedState == 0 ? this.getSlideDataElement(i).getTrueIntensity(intensityType) : this.getSlideDataElement(i).getIntensity(intensityType);
            if (!acceptZeros) {
                if (!(intensity < minIntensity) || intensity == 0.0f) continue;
                minIntensity = intensity;
                continue;
            }
            if (!(intensity < minIntensity)) continue;
            minIntensity = intensity;
        }
        return minIntensity;
    }

    @Override
    public float getMaxRatio() {
        return this.getMaxRatio(0);
    }

    @Override
    public float getMinRatio() {
        return this.getMinRatio(0);
    }

    @Override
    public float getMaxRatio(int logState) {
        return this.getMaxRatio(1, 0, logState);
    }

    @Override
    public float getMinRatio(int logState) {
        return this.getMinRatio(1, 0, logState);
    }

    @Override
    public float getMaxRatio(int intensityIndex1, int intensityIndex2, int logState) {
        float maxRatio = Float.MIN_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float ratio = this.getSlideDataElement(i).getRatio(intensityIndex1, intensityIndex2, logState);
            if (!(ratio > maxRatio)) continue;
            maxRatio = ratio;
        }
        return maxRatio;
    }

    @Override
    public float getMinRatio(int intensityIndex1, int intensityIndex2, int logState) {
        float minRatio = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float ratio = this.getSlideDataElement(i).getRatio(intensityIndex1, intensityIndex2, logState);
            if (!(ratio < minRatio)) continue;
            minRatio = ratio;
        }
        return minRatio;
    }

    @Override
    public float getMaxProduct(int intensityIndex1, int intensityIndex2) {
        float product = 0.0f;
        float maxProduct = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement sde = this.getSlideDataElement(i);
            product = sde.getIntensity(intensityIndex1) * sde.getIntensity(intensityIndex2);
            if (!(product > maxProduct)) continue;
            maxProduct = product;
        }
        return maxProduct;
    }

    @Override
    public float getMinProduct(int intensityIndex1, int intensityIndex2, boolean acceptZeros) {
        return this.getMinProduct(intensityIndex1, intensityIndex2, acceptZeros, 0);
    }

    @Override
    public float getMinProduct(int intensityIndex1, int intensityIndex2, boolean acceptZeros, int lowCutoff) {
        float product = 0.0f;
        float minProduct = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement sde = this.getSlideDataElement(i);
            product = sde.getIntensity(intensityIndex1) * sde.getIntensity(intensityIndex2);
            if (!(product >= (float)lowCutoff)) continue;
            if (!acceptZeros) {
                if (!(product < minProduct) || product == 0.0f) continue;
                minProduct = product;
                continue;
            }
            if (!(product < minProduct)) continue;
            minProduct = product;
        }
        return minProduct;
    }

    public long getSumIntensity(int intensityType) {
        long totalIntensity = 0L;
        for (int i = 0; i < this.size(); ++i) {
            totalIntensity = (long)((float)totalIntensity + this.getSlideDataElement(i).getIntensity(intensityType));
        }
        return totalIntensity;
    }

    public long getSumNonZeroIntensity(int intensityType) {
        long totalIntensity = 0L;
        for (int i = 0; i < this.size(); ++i) {
            try {
                ISlideDataElement sde = this.getSlideDataElement(i);
                if (!sde.hasNoZeros()) continue;
                totalIntensity = (long)((float)totalIntensity + sde.getIntensity(intensityType));
                continue;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return totalIntensity;
    }

    public LinearEquation getRegressionEquation(boolean useTrueValues) {
        double x = 0.0;
        double y = 0.0;
        double sum = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        double sumXY = 0.0;
        double weight = 1.0;
        double delta = 0.0;
        double a = 0.0;
        double b = 0.0;
        double variance = 1.0;
        double regressionCoefficient = 0.0;
        double sigmaA = 0.0;
        double sigmaB = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement sde = this.getSlideDataElement(i);
            if (sde == null) continue;
            if (useTrueValues) {
                x = sde.getTrueIntensity(0);
                y = sde.getTrueIntensity(1);
            } else {
                x = sde.getIntensity(0);
                y = sde.getIntensity(1);
            }
            if (x == 0.0 || y == 0.0) continue;
            sum += weight;
            sumX += weight * x;
            sumY += weight * y;
            sumX2 += weight * x * x;
            sumY2 += weight * y * y;
            sumXY += weight * x * y;
        }
        delta = sum * sumX2 - sumX * sumX;
        a = (sumX2 * sumY - sumX * sumXY) / delta;
        b = (sumXY * sum - sumX * sumY) / delta;
        sigmaA = Math.sqrt(variance * sumX2 / delta);
        sigmaB = Math.sqrt(variance * sum / delta);
        regressionCoefficient = (sum * sumXY - sumX * sumY) / Math.sqrt(delta * (sum * sumY2) - sumY * sumY);
        LinearEquation linearEquation = new LinearEquation(b, a, regressionCoefficient);
        return linearEquation;
    }

    @Override
    public void applyNormalization(int normalizationMode, Properties props) {
        switch (normalizationMode) {
            case 0: {
                this.applyNoNormalization();
                break;
            }
            case 1: {
                this.applyTotalIntensity();
                break;
            }
            case 2: {
                this.applyLeastSquares();
                break;
            }
            case 3: {
                this.applyLinearRegression(props);
                break;
            }
            case 4: {
                this.applyRatioStatistics(props);
                break;
            }
            case 5: {
                this.applyRatioStatistics(props);
                break;
            }
            case 6: {
                this.applyIterativeLog(props);
                break;
            }
            case 7: {
                this.applyLowess(10);
            }
        }
    }

    @Override
    public void applyNormalizationList(int normalizationMode) {
        switch (normalizationMode) {
            case 101: {
                this.applyTotalIntensity();
                break;
            }
            case 102: {
                this.applyLeastSquares();
                break;
            }
            case 103: {
                this.applyLinearRegression(new Properties());
                break;
            }
            case 104: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 105: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 106: {
                this.applyIterativeLog(new Properties());
                break;
            }
            case 107: {
                this.applyLowess(10);
            }
        }
    }

    public void applyNoNormalization() {
        if (this.normalizedState != 0) {
            for (int i = 0; i < this.size(); ++i) {
                ISlideDataElement sde = this.getSlideDataElement(i);
                sde.setIntensity(0, sde.getTrueIntensity(0));
                sde.setIntensity(1, sde.getTrueIntensity(1));
            }
            this.normalizedState = 0;
        }
    }

    public void applyTotalIntensity() {
        ISlideDataElement sde = this.getSlideDataElement(10);
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        cw = new TotInt(cw, "Cy3", false).getFileTotIntColumnWorker();
        this.setNormalizedIntensities(cw, goodValues);
        this.normalizedState = 1;
    }

    public void applyLinearRegression(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            String mode = (String)properties.get("mode");
            float sd = Float.parseFloat((String)properties.get("standard-deviation"));
            cw = new IterativeLinReg(cw, sd, mode, "Cy3").getIterLinRegColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 3;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    public void applyRatioStatistics(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            int confInt = Integer.parseInt((String)properties.get("confidence-interval"));
            cw = new RatioStats(cw, true, confInt, "Cy3").getRatioStatsColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 3;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            e.printStackTrace();
        }
    }

    public void applyIterativeLog(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            float sd = Float.parseFloat((String)properties.get("standard-deviation"));
            cw = new IterativeLogMean(cw, sd, "Cy3").getIterLogMeanColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 6;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    private ColumnWorker constructColumnWorker(boolean[] goodValues) {
        int n;
        int size = n = this.getSize();
        float[] cy3 = new float[n];
        float[] cy5 = new float[n];
        String[] metaCombo = new String[n];
        n = 0;
        for (int i = 0; i < size; ++i) {
            int metaRow = this.getSlideDataElement(i).getRow(1);
            int metaColumn = this.getSlideDataElement(i).getColumn(1);
            float CY3 = this.getSlideDataElement(i).getTrueIntensity(0);
            float CY5 = this.getSlideDataElement(i).getTrueIntensity(1);
            if (this.dataType == 1) {
                CY3 = 100000.0f;
                if ((CY5 = (float)(100000.0 * Math.pow(2.0, CY5))) == Float.POSITIVE_INFINITY || CY5 == Float.NEGATIVE_INFINITY) {
                    CY5 = 0.0f;
                    CY3 = 0.0f;
                }
            }
            if (CY3 == 0.0f || CY5 == 0.0f) continue;
            goodValues[i] = true;
            cy3[n] = CY3;
            cy5[n] = CY5;
            metaCombo[n] = Integer.toString(metaRow) + "_" + Integer.toString(metaColumn);
            ++n;
        }
        float[] goodCy3 = new float[n];
        float[] goodCy5 = new float[n];
        System.arraycopy(cy3, 0, goodCy3, 0, n);
        System.arraycopy(cy5, 0, goodCy5, 0, n);
        System.arraycopy(metaCombo, 0, metaCombo, 0, n);
        return new ColumnWorker(goodCy3, goodCy5, metaCombo);
    }

    private void setNormalizedIntensities(ColumnWorker cw, boolean[] goodIntensity) {
        float[] cy3 = cw.getColumnOneArray();
        float[] cy5 = cw.getColumnTwoArray();
        int goodIndex = 0;
        for (int i = 0; i < goodIntensity.length; ++i) {
            ISlideDataElement sde = this.getSlideDataElement(i);
            if (goodIntensity[i]) {
                if (this.dataType == 1) {
                    sde.setIntensity(0, 1.0f);
                    sde.setIntensity(1, (float)(Math.log(cy5[goodIndex] / cy3[goodIndex]) / Math.log(2.0)));
                } else {
                    sde.setIntensity(0, cy3[goodIndex]);
                    sde.setIntensity(1, cy5[goodIndex]);
                }
                ++goodIndex;
                continue;
            }
            sde.setIntensity(0, sde.getTrueIntensity(0));
            sde.setIntensity(1, sde.getTrueIntensity(1));
        }
    }

    public void applyLowess(int bins) {
        int i;
        int i2;
        Vector binVector = new Vector();
        ISlideDataElement[] sdes = new ISlideDataElement[this.size()];
        float[] logRatios = new float[this.size()];
        float[] logProduct = new float[this.size()];
        int[] descendingRank = new int[this.size()];
        int binSize = this.size() / bins + 1;
        for (i2 = 0; i2 < bins; ++i2) {
            binVector.addElement(new Vector());
        }
        for (i2 = 0; i2 < this.size(); ++i2) {
            sdes[i2] = this.getSlideDataElement(i2);
            logRatios[i2] = (float)Xcon.log2((double)sdes[i2].getRatio(1, 0, 0));
            logProduct[i2] = (float)Xcon.log10((double)(sdes[i2].getIntensity(0) * sdes[i2].getIntensity(1)));
        }
        double largest = 0.0;
        int highestRank = 0;
        for (i = 0; i < this.size(); ++i) {
            block3: for (int j = 0; j < this.size(); ++j) {
                if (!(largest < (double)logProduct[j])) continue;
                for (int k = 0; k < i; ++k) {
                    if (j == descendingRank[k]) continue block3;
                }
                largest = logProduct[j];
                highestRank = j;
            }
            descendingRank[i] = highestRank;
        }
        for (i = 0; i < this.size(); ++i) {
            System.out.println("Rank: " + i + ", Element: " + descendingRank[i]);
        }
        int binC = 0;
        int binP = 0;
        int i3 = 0;
        while (i3 < this.size()) {
            ((Vector)binVector.elementAt(binP)).addElement(sdes[descendingRank[i3]]);
            if (binC == binSize) {
                binC = 0;
                ++binP;
            }
            ++i3;
            ++binC;
        }
        System.out.println(binVector.size() + " bins created");
        for (i3 = 0; i3 < binVector.size(); ++i3) {
            System.out.println("Bin " + i3 + " has " + ((Vector)binVector.elementAt(i3)).size() + " elements");
        }
        for (int m = 0; m < binVector.size(); ++m) {
            int i4;
            Vector targetBin = (Vector)binVector.elementAt(m);
            long greensum = 0L;
            long redsum = 0L;
            long usegreensum = 0L;
            long useredsum = 0L;
            for (int i5 = 0; i5 < targetBin.size(); ++i5) {
                ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i5);
                greensum = (long)((float)greensum + sde.getIntensity(1));
                redsum = (long)((float)redsum + sde.getIntensity(0));
                if (!sde.hasNoZeros()) continue;
                usegreensum = (long)((float)usegreensum + sde.getIntensity(1));
                useredsum = (long)((float)useredsum + sde.getIntensity(0));
            }
            double norat = (double)redsum / (double)greensum;
            double usenorat = (double)useredsum / (double)usegreensum;
            double yzsum = 0.0;
            double yz = 0.0;
            double yzave = 0.0;
            int yzmun = 0;
            double[] ratio2 = new double[this.size()];
            System.out.println(m + " - All: " + redsum + "\t" + greensum + "\t" + norat);
            System.out.println(m + " - Use: " + useredsum + "\t" + usegreensum + "\t" + usenorat);
            for (i4 = 0; i4 < targetBin.size(); ++i4) {
                ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i4);
                sde.setIntensity(1, (long)((double)sde.getIntensity(1) * usenorat));
                yz = Xcon.log2((double)((double)sde.getRatio(0, 1, 0) / usenorat));
                if (sde.hasNoZeros()) {
                    yzsum += yz;
                    ++yzmun;
                }
                double lnx = Math.log(1.0);
                double lny = Math.log(1.0);
            }
            yzave = yzsum / (double)yzmun;
            System.out.println(m + " - Mean log ratio: " + yzave);
            yzsum = 0.0;
            yzmun = 0;
            double uselograt = Math.pow(Math.E, yzave);
            System.out.println(m + " - Scale: " + uselograt);
            for (i4 = 0; i4 < targetBin.size(); ++i4) {
                ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i4);
                sde.setIntensity(1, (long)((double)sde.getIntensity(1) * uselograt));
                yz = Xcon.log2((double)((double)sde.getRatio(0, 1, 0) / uselograt));
            }
            for (i4 = 0; i4 < targetBin.size(); ++i4) {
                ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i4);
                ratio2[i4] = sde.hasNoZeros() ? (double)sde.getRatio(0, 1, 0) / usenorat / uselograt : (double)sde.getRatio(0, 1, 0);
            }
            double xsum = 0.0;
            int xnum = 0;
            double x = 0.0;
            double xave = 0.0;
            double newlognor = 0.0;
            for (int it = 0; it <= 10; ++it) {
                int i6;
                for (i6 = 0; i6 < targetBin.size(); ++i6) {
                    ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i6);
                    if (!sde.hasNoZeros() || !((x = Xcon.log2((double)ratio2[i6])) <= 1.0) || !(x >= -1.0)) continue;
                    xsum += x;
                    ++xnum;
                }
                xave = xsum / (double)xnum;
                newlognor = Math.pow(Math.E, xave);
                System.out.println(m + " - Iteration " + it + "\tMean Log Ratio: " + xave + "\t" + newlognor);
                for (i6 = 0; i6 < targetBin.size(); ++i6) {
                    ISlideDataElement sde = (ISlideDataElement)targetBin.elementAt(i6);
                    if (sde.hasNoZeros()) {
                        ratio2[i6] = ratio2[i6] / newlognor;
                    }
                    sde.setIntensity(1, (long)((double)sde.getIntensity(1) * newlognor));
                }
            }
        }
        this.normalizedState = 7;
    }

    public void applyLeastSquares() {
        LinearEquation linearEquation = this.getRegressionEquation(true);
        if (this.normalizedState != 2) {
            for (int i = 0; i < this.size(); ++i) {
                ISlideDataElement sde = this.getSlideDataElement(i);
                if (sde == null) continue;
                sde.setIntensity(1, this.applyLeastSquares(sde.getTrueIntensity(1), linearEquation));
            }
            this.normalizedState = 2;
        }
    }

    public float applyLeastSquares(float value, LinearEquation linearEquation) {
        if (value > 0.0f) {
            return (float)(((double)value - linearEquation.getYIntercept()) * (1.0 / linearEquation.getSlope()));
        }
        return 0.0f;
    }

    public void output() {
        String contents = "";
        try {
            contents = "\n\n\n***SlideData***\n\n";
            for (int i = 0; i < this.size(); ++i) {
                contents = contents + this.getSlideDataElement(i).toString() + "\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(contents);
    }

    public Vector getSlideDataKeys() {
        if (this.isSampleAnnotationLoaded) {
            return new Vector(this.getSampleAnnotation().getAnnotationKeys());
        }
        return this.sampleLabelKeys;
    }

    @Override
    public Hashtable getSlideDataLabels() {
        if (this.isSampleAnnotationLoaded) {
            return this.getSampleAnnotation().getSampleAnnoHash();
        }
        return this.sampleLabels;
    }

    @Override
    public void setDataLabelKey(String key) {
        this.sampleLabelKey = key;
    }

    @Override
    public void addNewSampleLabel(String label, String value) {
        System.out.println("SlideData:addNewSampleLabel");
        if (!this.isSampleAnnotationLoaded) {
            if (!this.sampleLabelKeys.contains(label)) {
                this.sampleLabelKeys.addElement(label);
            }
            this.sampleLabels.put(label, value);
        } else {
            SampleAnnotation ann = new SampleAnnotation();
            this.isSampleAnnotationLoaded = true;
            ann.setAnnotation("Default Slide Name", this.getSampleAnnotation().getAnnotation("Default Slide Name"));
            ann.setAnnotation(label, value);
            this.setSampleAnnotation(ann);
        }
    }

    @Override
    public String getDetection(int row) {
        return this.getSlideDataElement(row).getDetection();
    }

    public Object clone() {
        return this.clone();
    }

    @Override
    public float getPvalue(int row) {
        return this.getSlideDataElement(row).getPvalue();
    }

    @Override
    public int getGenePixFlags(int row) {
        return this.getSlideDataElement(row).getGenePixFlags();
    }

    @Override
    public void setFlankingRegions(Vector[] flankingRegions) {
        if (flankingRegions == null) {
            System.out.println("NULL flankingRegions in SlideData.setFlankingRegion()");
        }
        this.flankingRegions = flankingRegions;
    }

    @Override
    public int getNumFlankingRegions(int chromosomeIndex) {
        if (this.flankingRegions == null) {
            System.out.println("NULL flankingRegions in SlideData");
        }
        return this.flankingRegions[chromosomeIndex].size();
    }

    @Override
    public Vector[] getFlankingRegions() {
        return this.flankingRegions;
    }

    @Override
    public boolean isMissingData(int cloneIndex) {
        return Float.isNaN(this.getCY3(cloneIndex)) || Float.isNaN(this.getCY5(cloneIndex));
    }

    @Override
    public boolean isSampleAnnotationLoaded() {
        return this.isSampleAnnotationLoaded;
    }

    @Override
    public void setSampleAnnotationLoaded(boolean isAnnLoaded) {
        this.isSampleAnnotationLoaded = isAnnLoaded;
    }
}

