/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class ShowThrowableDialog
extends JDialog {
    private JComponent message;
    private JComponent stack;
    private JPanel mainPanel;

    private ShowThrowableDialog(Frame frame, String title, boolean modal, int type, Throwable t, String friendlyMessage) {
        super(frame, title, modal);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.message = friendlyMessage == null || friendlyMessage.equals("") ? this.createMessageContent(type, t) : new JEditorPane("text/html", friendlyMessage);
        this.stack = this.createStackContent(t);
        this.mainPanel = this.createMainPanel();
        this.mainPanel.add((Component)this.message, "Center");
        JPanel btnsPanel = this.createBtnsPanel(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.pack();
    }

    public static void show(Frame frame, String title, Throwable t) {
        ShowThrowableDialog.show(frame, title, true, t);
    }

    public static void show(Frame frame, String title, boolean modal, Throwable t) {
        ShowThrowableDialog.show(frame, title, modal, 0, t);
    }

    public static void show(Frame frame, String title, boolean modal, int type, Throwable t, String friendlyMessage) {
        ShowThrowableDialog dlg = new ShowThrowableDialog(frame, title, modal, type, t, friendlyMessage);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setLocation((screenSize.width - dlg.getSize().width) / 2, (screenSize.height - dlg.getSize().height) / 2);
        dlg.setVisible(true);
    }

    public static void show(Frame frame, String title, boolean modal, int type, Throwable t) {
        ShowThrowableDialog.show(frame, title, modal, type, t, null);
    }

    private Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private JComponent createMessageContent(int type, Throwable t) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel(this.getIconForType(type)), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 20;
        panel.add((Component)new JLabel(t.getMessage()), gbc);
        return panel;
    }

    private String getTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        t.printStackTrace(ps);
        return stream.toString();
    }

    private JComponent createStackContent(Throwable t) {
        JTextArea area = new JTextArea(this.getTrace(t));
        area.setEditable(false);
        JScrollPane scroll = new JScrollPane(area);
        scroll.setPreferredSize(new Dimension(250, 150));
        return scroll;
    }

    private void setContent(JComponent content) {
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)content, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new BevelBorder(0));
        panel.setPreferredSize(new Dimension(400, 100));
        return panel;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        GridLayout gridLayout = new GridLayout();
        JPanel panel = new JPanel(gridLayout);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        panel.add(okButton);
        JToggleButton stackButton = new JToggleButton("Stack");
        stackButton.setActionCommand("stack-command");
        stackButton.addActionListener(listener);
        gridLayout.setHgap(4);
        panel.add(stackButton);
        this.getRootPane().setDefaultButton(okButton);
        return panel;
    }

    private void onStackTrace(boolean flag) {
        if (flag) {
            this.setContent(this.stack);
        } else {
            this.setContent(this.message);
        }
    }

    public static void main(String[] args) {
        IOException ioe = new IOException();
        SupportFileAccessError sfae = new SupportFileAccessError("testing, testing", ioe);
        ShowThrowableDialog.show(new JFrame(), "Test ShowThrowableDialog", new Exception("First line is really really really really really really really really really really really really really really really really really really really really really really really really really long."));
        ShowThrowableDialog.show(new JFrame(), "Test ShowThrowableDialog", sfae);
        ShowThrowableDialog.show(new JFrame(), "Test ShowThrowableDialog", true, 1, sfae, "friendlymessage");
        System.exit(0);
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                ShowThrowableDialog.this.dispose();
            } else if (command.equals("stack-command")) {
                AbstractButton button = (AbstractButton)e.getSource();
                ShowThrowableDialog.this.onStackTrace(button.isSelected());
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ShowThrowableDialog.this.dispose();
        }
    }
}

