/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetUpperLimitsDialog
extends JDialog {
    private int result;
    private JTextField cy3TextField;
    private JTextField cy5TextField;

    public SetUpperLimitsDialog(JFrame parent, float xValue, float yValue) {
        super(parent, "Set Upper Thresholds", true);
        EventListener listener = new EventListener();
        JLabel cy3Label = new JLabel("Max Cy3 (" + xValue + "): ");
        cy3Label.addKeyListener(listener);
        this.cy3TextField = new JTextField(10);
        this.cy3TextField.addKeyListener(listener);
        this.cy3TextField.setText("" + xValue);
        JLabel cy5Label = new JLabel("Max Cy5 (" + yValue + "): ");
        cy5Label.addKeyListener(listener);
        this.cy5TextField = new JTextField(10);
        this.cy5TextField.addKeyListener(listener);
        this.cy5TextField.setText("" + yValue);
        JButton okButton = new JButton("Ok");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        GBA gba = new GBA();
        gba.add(this.getContentPane(), (Component)cy3Label, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.getContentPane(), (Component)this.cy3TextField, 1, 0, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.getContentPane(), (Component)cy5Label, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.getContentPane(), (Component)this.cy5TextField, 1, 1, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.getContentPane(), (Component)cancelButton, 0, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.getContentPane(), (Component)okButton, 1, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.cy3TextField.grabFocus();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getUpperCY3() {
        return Float.parseFloat(this.cy3TextField.getText());
    }

    public float getUpperCY5() {
        return Float.parseFloat(this.cy5TextField.getText());
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(SetUpperLimitsDialog.this.cy3TextField.getText());
                    Float.parseFloat(SetUpperLimitsDialog.this.cy5TextField.getText());
                    SetUpperLimitsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetUpperLimitsDialog.this.result = 2;
                }
                SetUpperLimitsDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SetUpperLimitsDialog.this.result = 2;
                SetUpperLimitsDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetUpperLimitsDialog.this.result = -1;
            SetUpperLimitsDialog.this.dispose();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetUpperLimitsDialog.this.cy3TextField.getText());
                    Float.parseFloat(SetUpperLimitsDialog.this.cy5TextField.getText());
                    SetUpperLimitsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetUpperLimitsDialog.this.result = 2;
                }
                SetUpperLimitsDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

