/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class SetSingleLowerCutoffsDialog
extends AlgorithmDialog {
    private int result;
    private float originalCy3;
    private float originalCy5;
    private JTextField cy3TextField;
    private JTextField cy5TextField;
    private JCheckBox enableCheckBox;
    private JLabel cy3Label;
    private JLabel cy5Label;

    public SetSingleLowerCutoffsDialog(JFrame parent, float cy5) {
        super(parent, "Set Lower Cutoffs", true);
        this.originalCy5 = cy5;
        Listener listener = new Listener();
        GBA gba = new GBA();
        this.enableCheckBox = new JCheckBox("Enable Lower Cutoff Filter", true);
        this.enableCheckBox.setActionCommand("enable-check-box-command");
        this.enableCheckBox.setOpaque(false);
        this.enableCheckBox.setFocusPainted(false);
        this.enableCheckBox.addActionListener(listener);
        this.cy5Label = new JLabel("Intensity Lower Cutoff (" + cy5 + "): ");
        this.cy5TextField = new JTextField(10);
        this.cy5TextField.addKeyListener(listener);
        this.cy5TextField.setText("" + cy5);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        gba.add((Container)panel, (Component)this.enableCheckBox, 0, 0, 2, 1, 0, 0, 1, 10, new Insets(20, 0, 0, 0), 0, 0);
        gba.add((Container)panel, (Component)this.cy5Label, 0, 1, 1, 1, 0, 0, 2, 13, new Insets(5, 5, 25, 5), 0, 0);
        gba.add((Container)panel, (Component)this.cy5TextField, 1, 1, 2, 1, 0, 0, 0, 17, new Insets(5, 5, 25, 5), 0, 0);
        this.addContent(panel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.cy5TextField.grabFocus();
        this.cy5TextField.setCaretPosition(0);
        this.cy5TextField.selectAll();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isLowerCutoffEnabled() {
        return this.enableCheckBox.isSelected();
    }

    public float getLowerCY5Cutoff() {
        return Float.parseFloat(this.cy5TextField.getText());
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                SetSingleLowerCutoffsDialog.this.result = 2;
                SetSingleLowerCutoffsDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                SetSingleLowerCutoffsDialog.this.cy5TextField.setText(String.valueOf(SetSingleLowerCutoffsDialog.this.originalCy5));
                SetSingleLowerCutoffsDialog.this.cy5TextField.grabFocus();
                SetSingleLowerCutoffsDialog.this.cy5TextField.setCaretPosition(0);
                SetSingleLowerCutoffsDialog.this.cy5TextField.selectAll();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)SetSingleLowerCutoffsDialog.this), (String)"Set Lower Cutoffs");
            } else if (command.equals("enable-check-box-command")) {
                boolean enable = SetSingleLowerCutoffsDialog.this.enableCheckBox.isSelected();
                SetSingleLowerCutoffsDialog.this.cy5Label.setEnabled(enable);
                SetSingleLowerCutoffsDialog.this.cy5TextField.setEnabled(enable);
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetSingleLowerCutoffsDialog.this.result = -1;
            SetSingleLowerCutoffsDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        private void onOk() {
            try {
                Float.parseFloat(SetSingleLowerCutoffsDialog.this.cy5TextField.getText());
                SetSingleLowerCutoffsDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetSingleLowerCutoffsDialog.this.result = 2;
            }
            SetSingleLowerCutoffsDialog.this.dispose();
        }
    }
}

