/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class SetRatioScaleDialog
extends AlgorithmDialog {
    private int result;
    private boolean doubleGradient;
    private boolean origDoubleGradient;
    private BufferedImage origPosImage;
    private BufferedImage origNegImage;
    private JTextField upperTextField;
    private JTextField lowerTextField;
    private JTextField midTextField;
    private JLabel midLabel;
    private JRadioButton singleGradientButton;
    private JRadioButton doubleGradientButton;
    private float currMinValue;
    private float currMaxValue;
    private float currMidValue;
    private float origUpper;
    private float origLower;
    private float origMid;
    private String formattedUpper;
    private String formattedLower;
    private String formattedMid;
    private StatsPanel statsPanel;
    private GradientPreviewPanel gradientPreviewPanel;
    private IFramework framework;
    private MultipleArrayMenubar menubar;
    private DecimalFormat twoDecimalFormat;
    private DecimalFormat oneDecimalFormat;

    public SetRatioScaleDialog(JFrame parent, IFramework framework, MultipleArrayMenubar menubar, float upper, float lower, float mid, boolean doubleGradient) {
        super(parent, "Color Scale Limits", true);
        EventListener listener = new EventListener();
        Experiment experiment = framework.getData().getExperiment();
        FloatMatrix matrix = experiment.getMatrix();
        float[] extreems = experiment.getMinAndMax();
        float minValue = extreems[0];
        float maxValue = extreems[1];
        this.menubar = menubar;
        this.doubleGradient = doubleGradient;
        this.origDoubleGradient = doubleGradient;
        this.framework = framework;
        this.origLower = lower;
        this.origUpper = upper;
        this.origMid = mid;
        this.origNegImage = framework.getDisplayMenu().getNegativeGradientImage();
        this.origPosImage = framework.getDisplayMenu().getPositiveGradientImage();
        this.twoDecimalFormat = new DecimalFormat();
        this.twoDecimalFormat.setMaximumFractionDigits(2);
        this.twoDecimalFormat.setMinimumFractionDigits(2);
        this.oneDecimalFormat = new DecimalFormat();
        this.oneDecimalFormat.setMaximumFractionDigits(1);
        this.formattedUpper = this.twoDecimalFormat.format(this.origUpper);
        this.formattedLower = this.twoDecimalFormat.format(this.origLower);
        this.formattedMid = this.twoDecimalFormat.format(this.origMid);
        this.statsPanel = new StatsPanel(framework);
        float medianValue = this.statsPanel.getMedian();
        ButtonGroup bg = new ButtonGroup();
        this.doubleGradientButton = new JRadioButton("Double Gradient", doubleGradient);
        this.doubleGradientButton.setActionCommand("change-gradient-command");
        this.doubleGradientButton.addActionListener(listener);
        this.doubleGradientButton.setFocusPainted(false);
        this.doubleGradientButton.setOpaque(false);
        bg.add(this.doubleGradientButton);
        this.singleGradientButton = new JRadioButton("Single Gradient", !doubleGradient);
        this.singleGradientButton.setActionCommand("change-gradient-command");
        this.singleGradientButton.addActionListener(listener);
        this.singleGradientButton.setFocusPainted(false);
        this.singleGradientButton.setOpaque(false);
        bg.add(this.singleGradientButton);
        if (framework.getDisplayMenu().getColorScheme() == 8) {
            this.doubleGradientButton.setEnabled(false);
        }
        ParameterPanel gradientPanel = new ParameterPanel("Gradient Style");
        gradientPanel.setLayout((LayoutManager)new GridBagLayout());
        gradientPanel.add((Component)this.doubleGradientButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 20), 0, 0));
        gradientPanel.add((Component)this.singleGradientButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 10, 0), 0, 0));
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(2);
        JLabel upperLabel = new JLabel("Upper Limit ( max. data value = " + format.format(maxValue) + " ): ");
        upperLabel.addKeyListener(listener);
        this.upperTextField = new JTextField(5);
        this.upperTextField.addKeyListener(listener);
        this.upperTextField.setText("" + upper);
        this.midLabel = new JLabel("Midpoint Value ( median data value = " + format.format(medianValue) + " ): ");
        this.midLabel.addKeyListener(listener);
        this.midTextField = new JTextField(5);
        this.midTextField.addKeyListener(listener);
        this.midTextField.setText("" + mid);
        JLabel lowerLabel = new JLabel("Lower Limit ( min. data value = " + format.format(minValue) + " ): ");
        lowerLabel.addKeyListener(listener);
        this.lowerTextField = new JTextField(5);
        this.lowerTextField.addKeyListener(listener);
        this.lowerTextField.setText("" + lower);
        JButton updateLimitsButton = new JButton("Update Limits");
        updateLimitsButton.setPreferredSize(new Dimension(130, 30));
        updateLimitsButton.setFocusPainted(false);
        updateLimitsButton.setActionCommand("update-command");
        updateLimitsButton.addActionListener(listener);
        ParameterPanel rangePanel = new ParameterPanel("Color Range Selection");
        rangePanel.setLayout((LayoutManager)new GridBagLayout());
        rangePanel.add((Component)lowerLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 10), 0, 0));
        rangePanel.add((Component)this.lowerTextField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        rangePanel.add((Component)this.midLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        rangePanel.add((Component)this.midTextField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        rangePanel.add((Component)upperLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 25, 10), 0, 0));
        rangePanel.add((Component)this.upperTextField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 25, 0), 0, 0));
        rangePanel.add((Component)updateLimitsButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        ParameterPanel preview = new ParameterPanel("Gradient and Limits Preview");
        preview.setLayout((LayoutManager)new GridBagLayout());
        this.gradientPreviewPanel = new GradientPreviewPanel(framework);
        preview.add((Component)this.gradientPreviewPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        mainPanel.add((Component)gradientPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)rangePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)((Object)this.statsPanel), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)preview, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(mainPanel);
        this.addWindowListener(listener);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
        this.lowerTextField.grabFocus();
        this.lowerTextField.selectAll();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getUpperLimit() {
        return Float.parseFloat(this.upperTextField.getText());
    }

    public float getLowerLimit() {
        return Float.parseFloat(this.lowerTextField.getText());
    }

    public float getMidValue() {
        return Float.parseFloat(this.midTextField.getText());
    }

    public boolean getUseDoubleGradient() {
        return this.doubleGradientButton.isSelected();
    }

    public boolean isGradientStyleAltered() {
        return this.origDoubleGradient == this.doubleGradient;
    }

    public BufferedImage getPosImage() {
        return this.gradientPreviewPanel.getPosImage();
    }

    private void updateLimits() {
        if (this.validateValues()) {
            this.currMinValue = Float.parseFloat(this.lowerTextField.getText());
            this.currMaxValue = Float.parseFloat(this.upperTextField.getText());
            this.currMidValue = Float.parseFloat(this.midTextField.getText());
            this.formattedLower = this.twoDecimalFormat.format(this.currMinValue);
            this.formattedUpper = this.twoDecimalFormat.format(this.currMaxValue);
            this.formattedMid = this.twoDecimalFormat.format(this.currMidValue);
            this.statsPanel.updateStats(this.currMinValue, this.currMaxValue);
            this.menubar.setUseDoubleGradient(this.getUseDoubleGradient());
            this.menubar.setMaxRatioScale(this.currMaxValue);
            this.menubar.setMinRatioScale(this.currMinValue);
            this.menubar.setMidRatioValue(this.currMidValue);
            this.framework.refreshCurrentViewer();
            this.repaint();
        }
    }

    private BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private boolean validateValues() {
        int progress = 0;
        boolean valid = false;
        try {
            float newLower = Float.parseFloat(this.lowerTextField.getText());
            ++progress;
            float newUpper = Float.parseFloat(this.upperTextField.getText());
            ++progress;
            float newMid = Float.parseFloat(this.midTextField.getText());
            if (this.doubleGradient) {
                if (newLower < newMid && newMid < newUpper) {
                    valid = true;
                }
            } else if (newLower < newUpper) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            valid = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Input Error, Values cannot be parsed as floating point numbers.", "Input Error", 0);
        }
        if (!valid) {
            if (this.doubleGradient) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Input Error (Double Gradient), Value Limits:  floating point number, lower < mid < upper", "Input Error", 0);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Input Error (Single Gradient), Value Limits:  floating point number, lower limit < upper limit", "Input Error", 0);
            }
        }
        return valid;
    }

    private void resetControls() {
        this.upperTextField.setText(String.valueOf(this.origUpper));
        this.lowerTextField.setText(String.valueOf(this.origLower));
        this.midTextField.setText(String.valueOf(this.origMid));
        if (this.origDoubleGradient) {
            this.doubleGradientButton.setSelected(true);
        } else {
            this.singleGradientButton.setSelected(true);
        }
        this.doubleGradient = this.origDoubleGradient;
        this.midLabel.setEnabled(this.origDoubleGradient);
        this.midTextField.setEnabled(this.origDoubleGradient);
        this.updateLimits();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                if (SetRatioScaleDialog.this.validateValues()) {
                    SetRatioScaleDialog.this.result = 0;
                    SetRatioScaleDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                SetRatioScaleDialog.this.result = 2;
                SetRatioScaleDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                SetRatioScaleDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)SetRatioScaleDialog.this), (String)"Color Scale Dialog");
            } else if (command.equals("update-command")) {
                SetRatioScaleDialog.this.updateLimits();
            } else if (command.equals("change-gradient-command")) {
                SetRatioScaleDialog.this.doubleGradient = SetRatioScaleDialog.this.doubleGradientButton.isSelected();
                if (SetRatioScaleDialog.this.doubleGradient) {
                    BufferedImage posImage = SetRatioScaleDialog.this.createGradientImage(new Color(SetRatioScaleDialog.this.gradientPreviewPanel.getNegImage().getRGB(255, 0)), new Color(SetRatioScaleDialog.this.gradientPreviewPanel.getPosImage().getRGB(255, 0)));
                    SetRatioScaleDialog.this.gradientPreviewPanel.setPosImage(posImage);
                }
                SetRatioScaleDialog.this.midLabel.setEnabled(SetRatioScaleDialog.this.doubleGradient);
                SetRatioScaleDialog.this.midTextField.setEnabled(SetRatioScaleDialog.this.doubleGradient);
                SetRatioScaleDialog.this.repaint();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetRatioScaleDialog.this.result = -1;
            SetRatioScaleDialog.this.dispose();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetRatioScaleDialog.this.lowerTextField.getText());
                    Float.parseFloat(SetRatioScaleDialog.this.upperTextField.getText());
                    SetRatioScaleDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetRatioScaleDialog.this.result = 2;
                }
                SetRatioScaleDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    public class StatsPanel
    extends ParameterPanel {
        private JTextField offScaleField;
        private JTextField lowEndField;
        private JTextField highEndField;
        private JTextField offScalePercentField;
        private JTextField lowEndPercentField;
        private JTextField highEndPercentField;
        private float[] sortedValues;
        private DecimalFormat format;

        public StatsPanel(IFramework framework) {
            super("Color Saturation Statistics");
            this.setLayout(new GridBagLayout());
            this.format = new DecimalFormat();
            this.format.setMaximumIntegerDigits(3);
            this.format.setMaximumFractionDigits(1);
            this.format.setMinimumFractionDigits(1);
            JLabel numberLabel = new JLabel("Number");
            numberLabel.setOpaque(false);
            JLabel percentLabel = new JLabel("Percent");
            percentLabel.setOpaque(false);
            JLabel offScaleLabel = new JLabel("Elements Off Color Scale");
            JLabel lowEndLabel = new JLabel("Elements Below Lower Limit");
            JLabel highEndLabel = new JLabel("Elements Above Upper Limit");
            this.offScaleField = new JTextField(5);
            this.offScaleField.setBackground(Color.lightGray);
            this.offScaleField.setEditable(false);
            this.offScaleField.setHorizontalAlignment(4);
            this.lowEndField = new JTextField(5);
            this.lowEndField.setBackground(Color.lightGray);
            this.lowEndField.setEditable(false);
            this.lowEndField.setHorizontalAlignment(4);
            this.highEndField = new JTextField(5);
            this.highEndField.setBackground(Color.lightGray);
            this.highEndField.setEditable(false);
            this.highEndField.setHorizontalAlignment(4);
            this.offScalePercentField = new JTextField(5);
            this.offScalePercentField.setBackground(Color.lightGray);
            this.offScalePercentField.setEditable(false);
            this.offScalePercentField.setHorizontalAlignment(4);
            this.lowEndPercentField = new JTextField(5);
            this.lowEndPercentField.setBackground(Color.lightGray);
            this.lowEndPercentField.setEditable(false);
            this.lowEndPercentField.setHorizontalAlignment(4);
            this.highEndPercentField = new JTextField(5);
            this.highEndPercentField.setBackground(Color.lightGray);
            this.highEndPercentField.setEditable(false);
            this.highEndPercentField.setHorizontalAlignment(4);
            this.sortedValues = this.initSortedValues(framework.getData().getExperiment().getMatrix());
            this.updateStats(SetRatioScaleDialog.this.origLower, SetRatioScaleDialog.this.origUpper);
            JPanel dummyPanel = new JPanel();
            dummyPanel.setOpaque(false);
            this.add(numberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.add(numberLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 10), 0, 0));
            this.add(percentLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
            this.add(offScaleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 20), 0, 0));
            this.add(this.offScaleField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
            this.add(this.offScalePercentField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            JSeparator sep = new JSeparator(0);
            sep.setPreferredSize(new Dimension(200, 1));
            sep.setOpaque(true);
            this.add(sep, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add(lowEndLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 20), 0, 0));
            this.add(this.lowEndField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
            this.add(this.lowEndPercentField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add(highEndLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 20), 0, 0));
            this.add(this.highEndField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
            this.add(this.highEndPercentField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        private float[] initSortedValues(FloatMatrix m) {
            float[] vals = m.getColumnPackedCopy();
            QSort qsort = new QSort(vals, 1);
            vals = qsort.getSorted();
            int numberNaN = 0;
            for (int i = 0; i < vals.length && Float.isNaN(vals[i]); ++i) {
                ++numberNaN;
            }
            int validN = vals.length - numberNaN;
            float[] values = new float[validN];
            for (int i = 0; i < values.length; ++i) {
                values[i] = vals[i + numberNaN];
            }
            return values;
        }

        public float getMedian() {
            float median = this.sortedValues.length % 2 == 0 ? (this.sortedValues[this.sortedValues.length / 2] + this.sortedValues[this.sortedValues.length / 2 + 1]) / 2.0f : this.sortedValues[this.sortedValues.length / 2 + 1];
            return median;
        }

        public void updateStats(float lower, float upper) {
            int lowCount = this.getLowCount(lower);
            int highCount = this.getHighCount(upper);
            float lowPerc = (float)lowCount / (float)this.sortedValues.length * 100.0f;
            float highPerc = (float)highCount / (float)this.sortedValues.length * 100.0f;
            float offPerc = (float)(lowCount + highCount) / (float)this.sortedValues.length * 100.0f;
            this.offScaleField.setText(String.valueOf(lowCount + highCount));
            this.offScalePercentField.setText(this.format.format(offPerc));
            this.lowEndField.setText(String.valueOf(lowCount));
            this.lowEndPercentField.setText(this.format.format(lowPerc));
            this.highEndField.setText(String.valueOf(highCount));
            this.highEndPercentField.setText(this.format.format(highPerc));
        }

        private int getLowCount(float lower) {
            int index;
            for (index = 0; index < this.sortedValues.length && this.sortedValues[index] < lower; ++index) {
            }
            return index;
        }

        private int getHighCount(float upper) {
            int index = this.sortedValues.length - 1;
            int highCount = 0;
            while (index > -1 && this.sortedValues[index] > upper) {
                --index;
                ++highCount;
            }
            return highCount;
        }
    }

    private class GradientPreviewPanel
    extends JPanel {
        private BufferedImage negImage;
        private BufferedImage posImage;
        private String centerPointStr;
        private int TIC_HEIGHT = 35;
        private int GRAD_HEIGHT = 30;
        private int TEXT_BUFFER = 20;
        private Insets insets = new Insets(5, 5, 5, 5);

        public GradientPreviewPanel(IFramework framework) {
            this.negImage = framework.getDisplayMenu().getNegativeGradientImage();
            this.posImage = framework.getDisplayMenu().getPositiveGradientImage();
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            super.setPreferredSize(new Dimension(this.negImage.getWidth() + this.posImage.getWidth() + this.insets.left + this.insets.right, this.GRAD_HEIGHT + this.insets.top + this.insets.bottom + this.TEXT_BUFFER));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            FontMetrics fm = g.getFontMetrics();
            int totalWidth = this.negImage.getWidth() + this.posImage.getWidth();
            if (SetRatioScaleDialog.this.doubleGradient) {
                g.drawImage(this.negImage, this.insets.left, this.insets.top, this.negImage.getWidth(), this.GRAD_HEIGHT, null);
                g.drawImage(this.posImage, this.insets.left + this.negImage.getWidth() + 1, this.insets.top, this.posImage.getWidth(), this.GRAD_HEIGHT, null);
                g.drawLine(this.insets.left + this.negImage.getWidth(), this.insets.top, this.insets.left + this.negImage.getWidth(), this.insets.top + this.TIC_HEIGHT);
                g.drawLine(this.insets.left + this.negImage.getWidth() - 1, this.insets.top, this.insets.left + this.negImage.getWidth() - 1, this.insets.top + this.TIC_HEIGHT);
                g.drawLine(this.insets.left + this.negImage.getWidth() + 1, this.insets.top, this.insets.left + this.negImage.getWidth() + 1, this.insets.top + this.TIC_HEIGHT);
                g.drawString(SetRatioScaleDialog.this.formattedMid, this.insets.left + this.negImage.getWidth() - (int)((float)fm.stringWidth(SetRatioScaleDialog.this.formattedMid) / 2.0f), this.insets.top + this.TIC_HEIGHT + fm.getHeight());
            } else {
                g.drawImage(this.posImage, this.insets.left, this.insets.top, totalWidth, this.GRAD_HEIGHT, null);
            }
            g.drawLine(this.insets.left, this.insets.top, this.insets.left, this.insets.top + this.TIC_HEIGHT);
            g.drawLine(this.insets.left + 1, this.insets.top, this.insets.left + 1, this.insets.top + this.TIC_HEIGHT);
            g.drawLine(this.insets.left + 2, this.insets.top, this.insets.left + 2, this.insets.top + this.TIC_HEIGHT);
            g.drawLine(this.insets.left + totalWidth, this.insets.top, this.insets.left + totalWidth, this.insets.top + this.TIC_HEIGHT);
            g.drawLine(this.insets.left + totalWidth - 1, this.insets.top, this.insets.left + totalWidth - 1, this.insets.top + this.TIC_HEIGHT);
            g.drawLine(this.insets.left + totalWidth - 2, this.insets.top, this.insets.left + totalWidth - 2, this.insets.top + this.TIC_HEIGHT);
            g.drawString(SetRatioScaleDialog.this.formattedLower, this.insets.left, this.insets.top + this.TIC_HEIGHT + fm.getHeight());
            g.drawString(SetRatioScaleDialog.this.formattedUpper, this.insets.left + totalWidth - fm.stringWidth(SetRatioScaleDialog.this.formattedUpper), this.insets.top + this.TIC_HEIGHT + fm.getHeight());
        }

        public void setPosImage(BufferedImage posBI) {
            this.posImage = posBI;
            this.repaint();
        }

        public BufferedImage getPosImage() {
            return this.posImage;
        }

        public BufferedImage getNegImage() {
            return this.negImage;
        }
    }
}

