/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class SetFoldFilterDialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton filter;
    private JButton cancel;
    private JLabel msg1Label;
    private JLabel msg2Label;
    private JLabel msg3Label;
    private JLabel msg4Label;
    private int result;
    private FoldFilter ff;
    private String BOTH = "both";
    private String GREATER_THAN = ">";
    private String LESS_THAN = "<";
    protected boolean use_filter;

    public SetFoldFilterDialog(JFrame parent, String[] sample_names) {
        super(parent, "Set Fold Filter", true);
        int count;
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(BorderFactory.createLineBorder(Color.black));
        pane.setLayout(new BorderLayout(2, 2));
        Listener listener = new Listener();
        String msg1 = "Genes in Group A must be ";
        String msg2 = "than in Group B by ";
        String msg3 = " fold.";
        String msg4 = "'both' will keep ALL genes whose fold change is greater than the threshold";
        String[] selection_options = new String[]{this.GREATER_THAN, this.LESS_THAN, this.BOTH};
        this.msg1Label = new JLabel(msg1);
        this.msg2Label = new JLabel(msg2);
        this.msg3Label = new JLabel(msg3);
        this.msg4Label = new JLabel(msg4);
        JTextField fold_change = new JTextField("2.0", 3);
        fold_change.addKeyListener(new VoteKeyListener());
        fold_change.addFocusListener(new VoteFocusListener(0, 1));
        JList<String> divider_list = new JList<String>(selection_options);
        divider_list.setBorder(BorderFactory.createLineBorder(Color.black));
        divider_list.setBackground(Color.lightGray);
        divider_list.setVisibleRowCount(3);
        divider_list.addListSelectionListener(new SelectionListener());
        this.gPanel = new GroupExperimentsPanel(sample_names);
        this.ff = new FoldFilter(sample_names);
        for (count = 0; count < this.gPanel.groupARadioButtons.length; ++count) {
            this.gPanel.groupARadioButtons[count].addActionListener(new GroupListener(0, count));
        }
        for (count = 0; count < this.gPanel.groupBRadioButtons.length; ++count) {
            this.gPanel.groupBRadioButtons[count].addActionListener(new GroupListener(1, count));
        }
        pane.add((Component)this.gPanel, "Center");
        JPanel bottom_panel = new JPanel();
        bottom_panel.setLayout(new GridLayout(2, 1));
        JPanel sub1 = new JPanel();
        sub1.setBackground(Color.white);
        JPanel sub2 = new JPanel();
        sub2.setBackground(Color.white);
        sub1.setLayout(new FlowLayout(0));
        sub2.setLayout(new FlowLayout(0));
        sub1.add(this.msg1Label);
        sub1.add(divider_list);
        sub1.add(this.msg2Label);
        sub1.add(fold_change);
        sub1.add(this.msg3Label);
        sub2.add(this.msg4Label);
        bottom_panel.add(sub1);
        bottom_panel.add(sub2);
        pane.add((Component)bottom_panel, "South");
        this.addContent(pane);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    public static void main(String[] args) {
        String[] names = new String[40];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "name" + Integer.toString(i);
        }
        SetFoldFilterDialog d = new SetFoldFilterDialog(new JFrame(), names);
        d.showModal();
    }

    public SetFoldFilterDialog(JFrame parent, String[] sample_names, FoldFilter ff) {
        this(parent, sample_names);
        this.ff = ff;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public FoldFilter getFoldFilter() {
        return this.ff;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(String[] exptNames) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel panel1 = new JPanel();
            JLabel[] expLabels = new JLabel[exptNames.length];
            this.groupARadioButtons = new JRadioButton[exptNames.length];
            this.groupBRadioButtons = new JRadioButton[exptNames.length];
            this.neitherGroupRadioButtons = new JRadioButton[exptNames.length];
            ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.length];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            panel1.setLayout(gridbag);
            for (int i = 0; i < exptNames.length; ++i) {
                String s1 = exptNames[i];
                expLabels[i] = new JLabel(s1);
                chooseGroup[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                chooseGroup[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                chooseGroup[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither", false);
                chooseGroup[i].add(this.neitherGroupRadioButtons[i]);
                this.buildConstraints(constraints, 0, i, 1, 1, 25, 100);
                gridbag.setConstraints(expLabels[i], constraints);
                panel1.add(expLabels[i]);
                this.buildConstraints(constraints, 1, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupARadioButtons[i], constraints);
                panel1.add(this.groupARadioButtons[i]);
                this.buildConstraints(constraints, 2, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
                panel1.add(this.groupBRadioButtons[i]);
                this.buildConstraints(constraints, 3, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.neitherGroupRadioButtons[i], constraints);
                panel1.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane scroll = new JScrollPane(panel1);
            scroll.setPreferredSize(new Dimension(400, 450));
            this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
        }

        void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int group, int file_index) {
            this.group = group;
            this.file_index = file_index;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SetFoldFilterDialog.this.ff.get_group_membership(this.file_index) != this.group) {
                SetFoldFilterDialog.this.ff.set_group_membership(this.group, this.file_index);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                JList optionList = (JList)event.getSource();
                String selection = (String)optionList.getSelectedValue();
                if (selection.equals(SetFoldFilterDialog.this.GREATER_THAN)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.GREATER_THAN);
                }
                if (selection.equals(SetFoldFilterDialog.this.LESS_THAN)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.LESS_THAN);
                }
                if (selection.equals(SetFoldFilterDialog.this.BOTH)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.BOTH);
                }
            }
        }
    }

    class VoteFocusListener
    extends FocusAdapter {
        private int required;
        private int group_index;

        VoteFocusListener(int group, int req) {
            this.required = req;
            this.group_index = group;
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField textField = (JTextField)e.getSource();
            String content = textField.getText();
            SetFoldFilterDialog.this.ff.set_fold_change(Float.parseFloat(content));
        }
    }

    class VoteKeyListener
    extends KeyAdapter {
        VoteKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '.' && c != '\u007f') {
                SetFoldFilterDialog.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener,
    ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                SetFoldFilterDialog.this.result = 2;
                SetFoldFilterDialog.this.dispose();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetFoldFilterDialog.this.result = -1;
            SetFoldFilterDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void itemStateChanged(ItemEvent is_checked) {
            SetFoldFilterDialog.this.use_filter = is_checked.getStateChange() == 1;
        }

        private void onOk() {
            try {
                SetFoldFilterDialog.this.getFoldFilter();
                SetFoldFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetFoldFilterDialog.this.result = 2;
            }
            SetFoldFilterDialog.this.dispose();
        }
    }
}

