/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class SetDetectionFilterDialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton filter;
    private JButton cancel;
    private JLabel msg1Label;
    private JLabel msg2Label;
    private JLabel msg3Label;
    private JLabel tail1Label;
    private JLabel tail2Label;
    private int result;
    private DetectionFilter df;
    protected boolean use_filter;

    public SetDetectionFilterDialog(JFrame parent, String[] sample_names) {
        super(parent, "Set Detection Filter", true);
        int count;
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(BorderFactory.createLineBorder(Color.black));
        pane.setLayout(new BorderLayout(2, 2));
        Listener listener = new Listener();
        String msg1 = "Group A: Gene must be called (P)resent in:";
        String msg2 = "Group B: Gene must be called (P)resent in:";
        String msg3 = "Select one of the following: ";
        String tail1 = "out of the total in Group A";
        String tail2 = "out of the total in Group B";
        String[] selection_options = new String[]{"OR", "AND"};
        this.msg1Label = new JLabel(msg1);
        this.msg2Label = new JLabel(msg2);
        this.msg3Label = new JLabel(msg3);
        this.tail1Label = new JLabel(tail1);
        this.tail2Label = new JLabel(tail2);
        JTextField vote1 = new JTextField("1", 2);
        JTextField vote2 = new JTextField("1", 2);
        vote1.addKeyListener(new VoteKeyListener());
        vote2.addKeyListener(new VoteKeyListener());
        vote1.addFocusListener(new VoteFocusListener(0, 1));
        vote2.addFocusListener(new VoteFocusListener(1, 1));
        JList<String> use_both = new JList<String>(selection_options);
        use_both.setBorder(BorderFactory.createLineBorder(Color.black));
        use_both.setBackground(Color.lightGray);
        use_both.setVisibleRowCount(2);
        use_both.addListSelectionListener(new SelectionListener());
        this.gPanel = new GroupExperimentsPanel(sample_names);
        this.gPanel.setBackground(Color.white);
        this.df = new DetectionFilter(sample_names);
        for (count = 0; count < this.gPanel.groupARadioButtons.length; ++count) {
            this.gPanel.groupARadioButtons[count].addActionListener(new GroupListener(0, count));
        }
        for (count = 0; count < this.gPanel.groupBRadioButtons.length; ++count) {
            this.gPanel.groupBRadioButtons[count].addActionListener(new GroupListener(1, count));
        }
        pane.add((Component)this.gPanel, "Center");
        JPanel bottom_panel = new JPanel();
        bottom_panel.setLayout(new GridLayout(3, 1));
        JPanel sub1 = new JPanel();
        sub1.setBackground(Color.white);
        JPanel sub2 = new JPanel();
        sub2.setBackground(Color.white);
        JPanel sub3 = new JPanel();
        sub3.setBackground(Color.white);
        sub1.setLayout(new FlowLayout(0));
        sub2.setLayout(new FlowLayout(0));
        sub3.setLayout(new FlowLayout(0));
        sub1.add(this.msg1Label);
        sub1.add(vote1);
        sub1.add(this.tail1Label);
        sub2.add(this.msg3Label);
        sub2.add(use_both);
        sub3.add(this.msg2Label);
        sub3.add(vote2);
        sub3.add(this.tail2Label);
        bottom_panel.add(sub1);
        bottom_panel.add(sub2);
        bottom_panel.add(sub3);
        pane.add((Component)bottom_panel, "South");
        this.addContent(pane);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
    }

    public static void main(String[] args) {
        String[] names = new String[40];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "name" + Integer.toString(i);
        }
        SetDetectionFilterDialog d = new SetDetectionFilterDialog(new JFrame(), names);
        d.showModal();
    }

    public SetDetectionFilterDialog(JFrame parent, String[] sample_names, DetectionFilter df) {
        this(parent, sample_names);
        this.df = df;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public DetectionFilter getDetectionFilter() {
        return this.df;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;

        GroupExperimentsPanel(String[] exptNames) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel panel1 = new JPanel();
            JLabel[] expLabels = new JLabel[exptNames.length];
            this.groupARadioButtons = new JRadioButton[exptNames.length];
            this.groupBRadioButtons = new JRadioButton[exptNames.length];
            ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.length];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            panel1.setLayout(gridbag);
            for (int i = 0; i < exptNames.length; ++i) {
                String s1 = exptNames[i];
                expLabels[i] = new JLabel(s1);
                chooseGroup[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                chooseGroup[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                chooseGroup[i].add(this.groupBRadioButtons[i]);
                this.buildConstraints(constraints, 0, i, 1, 1, 25, 100);
                gridbag.setConstraints(expLabels[i], constraints);
                panel1.add(expLabels[i]);
                this.buildConstraints(constraints, 1, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupARadioButtons[i], constraints);
                panel1.add(this.groupARadioButtons[i]);
                this.buildConstraints(constraints, 2, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
                panel1.add(this.groupBRadioButtons[i]);
            }
            JScrollPane scroll = new JScrollPane(panel1);
            scroll.setPreferredSize(new Dimension(400, 300));
            this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
        }

        void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int group, int file_index) {
            this.group = group;
            this.file_index = file_index;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SetDetectionFilterDialog.this.df.get_group_membership(this.file_index) != this.group) {
                SetDetectionFilterDialog.this.df.set_group_membership(this.group, this.file_index);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                JList optionList = (JList)event.getSource();
                String selection = (String)optionList.getSelectedValue();
                if (selection.equals("AND")) {
                    SetDetectionFilterDialog.this.df.set_both(true);
                } else {
                    SetDetectionFilterDialog.this.df.set_both(false);
                }
            }
        }
    }

    class VoteFocusListener
    extends FocusAdapter {
        private int required;
        private int group_index;

        VoteFocusListener(int group, int req) {
            this.required = req;
            this.group_index = group;
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField textField = (JTextField)e.getSource();
            String content = textField.getText();
            SetDetectionFilterDialog.this.df.set_num_required(this.group_index, Integer.parseInt(content));
        }
    }

    class VoteKeyListener
    extends KeyAdapter {
        VoteKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                SetDetectionFilterDialog.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener,
    ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                SetDetectionFilterDialog.this.result = 2;
                SetDetectionFilterDialog.this.dispose();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetDetectionFilterDialog.this.result = -1;
            SetDetectionFilterDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void itemStateChanged(ItemEvent is_checked) {
            SetDetectionFilterDialog.this.use_filter = is_checked.getStateChange() == 1;
        }

        private void onOk() {
            try {
                SetDetectionFilterDialog.this.getDetectionFilter();
                SetDetectionFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetDetectionFilterDialog.this.result = 2;
            }
            SetDetectionFilterDialog.this.dispose();
        }
    }
}

