/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.awt.GBA;

public class SetDatabaseDialog
extends JDialog {
    private int result;
    private JComboBox dbChoice;

    public SetDatabaseDialog(Frame parent) {
        super(parent, "Select a Database", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JLabel dbLabel = new JLabel("Select a Database: ");
        this.dbChoice = new JComboBox();
        String[] databases = TMEV.getDatabases();
        for (int i = 0; i < databases.length; ++i) {
            this.dbChoice.addItem(databases[i]);
        }
        this.dbChoice.addKeyListener(listener);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GBA gba = new GBA();
        gba.add(contentPane, (Component)dbLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)this.dbChoice, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)cancelButton, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)okButton, 1, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setResizable(false);
        this.dbChoice.grabFocus();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getDatabase() {
        return (String)this.dbChoice.getSelectedItem();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                SetDatabaseDialog.this.result = 2;
                SetDatabaseDialog.this.dispose();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetDatabaseDialog.this.result = -1;
            SetDatabaseDialog.this.dispose();
        }

        private void onOk() {
            SetDatabaseDialog.this.result = 0;
            SetDatabaseDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

