/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import org.kohsuke.args4j.Option;
import org.tigr.microarray.mev.file.FileType;

public class SessionOptions {
    public static final String DATAFILE_STANFORD_ARG = FileType.STANFORD.getCommandArg();
    private String helpText = "\nMeV Command-line options \n\n-help \nPrint this help text and exit MeV. \n\n-gaggle \nIf this flag is present, MeV will automatically try to\n connect to the Gaggle boss on startup. It will start the boss if\n one is not already started. This option requires an internet\n connection.\n\n-fileType TYPE \n This flag specifies the type of datafile to be loaded.\n Options are:\n" + this.getFileTypeOptions() + "\n" + "-fileUrl URL \n" + " The URL of the data file to be preloaded. This must be a complete\n" + " url, including the http:// or ftp:// protocol indicators. Relative\n" + " urls are not supported. Local filesystem files are also not \n" + " supported at this time.\n" + "-firstRow \n" + "The index of the first row of expression data (rather than annotation) in a TDMS-like file. \n" + "If both this and the firstColumn flag are set, MeV can load TDMS-like datafiles \n" + "without interaction from the user. This number is zero-indexed. \n" + "-firstColumn \n" + "The index of the first column of expression data (rather than annotation) in a TDMS-like file. \n" + "If both this and the firstRow flag are set, MeV can load TDMS-like datafiles \n" + "without interaction from the user. This number is zero-indexed. \n" + "-arrayType \n" + "This value specifies the name of the array that the data in -fileUrl came from. The  \n" + "string must exactly match one of the list of currently-supported arrays, by default found at " + "ftp://occams.dfci.harvard.edu/pub/bio/tgi/data/Resourcerer/pipeline/supported_arrays.txt. \n" + "The species name is not required. \n";
    @Option(name="-help", usage="Prints help text and exits.")
    private boolean sendHelpText = false;
    @Option(name="-gaggle", usage="Connect to Gaggle network on startup.")
    private boolean connectToGaggle;
    @Option(name="-fileUrl", metaVar="URL", usage="URL for data file to load.")
    private String dataFile = null;
    @Option(name="-fileType", metaVar="FILE_FORMAT", usage="Format of input file. ")
    private String fileType = DATAFILE_STANFORD_ARG;
    @Option(name="-arrayType", metaVar="ARRAY_NAME", usage="Name of array type (optional).")
    private String arrayType = null;
    @Option(name="-firstRow", metaVar="FIRST_ROW", usage="Index of first non-annotation row of the file in -fileURL (optional).")
    private int firstRow = -1;
    @Option(name="-firstColumn", metaVar="FIRST_COLUMN", usage="Index of first non-annotation column of the file in -fileURL (optional).")
    private int firstColumn = -1;

    public String toString() {
        String outString = "";
        outString = outString + "Connect To Gaggle: \t" + this.connectToGaggle + "\n";
        outString = outString + "Data File URL: \t" + this.dataFile + "\n";
        outString = outString + "File Loader Type: \t" + this.fileType + "\n";
        outString = outString + "Array Name or Type: \t" + this.arrayType + "\n";
        outString = outString + "First row of data: \t" + this.firstRow + "\n";
        outString = outString + "First column of data: \t" + this.firstColumn + "\n";
        return outString;
    }

    public String getFileTypeOptions() {
        String options = "";
        for (FileType f : FileType.values()) {
            options = options + "\t" + f.getCommandArg() + "\t" + f.getDescription() + "\n";
        }
        return options;
    }

    public boolean sendHelpText() {
        return this.sendHelpText;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public boolean isConnectToGaggle() {
        return this.connectToGaggle;
    }

    public void setConnectToGaggle(boolean connectToGaggle) {
        this.connectToGaggle = connectToGaggle;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public FileType getFileType() {
        return FileType.getFileType(this.fileType);
    }

    public void setFileType(String dataType) {
        this.fileType = dataType;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public void setFirstColumn(int firstColumn) {
        this.firstColumn = firstColumn;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }
}

