/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SearchResultDialog
extends AlgorithmDialog {
    private int result = 2;
    private IFramework framework;
    private JTree nodeTree;
    private JList expViewNodeList;
    private JList tableViewNodeList;
    private Hashtable expViewHash;
    private Hashtable tableViewHash;
    private int[] indices;
    private boolean geneResult;
    private ResultTable resultTable;
    private boolean noViewers = false;
    private AlgorithmData searchCriteria;
    private String[] inputIds;
    private boolean isListImportResult = false;

    public SearchResultDialog(IFramework framework, AlgorithmData searchCriteria, JTree resultTree, Hashtable expViewNodeHash, Hashtable tableViewNodeHash, int[] indices) {
        super(framework.getFrame(), "Search Result", false);
        this.framework = framework;
        this.nodeTree = resultTree;
        this.indices = indices;
        this.searchCriteria = searchCriteria;
        this.geneResult = searchCriteria.getParams().getBoolean("gene-search");
        TreeListener listener = new TreeListener();
        this.nodeTree.addTreeSelectionListener(listener);
        this.expViewHash = expViewNodeHash;
        this.tableViewHash = tableViewNodeHash;
        if (resultTree.getModel().getRoot() == null || ((TreeNode)resultTree.getModel().getRoot()).getChildCount() < 1) {
            this.initElementOnlyResult();
        } else {
            this.initFullResult();
            this.expViewNodeList.addListSelectionListener(listener);
            this.tableViewNodeList.addListSelectionListener(listener);
        }
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser((Window)((Object)SearchResultDialog.this), (String)"Search Result Dialog");
            }
        });
        this.resetButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.pack();
        this.setSize(550, 500);
    }

    public SearchResultDialog(IFramework framework, AlgorithmData searchCriteria, int[] indices) {
        super(framework.getFrame(), "Search Result", false);
        this.framework = framework;
        this.indices = indices;
        this.geneResult = searchCriteria.getParams().getBoolean("gene-search");
        this.noViewers = true;
        this.initElementOnlyResult();
        this.expViewHash = null;
        this.tableViewHash = null;
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser((Window)((Object)SearchResultDialog.this), (String)"Search Result Dialog");
            }
        });
        this.resetButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.pack();
        this.setSize(550, 400);
    }

    public SearchResultDialog(IFramework framework, int[] indices, String[] idList, boolean[] foundTerms, boolean geneResult) {
        super(framework.getFrame(), "Import Results", true);
        this.framework = framework;
        this.isListImportResult = true;
        this.indices = indices;
        this.inputIds = idList;
        this.geneResult = geneResult;
        this.noViewers = true;
        this.initListImportResult(idList, foundTerms);
        this.expViewHash = null;
        this.tableViewHash = null;
        this.resetButton.setVisible(false);
        this.okButton.setText("Store Cluster");
        this.okButton.setSize(100, 30);
        this.okButton.setPreferredSize(new Dimension(100, 30));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchResultDialog.this.result = 0;
                SearchResultDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchResultDialog.this.result = 2;
                SearchResultDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser((Window)((Object)SearchResultDialog.this), (String)"Import Result Dialog");
            }
        });
        super.validate();
        this.pack();
        this.setSize(550, 500);
    }

    private void initFullResult() {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane treePane = new JScrollPane(this.nodeTree);
        JScrollPane expViewPane = new JScrollPane(this.expViewNodeList);
        JScrollPane tableViewPane = new JScrollPane(this.tableViewNodeList);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        JPanel primaryPanel = new JPanel();
        primaryPanel.setBackground(Color.white);
        primaryPanel.setLayout(new GridBagLayout());
        primaryPanel.add((Component)treePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ParameterPanel expViewPanel = new ParameterPanel("Expression Viewers");
        expViewPanel.setLayout((LayoutManager)new GridBagLayout());
        expViewPanel.add((Component)expViewPane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ParameterPanel tableViewPanel = new ParameterPanel("Table Viewers");
        tableViewPanel.setLayout((LayoutManager)new GridBagLayout());
        tableViewPanel.add((Component)tableViewPane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.resultTable = this.geneResult ? new ResultTable("Genes Found", this.framework.getData(), this.indices, this.geneResult, false) : new ResultTable("Samples Found", this.framework.getData(), this.indices, this.geneResult, false);
        ParameterPanel shortCutPanel = new ParameterPanel("Viewer Shortcuts");
        shortCutPanel.setLayout((LayoutManager)new GridBagLayout());
        shortCutPanel.add((Component)primaryPanel, (Object)new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        shortCutPanel.add((Component)expViewPanel, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        shortCutPanel.add((Component)tableViewPanel, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)shortCutPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.addContent(mainPanel);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void initListImportResult(String[] inputIDs, boolean[] foundIDs) {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane treePane = new JScrollPane(this.nodeTree);
        JScrollPane expViewPane = new JScrollPane(this.expViewNodeList);
        JScrollPane tableViewPane = new JScrollPane(this.tableViewNodeList);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        Vector<String> found = new Vector<String>();
        Vector<String> lost = new Vector<String>();
        for (int i = 0; i < foundIDs.length; ++i) {
            if (foundIDs[i]) {
                found.addElement(inputIDs[i]);
                continue;
            }
            lost.addElement(inputIDs[i]);
        }
        String resultDescription = "<html><center>" + String.valueOf(found.size()) + " of " + String.valueOf(inputIDs.length) + " input IDs were matched.<br>" + String.valueOf("(List length = " + this.indices.length + ")</center><html>");
        if (this.geneResult) {
            this.resultTable = new ResultTable("Genes Matched", this.framework.getData(), this.indices, this.geneResult, true);
            this.resultTable.setResultText(resultDescription);
        } else {
            this.resultTable = new ResultTable("Samples Matched", this.framework.getData(), this.indices, this.geneResult, true);
            this.resultTable.setResultText(resultDescription);
        }
        ParameterPanel lostAndFoundPanel = new ParameterPanel("Matching Results");
        lostAndFoundPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel foundLabel = new JLabel("IDs Found (" + found.size() + " of " + inputIDs.length + ")");
        JScrollPane foundPane = new JScrollPane(new JList(found));
        JLabel lostLabel = new JLabel("IDs Not Found (" + lost.size() + " of " + inputIDs.length + ")");
        JScrollPane lostPane = new JScrollPane(new JList(lost));
        lostAndFoundPanel.add((Component)foundLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 0, 15), 0, 0));
        lostAndFoundPanel.add((Component)lostLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        lostAndFoundPanel.add((Component)foundPane, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 15), 0, 0));
        lostAndFoundPanel.add((Component)lostPane, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        mainPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)lostAndFoundPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(mainPanel);
    }

    private void initElementOnlyResult() {
        this.expViewNodeList = new JList(new Vector());
        this.tableViewNodeList = new JList(new Vector());
        JScrollPane treePane = new JScrollPane(this.nodeTree);
        JScrollPane expViewPane = new JScrollPane(this.expViewNodeList);
        JScrollPane tableViewPane = new JScrollPane(this.tableViewNodeList);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        ParameterPanel emptyViewerPanel = new ParameterPanel("Viewers");
        emptyViewerPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel label = this.geneResult ? new JLabel("<html><body><center>No expression or table viewers were found<br>containing the matching genes.</center></body></html>") : new JLabel("<html><body><center>No expression or table viewers were found<br>containing the matching samples.</center></body></html>");
        label.setOpaque(false);
        label.setHorizontalAlignment(0);
        emptyViewerPanel.add((Component)label, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.resultTable = this.geneResult ? new ResultTable("Genes Found", this.framework.getData(), this.indices, this.geneResult, false) : new ResultTable("Samples Found", this.framework.getData(), this.indices, this.geneResult, false);
        mainPanel.add((Component)((Object)this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)emptyViewerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(mainPanel);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(400, 400);
        frame.setVisible(true);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Analysis Results");
        DefaultMutableTreeNode a1 = new DefaultMutableTreeNode("KMC - genes(1)");
        DefaultMutableTreeNode a2 = new DefaultMutableTreeNode("SOM - genes(2)");
        root.add(a1);
        root.add(a2);
        DefaultMutableTreeNode c1 = new DefaultMutableTreeNode("Cluster 2");
        DefaultMutableTreeNode c2 = new DefaultMutableTreeNode("Cluster 8");
        Vector<DefaultMutableTreeNode> expVector = new Vector<DefaultMutableTreeNode>();
        expVector.add(c1);
        expVector.add(c2);
        Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>> expTable = new Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>>();
        expTable.put(a1, expVector);
        expTable.put(a2, expVector);
        Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>> tabTable = new Hashtable<DefaultMutableTreeNode, Vector<DefaultMutableTreeNode>>();
        tabTable.put(a1, expVector);
        tabTable.put(a2, expVector);
        ResultTree tree = new ResultTree(root);
    }

    private void updateLists(DefaultMutableTreeNode node) {
        Vector v1 = (Vector)this.expViewHash.get(node);
        if (v1 == null) {
            v1 = new Vector();
        }
        this.expViewNodeList.setListData(v1);
        Vector v2 = (Vector)this.tableViewHash.get(node);
        if (v2 == null) {
            v2 = new Vector();
        }
        this.tableViewNodeList.setListData(v2);
    }

    private void updateViewerResults(int[] ind) {
        if (ind.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No element indices are selected in the table as a basis for viewer update.", "Empty Element List", 1);
            return;
        }
        if (ind.length == this.indices.length) {
            this.repaint();
            return;
        }
        ResultTree resultTree = this.framework.getResultTree();
        Vector result = resultTree.findViewerCollection(ind, this.geneResult);
        if (result != null) {
            Vector primaryNodes = (Vector)result.elementAt(0);
            Hashtable eViewHash = (Hashtable)result.elementAt(1);
            Hashtable tViewHash = (Hashtable)result.elementAt(2);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Analysis Results");
            for (int i = 0; i < primaryNodes.size(); ++i) {
                root.add((DefaultMutableTreeNode)primaryNodes.elementAt(i));
            }
            JTree tree = new JTree(root);
            SearchResultDialog resultDialog = new SearchResultDialog(this.framework, this.searchCriteria, tree, eViewHash, tViewHash, ind);
            resultDialog.showModal();
        }
    }

    private void storeCluster() {
        if (this.geneResult) {
            this.framework.storeOperationCluster("Search Result", "Selected Genes", this.resultTable.getSelectedIndices(), this.geneResult);
        } else {
            this.framework.storeOperationCluster("Search Result", "Selected Samples", this.resultTable.getSelectedIndices(), this.geneResult);
        }
        this.repaint();
    }

    public int[] getSelectedIndices() {
        return this.resultTable.getSelectedIndices();
    }

    private class ResultTable
    extends ParameterPanel {
        private JTable table;
        private ResultDataModel model;
        private JLabel elementLabel;
        private JButton updateViewerListsButton;
        private JButton saveClusterButton;

        public ResultTable(String title, IData data, int[] indices, boolean geneResult, boolean listImportResult) {
            String[] headerNames;
            super(title);
            this.setLayout(new GridBagLayout());
            if (geneResult) {
                String[] fields = data.getFieldNames();
                headerNames = new String[fields.length + 3];
                headerNames[0] = "Selected";
                headerNames[1] = "File Index";
                headerNames[2] = "Color";
                for (int i = 0; i < fields.length; ++i) {
                    headerNames[i + 3] = fields[i];
                }
            } else {
                Vector slideKeys = this.getSlideNameKeyVectorUnion(data);
                headerNames = new String[slideKeys.size() + 3];
                headerNames[0] = "Selected";
                headerNames[1] = "File Index";
                headerNames[2] = "Color";
                for (int i = 0; i < slideKeys.size(); ++i) {
                    headerNames[i + 3] = (String)slideKeys.elementAt(i);
                }
            }
            this.model = new ResultDataModel(data, indices, headerNames, geneResult);
            this.table = new JTable(this.model);
            this.table.setCellSelectionEnabled(true);
            this.table.getColumn("Color").setCellRenderer(new SearchTableCellRenderer());
            JScrollPane pane = new JScrollPane(this.table);
            pane.setColumnHeaderView(this.table.getTableHeader());
            this.elementLabel = !listImportResult ? (geneResult ? new JLabel("Number of genes matching the search: " + indices.length) : new JLabel("Number of samples matching the search: " + indices.length)) : (geneResult ? new JLabel("<html>Number of genes matching the " + SearchResultDialog.this.inputIds.length + " input ids : " + indices.length + "<br>(Note that replicates for an id may exist)</html>") : new JLabel("<html>Number of samples matching the " + SearchResultDialog.this.inputIds.length + " input ids : " + indices.length));
            this.elementLabel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.elementLabel.setOpaque(true);
            this.elementLabel.setBackground(Color.lightGray);
            this.elementLabel.setHorizontalAlignment(0);
            ButtonListener listener = new ButtonListener();
            JButton clearButton = new JButton("Clear");
            clearButton.setActionCommand("clear-all-command");
            clearButton.addActionListener(listener);
            clearButton.setFocusPainted(false);
            clearButton.setPreferredSize(new Dimension(80, 30));
            clearButton.setSize(80, 30);
            JButton selectAllButton = new JButton("Select All");
            selectAllButton.setActionCommand("select-all-command");
            selectAllButton.addActionListener(listener);
            selectAllButton.setFocusPainted(false);
            selectAllButton.setPreferredSize(new Dimension(80, 30));
            selectAllButton.setSize(80, 30);
            if (!listImportResult) {
                this.saveClusterButton = new JButton("Store Cluster");
                this.saveClusterButton.setActionCommand("store-cluster-command");
                this.saveClusterButton.addActionListener(listener);
                this.saveClusterButton.setFocusPainted(false);
                this.saveClusterButton.setPreferredSize(new Dimension(100, 30));
                this.saveClusterButton.setSize(100, 30);
                this.updateViewerListsButton = new JButton("Update Shortcuts");
                this.updateViewerListsButton.setEnabled(false);
                this.updateViewerListsButton.setActionCommand("update-viewer-lists-command");
                this.updateViewerListsButton.addActionListener(listener);
                this.updateViewerListsButton.setFocusPainted(false);
                this.updateViewerListsButton.setPreferredSize(new Dimension(100, 30));
                this.updateViewerListsButton.setSize(100, 30);
            }
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            buttonPanel.setOpaque(false);
            if (!listImportResult) {
                buttonPanel.add((Component)selectAllButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                buttonPanel.add((Component)clearButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                buttonPanel.add((Component)this.saveClusterButton, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
                buttonPanel.add((Component)this.updateViewerListsButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 30, 0, 0), 0, 0));
                this.add(this.elementLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                this.add(pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.add(buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.setPreferredSize(new Dimension(450, 150));
                this.setSize(450, 150);
            } else {
                buttonPanel.add((Component)selectAllButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 25, 0, 15), 0, 0));
                buttonPanel.add((Component)clearButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 2, new Insets(0, 15, 0, 25), 0, 0));
                this.add(this.elementLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                this.add(pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.add(buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.setPreferredSize(new Dimension(450, 200));
                this.setSize(450, 200);
            }
        }

        public void setResultText(String text) {
            this.elementLabel.setText(text);
            this.validate();
        }

        public Vector getSlideNameKeyVectorUnion(IData data) {
            Vector<String> fullKeyVector = new Vector<String>();
            for (int i = 0; i < data.getFeaturesCount(); ++i) {
                Vector<String> keyVector = data.getFeature(i).getSlideDataKeys();
                for (int j = 0; j < keyVector.size(); ++j) {
                    String key = keyVector.elementAt(j);
                    if (fullKeyVector.contains(key)) continue;
                    fullKeyVector.addElement(key);
                }
            }
            return fullKeyVector;
        }

        private int[] getSelectedIndices() {
            return this.model.getSelectedIndices();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                if (command.equals("select-all-command")) {
                    ResultTable.this.model.selectAll();
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(true);
                    }
                } else if (command.equals("clear-all-command")) {
                    ResultTable.this.model.clearAll();
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(false);
                    }
                } else if (command.equals("update-viewer-lists-command")) {
                    SearchResultDialog.this.updateViewerResults(ResultTable.this.model.getSelectedIndices());
                } else if (command.equals("store-cluster-command")) {
                    SearchResultDialog.this.storeCluster();
                }
            }
        }

        private class SearchTableCellRenderer
        implements TableCellRenderer {
            JPanel colorPanel = new JPanel();

            public SearchTableCellRenderer() {
                this.colorPanel.setBackground(Color.white);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int param4, int param5) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
        }

        private class ResultDataModel
        extends AbstractTableModel {
            private IData data;
            private int[] indices;
            private boolean[] selected;
            private String[] headerNames;
            private int columnCount;
            private int rowCount;
            private String value;
            private boolean geneResult;
            private JCheckBox checkBox;
            private JLabel colorLabel;

            public ResultDataModel(IData data, int[] indices, String[] headerNames, boolean geneResult) {
                this.data = data;
                this.indices = indices;
                this.headerNames = headerNames;
                this.geneResult = geneResult;
                this.checkBox = new JCheckBox();
                this.colorLabel = new JLabel();
                this.colorLabel.setOpaque(true);
                this.columnCount = headerNames.length;
                this.rowCount = indices.length;
                this.selected = new boolean[this.rowCount];
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = true;
                }
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return new Boolean(this.selected[row]);
                }
                if (col == 1) {
                    return Integer.toString(this.indices[row]);
                }
                if (col == 2) {
                    Color color = this.data.getProbeColor(this.indices[row]);
                    if (color != null) {
                        return color;
                    }
                    return Color.white;
                }
                this.value = this.geneResult ? this.data.getElementAttribute(this.indices[row], col - 3) : (String)this.data.getFeature(this.indices[row]).getSlideDataLabels().get(this.headerNames[col]);
                if (this.value == null) {
                    this.value = " ";
                }
                return this.value;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 0) {
                    this.selected[row] = (Boolean)value;
                    if (!SearchResultDialog.this.isListImportResult) {
                        ResultTable.this.updateViewerListsButton.setEnabled(true);
                    }
                }
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public int getColumnCount() {
                return this.columnCount;
            }

            @Override
            public int getRowCount() {
                return this.rowCount;
            }

            @Override
            public String getColumnName(int col) {
                return this.headerNames[col];
            }

            public void selectAll() {
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = true;
                }
                ResultTable.this.table.repaint();
            }

            public void clearAll() {
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = false;
                }
                ResultTable.this.table.repaint();
            }

            public int[] getSelectedIndices() {
                Vector<Integer> indices = new Vector<Integer>();
                for (int i = 0; i < this.selected.length; ++i) {
                    if (!this.selected[i]) continue;
                    indices.add(new Integer((String)ResultTable.this.model.getValueAt(i, 1)));
                }
                int[] newIndices = new int[indices.size()];
                for (int i = 0; i < newIndices.length; ++i) {
                    newIndices[i] = (Integer)indices.elementAt(i);
                }
                return newIndices;
            }
        }
    }

    private class TreeListener
    implements TreeSelectionListener,
    ListSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SearchResultDialog.this.nodeTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            SearchResultDialog.this.updateLists(node);
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            JList list = (JList)lse.getSource();
            if (list == SearchResultDialog.this.expViewNodeList) {
                SearchResultDialog.this.tableViewNodeList.clearSelection();
            } else {
                SearchResultDialog.this.expViewNodeList.clearSelection();
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)list.getSelectedValue();
            if (node != null && SearchResultDialog.this.framework != null) {
                SearchResultDialog.this.framework.setTreeNode(node);
            }
        }
    }
}

