/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SearchDialog
extends AlgorithmDialog {
    private int result = 2;
    private JPanel controlPanel;
    private JTextField termField;
    private JCheckBox caseSensBox;
    private JCheckBox entireWordBox;
    private JRadioButton geneSearchButton;
    private JRadioButton expSearchButton;
    private FieldsPanel fieldsPanel;
    private FieldsPanel sampleFieldsPanel;

    public SearchDialog(Frame parent, String[] fieldNames, String[] sampleNames) {
        super(parent, "Global Search", true);
        Listener listener = new Listener();
        this.controlPanel = new JPanel(new GridBagLayout());
        this.controlPanel.setBackground(Color.white);
        ParameterPanel modePanel = new ParameterPanel("Search Mode");
        modePanel.setLayout((LayoutManager)new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        this.geneSearchButton = new JRadioButton("Gene Search", true);
        this.geneSearchButton.setFocusPainted(false);
        this.geneSearchButton.setBackground(Color.white);
        this.geneSearchButton.setActionCommand("search-mode-change");
        this.geneSearchButton.addActionListener((ActionListener)((Object)listener));
        bg.add(this.geneSearchButton);
        this.expSearchButton = new JRadioButton("Sample Search", true);
        this.expSearchButton.setFocusPainted(false);
        this.expSearchButton.setBackground(Color.white);
        this.expSearchButton.setActionCommand("search-mode-change");
        this.expSearchButton.addActionListener((ActionListener)((Object)listener));
        bg.add(this.expSearchButton);
        modePanel.add((Component)this.geneSearchButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 25), 0, 0));
        modePanel.add((Component)this.expSearchButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 40, 0, 0), 0, 0));
        ParameterPanel searchTermPanel = new ParameterPanel("Search Term");
        searchTermPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel termLabel = new JLabel("Search Term:");
        termLabel.setOpaque(false);
        this.termField = new JTextField(25);
        this.caseSensBox = new JCheckBox("Case Sensitive", false);
        this.caseSensBox.setOpaque(false);
        this.caseSensBox.setFocusPainted(false);
        this.entireWordBox = new JCheckBox("Exact Match", false);
        this.entireWordBox.setOpaque(false);
        this.entireWordBox.setFocusPainted(false);
        searchTermPanel.add((Component)termLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 20, 0, 0), 0, 0));
        searchTermPanel.add((Component)this.termField, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 20), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)this.caseSensBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 35), 0, 0));
        panel.add((Component)this.entireWordBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        searchTermPanel.add((Component)panel, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldsPanel = new FieldsPanel(fieldNames);
        this.sampleFieldsPanel = new FieldsPanel(sampleNames);
        this.controlPanel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)searchTermPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)((Object)this.fieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addContent(this.controlPanel);
        this.setActionListeners((ActionListener)((Object)listener));
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Vector getSelectedFields() {
        FieldsPanel fPanel = this.isGeneSearch() ? this.fieldsPanel : this.sampleFieldsPanel;
        Vector<String> v = new Vector<String>();
        Vector boxes = fPanel.fieldBoxVector;
        for (int i = 0; i < boxes.size(); ++i) {
            JCheckBox box = (JCheckBox)boxes.elementAt(i);
            if (!box.isSelected()) continue;
            v.add(box.getText());
        }
        return v;
    }

    public boolean isGeneSearch() {
        return this.geneSearchButton.isSelected();
    }

    public String getSearchTerm() {
        return this.termField.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensBox.isSelected();
    }

    public boolean isWholeTermRequired() {
        return this.entireWordBox.isSelected();
    }

    public AlgorithmData getSearchCriteria() {
        AlgorithmData params = new AlgorithmData();
        params.addParam("search-term", this.getSearchTerm());
        params.addParam("case-sensitive", String.valueOf(this.isCaseSensitive()));
        params.addParam("full-term", String.valueOf(this.isWholeTermRequired()));
        params.addParam("gene-search", String.valueOf(this.isGeneSearch()));
        Vector v = this.getSelectedFields();
        String[] fieldNames = new String[v.size()];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = (String)v.elementAt(i);
        }
        params.addStringArray("field-names", fieldNames);
        return params;
    }

    private void resetControls() {
        this.geneSearchButton.setSelected(true);
        this.caseSensBox.setSelected(false);
        this.entireWordBox.setSelected(false);
        for (int i = 0; i < this.fieldsPanel.fieldBoxVector.size(); ++i) {
            ((JCheckBox)this.fieldsPanel.fieldBoxVector.elementAt(i)).setSelected(i == 0);
        }
        this.termField.setText("");
        this.termField.grabFocus();
        this.termField.selectAll();
    }

    private void addBox(JPanel p, Vector v, String s, int yPos) {
        JCheckBox box = new JCheckBox(s);
        box.setOpaque(false);
        box.setFocusPainted(false);
        box.setSelected(yPos == 0);
        p.add((Component)box, new GridBagConstraints(0, yPos, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        v.addElement(box);
    }

    private void setFieldsPanel() {
        if (!this.isGeneSearch()) {
            this.controlPanel.remove((Component)((Object)this.fieldsPanel));
            this.controlPanel.add((Component)((Object)this.sampleFieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.controlPanel.validate();
            this.repaint();
        } else {
            this.controlPanel.remove((Component)((Object)this.sampleFieldsPanel));
            this.controlPanel.add((Component)((Object)this.fieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.controlPanel.validate();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        String[] s = new String[]{"UID", "TC#", "GenBank", "Locus Link Human gene Identifier this is a long field name", "Unigene", "UID", "TC#", "GenBank"};
        String[] expFields = new String[]{"Default Sample Name", "Strain"};
        SearchDialog dialog = new SearchDialog(new Frame(), s, expFields);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                SearchDialog.this.result = 0;
                SearchDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SearchDialog.this.result = 2;
                SearchDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    SearchDialog.this.resetControls();
                    SearchDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)SearchDialog.this), (String)"Search Dialog");
                } else if (command.equals("search-mode-change")) {
                    SearchDialog.this.setFieldsPanel();
                    return;
                }
            }
            SearchDialog.this.dispose();
        }

        public void windowClosing(WindowEvent e) {
            SearchDialog.this.result = -1;
            SearchDialog.this.dispose();
        }
    }

    private class MyCellRenderer
    implements ListCellRenderer {
        private JCheckBox box = new JCheckBox();

        public MyCellRenderer() {
            this.box.setFocusPainted(false);
            this.box.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object obj, int param, boolean sel, boolean param4) {
            this.box.setText((String)obj);
            this.box.setSelected(sel);
            return this.box;
        }
    }

    private class FieldsPanel
    extends ParameterPanel {
        JScrollPane scrollPane;
        JList fieldList;
        Vector fieldBoxVector;
        JButton allButton;
        JButton resetSelButton;

        public FieldsPanel(String[] fields) {
            super("Searchable Fields");
            super.setLayout((LayoutManager)new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.allButton = new JButton("Select All Fields");
            this.allButton.setFocusPainted(false);
            this.allButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (int i = 0; i < FieldsPanel.this.fieldBoxVector.size(); ++i) {
                        ((JCheckBox)FieldsPanel.this.fieldBoxVector.elementAt(i)).setSelected(true);
                    }
                }
            });
            this.resetSelButton = new JButton("Reset Selection");
            this.resetSelButton.setFocusPainted(false);
            this.resetSelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (int i = 0; i < FieldsPanel.this.fieldBoxVector.size(); ++i) {
                        ((JCheckBox)FieldsPanel.this.fieldBoxVector.elementAt(i)).setSelected(i == 0);
                    }
                }
            });
            this.fieldBoxVector = new Vector();
            JPanel fieldPanel = new JPanel();
            fieldPanel.setLayout(new GridBagLayout());
            fieldPanel.setBackground(Color.white);
            for (int i = 0; i < fields.length; ++i) {
                SearchDialog.this.addBox(fieldPanel, this.fieldBoxVector, fields[i], i);
            }
            this.fieldList = new JList(this.fieldBoxVector);
            this.fieldList.setSelectionMode(2);
            this.fieldList.setVisibleRowCount(5);
            this.fieldList.setCellRenderer(new MyCellRenderer());
            this.scrollPane = new JScrollPane(fieldPanel);
            this.scrollPane.setPreferredSize(new Dimension(350, Math.min(200, this.fieldBoxVector.size() * 30)));
            this.scrollPane.setSize(350, Math.min(200, this.fieldBoxVector.size() * 30));
            super.add((Component)this.allButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 5), 0, 0));
            super.add((Component)this.resetSelButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 10, 0), 0, 0));
            JPanel p = new JPanel();
            p.setBackground(Color.red);
            super.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

