/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ResultTree
extends JTree
implements Serializable {
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode analysisNode;
    Vector dumpVector;

    public ResultTree() {
        this.setCellRenderer(new ResultTreeNodeRenderer());
    }

    public ResultTree(DefaultMutableTreeNode root) {
        super(root);
        this.root = root;
        this.setCellRenderer(new ResultTreeNodeRenderer());
        this.dumpVector = new Vector();
    }

    public ResultTree(DefaultMutableTreeNode root, DefaultMutableTreeNode analysisNode) {
        super(root);
        this.root = root;
        this.setCellRenderer(new ResultTreeNodeRenderer());
        this.analysisNode = analysisNode;
        this.dumpVector = new Vector();
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode r) {
        this.root = r;
    }

    public DefaultMutableTreeNode getAnalysisNode() {
        return this.analysisNode;
    }

    public void setAnalysisNode(DefaultMutableTreeNode n) {
        this.analysisNode = n;
    }

    public void insertNode(DefaultMutableTreeNode node, DefaultMutableTreeNode parentNode, int locationIndex) {
        if (node == null || parentNode == null) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        treeModel.insertNodeInto(node, parentNode, locationIndex);
    }

    public void removeNode(DefaultMutableTreeNode node) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        treeModel.removeNodeFromParent(node);
    }

    public DefaultMutableTreeNode getNode(Object object) {
        Enumeration<TreeNode> _enum = this.root.depthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)_enum.nextElement();
            if (node.getUserObject() != object) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getNode(String[] nodeNames) {
        DefaultMutableTreeNode node = this.root;
        for (int i = 0; i < nodeNames.length; ++i) {
            for (int j = 0; j < node.getChildCount(); ++j) {
                if (!node.getChildAt(j).toString().equals(nodeNames[i])) continue;
                node = (DefaultMutableTreeNode)node.getChildAt(j);
            }
        }
        if (node.toString().equals(nodeNames[nodeNames.length - 1])) {
            return node;
        }
        return null;
    }

    public Hashtable getAllExperiments() {
        Hashtable<Integer, Experiment> allExpts = new Hashtable<Integer, Experiment>();
        Enumeration<TreeNode> allTreeNodes = this.analysisNode.breadthFirstEnumeration();
        while (allTreeNodes.hasMoreElements()) {
            Experiment e;
            LeafInfo l;
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)allTreeNodes.nextElement();
            Object o = dmtn.getUserObject();
            if (!(o instanceof LeafInfo) || (l = (LeafInfo)o).getViewer() == null || (e = l.getViewer().getExperiment()) == null) continue;
            allExpts.put(new Integer(e.getId()), l.getViewer().getExperiment());
        }
        return allExpts;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> table = new Hashtable<String, Object[]>();
        boolean stop = false;
        int childCount = this.analysisNode.getChildCount();
        String algName = "";
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode analysisRoot = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            Object object = analysisRoot.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                algName = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                algName = (String)object;
            }
            Enumeration<TreeNode> _enum = analysisRoot.depthFirstEnumeration();
            while (!stop && _enum.hasMoreElements()) {
                IViewer viewer;
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)_enum.nextElement();
                if (!(currentNode.getUserObject() instanceof LeafInfo) || (viewer = ((LeafInfo)currentNode.getUserObject()).getViewer()) == null) continue;
                Experiment exp = viewer.getExperiment();
                int[][] clusters = viewer.getClusters();
                if (exp == null || clusters == null) continue;
                Object[] vals = new Object[]{exp, clusters};
                table.put(algName, vals);
                stop = true;
            }
            stop = false;
        }
        return table;
    }

    public Vector findViewerCollection(int[] indices, boolean geneSearch) {
        Vector<Cloneable> result = new Vector<Cloneable>();
        Vector<DefaultMutableTreeNode> analysisNodes = new Vector<DefaultMutableTreeNode>();
        Hashtable expViewHash = new Hashtable();
        Hashtable tabViewHash = new Hashtable();
        Vector childNodes = new Vector();
        int childCount = this.analysisNode.getChildCount();
        boolean hasResult = false;
        for (int analysis = 0; analysis < childCount; ++analysis) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.analysisNode.getChildAt(analysis);
            DefaultMutableTreeNode aNode = this.getSearchResults(indices, node, expViewHash, tabViewHash, geneSearch);
            if (aNode == null) continue;
            analysisNodes.addElement(aNode);
        }
        result.add(analysisNodes);
        result.add(expViewHash);
        result.add(tabViewHash);
        if (expViewHash.size() == 0 && expViewHash.size() == 0) {
            return null;
        }
        return result;
    }

    private DefaultMutableTreeNode getSearchResults(int[] indices, DefaultMutableTreeNode analRoot, Hashtable expHash, Hashtable tabHash, boolean geneSearch) {
        boolean result = false;
        Enumeration<TreeNode> _enum = analRoot.depthFirstEnumeration();
        Vector<DefaultMutableTreeNode> expViewers = new Vector<DefaultMutableTreeNode>();
        Vector<DefaultMutableTreeNode> tabViewers = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode(analRoot.getUserObject());
        while (_enum.hasMoreElements()) {
            Experiment currExperiment;
            int[][] clusters;
            int clusterIndex;
            Object currIndexObject;
            LeafInfo currLeafInfo;
            IViewer currViewer;
            DefaultMutableTreeNode currNode = (DefaultMutableTreeNode)_enum.nextElement();
            Object currUserObject = currNode.getUserObject();
            if (!(currUserObject instanceof LeafInfo) || (currViewer = (currLeafInfo = (LeafInfo)currUserObject).getViewer()) == null) continue;
            if (geneSearch) {
                if (currViewer instanceof ExperimentViewer) {
                    currIndexObject = ((LeafInfo)currUserObject).getUserObject();
                    if (currIndexObject == null || !(currIndexObject instanceof Integer)) continue;
                    clusterIndex = (Integer)currIndexObject;
                    clusters = currViewer.getClusters();
                    currExperiment = currViewer.getExperiment();
                    if (clusters == null || currExperiment == null || !this.containsGeneIndices(indices, clusters[clusterIndex], currExperiment)) continue;
                    result = true;
                    expViewers.addElement(currNode);
                    continue;
                }
                if (!(currViewer instanceof ClusterTableViewer) || (currIndexObject = ((LeafInfo)currUserObject).getUserObject()) == null || !(currIndexObject instanceof Integer)) continue;
                clusterIndex = (Integer)currIndexObject;
                clusters = currViewer.getClusters();
                currExperiment = currViewer.getExperiment();
                if (clusters == null || currExperiment == null || !this.containsGeneIndices(indices, clusters[clusterIndex], currExperiment)) continue;
                result = true;
                tabViewers.addElement(currNode);
                continue;
            }
            if (currViewer instanceof ExperimentClusterViewer) {
                currIndexObject = ((LeafInfo)currUserObject).getUserObject();
                if (currIndexObject == null || !(currIndexObject instanceof Integer)) continue;
                clusterIndex = (Integer)currIndexObject;
                clusters = currViewer.getClusters();
                currExperiment = currViewer.getExperiment();
                if (clusters == null || currExperiment == null || !this.containsExperimentIndices(indices, clusters[clusterIndex], currExperiment)) continue;
                result = true;
                expViewers.addElement(currNode);
                continue;
            }
            if (!(currViewer instanceof ExperimentClusterTableViewer) || (currIndexObject = ((LeafInfo)currUserObject).getUserObject()) == null || !(currIndexObject instanceof Integer)) continue;
            clusterIndex = (Integer)currIndexObject;
            clusters = currViewer.getClusters();
            currExperiment = currViewer.getExperiment();
            if (clusters == null || currExperiment == null || !this.containsExperimentIndices(indices, clusters[clusterIndex], currExperiment)) continue;
            result = true;
            tabViewers.addElement(currNode);
        }
        if (result) {
            expHash.put(newRoot, expViewers);
            tabHash.put(newRoot, tabViewers);
            return newRoot;
        }
        return null;
    }

    private boolean containsGeneIndices(int[] indices, int[] clusterIndices, Experiment experiment) {
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < clusterIndices.length; ++j) {
                if (indices[i] != experiment.getGeneIndexMappedToData(clusterIndices[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsExperimentIndices(int[] indices, int[] clusterIndices, Experiment experiment) {
        int[] colIndices = experiment.getColumnIndicesCopy();
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < clusterIndices.length; ++j) {
                if (indices[i] != colIndices[clusterIndices[j]]) continue;
                return true;
            }
        }
        return false;
    }

    public void clearDataSelection() {
        Enumeration<TreeNode> _enum = this.root.depthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)_enum.nextElement();
            if (node.getUserObject() == null || !(node.getUserObject() instanceof LeafInfo)) continue;
            ((LeafInfo)node.getUserObject()).setSelectedDataSource(false);
        }
    }

    public class ResultTreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon defaultLeafIcon;
        private Icon primaryResultIcon = GUIFactory.getIcon((String)"PrimaryResult.gif");
        private Icon expressionImageIcon = GUIFactory.getIcon((String)"ExpressionImageResult.gif");
        private Icon expressionChartIcon = GUIFactory.getIcon((String)"ExpressionChartResult.gif");
        private Icon centroidGraphIcon = GUIFactory.getIcon((String)"CentroidResult.gif");
        private Icon expressionGraphIcon = GUIFactory.getIcon((String)"ExpressionGraphResult.gif");
        private Icon pwfIcon = GUIFactory.getIcon((String)"PWF_plot.gif");
        private Icon hclIcon = GUIFactory.getIcon((String)"HCLResult.gif");
        private Icon nodeHeightIcon = GUIFactory.getIcon((String)"NodeHeightResult.gif");
        private Icon samGraphIcon = GUIFactory.getIcon((String)"SAMGraphResult.gif");
        private Icon volcanoIcon = GUIFactory.getIcon((String)"VolcanoPlotResult.gif");
        private Icon networkIcon = GUIFactory.getIcon((String)"NetworkResult.gif");
        private Icon SOMColorIcon = GUIFactory.getIcon((String)"SOMColorResult.gif");
        private Icon SOMBWIcon = GUIFactory.getIcon((String)"SOMBWResult.gif");
        private Icon gdmMatrixIcon = GUIFactory.getIcon((String)"GDMMatrixResult.gif");
        private Icon clusterInfoIcon = GUIFactory.getIcon((String)"ClusterInformationResult.gif");
        private Icon survDiffIcon = GUIFactory.getIcon((String)"SurvDiffResultsIcon.gif");
        private Icon KMGraphIcon = GUIFactory.getIcon((String)"Kaplan-MeierPlotResult.gif");
        private Icon BasehazGraphIcon = GUIFactory.getIcon((String)"BaselineHazardPlotResult.gif");
        private Icon generalInfoIcon = GUIFactory.getIcon((String)"Information16.gif");
        private Icon tableIcon = GUIFactory.getIcon((String)"TableViewerResult.gif");
        private Icon pValueIcon = GUIFactory.getIcon((String)"pValueGraphViewer.gif");
        private Icon testStatValueIcon = GUIFactory.getIcon((String)"TestStatisticViewer.gif");
        private Icon leadingEdgeViewerIcon = GUIFactory.getIcon((String)"LeadingEdgeViewer.gif");
        private Icon geneSetMembershipPlotIcon = GUIFactory.getIcon((String)"genesetmembership.gif");
        private Icon clvalidIcon = GUIFactory.getIcon((String)"clvalid_result_tree.gif");
        private Icon pca3DIcon = GUIFactory.getIcon((String)"PCA3DResult.gif");
        private Icon trn3DIcon = GUIFactory.getIcon((String)"TerrainResult.gif");
        private Icon mevIcon = GUIFactory.getIcon((String)"mev_mini_splash.gif");
        private Icon mainViewIcon = GUIFactory.getIcon((String)"MainView.gif");
        private Icon analysisIcon = GUIFactory.getIcon((String)"Analysis.gif");
        private Icon clusterManagerIcon = GUIFactory.getIcon((String)"ClusterManager.gif");
        private Icon historyIcon = GUIFactory.getIcon((String)"History.gif");
        private Icon dotTerminalIcon = GUIFactory.getIcon((String)"TerminalDot.gif");
        private Icon scriptManagerIcon = GUIFactory.getIcon((String)"ScriptManager.gif");
        private Icon scriptIcon = GUIFactory.getIcon((String)"ScriptIcon.gif");
        private Icon scriptTreeViewerIcon = GUIFactory.getIcon((String)"ScriptTreeViewer.gif");
        private Icon scriptXMLViewerIcon = GUIFactory.getIcon((String)"ScriptXMLViewer.gif");
        private Icon searchIcon = GUIFactory.getIcon((String)"search_16.gif");
        private Icon goHierarchyViewerIcon = GUIFactory.getIcon((String)"go_hierarchy_viewer.gif");
        private Icon dataSelectionIcon = GUIFactory.getIcon((String)"data_selection_icon.gif");
        private Icon dataFilterIcon = GUIFactory.getIcon((String)"DataFilterResult.gif");
        private Icon lemViewerIcon = GUIFactory.getIcon((String)"LEM_result.gif");
        private Icon chrViewIcon = GUIFactory.getIcon((String)"cgh_chrom.gif");
        private Icon exprViewIcon = GUIFactory.getIcon((String)"cgh_circular.gif");
        private Icon cirViewIcon = GUIFactory.getIcon((String)"Chr_Circular.gif");
        private Icon chrXYIcon = GUIFactory.getIcon((String)"Chr_XY.gif");
        private Icon chrIcon = GUIFactory.getIcon((String)"Chr_Auto.gif");
        private Icon ampDelIcon = GUIFactory.getIcon((String)"Cgh_Amp_Del.gif");
        private DefaultMutableTreeNode parent;
        private DefaultMutableTreeNode grandParent;

        public ResultTreeNodeRenderer() {
            this.setIcon(this.closedIcon);
            super.setOpaque(false);
            this.setIconTextGap(2);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
            this.selected = selected;
            String text = "";
            String parentText = "";
            String grandParentText = "";
            Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            if (!isLeaf) {
                if (userObj instanceof String) {
                    text = (String)userObj;
                    this.setText(text);
                } else if (userObj instanceof LeafInfo) {
                    text = ((LeafInfo)userObj).toString();
                    this.setText(text);
                    if (((LeafInfo)userObj).isSelectedDataSource()) {
                        this.setBorder(BorderFactory.createLineBorder(Color.green, 2));
                    }
                }
                if (expanded) {
                    this.setIcon(this.openIcon);
                } else {
                    this.setIcon(this.closedIcon);
                }
                if (text.indexOf("Expression Image") != -1) {
                    this.setIcon(this.expressionImageIcon);
                } else if (text.indexOf("Expression Chart") != -1) {
                    this.setIcon(this.expressionChartIcon);
                } else if (text.indexOf("Set ") == -1) {
                    if (text.indexOf("Included Gene Sets") != -1 || text.indexOf("Excluded Gene Sets") != -1 || text.indexOf("Probe to Gene Mapping") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Centroid") != -1) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (text.indexOf("Expression Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.indexOf("Cophenetic Correlation Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.indexOf("H Factor") != -1 || text.indexOf("W Factor") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.equals("Analysis Results")) {
                        this.setIcon(this.analysisIcon);
                    } else if (text.equals("Cluster Manager")) {
                        this.setIcon(this.clusterManagerIcon);
                    } else if (text.equals("Script Manager")) {
                        this.setIcon(this.scriptManagerIcon);
                    } else if (text.equals("History")) {
                        this.setIcon(this.historyIcon);
                    } else if (text.equals("General Information")) {
                        this.setIcon(this.generalInfoIcon);
                    } else if (text.indexOf(40) != -1 && ((DefaultMutableTreeNode)value).getParent() == ResultTree.this.root.getChildAt(2)) {
                        this.setIcon(this.primaryResultIcon);
                    } else if (text.indexOf("F-Ratio") != -1 || text.indexOf("Statistic") != -1 || text.indexOf("Table") != -1 || text.indexOf("table") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (text.equals("Cluster Information")) {
                        this.setIcon(this.clusterInfoIcon);
                    } else if (text.equals("MultipleExperimentViewer")) {
                        this.setText("");
                        this.setBorder(new EmptyBorder(3, 2, 3, 0));
                        this.setIcon(this.mevIcon);
                    } else if (text.equals("Probability Weighting Function")) {
                        this.setIcon(this.pwfIcon);
                    } else if (text.equals("Hierarchical Trees") || text.startsWith("Consensus") || parentText.startsWith("Consensus")) {
                        this.setIcon(this.hclIcon);
                    } else if (text.equals("SOM Visualization")) {
                        this.setIcon(this.SOMColorIcon);
                    } else if (text.indexOf("Network") != -1) {
                        this.setIcon(this.networkIcon);
                    } else if (text.indexOf("Script (") != -1) {
                        this.setIcon(this.scriptIcon);
                    } else if (text.equals("Search Result Shortcuts")) {
                        this.setIcon(this.searchIcon);
                    } else if (text.indexOf("Data Filter") != -1) {
                        this.setIcon(this.dataFilterIcon);
                    } else if (text.equals("Original Data")) {
                        this.setIcon(this.mainViewIcon);
                    } else if (text.equals("Experiment Viewer")) {
                        this.setIcon(this.mainViewIcon);
                    } else if (text.equals("Geneset p-value graph")) {
                        this.setIcon(this.pValueIcon);
                    } else if (text.equals("Test statistics graph")) {
                        this.setIcon(this.testStatValueIcon);
                    } else if (text.equals("Geneset Membership Plot")) {
                        this.setIcon(this.geneSetMembershipPlotIcon);
                    } else if (text.equals("Chromosome Views")) {
                        this.setIcon(this.chrViewIcon);
                    } else if (text.equals("Chromosome 1") | text.equals("Chromosome 2") | text.equals("Chromosome 3") | text.equals("Chromosome 4") | text.equals("Chromosome 5") | text.equals("Chromosome 6") | text.equals("Chromosome 7") | text.equals("Chromosome 8") | text.equals("Chromosome 9") | text.equals("Chromosome 10") | text.equals("Chromosome 11") | text.equals("Chromosome 12") | text.equals("Chromosome 13") | text.equals("Chromosome 14") | text.equals("Chromosome 15") | text.equals("Chromosome 16") | text.equals("Chromosome 17") | text.equals("Chromosome 18") | text.equals("Chromosome 19") | text.equals("Chromosome 20") | text.equals("Chromosome 21") | text.equals("Chromosome 22")) {
                        this.setIcon(this.chrIcon);
                    } else if (text.equals("Chromosome X") | text.equals("Chromosome Y")) {
                        this.setIcon(this.chrXYIcon);
                    } else if (text.equals("Experiment Views")) {
                        this.setIcon(this.exprViewIcon);
                    } else if (text.equals("Results") | text.equals("A and B") | text.equals("B Only") | text.equals("A Only")) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Amplifications") != -1 | text.indexOf("Deletions") != -1) {
                        this.setIcon(this.ampDelIcon);
                    }
                }
            } else {
                this.setIcon(this.leafIcon);
                if (userObj instanceof String) {
                    text = (String)userObj;
                    this.setText(text);
                    this.setIcon(this.dotTerminalIcon);
                } else if (userObj instanceof LeafInfo) {
                    text = ((LeafInfo)userObj).toString();
                    this.setText(text);
                    if (((LeafInfo)userObj).isSelectedDataSource()) {
                        this.setBorder(BorderFactory.createLineBorder(Color.green, 2));
                    }
                    this.parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent();
                    if (this.parent.getUserObject() instanceof String) {
                        parentText = (String)this.parent.getUserObject();
                    } else if (this.parent.getUserObject() instanceof LeafInfo) {
                        parentText = ((LeafInfo)this.parent.getUserObject()).toString();
                    }
                    this.grandParent = (DefaultMutableTreeNode)this.parent.getParent();
                    if (this.grandParent != null) {
                        if (this.grandParent.getUserObject() instanceof String) {
                            grandParentText = (String)this.grandParent.getUserObject();
                        } else if (this.grandParent.getUserObject() instanceof LeafInfo) {
                            grandParentText = ((LeafInfo)this.grandParent.getUserObject()).toString();
                        }
                    } else {
                        grandParentText = null;
                    }
                    if (parentText.indexOf("Expression Image") != -1) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (parentText.indexOf("Expression Chart") != -1) {
                        this.setIcon(this.expressionChartIcon);
                    } else if (parentText.indexOf("Centroid") != -1) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (parentText.indexOf("Expression Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (parentText.indexOf("Cophenetic Correlation Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (parentText.indexOf("Metagene") != -1 && parentText.indexOf("graphs") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (parentText.indexOf("Metagene") != -1 && parentText.indexOf("graphs") == -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.indexOf("Cluster Manager") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.indexOf("F-Ratio") != -1 || parentText.indexOf("Statistic") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.equals("Cluster Information") || text.equals("Classification Information")) {
                        this.setIcon(this.clusterInfoIcon);
                    } else if (text.equals("MultipleExperimentViewer")) {
                        this.setIcon(this.openIcon);
                    } else if (text.equals("Original Data")) {
                        this.setIcon(this.mainViewIcon);
                    } else if (text.equalsIgnoreCase("Analysis Results")) {
                        this.setIcon(this.analysisIcon);
                    } else if (text.equalsIgnoreCase("Cluster Manager")) {
                        this.setIcon(this.clusterManagerIcon);
                    } else if (text.equals("Script Manager")) {
                        this.setIcon(this.scriptManagerIcon);
                    } else if (text.equalsIgnoreCase("History")) {
                        this.setIcon(this.historyIcon);
                    } else if (text.indexOf("able") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.indexOf("Hierarchical") != -1 || text.indexOf("Dendogram") != -1 || text.indexOf("HCL Tree") != -1 || text.indexOf("Support Tree") != -1 || text.startsWith("Consensus") || parentText.startsWith("Consensus")) {
                        this.setIcon(this.hclIcon);
                    } else if (text.equals("Probability Weighting Function")) {
                        this.setIcon(this.pwfIcon);
                    } else if (text.equals("Expression Image")) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (text.equals("Expression Chart")) {
                        this.setIcon(this.expressionChartIcon);
                    } else if (text.equals("Expression Graph")) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.equals("Cophenetic Correlation Graph")) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.equals("Optimal Cluster Scores")) {
                        this.setIcon(this.clusterInfoIcon);
                    } else if (text.indexOf("H Factor") != -1 || text.indexOf("W Factor") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.equals("Centroid Graph")) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (parentText.indexOf("Table") != -1 || text.indexOf("SVM") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Height Plot") != -1 || text.indexOf("SOTA Diversity") != -1 || text.indexOf("Graph - FOM") != -1) {
                        this.setIcon(this.nodeHeightIcon);
                    } else if (text.equals("Differential Survival")) {
                        this.setIcon(this.survDiffIcon);
                    } else if (text.equals("Cox Proportional Hazard Model")) {
                        this.setIcon(this.survDiffIcon);
                    } else if (text.contains("Kaplan-Meier Plot")) {
                        this.setIcon(this.KMGraphIcon);
                    } else if (text.contains("Baseline")) {
                        this.setIcon(this.BasehazGraphIcon);
                    } else if (text.equals("Volcano Plot")) {
                        this.setIcon(this.volcanoIcon);
                    } else if (text.equals("SAM Graph")) {
                        this.setIcon(this.samGraphIcon);
                    } else if (text.indexOf("Network") != -1) {
                        this.setIcon(this.networkIcon);
                    } else if (text.equals("Matrix View")) {
                        this.setIcon(this.gdmMatrixIcon);
                    } else if (text.equals("U-Matrix Color")) {
                        this.setIcon(this.SOMColorIcon);
                    } else if (text.equals("U-Matrix Distance")) {
                        this.setIcon(this.SOMBWIcon);
                    } else if (text.equals("3D view")) {
                        this.setIcon(this.pca3DIcon);
                    } else if (text.equals("Map") && parentText.indexOf("Terrain") != -1) {
                        this.setIcon(this.trn3DIcon);
                    } else if (text.indexOf("Script Tree") != -1) {
                        this.setIcon(this.scriptTreeViewerIcon);
                    } else if (text.equals("Script XML Viewer")) {
                        this.setIcon(this.scriptXMLViewerIcon);
                    } else if (text.indexOf("GO") != -1) {
                        this.setIcon(this.goHierarchyViewerIcon);
                    } else if (text.equals("Data Source Selection")) {
                        this.setIcon(this.dataSelectionIcon);
                    } else if (text.indexOf("LEM Viewer") != -1) {
                        this.setIcon(this.lemViewerIcon);
                    } else if (text.indexOf("Geneset p-value graph") != -1) {
                        this.setIcon(this.pValueIcon);
                    } else if (text.indexOf("Test statistics graph") != -1) {
                        this.setIcon(this.testStatValueIcon);
                    } else if (text.indexOf("Leading Edge Graph") != -1) {
                        this.setIcon(this.leadingEdgeViewerIcon);
                    } else if (text.indexOf("Leading edge genes") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Geneset Membership Plot") != -1) {
                        this.setIcon(this.geneSetMembershipPlotIcon);
                    } else if (text.equals("Experiment Views")) {
                        this.setIcon(this.exprViewIcon);
                    } else if (parentText.equals("Experiment Views")) {
                        this.setIcon(this.cirViewIcon);
                    } else if (text.equals("Chromosome Views")) {
                        this.setIcon(this.chrViewIcon);
                    } else if (text.equals("Chromosome 1") | text.equals("Chromosome 2") | text.equals("Chromosome 3") | text.equals("Chromosome 4") | text.equals("Chromosome 5") | text.equals("Chromosome 6") | text.equals("Chromosome 7") | text.equals("Chromosome 8") | text.equals("Chromosome 9") | text.equals("Chromosome 10") | text.equals("Chromosome 11") | text.equals("Chromosome 12") | text.equals("Chromosome 13") | text.equals("Chromosome 14") | text.equals("Chromosome 15") | text.equals("Chromosome 16") | text.equals("Chromosome 17") | text.equals("Chromosome 18") | text.equals("Chromosome 19") | text.equals("Chromosome 20") | text.equals("Chromosome 21") | text.equals("Chromosome 22")) {
                        this.setIcon(this.chrIcon);
                    } else if (text.equals("Chromosome X") | text.equals("Chromosome Y")) {
                        this.setIcon(this.chrXYIcon);
                    } else if (text.equals("Results") | text.equals("A and B") | text.equals("B Only") | text.equals("A Only")) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Amplifications") != -1 | text.indexOf("Deletions") != -1) {
                        this.setIcon(this.ampDelIcon);
                    } else if (text.indexOf("Included Gene Sets") != -1 || text.indexOf("Excluded Gene Sets") != -1 || text.indexOf("Probe to Gene Mapping") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (grandParentText != null) {
                        if (grandParentText.indexOf("Expression Image") != -1) {
                            this.setIcon(this.expressionImageIcon);
                        } else if (grandParentText.indexOf("Expression Chart") != -1) {
                            this.setIcon(this.expressionChartIcon);
                        } else if (grandParentText.indexOf("Table Views") != -1) {
                            this.setIcon(this.tableIcon);
                        } else if (grandParentText.indexOf("Centroid") != -1) {
                            this.setIcon(this.centroidGraphIcon);
                        } else if (grandParentText.indexOf("Expression Graph") != -1) {
                            this.setIcon(this.expressionGraphIcon);
                        } else if (grandParentText.indexOf("Cluster Validation") != -1) {
                            this.setIcon(this.clvalidIcon);
                        }
                    }
                }
            }
            if (selected) {
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            if (g == null) {
                return;
            }
            Color c = this.selected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
            g.setColor(c);
            int width = this.getWidth();
            if (this.getIcon() != null) {
                width -= this.getIcon().getIconWidth();
            }
            g.fillRect(this.getWidth() - width + 1, 0, width + 1, this.getHeight());
            super.setOpaque(false);
            super.paint(g);
        }
    }
}

