/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.IRNASeqSlide;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;

public class RNASeqFloatSlideData
extends FloatSlideData
implements IRNASeqSlide {
    protected int[] counts;
    protected int librarySize;

    public RNASeqFloatSlideData(ISlideMetaData slideMetaData, int[] counts) {
        super(slideMetaData);
        this.counts = counts;
    }

    public RNASeqFloatSlideData(ISlideMetaData slideMetaData, SampleAnnotation sampAnn, int[] counts) {
        super(slideMetaData, sampAnn);
        this.counts = counts;
    }

    public RNASeqFloatSlideData(ISlideMetaData slideMetaData, int spotCount, SampleAnnotation sampAnn) {
        super(slideMetaData, spotCount, sampAnn);
        this.counts = new int[spotCount];
    }

    public RNASeqFloatSlideData(FloatSlideData fsd, ClusterWrapper countsWrapper, Integer librarySize) {
        super(fsd);
        this.counts = countsWrapper.getClusters()[0];
        this.librarySize = librarySize;
    }

    public int[] getCounts() {
        return this.counts;
    }

    @Override
    public int getCount(int i) {
        return this.counts[i];
    }

    @Override
    public void setCount(int index, int countValue) {
        this.counts[index] = countValue;
    }

    @Override
    public int getLibrarySize() {
        return this.librarySize;
    }

    @Override
    public void setLibrarySize(int size) {
        this.librarySize = size;
    }
}

