/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.core.datatypes.Namelist;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.systemsbiology.gaggle.util.MiscUtil;
import org.tigr.microarray.file.AnnFileParser;
import org.tigr.microarray.mev.AnalysisFileFilter;
import org.tigr.microarray.mev.AnalysisFileView;
import org.tigr.microarray.mev.AnalysisSaveDialog;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.ExperimentLabelEditor;
import org.tigr.microarray.mev.GeneAnnotationImportDialog;
import org.tigr.microarray.mev.GenePixCutoffDialog;
import org.tigr.microarray.mev.GetSpeciesDialog;
import org.tigr.microarray.mev.HistoryViewer;
import org.tigr.microarray.mev.IDFEditor;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.MultipleArrayCanvas;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayToolbar;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.SearchDialog;
import org.tigr.microarray.mev.SearchResultDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.SetDetectionFilterDialog;
import org.tigr.microarray.mev.SetFoldFilterDialog;
import org.tigr.microarray.mev.SetLowerCutoffsDialog;
import org.tigr.microarray.mev.SetPercentageCutoffsDialog;
import org.tigr.microarray.mev.SetPresentCallDialog;
import org.tigr.microarray.mev.SetRatioScaleDialog;
import org.tigr.microarray.mev.SetSingleLowerCutoffsDialog;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.VarianceFilterDialog;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.GenomeAnnoDialog;
import org.tigr.microarray.mev.annotation.IChipAnnotation;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.AlterationsComparator.CompareExperiments;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.CGHAlgorithmFactory;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.GeneAmplifications;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.GeneDeletions;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.GeneAlterations.LoadGeneList;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.NumberOfAlterations.NumberOfAlterationsCalculator;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.FlankingRegionCalculator;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHAnnotationsModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModelDyeSwap;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModelNoDyeSwap;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHCircleViewerModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModelDyeSwap;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModelNoDyeSwap;
import org.tigr.microarray.mev.cgh.CGHDataModel.CytoBandsModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.CytoBands;
import org.tigr.microarray.mev.cgh.CGHDataObj.DataRegionGeneData;
import org.tigr.microarray.mev.cgh.CGHDataObj.GeneDataSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfAlterationsViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfDeletionsAmpilficationsDataModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser.CGHBrowser;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHCircleViewer.CGHCircleViewerPanel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHDataValuesDisplay;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHDisplayOrderChanger;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCombinedHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHThresholdSetter;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GuiUtil;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.SingleValueSelectorDialog;
import org.tigr.microarray.mev.cgh.CGHListenerObj.ICGHListener;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterTable;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterWorker;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.GenomeBrowserWebstart;
import org.tigr.microarray.mev.cluster.gui.helpers.TextViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HTMLMessageFileChooser;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFPlotViewer;
import org.tigr.microarray.mev.file.AnnFileFilter;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.CGHStanfordFileLoader;
import org.tigr.microarray.mev.file.FileLoadInfo;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.gaggle.GaggleListener;
import org.tigr.microarray.mev.gaggle.GaggleTranslater;
import org.tigr.microarray.mev.gaggle.GooseImpl;
import org.tigr.microarray.mev.persistence.BufferedImageWrapper;
import org.tigr.microarray.mev.persistence.MEVSessionPrefs;
import org.tigr.microarray.mev.persistence.MavXMLEncoder;
import org.tigr.microarray.mev.persistence.SessionMetaData;
import org.tigr.microarray.mev.persistence.StateSavingProgressPanel;
import org.tigr.microarray.mev.persistence.XMLEncoderFactory;
import org.tigr.microarray.mev.r.Rama;
import org.tigr.microarray.mev.resources.IMultiSupportFileDefinition;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.microarray.mev.sampleannotation.MageIDF;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.util.awt.AccessibleColorSchemeSelectionDialog;
import org.tigr.microarray.util.awt.ColorSchemeSelectionDialog;
import org.tigr.microarray.util.awt.SetElementSizeDialog;
import org.tigr.microarray.util.awt.SetSlideFilenameDialog;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;
import org.tigr.util.swing.BMPFileFilter;
import org.tigr.util.swing.ImageFileFilter;
import org.tigr.util.swing.JPGFileFilter;
import org.tigr.util.swing.PNGFileFilter;
import org.tigr.util.swing.TIFFFileFilter;

public class MultipleArrayViewer
extends ArrayViewer
implements Printable {
    private MultipleArrayMenubar menubar;
    private MultipleArrayToolbar toolbar;
    private JSplitPane splitPane;
    private JScrollPane viewScrollPane;
    private JLabel statusLabel;
    private JScrollPane treeScrollPane;
    private ResultTree tree;
    private DefaultMutableTreeNode mainViewerNode;
    private DefaultMutableTreeNode clusterNode;
    private DefaultMutableTreeNode analysisNode;
    private DefaultMutableTreeNode scriptNode;
    private DefaultMutableTreeNode historyNode;
    private IViewer viewer;
    private IFramework framework = new FrameworkImpl();
    private MultipleArrayData data = new MultipleArrayData();
    private float[] sortedValues;
    private ActionManager manager;
    private int resultCount = 1;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository experimentClusterRepository;
    private ClusterTable geneClusterManager;
    private ClusterTable experimentClusterManager;
    private ScriptManager scriptManager;
    private HistoryViewer historyLog;
    private File currentAnalysisFile;
    private boolean modifiedResult = false;
    private CytoBandsModel cytoBandsModel;
    XMLDecoder ois;
    DataInputStream dis;
    boolean keepRunning = true;
    StateSavingProgressPanel progressPanel;
    SessionMetaData smd;
    public static String CURRENT_TEMP_DIR = "mev_temp";
    private GooseImpl gooseImpl = new GooseImpl();
    private static boolean firstLoad = true;
    private AnnotationDownloadHandler adh;

    public MultipleArrayViewer() {
        super(new JFrame("Multiple Array Viewer"));
        this.initSessionMetaData();
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, new String[0], TMEV.getGUIFactory());
        this.gooseImpl.setListener(eventListener);
        this.menubar = new MultipleArrayMenubar(this.manager);
        this.mainframe.setJMenuBar(this.menubar);
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.setMenubarDefaults();
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(150);
        this.systemDisable(1001);
        this.systemDisable(1003);
        if (TMEV.GAGGLE_CONNECT_ON_STARTUP) {
            this.gooseImpl.connectToGaggle();
        }
    }

    public MultipleArrayViewer(MultipleArrayData arrayData) {
        super(new JFrame("Multiple Array Viewer"));
        this.initSessionMetaData();
        if (TMEV.GAGGLE_CONNECT_ON_STARTUP) {
            this.gooseImpl.connectToGaggle();
        }
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, arrayData.getFieldNames(), TMEV.getGUIFactory());
        this.gooseImpl.setListener(eventListener);
        this.data = arrayData;
        this.menubar = new MultipleArrayMenubar(this.manager);
        this.menubar.addExperimentLabelMenuItems(arrayData.getSlideNameKeyVectorUnion());
        this.mainframe.setJMenuBar(this.menubar);
        this.setMenubarDefaults();
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        ((MultipleArrayCanvas)this.viewer).addSortMenuItems(arrayData.getFieldNames());
        Date date = new Date(System.currentTimeMillis());
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getDefault());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(format.format(date));
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.insertNodeInto(node, this.analysisNode, this.analysisNode.getChildCount());
        this.setNormalizedState(arrayData.getNormalizationState());
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(150);
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public MultipleArrayViewer(MultipleArrayData arrayData, MultipleArrayMenubar origMenubar) {
        super(new JFrame("Multiple Array Viewer"));
        this.initSessionMetaData();
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, arrayData.getFieldNames(), TMEV.getGUIFactory());
        this.gooseImpl.setListener(eventListener);
        this.data = arrayData;
        this.menubar = new MultipleArrayMenubar(origMenubar, this.manager);
        if (TMEV.GAGGLE_CONNECT_ON_STARTUP) {
            this.gooseImpl.connectToGaggle();
        }
        this.menubar.synchronizeSettings(origMenubar);
        this.menubar.addExperimentLabelMenuItems(arrayData.getSlideNameKeyVectorUnion());
        this.mainframe.setJMenuBar(this.menubar);
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        this.setMenubarDefaults();
        ((MultipleArrayCanvas)this.viewer).addSortMenuItems(arrayData.getFieldNames());
        Date date = new Date(System.currentTimeMillis());
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getDefault());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(format.format(date));
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.insertNodeInto(node, this.analysisNode, this.analysisNode.getChildCount());
        this.data.setUseMainData(true);
        ((LeafInfo)this.mainViewerNode.getUserObject()).setSelectedDataSource(true);
        this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
        this.tree.repaint();
        this.setNormalizedState(arrayData.getNormalizationState());
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(150);
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.systemEnable(1003);
        this.fireDataChanged();
        this.initMainViewAndClusterManager();
    }

    protected void setMenubarDefaults() {
        try {
            int height = new Integer(TMEV.getSettingForOption("last-selected-element-height"));
            int width = new Integer(TMEV.getSettingForOption("last-selected-element-width"));
            this.onElementSizeChanged(width, height);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.menubar.setUseDoubleGradient(new Boolean(TMEV.getSettingForOption("last-selected-color-scheme-double-gradient", "true")));
            Color positiveColor = new Color(new Integer(TMEV.getSettingForOption("last-selected-color-scheme-positive")));
            Color negativeColor = new Color(new Integer(TMEV.getSettingForOption("last-selected-color-scheme-negative")));
            Color neutralColor = new Color(new Integer(TMEV.getSettingForOption("last-selected-color-scheme-neutral")));
            this.menubar.setPositiveGradientImage(this.menubar.getDisplayMenu().createGradientImage(neutralColor, positiveColor));
            this.menubar.setNegativeGradientImage(this.menubar.getDisplayMenu().createGradientImage(negativeColor, neutralColor));
            this.menubar.setColorSchemeIndex(new Integer(TMEV.getSettingForOption("last-selected-color-scheme-index")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void systemDisable(int state) {
        this.menubar.systemDisable(state);
        this.toolbar.systemDisable(state);
    }

    @Override
    public void systemEnable(int state) {
        this.menubar.systemEnable(state);
        this.toolbar.systemEnable(state);
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return TMEV.getAlgorithmFactory();
    }

    public IData getData() {
        return this.data;
    }

    private void displaySlideElementInfo(int column, int row) {
        Manager.displaySlideElementInfo(this.mainframe, this.data, column, row);
    }

    public void saveAnalysisAs() {
        try {
            String dataPath = TMEV.getDataPath();
            File fileLoc = TMEV.getFile("data/");
            if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
                fileLoc = TMEV.getFile("data/");
            }
            final JFileChooser chooser = new JFileChooser(fileLoc);
            chooser.setFileView(new AnalysisFileView());
            chooser.setFileFilter(new AnalysisFileFilter());
            chooser.setApproveButtonText("Save");
            chooser.setDialogType(1);
            JPanel panel = new JPanel(new GridBagLayout());
            final JDialog dialog = new JDialog(this.getFrame(), "Save Dialog", true);
            chooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    if (cmd.equals("ApproveSelection")) {
                        File file = chooser.getSelectedFile();
                        try {
                            AnalysisFileFilter filter = new AnalysisFileFilter();
                            String ext = filter.getExtension(file);
                            if (ext == null) {
                                file = new File(file.getPath() + ".anl");
                            }
                            if (file.exists()) {
                                JOptionPane pane = new JOptionPane("File exists. Overwrite?");
                                Object[] options = new String[]{"Ok", "Cancel"};
                                pane.setOptions(options);
                                JDialog dialog2 = pane.createDialog(new JFrame(), "File Overwrite Warning.");
                                dialog2.setVisible(true);
                                if (!pane.getValue().equals("Ok")) {
                                    return;
                                }
                            }
                            dialog.dispose();
                            MultipleArrayViewer.this.saveState(file);
                            TMEV.setDataPath(file.getParentFile().getPath());
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(MultipleArrayViewer.this, "I/O Exception, Error saving analysis. File (" + (file != null ? file.getName() : "name unknown") + ")", "Save Analysis", 0);
                            ioe.printStackTrace();
                        }
                    } else if (dialog != null) {
                        dialog.dispose();
                    }
                }
            });
            JTextPane pane = new JTextPane();
            pane.setContentType("text/html");
            pane.setEditable(false);
            panel.add((Component)chooser, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            dialog.getContentPane().add(panel);
            dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setLocation((screenSize.width - dialog.getSize().width) / 2, (screenSize.height - dialog.getSize().height) / 2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAnalysis() {
        if (this.currentAnalysisFile != null) {
            try {
                this.saveState(this.currentAnalysisFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.saveAnalysisAs();
        }
    }

    public boolean keepSaving() {
        return this.keepRunning;
    }

    private void saveState(File file) throws FileNotFoundException, IOException {
        this.keepRunning = true;
        this.currentAnalysisFile = file;
        boolean debug = false;
        final File tempDir = File.createTempFile("mev_temp", "", null);
        if (!tempDir.delete()) {
            throw new IOException();
        }
        if (!tempDir.mkdir()) {
            throw new IOException();
        }
        CURRENT_TEMP_DIR = tempDir.getPath();
        File tmpXML = new File(tempDir, "mev_state.xml");
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpXML));
        final MavXMLEncoder oos = XMLEncoderFactory.getMAVEncoder(new MavXMLEncoder(os, this), this.tree);
        tempDir.deleteOnExit();
        tmpXML.deleteOnExit();
        oos.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exception) {
                try {
                    if (exception.toString().indexOf("Listener") == -1) {
                        PrintStream log = new PrintStream(new FileOutputStream(new File("saving.log"), false));
                        log.println(new Date());
                        exception.printStackTrace(log);
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Could not open save log file.");
                }
                catch (StackOverflowError soe) {
                    System.out.println("Stack overflow error");
                    soe.printStackTrace();
                    MultipleArrayViewer.this.progressPanel.dispose();
                }
            }
        });
        this.progressPanel = new StateSavingProgressPanel("Saving Current Analysis", this);
        this.progressPanel.setLocationRelativeTo(this.mainframe);
        this.progressPanel.setVisible(true);
        this.prepSessionMetaData(this.smd.getMevSessionPrefs());
        Thread thread = new Thread(new Runnable(){

            private void cancelSave() {
                MultipleArrayViewer.this.currentAnalysisFile.delete();
                tempDir.delete();
                MultipleArrayViewer.this.progressPanel.dispose();
                MultipleArrayViewer.this.modifiedResult = false;
            }

            @Override
            public void run() {
                try {
                    MultipleArrayViewer.this.setCursor(new Cursor(3));
                    MultipleArrayViewer.this.progressPanel.update("Writing Metadata");
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(true);
                    oos.writeObject(MultipleArrayViewer.this.smd);
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelSave();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Writing Intensities");
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(true);
                    oos.writeObject(MultipleArrayViewer.this.data);
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelSave();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Writing Clusters");
                    MultipleArrayViewer.this.saveClusterRepositories(oos);
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelSave();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Writing Analysis Results");
                    oos.writeObject(MultipleArrayViewer.this.tree.getAnalysisNode());
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelSave();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Writing History");
                    oos.writeObject(MultipleArrayViewer.this.historyNode);
                    oos.flush();
                    oos.close();
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(false);
                    MultipleArrayViewer.this.progressPanel.update("Compressing Data");
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(MultipleArrayViewer.this.currentAnalysisFile));
                    MultipleArrayViewer.this.zipTempFiles(zos, tempDir.getPath(), tempDir);
                    zos.close();
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelSave();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Cleaning Up");
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(false);
                    String[] files = tempDir.list();
                    for (int i = 0; i < files.length; ++i) {
                        File aFile = new File(tempDir, files[i]);
                        aFile.deleteOnExit();
                        if (aFile.delete()) continue;
                        System.out.println("Couldn't delete " + aFile.getPath());
                    }
                    if (!tempDir.delete()) {
                        // empty if block
                    }
                    MultipleArrayViewer.this.progressPanel.dispose();
                    MultipleArrayViewer.this.modifiedResult = false;
                }
                catch (IOException ioe) {
                    MultipleArrayViewer.this.setCursor(0);
                    JOptionPane.showMessageDialog(MultipleArrayViewer.this, "Analysis was not saved.  Error writing output file.", "Save Error", 2);
                    ioe.printStackTrace();
                    TMEV.activeSave = false;
                }
            }
        });
        thread.setPriority(5);
        thread.start();
    }

    private void zipTempFiles(ZipOutputStream zos, String tempFilePath, File tempDir) throws IOException {
        byte[] buf = new byte[1024];
        String[] fileNames = tempDir.list();
        this.progressPanel.setMaximum(fileNames.length);
        for (int i = 0; i < fileNames.length; ++i) {
            int len;
            File aFile = new File(tempFilePath, fileNames[i]);
            ZipEntry entry = new ZipEntry(aFile.getName());
            zos.putNextEntry(entry);
            FileInputStream fis = new FileInputStream(aFile);
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            fis.close();
            this.progressPanel.increment();
        }
    }

    public void cancelLoadState() {
        this.keepRunning = false;
    }

    private void cleanUp() {
        this.data = new MultipleArrayData();
        this.analysisNode.removeAllChildren();
        this.geneClusterRepository = null;
        this.experimentClusterRepository = null;
        this.clusterNode.removeAllChildren();
        this.experimentClusterManager = null;
        this.fireMenuChanged();
        this.fireDataChanged();
        this.fireHeaderChanged();
        this.progressPanel.dispose();
    }

    private void loadHistoryNode(DefaultMutableTreeNode d) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode node = d;
        if (node != null) {
            this.tree.removeNode(this.historyNode);
            this.historyNode = node;
            this.tree.insertNode(this.historyNode, this.tree.getRoot(), this.tree.getRoot().getChildCount());
            this.historyNode = node;
            this.historyLog = (HistoryViewer)((LeafInfo)((DefaultMutableTreeNode)this.historyNode.getChildAt(0)).getUserObject()).getViewer();
        }
    }

    private void initializeCGH() {
        if (this.data.isCGHData()) {
            this.data.setChromosomeIndices(CGHStanfordFileLoader.calculateChromosomeIndices(this.data.getClones()));
            this.data.setHasDyeSwap(this.data.isHasDyeSwap());
            this.loadCytoBandFile();
            this.manager.initCghAnalysiActions(new CGHAlgorithmFactory());
            this.menubar.addCGHMenus();
            this.mainframe.validate();
        }
    }

    private void initializeCGHViews() {
        this.ExperimentsLoaded();
        this.onFlankingRegionDeterminationChanged();
    }

    private void createCGHAnalysisNodes() {
        if (this.analysisNode == null) {
            return;
        }
        float ampThresh_T = 0.0f;
        float delThresh_T = 0.0f;
        float ampThresh2Copy_T = 0.0f;
        float delThresh2Copy_T = 0.0f;
        Vector<String> extraParam = null;
        int index = -1;
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        float ampThresh = menu.getAmpThresh();
        float delThresh = menu.getDelThresh();
        float ampThresh2Copy = menu.getAmpThresh2Copy();
        float delThresh2Copy = menu.getDelThresh2Copy();
        int childCount = this.analysisNode.getChildCount();
        String algName = "";
        String trimName = "";
        for (int i = 0; i < childCount; ++i) {
            index = -1;
            ampThresh_T = 0.0f;
            delThresh_T = 0.0f;
            ampThresh2Copy_T = 0.0f;
            delThresh2Copy_T = 0.0f;
            DefaultMutableTreeNode analysisRoot = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            Object object = analysisRoot.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                algName = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                algName = (String)object;
            }
            trimName = this.getCGHAlgoNameWihtoutIndex(algName);
            if (trimName != null) {
                index = this.findCGHAlgoIndexFromFactory(trimName);
            }
            if (index == -1) continue;
            extraParam = new Vector<String>();
            Enumeration<TreeNode> treeEnum = analysisRoot.depthFirstEnumeration();
            while (treeEnum.hasMoreElements()) {
                boolean notFloat;
                float floatVal;
                String nodeSubStr;
                block14: {
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)treeEnum.nextElement();
                    if (currentNode.getUserObject() instanceof LeafInfo) {
                        System.out.print("\t");
                        continue;
                    }
                    if (!(currentNode.getUserObject() instanceof String)) continue;
                    System.out.print("\t");
                    String nodeStr = (String)currentNode.getUserObject();
                    int i_T = nodeStr.lastIndexOf(":");
                    if (i_T == -1) continue;
                    nodeSubStr = nodeStr.substring(0, i_T);
                    floatVal = 0.0f;
                    notFloat = false;
                    try {
                        floatVal = Float.parseFloat(nodeStr.substring(i_T + 1, nodeStr.length()).trim());
                    }
                    catch (NumberFormatException ne) {
                        System.out.println("File Name or InValid parameter");
                        notFloat = true;
                        if (index != 8 && index != 9) break block14;
                        extraParam.add(nodeStr.substring(i_T + 1, nodeStr.length()).trim());
                    }
                }
                if (notFloat) continue;
                if (nodeSubStr.equals("Amplification Threshold")) {
                    ampThresh_T = floatVal;
                    continue;
                }
                if (nodeSubStr.equals("Deletion Threshold")) {
                    delThresh_T = floatVal;
                    continue;
                }
                if (nodeSubStr.equals("Amplification 2 Copy Threshold")) {
                    ampThresh2Copy_T = floatVal;
                    continue;
                }
                if (!nodeSubStr.equals("Deletion 2 Copy Threshold")) continue;
                delThresh2Copy_T = floatVal;
            }
            menu.setAmpThresh(ampThresh_T);
            menu.setDelThresh(delThresh_T);
            menu.setAmpThresh2Copy(ampThresh2Copy_T);
            menu.setDelThresh2Copy(delThresh2Copy_T);
            this.data.onCopyDeterminationChanged(menu);
            Action action = this.manager.getAction("cgh-analysis-action" + String.valueOf(index));
            if (index == 4 || index == 5 || index == 6 || index == 7 || index == 8) {
                this.onFlankingRegionDeterminationChanged();
            }
            this.runCghAnalysis(action, algName, i, extraParam);
            menu.setAmpThresh(ampThresh);
            menu.setDelThresh(delThresh);
            menu.setAmpThresh2Copy(ampThresh2Copy);
            menu.setDelThresh2Copy(delThresh2Copy);
            this.data.onCopyDeterminationChanged(menu);
            this.removeCGHAnalysisNode(analysisRoot);
        }
    }

    private String getCGHAlgoNameWihtoutIndex(String name) {
        int last_Ind = name.lastIndexOf("(");
        if (last_Ind == -1) {
            return null;
        }
        return name.substring(0, last_Ind - 1).trim();
    }

    private int findCGHAlgoIndexFromFactory(String name) {
        String[] algNames = CGHAlgorithmFactory.getAlgorithimNames();
        for (int i = 0; i < algNames.length; ++i) {
            if (name.equals("ChARM")) {
                return -1;
            }
            if (!name.equals(algNames[i])) continue;
            return i;
        }
        if (name.equals("GeneAlterations")) {
            return 8;
        }
        return -1;
    }

    private String removeCGHAnalysisNode(DefaultMutableTreeNode node) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        TreePath parentPath = new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath());
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
        this.tree.getSelectionModel().setSelectionPath(parentPath);
        this.tree.scrollPathToVisible(parentPath);
        String nodeName = " ";
        Object object = node.getUserObject();
        if (object instanceof LeafInfo) {
            nodeName = ((LeafInfo)object).toString();
        } else if (object instanceof String) {
            nodeName = (String)object;
        }
        return nodeName;
    }

    public synchronized void insertAnalysisResult(DefaultMutableTreeNode node, String nodeTitle, int location) {
        if (node == null) {
            return;
        }
        this.modifiedResult = true;
        node.setUserObject(nodeTitle);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.insertNodeInto(node, this.analysisNode, location);
        TreeSelectionModel selModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(node.getPath());
        selModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        JScrollBar bar = this.treeScrollPane.getHorizontalScrollBar();
        if (bar != null) {
            bar.setValue(0);
        }
    }

    private void runCghAnalysis(Action action, String nodeName, int location, Vector paramBuff) {
        DefaultMutableTreeNode result = null;
        String className = (String)action.getValue("command-parameter");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(className, true, cl);
            NumberOfAlterationsCalculator gui = (NumberOfAlterationsCalculator)clazz.newInstance();
            if (gui instanceof LoadGeneList) {
                File file = new File((String)paramBuff.get(0));
                result = ((LoadGeneList)gui).execute(this.framework, file);
            } else if (gui instanceof CompareExperiments) {
                int[] indices = new int[]{this.getSampleIndex((String)paramBuff.get(0)), this.getSampleIndex((String)paramBuff.get(1))};
                System.out.println("Exprs: " + (String)paramBuff.get(0) + " " + (String)paramBuff.get(1));
                System.out.println("Indices: " + indices[0] + " " + indices[1]);
                result = ((CompareExperiments)gui).execute(this.framework, indices);
            } else {
                result = gui.execute(this.framework);
            }
            this.insertAnalysisResult(result, nodeName, location);
        }
        catch (ClassCastException e) {
            System.out.println("Error: org.tigr.microarray.mev.cluster.gui.IClusterGUI interface is expected.");
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
    }

    private int getSampleIndex(String sampleName) {
        if (this.data == null) {
            return -1;
        }
        ArrayList featuresList = this.data.getFeaturesList();
        for (int i = 0; i < featuresList.size(); ++i) {
            if (!((ISlideData)featuresList.get(i)).getSlideDataName().equals(sampleName)) continue;
            return i;
        }
        return -1;
    }

    private void saveClusterRepositories(XMLEncoder oos) throws IOException {
        if (this.geneClusterRepository == null) {
            Boolean isGeneClusterRepository = new Boolean(false);
            oos.writeObject(isGeneClusterRepository);
        } else {
            Boolean isGeneClusterRepository = new Boolean(true);
            oos.writeObject(isGeneClusterRepository);
            oos.writeObject(this.geneClusterRepository);
        }
        if (this.experimentClusterRepository == null) {
            Boolean isExperimentClusterRepository = new Boolean(false);
            oos.writeObject(isExperimentClusterRepository);
        } else {
            Boolean isExperimentClusterRepository = new Boolean(true);
            oos.writeObject(isExperimentClusterRepository);
            oos.writeObject(this.experimentClusterRepository);
        }
    }

    private void loadAnalysisFromFile(final File file) throws IOException, ClassNotFoundException {
        this.keepRunning = true;
        this.progressPanel = new StateSavingProgressPanel("Loading Saved Analysis", this);
        this.progressPanel.setLocationRelativeTo(this.mainframe);
        this.progressPanel.setVisible(true);
        File tempDir = File.createTempFile("mev_temp", "", null);
        if (!tempDir.delete()) {
            throw new IOException();
        }
        if (!tempDir.mkdir()) {
            throw new IOException();
        }
        CURRENT_TEMP_DIR = tempDir.getPath();
        Thread thread = new Thread(new Runnable(){

            private void cancelLoad() {
                MultipleArrayViewer.this.cleanUp();
            }

            @Override
            public void run() {
                try {
                    ZipEntry entry;
                    File unzipDir = new File(CURRENT_TEMP_DIR);
                    ZipFile zipFile = new ZipFile(file);
                    ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
                    File tmpXML = new File(unzipDir, "mev_state.xml");
                    tmpXML.deleteOnExit();
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Uncompressing Data");
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(false);
                    MultipleArrayViewer.this.progressPanel.setMaximum(zipFile.size());
                    byte[] buf = new byte[1024];
                    while ((entry = zis.getNextEntry()) != null) {
                        int len;
                        if (entry.getName().endsWith(".xml")) {
                            InputStreamReader isr = new InputStreamReader(zis);
                            FileWriter fw = new FileWriter(tmpXML);
                            while ((len = isr.read()) != -1) {
                                fw.write(len);
                            }
                            fw.close();
                        } else {
                            File outFile = new File(unzipDir, entry.getName());
                            DataOutputStream dos = new DataOutputStream(new FileOutputStream(outFile));
                            while ((len = zis.read(buf)) > 0) {
                                dos.write(buf, 0, len);
                            }
                            dos.close();
                        }
                        zis.closeEntry();
                        MultipleArrayViewer.this.progressPanel.increment();
                    }
                    zis.close();
                    zipFile.close();
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    BufferedInputStream ois = new BufferedInputStream(new FileInputStream(tmpXML));
                    XMLDecoder xmld = new XMLDecoder(ois);
                    MultipleArrayViewer.this.progressPanel.update("Loading Metadata");
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(true);
                    MultipleArrayViewer.this.smd = (SessionMetaData)xmld.readObject();
                    MultipleArrayViewer.this.processMeVPrefs(MultipleArrayViewer.this.smd.getMevSessionPrefs());
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Loading Experiment Data");
                    MultipleArrayViewer.this.data = (MultipleArrayData)xmld.readObject();
                    int data_type = MultipleArrayViewer.this.data.getDataType();
                    if (data_type != 0 || data_type != 1) {
                        TMEV.setDataType(2);
                    }
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    if (MultipleArrayViewer.this.data.isCGHData()) {
                        MultipleArrayViewer.this.initializeCGH();
                    }
                    MultipleArrayViewer.this.progressPanel.update("Loading Clusters");
                    if (((Boolean)xmld.readObject()).booleanValue()) {
                        MultipleArrayViewer.this.geneClusterRepository = (ClusterRepository)xmld.readObject();
                        MultipleArrayViewer.this.data.setGeneClusterRepository(MultipleArrayViewer.this.geneClusterRepository);
                        MultipleArrayViewer.this.geneClusterRepository.setFramework(MultipleArrayViewer.this.framework);
                        MultipleArrayViewer.this.geneClusterManager = new ClusterTable(MultipleArrayViewer.this.geneClusterRepository, MultipleArrayViewer.this.framework);
                        DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)MultipleArrayViewer.this.geneClusterManager), false);
                        MultipleArrayViewer.this.addNode(MultipleArrayViewer.this.clusterNode, genesNode);
                    }
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    if (((Boolean)xmld.readObject()).booleanValue()) {
                        MultipleArrayViewer.this.experimentClusterRepository = (ClusterRepository)xmld.readObject();
                        MultipleArrayViewer.this.data.setExperimentClusterRepository(MultipleArrayViewer.this.experimentClusterRepository);
                        MultipleArrayViewer.this.experimentClusterRepository.setFramework(MultipleArrayViewer.this.framework);
                        MultipleArrayViewer.this.experimentClusterManager = new ClusterTable(MultipleArrayViewer.this.experimentClusterRepository, MultipleArrayViewer.this.framework);
                        DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)MultipleArrayViewer.this.experimentClusterManager), false);
                        MultipleArrayViewer.this.addNode(MultipleArrayViewer.this.clusterNode, experimentNode);
                    }
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.progressPanel.update("Loading Analysis Results");
                    int location = MultipleArrayViewer.this.tree.getModel().getIndexOfChild(MultipleArrayViewer.this.tree.getRoot(), MultipleArrayViewer.this.analysisNode);
                    MultipleArrayViewer.this.tree.removeNode(MultipleArrayViewer.this.analysisNode);
                    MultipleArrayViewer.this.analysisNode = (DefaultMutableTreeNode)xmld.readObject();
                    MultipleArrayViewer.this.tree.insertNode(MultipleArrayViewer.this.analysisNode, MultipleArrayViewer.this.tree.getRoot(), location);
                    MultipleArrayViewer.this.tree.setAnalysisNode(MultipleArrayViewer.this.analysisNode);
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.loadHistoryNode((DefaultMutableTreeNode)xmld.readObject());
                    if (MultipleArrayViewer.this.data.isCGHData()) {
                        MultipleArrayViewer.this.initializeCGH();
                    }
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.data.updateSpotColors();
                    MultipleArrayViewer.this.data.updateExperimentColors();
                    MultipleArrayViewer.this.menubar.replaceExperimentLabelMenuItems(MultipleArrayViewer.this.data.getSlideNameKeyArray());
                    MultipleArrayViewer.this.data.setSampleLabelKey("Default Slide Name");
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.menubar.replaceLabelMenuItems(MultipleArrayViewer.this.data.getFieldNames());
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.menubar.replaceSortMenuItems(MultipleArrayViewer.this.data.getFieldNames());
                    if (MultipleArrayViewer.this.data.isCGHData()) {
                        MultipleArrayViewer.this.createCGHAnalysisNodes();
                        MultipleArrayViewer.this.initializeCGHViews();
                    }
                    if (!MultipleArrayViewer.this.keepSaving()) {
                        this.cancelLoad();
                        return;
                    }
                    MultipleArrayViewer.this.setMaxCY3AndCY5();
                    MultipleArrayViewer.this.systemEnable(1003);
                    MultipleArrayViewer.this.fireMenuChanged();
                    MultipleArrayViewer.this.fireDataChanged();
                    MultipleArrayViewer.this.fireHeaderChanged();
                    MultipleArrayViewer.this.initMainViewAndClusterManager();
                    Date date = new Date(System.currentTimeMillis());
                    DateFormat format = DateFormat.getDateTimeInstance();
                    format.setTimeZone(TimeZone.getDefault());
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(format.format(date));
                    DefaultTreeModel treeModel = (DefaultTreeModel)MultipleArrayViewer.this.tree.getModel();
                    treeModel.insertNodeInto(node, MultipleArrayViewer.this.analysisNode, MultipleArrayViewer.this.analysisNode.getChildCount());
                    TreePath path = new TreePath(((DefaultTreeModel)MultipleArrayViewer.this.tree.getModel()).getPathToRoot(MultipleArrayViewer.this.analysisNode));
                    MultipleArrayViewer.this.tree.expandPath(path);
                    path = new TreePath(((DefaultTreeModel)MultipleArrayViewer.this.tree.getModel()).getPathToRoot(MultipleArrayViewer.this.historyNode));
                    MultipleArrayViewer.this.tree.expandPath(path);
                    MultipleArrayViewer.this.menubar.systemEnable(101);
                    if (TMEV.getDataType() == 2) {
                        MultipleArrayViewer.this.menubar.addAffyFilterMenuItems();
                    }
                    MultipleArrayViewer.this.menubar.systemEnable(101);
                    if (TMEV.getDataType() == 2) {
                        MultipleArrayViewer.this.menubar.addAffyFilterMenuItems();
                    }
                    MultipleArrayViewer.this.progressPanel.setIndeterminate(false);
                    ((HistoryViewer)((LeafInfo)((DefaultMutableTreeNode)MultipleArrayViewer.this.historyNode.getChildAt(0)).getUserObject()).getViewer()).addHistory("Load analysis: " + MultipleArrayViewer.this.currentAnalysisFile);
                    ois.close();
                    xmld.close();
                    MultipleArrayViewer.this.currentAnalysisFile = file;
                    TMEV.setDataPath(file.getParentFile().getPath());
                    String[] files = unzipDir.list();
                    for (int i = 0; i < files.length; ++i) {
                        if (new File(unzipDir, files[i]).delete()) continue;
                    }
                    if (!unzipDir.delete()) {
                        // empty if block
                    }
                    ((HistoryViewer)((LeafInfo)((DefaultMutableTreeNode)MultipleArrayViewer.this.historyNode.getChildAt(0)).getUserObject()).getViewer()).addHistory("Load analysis: " + file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MultipleArrayViewer.this.cleanUp();
                    JOptionPane.showMessageDialog(MultipleArrayViewer.this, "Analysis was not loaded.  Error reading input file.", "Load Analysis Error", 2);
                    System.out.println(e.getMessage());
                }
                MultipleArrayViewer.this.progressPanel.dispose();
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    private void prepSessionMetaData(MEVSessionPrefs msp) {
        try {
            msp.setMaxRatioScale(this.menubar.getDisplayMenu().getMaxRatioScale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setMinRatioScale(this.menubar.getDisplayMenu().getMinRatioScale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setMidRatioScale(this.menubar.getDisplayMenu().getMidRatioValue());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setMaxCY3(this.menubar.getDisplayMenu().getMaxCY3Scale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setMaxCY5(this.menubar.getDisplayMenu().getMaxCY5Scale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setColorGradientState(this.menubar.getDisplayMenu().getColorGradientState());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setColorScheme(this.menubar.getColorScheme());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setPositiveGradientImageWrapper(new BufferedImageWrapper(this.menubar.getDisplayMenu().getPositiveGradientImage()));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setNegativeGradientImageWrapper(new BufferedImageWrapper(this.menubar.getDisplayMenu().getNegativeGradientImage()));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            msp.setElementSize(this.menubar.getDisplayMenu().getElementSize());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    private void processMeVPrefs(MEVSessionPrefs msp) {
        try {
            this.menubar.setMaxRatioScale(msp.getMaxRatioScale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setMidRatioValue(msp.getMidRatioScale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setMinRatioScale(msp.getMinRatioScale());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setMaxCY3Scale(msp.getMaxCY3());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setMaxCY5Scale(msp.getMaxCY5());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setColorGradientState(msp.isColorGradientState());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setColorSchemeIndex(msp.getColorScheme());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setPositiveGradientImage(msp.getPositiveGradientImageWrapper().getBufferedImage());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setNegativeGradientImage(msp.getNegativeGradientImageWrapper().getBufferedImage());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            this.menubar.setElementSize(msp.getElementSize().width, msp.getElementSize().height);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    private void loadAnalysis() {
        String dataPath = TMEV.getDataPath();
        File pathFile = TMEV.getFile("data/");
        if (dataPath != null && !(pathFile = new File(dataPath)).exists()) {
            pathFile = TMEV.getFile("data/");
        }
        try {
            JFileChooser chooser = new JFileChooser(pathFile);
            chooser.setFileView(new AnalysisFileView());
            chooser.setFileFilter(new AnalysisFileFilter());
            if (chooser.showOpenDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                this.loadAnalysisFromFile(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onNewScript() {
        if (this.scriptManager == null) {
            this.scriptManager = new ScriptManager(this.framework, this.scriptNode, this.manager);
        }
        this.scriptManager.addNewScript();
    }

    private void onLoadScript() {
        if (this.scriptManager == null) {
            this.scriptManager = new ScriptManager(this.framework, this.scriptNode, this.manager);
        }
        this.scriptManager.loadScript();
    }

    private String getStatusText() {
        if (this.statusLabel == null) {
            return " ";
        }
        return this.statusLabel.getText();
    }

    private void setStatusText(String text) {
        this.statusLabel.setText(text);
    }

    private Object getUserObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object leaf = node.getUserObject();
        if (!(leaf instanceof LeafInfo)) {
            return null;
        }
        return ((LeafInfo)leaf).getUserObject();
    }

    @Override
    public JFrame getFrame() {
        return this.mainframe;
    }

    public void setContentLocation(int x, int y) {
        Dimension viewSize = this.viewScrollPane.getViewport().getViewSize();
        Dimension extSize = this.viewScrollPane.getViewport().getExtentSize();
        if (extSize.height + y > viewSize.height) {
            y = viewSize.height - extSize.height;
        }
        this.viewScrollPane.getViewport().setViewPosition(new Point(x, y));
    }

    private JScrollPane createTreeScrollPane(EventListener listener) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("MultipleExperimentViewer");
        this.viewer = new MultipleArrayCanvas(this.framework, new Insets(0, 10, 0, 20));
        LeafInfo mainViewLeafInfo = new LeafInfo("Original Data", this.viewer);
        this.mainViewerNode = new DefaultMutableTreeNode(mainViewLeafInfo, true);
        root.add(this.mainViewerNode);
        this.clusterNode = new DefaultMutableTreeNode(new LeafInfo("Cluster Manager"));
        root.add(this.clusterNode);
        this.analysisNode = new DefaultMutableTreeNode(new LeafInfo("Analysis Results"));
        root.add(this.analysisNode);
        this.scriptNode = new DefaultMutableTreeNode(new LeafInfo("Script Manager"));
        root.add(this.scriptNode);
        this.historyNode = new DefaultMutableTreeNode(new LeafInfo("History"));
        root.add(this.historyNode);
        this.historyLog = new HistoryViewer();
        this.historyNode.add(new DefaultMutableTreeNode(new LeafInfo("History Log", (IViewer)this.historyLog)));
        this.tree = new ResultTree(root);
        this.tree.setAnalysisNode(this.analysisNode);
        this.tree.addTreeSelectionListener(listener);
        this.tree.addMouseListener(listener);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectionPath(new TreePath(this.mainViewerNode.getPath()));
        this.tree.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        return new JScrollPane(this.tree);
    }

    private JScrollPane createViewScrollPane(EventListener listener) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setScrollMode(0);
        KeyStroke up = KeyStroke.getKeyStroke(38, 0);
        KeyStroke down = KeyStroke.getKeyStroke(40, 0);
        KeyStroke pgup = KeyStroke.getKeyStroke(33, 0);
        KeyStroke pgdown = KeyStroke.getKeyStroke(34, 0);
        scrollPane.registerKeyboardAction(listener, "lineup", up, 2);
        scrollPane.registerKeyboardAction(listener, "linedown", down, 2);
        scrollPane.registerKeyboardAction(listener, "pageup", pgup, 2);
        scrollPane.registerKeyboardAction(listener, "pagedown", pgdown, 2);
        return scrollPane;
    }

    private void setCurrentViewer(IViewer viewer) {
        if (viewer == null) {
            return;
        }
        if (viewer.getContentComponent() == null) {
            viewer.onSelected(this.framework);
            return;
        }
        if (this.viewer != null) {
            this.viewer.onDeselected();
        }
        this.viewer = viewer;
        if (this.viewer instanceof CGHPositionGraphViewer || this.viewer instanceof NMFPlotViewer) {
            this.viewer.onSelected(this.framework);
        }
        this.viewScrollPane.setViewportView(this.viewer.getContentComponent());
        JComponent header = viewer.getHeaderComponent();
        if (header != null) {
            this.viewScrollPane.setColumnHeaderView(header);
        } else {
            this.viewScrollPane.setColumnHeader(null);
        }
        JComponent rowHeader = viewer.getRowHeaderComponent();
        if (rowHeader != null) {
            this.viewScrollPane.setRowHeaderView(rowHeader);
        } else {
            this.viewScrollPane.setRowHeader(null);
        }
        JComponent cornerComponent = viewer.getCornerComponent(0);
        if (cornerComponent != null) {
            this.viewScrollPane.setCorner("UPPER_LEFT_CORNER", cornerComponent);
        }
        if ((cornerComponent = viewer.getCornerComponent(1)) != null) {
            this.viewScrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
        }
        if ((cornerComponent = viewer.getCornerComponent(2)) != null) {
            this.viewScrollPane.setCorner("LOWER_LEFT_CORNER", cornerComponent);
        }
        if (!(this.viewer instanceof CGHPositionGraphViewer)) {
            this.viewer.onSelected(this.framework);
        }
    }

    private IViewer getCurrentViewer() {
        return this.viewer;
    }

    private void fireOnCloseEvent(DefaultMutableTreeNode node) {
        LeafInfo leafInfo;
        IViewer viewer;
        Object userObject = node.getUserObject();
        if (userObject instanceof LeafInfo && (viewer = (leafInfo = (LeafInfo)userObject).getViewer()) != null) {
            viewer.onClosed();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.fireOnCloseEvent((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void onClose() {
        this.onSaveCheck();
        this.addHistory("Close Viewer");
        TMEV.setDataType(1);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        this.fireOnCloseEvent((DefaultMutableTreeNode)model.getRoot());
        this.gooseImpl.disconnectFromGaggle();
        this.mainframe.dispose();
        Manager.removeComponent(this);
    }

    private void onSaveCheck() {
        if (this.modifiedResult && this.data != null && TMEV.permitSavePrompt) {
            AnalysisSaveDialog dialog = new AnalysisSaveDialog(this.getFrame());
            int result = dialog.showModal();
            boolean permitSave = dialog.askAgain();
            if (result == 0) {
                this.saveAnalysisAs();
            }
            if (TMEV.permitSavePrompt != permitSave) {
                TMEV.setPermitPrompt(permitSave);
            }
        }
    }

    private BufferedImage createDefaultImage(IViewer viewer) {
        JComponent content = viewer.getContentComponent();
        JComponent header = viewer.getHeaderComponent();
        int width = content.getWidth();
        int height = content.getHeight();
        if (header != null) {
            width = Math.max(width, header.getWidth());
            height += header.getHeight();
        }
        BufferedImage image = null;
        try {
            image = new BufferedImage(width, height, 5);
        }
        catch (Error e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Can not save image!\n Image size is " + width + "x" + height, e.toString(), 0);
            System.out.println("Image saving failed...");
            throw e;
        }
        Graphics2D g = image.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        if (header != null) {
            int headerHeight = header.getHeight();
            g.setClip(0, 0, width, headerHeight);
            header.paint(g);
            g.translate(0, headerHeight);
            g.setClip(0, 0, width, height - headerHeight);
        } else {
            g.setClip(0, 0, width, height);
        }
        content.paint(g);
        return image;
    }

    private void onSaveImage() {
        String dataPath = TMEV.getDataPath();
        File fileLoc = TMEV.getFile("data/");
        if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
            fileLoc = TMEV.getFile("data/");
        }
        JFileChooser chooser = new JFileChooser(fileLoc);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter((FileFilter)new BMPFileFilter());
        chooser.addChoosableFileFilter((FileFilter)new JPGFileFilter());
        chooser.addChoosableFileFilter((FileFilter)new PNGFileFilter());
        chooser.addChoosableFileFilter((FileFilter)new TIFFFileFilter());
        chooser.setDialogType(1);
        int chooserState = chooser.showSaveDialog(this.getFrame());
        if (chooserState == 0) {
            IViewer viewer = this.getCurrentViewer();
            BufferedImage image = viewer.getImage();
            if (image == null) {
                image = this.createDefaultImage(viewer);
            }
            final File fFile = chooser.getSelectedFile();
            final BufferedImage fImage = image;
            final String fFormat = ((ImageFileFilter)chooser.getFileFilter()).getFileFormat();
            final ImageEncodeParam fParam = ((ImageFileFilter)chooser.getFileFilter()).getImageEncodeParam();
            try {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        JAI.create((String)"filestore", (RenderedImage)fImage, (Object)fFile.getPath(), (Object)fFormat, (Object)fParam);
                        Manager.message(MultipleArrayViewer.this.getFrame(), "Image saved: " + fFile.getPath());
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            catch (Exception e) {
                Manager.message(this.getFrame(), e);
            }
        }
    }

    private void onLoadFile() {
        try {
            ISlideData slideData = this.loadSlideData(this.data.getSlideMetaData());
            if (slideData != null) {
                this.addFeature(slideData);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Load File Error", e);
        }
    }

    private void onLoadCluster() {
        this.loadFromStanfordFile("Select a Cluster File to Open");
    }

    private void onLoadStanford() {
        this.loadFromStanfordFile("Select a Stanford File to Open");
    }

    private void onLoadDatabase() {
        SetDatabaseDialog sdd = new SetDatabaseDialog(this.getFrame());
        if (sdd.showModal() != 0) {
            return;
        }
        String database = sdd.getDatabase();
        String[] files = new String[]{"L4A1", "L4A2", "L4A3"};
        SetSlideFilenameDialog ssfd = new SetSlideFilenameDialog((Frame)this.getFrame(), files);
        if (ssfd.showModal() != 0) {
            return;
        }
        String filename = ssfd.getFileName();
    }

    private void loadFromStanfordFile(String title) {
        try {
            ISlideData[] slideData = super.loadStanfordFile(title);
            if (slideData != null) {
                this.addFeatures(slideData);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Load Data Error", e);
        }
    }

    private void onLoadDirectory() {
        try {
            ISlideData[] slideData = this.loadDirectory(this.data.getSlideMetaData());
            if (slideData != null) {
                this.addFeatures(slideData);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Load Directory Error", e);
        }
    }

    private void setMaxCY3AndCY5() {
        this.menubar.setMaxCY3Scale(this.data.getMaxCY3());
        this.menubar.setMaxCY5Scale(this.data.getMaxCY5());
    }

    private void onLabelChanged(Action action) {
        String index = (String)action.getValue("command-parameter");
        this.menubar.setLabelIndex(Integer.parseInt(index));
        this.fireMenuChanged();
    }

    private void onExperimentLabelChanged(Action action) {
        String key = (String)action.getValue("command-parameter");
        this.data.setSampleLabelKey(key);
        this.fireMenuChanged();
    }

    private void onChangeGaggleTarget(Action action) {
        String key = (String)action.getValue("command-parameter");
        this.gooseImpl.setTargetGoose(key);
        this.fireMenuChanged();
    }

    private void onShowGoose(Action action) {
        String key = (String)action.getValue("command-parameter");
        try {
            this.gooseImpl.show(key);
            this.fireMenuChanged();
        }
        catch (RemoteException re) {
            System.err.println("Couldn't show Goose " + key);
        }
    }

    private void onIDFFieldsAdded() {
        boolean safeToReorderExperiments = false;
        if (this.data.getIDFObject() != null) {
            IDFEditor editor = new IDFEditor(this.getFrame(), "IDF File Editor", true, safeToReorderExperiments, this.data);
            editor.showModal();
            String[][] data = editor.getLabelDataWithoutKeys();
            String[] keyes = editor.getLabelKeys();
            Hashtable temp = new Hashtable();
            for (int index = 0; index < keyes.length; ++index) {
                ArrayList<String> l = new ArrayList<String>();
                for (int j = 0; j < data[index].length; ++j) {
                    l.add(data[index][j]);
                }
                temp.put(keyes[index], l);
            }
            this.data.getIDFObject().setIDFHash(temp);
            this.fireDataChanged();
        } else {
            JOptionPane.showMessageDialog(null, "You do not seem to have loaded an IDF file.", "IDF Warning", 1);
        }
    }

    private void onExperimentLabelAdded() {
        boolean safeToReorderExperiments = false;
        safeToReorderExperiments = this.resultCount < 2 && this.geneClusterRepository == null && this.experimentClusterRepository == null;
        Vector featureAttributes = this.data.getSlideNameKeyVectorUnion();
        ExperimentLabelEditor editor = new ExperimentLabelEditor(this.getFrame(), featureAttributes, this.data, safeToReorderExperiments);
        if (editor.showModal() != 0) {
            return;
        }
        String[][] data = editor.getLabelDataWithoutKeys();
        String[] keys = editor.getLabelKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.data.addNewExperimentLabel(keys[i], data[i]);
        }
        this.menubar.replaceExperimentLabelMenuItems(keys);
        if (safeToReorderExperiments && editor.isReorderedSelected()) {
            int[] order = editor.getNewOrderScheme();
            ArrayList<ISlideData> featuresList = new ArrayList<ISlideData>(order.length);
            for (int i = 0; i < order.length; ++i) {
                featuresList.add(this.data.getFeature(order[i]));
            }
            this.data.setFeaturesList(featuresList);
        }
        this.fireDataChanged();
    }

    private void addFeature(ISlideData slideData) {
        this.data.addFeature(slideData);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    private void addFeatures(ISlideData[] slideData) {
        this.data.addFeatures(slideData);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public void fireDataChanged() {
        IViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return;
        }
        viewer.onDataChanged((IData)this.data);
        this.doViewLayout();
    }

    private void fireMenuChanged() {
        IViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return;
        }
        if (viewer instanceof ICGHViewer) {
            ((ICGHViewer)viewer).onMenuChanged(this.menubar.getCghDisplayMenu());
            ((ICGHViewer)viewer).onMenuChanged(this.menubar.getDisplayMenu());
        } else {
            viewer.onMenuChanged(this.menubar.getDisplayMenu());
        }
        this.doViewLayout();
    }

    private void fireHeaderChanged() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof LeafInfo)) {
            return;
        }
        this.setCurrentViewer(((LeafInfo)userObject).getViewer());
    }

    private void doViewLayout() {
        JViewport header = this.viewScrollPane.getColumnHeader();
        if (header != null) {
            header.doLayout();
        }
        this.viewScrollPane.getViewport().doLayout();
        this.viewScrollPane.doLayout();
        this.viewScrollPane.repaint();
    }

    private void onNormalizeData(int mode) {
        this.setCursor(3);
        this.data.normalize(mode, this);
        this.addHistory("Normalization State: " + SlideData.normalizationString(mode));
        this.setCursor(0);
    }

    private void onNormalizeDataList(int mode) {
        this.setCursor(3);
        this.data.normalizeList(mode);
        this.addHistory(SlideData.normalizationString(mode));
        this.setCursor(0);
    }

    private void onNodeChanged(TreeSelectionEvent event) {
        JTree tree = (JTree)event.getSource();
        TreePath path = event.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof LeafInfo)) {
            return;
        }
        this.setCurrentViewer(((LeafInfo)userObject).getViewer());
    }

    private void onElementSizeChanged(int width, int height) {
        this.menubar.setElementSize(width, height);
        TMEV.storeProperty("last-selected-element-width", new Integer(width).toString());
        TMEV.storeProperty("last-selected-element-height", new Integer(height).toString());
        this.fireMenuChanged();
    }

    private void onElementSizeChanged() {
        SetElementSizeDialog sesd = new SetElementSizeDialog(this.getFrame(), this.menubar.getDisplayMenu().getElementSize());
        if (sesd.showModal() == 0) {
            Dimension size = sesd.getElementSize();
            this.onElementSizeChanged(size.width, size.height);
        }
    }

    private void onFontChanged(String newFont) {
        this.menubar.setNewFont(newFont);
        this.fireMenuChanged();
    }

    private void onColorSchemeChange(int colorScheme) {
        int initColorScheme = this.menubar.getColorScheme();
        if (colorScheme == 5 || colorScheme == 6 || colorScheme == 8) {
            this.menubar.setColorSchemeIndex(colorScheme);
            if (colorScheme == 8) {
                this.menubar.setUseDoubleGradient(false);
            } else {
                this.menubar.setUseDoubleGradient(true);
            }
        } else if (colorScheme == 10) {
            AccessibleColorSchemeSelectionDialog adialog = new AccessibleColorSchemeSelectionDialog(this.getFrame(), true, this.menubar.getNegativeGradientImage(), this.menubar.getPositiveGradientImage(), this.menubar.getDisplayMenu().getUseDoubleGradient());
            if (adialog.showModal() != 2) {
                this.menubar.setPositiveGradientImage(adialog.getPositiveGradient());
                this.menubar.setNegativeGradientImage(adialog.getNegativeGradient());
                this.menubar.setColorSchemeIndex(colorScheme);
                this.menubar.setUseDoubleGradient(adialog.getUseDoubleGradient());
            }
        } else {
            ColorSchemeSelectionDialog dialog;
            boolean rainbowScheme;
            boolean bl = rainbowScheme = initColorScheme == 8;
            if (rainbowScheme) {
                this.menubar.setColorSchemeIndex(5);
                this.menubar.setUseDoubleGradient(true);
            }
            if ((dialog = new ColorSchemeSelectionDialog(this.getFrame(), true, this.menubar.getNegativeGradientImage(), this.menubar.getPositiveGradientImage(), this.menubar.getDisplayMenu().getUseDoubleGradient())).showModal() != 0) {
                if (rainbowScheme) {
                    this.menubar.setColorSchemeIndex(8);
                    this.menubar.setUseDoubleGradient(false);
                }
                return;
            }
            this.menubar.setPositiveGradientImage(dialog.getPositiveGradient());
            this.menubar.setNegativeGradientImage(dialog.getNegativeGradient());
            this.menubar.setColorSchemeIndex(colorScheme);
            this.menubar.setUseDoubleGradient(dialog.getUseDoubleGradient());
        }
        boolean useDoubleGradient = this.menubar.getDisplayMenu().getUseDoubleGradient();
        BufferedImage positiveImage = this.menubar.getPositiveGradientImage();
        BufferedImage negativeImage = this.menubar.getNegativeGradientImage();
        Integer positiveColor = positiveImage.getRGB(positiveImage.getWidth() - 1, 0);
        Integer negativeColor = negativeImage.getRGB(0, 0);
        Integer neutralColor = positiveImage.getRGB(0, 0);
        TMEV.storeProperty("last-selected-color-scheme-index", new Integer(colorScheme).toString());
        TMEV.storeProperty("last-selected-color-scheme-positive", positiveColor.toString());
        TMEV.storeProperty("last-selected-color-scheme-negative", negativeColor.toString());
        TMEV.storeProperty("last-selected-color-scheme-neutral", neutralColor.toString());
        TMEV.storeProperty("last-selected-color-scheme-double-gradient", new Boolean(useDoubleGradient).toString());
        this.fireMenuChanged();
    }

    private void onColorGradientChange(boolean gradientState) {
        this.menubar.setColorGradientState(gradientState);
        this.fireMenuChanged();
    }

    private void onDrawBorders() {
        this.menubar.setDrawBorders(!this.menubar.getDisplayMenu().isDrawingBorder());
        this.fireMenuChanged();
    }

    private void onCompactClusters() {
        this.menubar.setCompactClusters(!this.menubar.getDisplayMenu().isCompactClusters());
        this.fireMenuChanged();
    }

    private void onShowRects() {
        this.menubar.setShowRects(!this.menubar.getDisplayMenu().isShowRects());
        this.fireMenuChanged();
    }

    private void onAutoArrangeColors() {
        this.menubar.setAutoArrangeColors(!this.menubar.getDisplayMenu().isAutoArrangeColors());
        this.fireMenuChanged();
    }

    private void onSystemInfo() {
        int width = 640;
        int height = 550;
        InformationPanel infoPanel = new InformationPanel();
        JFrame frame = new JFrame("System Information");
        frame.getContentPane().add(infoPanel);
        frame.setSize(width, height);
        Dimension screenSize = this.getToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
        frame.setResizable(false);
        frame.setVisible(true);
        infoPanel.Start();
    }

    private void onDefaultDistance() {
        String defaultText = "<html><font color=\"#000000\"><b><u>Default Distances</u></b></font><p><table border=20 cellspacing=10 cellpadding = 10 width= 380 height= 400><tr><th><u><center><width=200>Algorithm</center></u></th><th width = 150><u><center>Default Metric</center></u></th></tr><tr><td><center>HCL, ST, SOTA, KMC, KMS, SOM, CAST, GSH, FOM</center></td><td><center>Euclidean</center></td></tr><tr><td><center>PCA</center></td><td><center>Covariance</center></td></tr><tr><td><center>SVM</center></td><td><center>Dot Product</center></td></tr><tr><td><center>RN, QTC, PTM</center></td><td><center>Pearson Correlation</center></td></tr></center></table></html>";
        JOptionPane.showMessageDialog(this.getFrame(), new JLabel(defaultText), "Default Distances", -1);
    }

    private void setNormalizedState(int originalMode) {
        if (originalMode == 0) {
            this.menubar.setNormalizedButtonState(5);
        } else {
            this.addHistory(SlideData.normalizationString(originalMode));
            if (originalMode == 1) {
                this.menubar.setNormalizedButtonState(0);
            } else if (originalMode == 3) {
                this.menubar.setNormalizedButtonState(1);
            } else if (originalMode == 4 || originalMode == 5) {
                this.menubar.setNormalizedButtonState(2);
            } else if (originalMode == 6) {
                this.menubar.setNormalizedButtonState(3);
            }
        }
    }

    private void onNormalize(int mode) {
        final int originalMode = this.data.getFeature(0).getNormalizedState();
        final int Mode = mode;
        this.setCursor(3);
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String result = MultipleArrayViewer.this.data.normalize(Mode, MultipleArrayViewer.this);
                    if (!result.equals("no_change")) {
                        if (result.equals("normalized")) {
                            MultipleArrayViewer.this.addHistory(SlideData.normalizationString(Mode));
                        } else if (result.equals("process_abort_reset")) {
                            MultipleArrayViewer.this.addHistory("Norm. aborted, reset to raw state");
                            MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                        }
                        MultipleArrayViewer.this.fireDataChanged();
                        MultipleArrayViewer.this.setCursor(0);
                    } else if (originalMode == 0) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                    } else if (originalMode == 1) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(0);
                    } else if (originalMode == 3) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(1);
                    } else if (originalMode == 4 || originalMode == 5) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(2);
                    } else if (originalMode == 6) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(3);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(0);
        this.fireDataChanged();
    }

    private void onNormalizeList(int mode) {
        this.setCursor(3);
        this.data.normalizeList(mode);
        this.addHistory(SlideData.normalizationString(mode));
        this.fireDataChanged();
        this.setCursor(0);
    }

    private void onPrintImage() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this, pj.defaultPage());
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        IViewer viewer = this.getCurrentViewer();
        BufferedImage bImage = viewer.getImage();
        if (bImage == null) {
            bImage = this.createDefaultImage(viewer);
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform t2d = new AffineTransform();
        t2d.translate(pf.getImageableX(), pf.getImageableY());
        double xscale = pf.getImageableWidth() / (double)bImage.getWidth();
        double yscale = pf.getImageableHeight() / (double)bImage.getHeight();
        double scale = Math.min(xscale, yscale);
        t2d.scale(scale, scale);
        try {
            g2.drawImage(bImage, t2d, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        return 0;
    }

    public synchronized void addAnalysisResult(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        String nodeTitle = (String)node.getUserObject();
        nodeTitle = nodeTitle + " (" + this.resultCount + ")";
        ++this.resultCount;
        this.modifiedResult = true;
        node.setUserObject(nodeTitle);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.insertNodeInto(node, this.analysisNode, this.analysisNode.getChildCount());
        TreeSelectionModel selModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(node.getPath());
        selModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        JScrollBar bar = this.treeScrollPane.getHorizontalScrollBar();
        if (bar != null) {
            bar.setValue(0);
        }
        this.addHistory("Analysis Result: " + nodeTitle);
    }

    private void addHistory(String info) {
        this.historyLog.addHistory(info);
    }

    private void onAnalysis(Action action) {
        String className = (String)action.getValue("command-parameter");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(className, true, cl);
            final IClusterGUI gui = (IClusterGUI)clazz.newInstance();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultMutableTreeNode result = gui.execute(MultipleArrayViewer.this.framework);
                        MultipleArrayViewer.this.addAnalysisResult(result);
                    }
                    catch (AbortException e) {
                    }
                    catch (Throwable t) {
                        ShowThrowableDialog.show(MultipleArrayViewer.this.mainframe, "Analysis Error", false, t);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (ClassCastException e) {
            System.out.println("Error: org.tigr.microarray.mev.cluster.gui.IClusterGUI interface is expected.");
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
    }

    private void onDeleteNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node.getParent() == null) {
            return;
        }
        this.fireOnCloseEvent(node);
        TreePath parentPath = new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath());
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
        this.tree.getSelectionModel().setSelectionPath(parentPath);
        this.tree.scrollPathToVisible(parentPath);
        String nodeName = " ";
        Object object = node.getUserObject();
        if (object instanceof LeafInfo) {
            nodeName = ((LeafInfo)object).toString();
        } else if (object instanceof String) {
            nodeName = (String)object;
        }
        this.addHistory("Deleted Node: " + nodeName);
    }

    private void onSetData(boolean isSelected) {
        LeafInfo leafInfo;
        IViewer viewer;
        boolean selected = isSelected;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        Object object = node.getUserObject();
        int index = 0;
        if (node == null || node.getParent() == null) {
            return;
        }
        if (object instanceof LeafInfo && (viewer = (leafInfo = (LeafInfo)object).getViewer()) != null) {
            Experiment experiment = viewer.getExperiment();
            int[][] clusters = viewer.getClusters();
            if (leafInfo.toString().equals("Original Data")) {
                this.tree.clearDataSelection();
                leafInfo.setSelectedDataSource(isSelected);
                this.data.setUseMainData(true);
                this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
                this.tree.repaint();
                return;
            }
            if (experiment == null || clusters == null) {
                return;
            }
            Object leafUserObject = leafInfo.getUserObject();
            if (leafUserObject instanceof Integer) {
                index = (Integer)leafUserObject;
            } else if (leafUserObject instanceof CentroidUserObject) {
                index = ((CentroidUserObject)leafUserObject).getClusterIndex();
            } else {
                return;
            }
            int viewerType = viewer.getViewerType();
            if (viewerType == -1) {
                return;
            }
            this.tree.clearDataSelection();
            leafInfo.setSelectedDataSource(isSelected);
            if (isSelected) {
                this.data.constructAndSetAlternateExperiment(experiment, clusters[index], viewerType);
                this.createDataSelectionNode(node, experiment, clusters[index].length, viewerType);
            } else {
                this.data.setUseMainData(true);
                ((LeafInfo)((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0)).getUserObject()).setSelectedDataSource(true);
                this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
            }
        }
        this.tree.repaint();
    }

    private void createDataSelectionNode(DefaultMutableTreeNode node, Experiment experiment, int clusterSize, int clusterType) {
        int numSamples;
        int numGenes;
        String dataSourcePath = "";
        String msg = "<html><body>";
        msg = msg + "<h1>Data Source Selection Information</h1>";
        msg = msg + "<table align=left>";
        TreeNode[] path = node.getPath();
        String indent = "   ";
        msg = msg + "<tr><td><b>Data Source Path:</b></td><td>";
        dataSourcePath = dataSourcePath + "Data Source Path: ";
        for (int i = 1; i < path.length - 1; ++i) {
            msg = msg + path[i].toString();
            msg = msg + " : ";
            dataSourcePath = dataSourcePath + path[i].toString();
            dataSourcePath = dataSourcePath + " : ";
        }
        msg = msg + path[path.length - 1] + "</td></tr>";
        dataSourcePath = dataSourcePath + path[path.length - 1];
        msg = msg + "<tr><td><b>Date Loaded:</b></td><td>";
        Date date = new Date(System.currentTimeMillis());
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getDefault());
        msg = msg + format.format(date);
        String dateStamp = "Date Loaded: " + format.format(date);
        if (clusterType == 0) {
            numGenes = clusterSize;
            numSamples = experiment.getNumberOfSamples();
            msg = msg + "<tr><td><b>Number of Genes:</b></td><td>" + clusterSize + "</td></tr>";
            msg = msg + "<tr><td><b>Number of Samples:</b></td><td>" + experiment.getNumberOfSamples() + "</td></tr>";
        } else {
            numGenes = experiment.getNumberOfGenes();
            numSamples = clusterSize;
            msg = msg + "<tr><td><b>Number of Genes:</b></td><td>" + experiment.getNumberOfGenes() + "</td></tr>";
            msg = msg + "<tr><td><b>Number of Samples:</b></td><td>" + clusterSize + "</td></tr>";
        }
        msg = msg + "</table></body></html>";
        DefaultMutableTreeNode dataInfoNode = new DefaultMutableTreeNode(new LeafInfo("Data Source Selection", (IViewer)new TextViewer(msg)));
        this.addNode(this.analysisNode, dataInfoNode);
        String historyString = "Data Source Selection\n";
        historyString = historyString + "=====================\n";
        historyString = historyString + dataSourcePath + "\n";
        historyString = historyString + dateStamp + "\n";
        historyString = historyString + "Number of Genes: " + String.valueOf(numGenes) + "\n";
        historyString = historyString + "Number of Samples: " + String.valueOf(numSamples);
        this.addHistory(historyString);
    }

    private void onRama() {
        Rama rama = new Rama(this, this.menubar);
    }

    private void onRamaDoc() {
        try {
            BrowserLauncher.openURL((String)"http://www.expression.washington.edu/ramaDoc/MeV-R_Documentation.html");
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Please see MeV-R_Documentation.html in the documentation folder", "Input Error", 0);
        }
    }

    private void onSetDetectionFilter() {
        SetDetectionFilterDialog sdfd;
        int num_samples = this.data.getFeaturesCount();
        String[] sample_names = new String[num_samples];
        for (int i = 0; i < num_samples; ++i) {
            sample_names[i] = this.data.getFullSampleName(i);
        }
        if (this.data.getdfSet()) {
            sdfd = new SetDetectionFilterDialog(this.getFrame(), sample_names, this.data.getDetectionFilter());
        } else {
            sdfd = new SetDetectionFilterDialog(this.getFrame(), sample_names);
            this.data.setdfSet(true);
        }
        if (sdfd.showModal() == 0) {
            this.data.setDetectionFilter(sdfd.getDetectionFilter());
            if (this.data.isDetectionFilter()) {
                this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void onSetFoldFilter() {
        SetFoldFilterDialog ffd;
        int num_samples = this.data.getFeaturesCount();
        String[] sample_names = new String[num_samples];
        for (int i = 0; i < num_samples; ++i) {
            sample_names[i] = this.data.getFullSampleName(i);
        }
        if (this.data.getffSet()) {
            ffd = new SetFoldFilterDialog(this.getFrame(), sample_names);
        } else {
            ffd = new SetFoldFilterDialog(this.getFrame(), sample_names);
            this.data.setffSet(true);
        }
        if (ffd.showModal() == 0) {
            this.data.setFoldFilter(ffd.getFoldFilter());
            if (this.data.isFoldFilter()) {
                this.addHistory("Fold Filter (" + this.data.getFoldFilter().toString() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void applyLowerCutoffs() {
        SetLowerCutoffsDialog slcd = new SetLowerCutoffsDialog(this.getFrame(), this.data.getLowerCY3Cutoff(), this.data.getLowerCY5Cutoff());
        if (slcd.showModal() == 0) {
            boolean useCutoff = slcd.isLowerCutoffEnabled();
            this.data.setUseLowerCutoffs(useCutoff);
            this.data.setLowerCutoffs(slcd.getLowerCY3Cutoff(), slcd.getLowerCY5Cutoff());
            Properties props = new Properties();
            props.setProperty("CY3 Cutoff", Float.toString(slcd.getLowerCY3Cutoff()));
            props.setProperty("CY5 Cutoff", Float.toString(slcd.getLowerCY5Cutoff()));
            if (this.data.isLowerCutoffs()) {
                this.addAdjustmentResultNodes("Data Filter - Low Intensity Cutoff Filter", this.data.getExperiment(), props);
                this.addHistory("Low Intensity Cutoff Filter is ON ( cy3= " + Float.toString(slcd.getLowerCY3Cutoff()) + "  cy5 =" + Float.toString(slcd.getLowerCY5Cutoff()) + " )");
            } else {
                this.addHistory("Low Intensity Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applySingleLowerCutoffs() {
        SetSingleLowerCutoffsDialog slcd = new SetSingleLowerCutoffsDialog(this.getFrame(), this.data.getLowerCY5Cutoff());
        if (slcd.showModal() == 0) {
            boolean useCutoff = slcd.isLowerCutoffEnabled();
            this.data.setUseLowerCutoffs(useCutoff);
            this.data.setLowerCutoffs(0.0f, slcd.getLowerCY5Cutoff());
            Properties props = new Properties();
            props.setProperty("CY5 Cutoff", Float.toString(slcd.getLowerCY5Cutoff()));
            if (this.data.isLowerCutoffs()) {
                this.addAdjustmentResultNodes("Data Filter - Low Intensity Cutoff Filter", this.data.getExperiment(), props);
                this.addHistory("Low Intensity Cutoff Filter is ON ( thresholds = " + Float.toString(slcd.getLowerCY5Cutoff()) + " )");
            } else {
                this.addHistory("Low Intensity Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyPercentageCutoffs() {
        SetPercentageCutoffsDialog spcd = new SetPercentageCutoffsDialog(this.getFrame(), this.data.getPercentageCutoff());
        if (spcd.showModal() == 0) {
            boolean useCutoff = spcd.isCutoffFilterEnabled();
            float percent = spcd.getPercentageCutoff();
            this.data.setUsePercentageCutoff(useCutoff);
            this.data.setPercentageCutoff(percent);
            Properties props = new Properties();
            props.setProperty("Percentage", Float.toString(percent));
            if (this.data.isPercentageCutoff()) {
                this.addAdjustmentResultNodes("Data Filter - Percentage Cutoff Filter", this.data.getExperiment(), props);
                this.addHistory("Percentage Cutoff Filter is ON ( percent = " + Float.toString(percent) + " )");
            } else {
                this.addHistory("Percentage Cutoff Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyPresentCallFilter() {
        SetPresentCallDialog spcd = new SetPresentCallDialog(this.getFrame(), this.data.getPercentageCutoff());
        if (spcd.showModal() == 0) {
            boolean useCutoff = spcd.isCutoffFilterEnabled();
            float percent = spcd.getPercentageCutoff();
            this.data.setUsePresentCutoff(useCutoff);
            this.data.setPercentageCutoff(percent);
            Properties props = new Properties();
            props.setProperty("Percentage", Float.toString(percent));
            if (this.data.isPresentCallCutoff()) {
                this.addAdjustmentResultNodes("Data Filter - Percentage Cutoff Filter", this.data.getExperiment(), props);
                this.addHistory("Percentage Cutoff Filter is ON ( percent = " + Float.toString(percent) + " )");
            } else {
                this.addHistory("Percentage Cutoff Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyGenePixFlagsFilter() {
        GenePixCutoffDialog spcd = new GenePixCutoffDialog(this.mainframe, this.data.getPercentageCutoff());
        if (spcd.showModal() == 0) {
            boolean useCutoff = spcd.isCutoffFilterEnabled();
            float percent = spcd.getPercentageCutoff();
            this.data.setUseGenePixCutoff(useCutoff);
            this.data.setGenePixCutoff(percent);
            Properties props = new Properties();
            props.setProperty("Percentage", Float.toString(percent));
            if (this.data.isGenePixFilter()) {
                this.addAdjustmentResultNodes("Data Filter - GenePix Flags Filter", this.data.getExperiment(), props);
                this.addHistory("GenePix Flags Filter is ON ( percent = " + Float.toString(percent) + " )");
            } else {
                this.addHistory("GenePix Flags Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyGCOSPercentageFilter() {
        SetPresentCallDialog spcd = new SetPresentCallDialog(this.getFrame(), this.data.getPercentageCutoff());
        if (spcd.showModal() == 0) {
            boolean useCutoff = spcd.isCutoffFilterEnabled();
            float percent = spcd.getPercentageCutoff();
            this.data.setUseGCOSPercentageCutoff(useCutoff);
            this.data.setPercentageCutoff(percent);
            Properties props = new Properties();
            props.setProperty("Percentage", Float.toString(percent));
            if (this.data.isGCOSPercentCutoff()) {
                this.addAdjustmentResultNodes("Data Filter - Percentage Cutoff Filter", this.data.getExperiment(), props);
                this.addHistory("Percentage Cutoff Filter is ON ( percent = " + Float.toString(percent) + " )");
            } else {
                this.addHistory("Percentage Cutoff Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyPvaluePercentageFilter() {
        boolean pvalueCutoff = true;
        float percent = 80.0f;
        this.data.setUsePvaluePercentageCutoff(pvalueCutoff);
        this.data.setPvaluePercentageCutoff(percent);
        Properties props = new Properties();
        props.setProperty("Percentage", Float.toString(percent));
        this.addAdjustmentResultNodes("Data Filter - Percentage Cutoff Filter", this.data.getExperiment(), props);
        this.addHistory("P-value Percentage Cutoff Filter is ON ( percent =  80%)");
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void applyVarianceFilter() {
        VarianceFilterDialog dialog = new VarianceFilterDialog(this.getFrame());
        if (dialog.showModal() == 0) {
            Properties props = dialog.getProperties();
            this.data.setVarianceFilter(props);
            if (this.data.isVarianceFilter()) {
                this.addAdjustmentResultNodes("Data Filter - Variance Filter", this.data.getExperiment(), props);
                this.addHistory("Variance Filter is ON ( mode= " + props.getProperty("Filter Mode") + " value= " + props.getProperty("Value") + " )");
            } else {
                this.addHistory("Variance Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void addAdjustmentResultNodes(String mainTitle, Experiment experiment, Properties props) {
        DefaultMutableTreeNode filterNode = new DefaultMutableTreeNode(mainTitle);
        int[][] cluster = new int[1][experiment.getNumberOfGenes()];
        for (int i = 0; i < cluster[0].length; ++i) {
            cluster[0][i] = i;
        }
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)new ExperimentViewer(experiment, cluster), (Object)new Integer(0)));
        filterNode.add(expressionNode);
        filterNode.add(new DefaultMutableTreeNode("Gene/Row Count: " + cluster[0].length));
        if (props.size() > 0) {
            String label = "Parameter";
            if (props.size() > 1) {
                label = label + "s";
            }
            DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode(label);
            Enumeration<Object> _enum = props.keys();
            while (_enum.hasMoreElements()) {
                String key = (String)_enum.nextElement();
                parameterNode.add(new DefaultMutableTreeNode(key + ": " + (String)props.get(key)));
            }
            filterNode.add(parameterNode);
        }
        this.addNode(this.analysisNode, filterNode);
        Object[] path = new Object[]{this.tree.getRoot(), this.analysisNode, filterNode};
        this.tree.scrollPathToVisible(new TreePath(path));
    }

    private void onUseDetectionFilter(AbstractButton item) {
        this.data.setUseDetectionFilter(item.isSelected());
        if (this.data.isDetectionFilter()) {
            this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
            this.addAdjustmentResultNodes("Data Filter - Affy Detection Filter", this.data.getExperiment(), new Properties());
        } else {
            this.addHistory("Detection Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onUseFoldFilter(AbstractButton item) {
        this.data.setUseFoldFilter(item.isSelected());
        if (this.data.isFoldFilter()) {
            this.addHistory("Fold Filter (" + this.data.getDetectionFilter() + ")");
            this.addAdjustmentResultNodes("Data Filter - Affy Fold Filter", this.data.getExperiment(), new Properties());
        } else {
            this.addHistory("Fold Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onLog2Transform() {
        this.data.log2Transform();
        this.fireDataChanged();
        this.addHistory("Log2 Transform");
    }

    private void onUnLog2Transform() {
        this.data.unlog2Transform();
        this.fireDataChanged();
        this.addHistory("Unlog2 Transform");
    }

    private void onNormalizeSpots() {
        this.data.normalizeSpots();
        this.fireDataChanged();
        this.addHistory("Normalize Gene/Row Vectors");
    }

    private void onDivideSpotsRMS() {
        this.data.divideSpotsRMS();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row RMS");
    }

    private void onDivideSpotsSD() {
        this.data.divideSpotsSD();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row SD");
    }

    private void onDivideGenesMedian() {
        this.data.divideGenesMedian();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row Median");
    }

    private void onDivideGenesMean() {
        this.data.divideGenesMean();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row Mean");
    }

    private void onMeanCenterSpots() {
        this.data.meanCenterSpots();
        this.fireDataChanged();
        this.addHistory("Mean Center by Gene/Row Mean");
    }

    private void onMedianCenterSpots() {
        this.data.medianCenterSpots();
        this.fireDataChanged();
        this.addHistory("Median Center by Gene/Row Median");
    }

    private void onDigitalSpots() {
        this.data.digitalSpots();
        this.fireDataChanged();
        this.addHistory("Digital Rows");
    }

    private void onNormalizeExperiments() {
        this.data.normalizeExperiments();
        this.fireDataChanged();
        this.addHistory("Normalize Sample/Column Vectors");
    }

    private void onDivideExperimentsRMS() {
        this.data.divideExperimentsRMS();
        this.fireDataChanged();
        this.addHistory("Divide by Sample/Column RMS");
    }

    private void onDivideExperimentsSD() {
        this.data.divideExperimentsSD();
        this.fireDataChanged();
        this.addHistory("Divide by Sample/Column SD");
    }

    private void onMeanCenterExperiments() {
        this.data.meanCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Mean Center by Column/Sample Mean");
    }

    private void onMedianCenterExperiments() {
        this.data.medianCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Median Center by Sample/Column Median");
    }

    private void onDigitalExperiments() {
        this.data.digitalExperiments();
        this.fireDataChanged();
        this.addHistory("Digital Samples");
    }

    private void onLog10toLog2() {
        this.data.log10toLog2();
        this.fireDataChanged();
        this.addHistory("Log10 to Log2");
    }

    private void onLog2toLog10() {
        this.data.log2toLog10();
        this.fireDataChanged();
        this.addHistory("Log2 to Log10");
    }

    private void onAdjustIntensities(AbstractButton item) {
        this.data.setNonZero(item.isSelected());
        this.fireDataChanged();
    }

    private void onSaveMatrix() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.mainframe, (Experiment)this.data.getExperiment(), (IData)this.data);
            this.addHistory("Save Data Matrix to File");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainframe, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetRatioScale() {
        IDisplayMenu menu = this.menubar.getDisplayMenu();
        SetRatioScaleDialog srsd = new SetRatioScaleDialog(this.mainframe, this.framework, this.menubar, menu.getMaxRatioScale(), menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getUseDoubleGradient());
        if (srsd.showModal() == 0) {
            this.menubar.setMaxRatioScale(srsd.getUpperLimit());
            this.menubar.setMinRatioScale(srsd.getLowerLimit());
            this.menubar.setMidRatioValue(srsd.getMidValue());
            this.menubar.setUseDoubleGradient(srsd.getUseDoubleGradient());
            if (srsd.isGradientStyleAltered() && srsd.getUseDoubleGradient()) {
                this.menubar.setPositiveGradientImage(srsd.getPosImage());
            }
            this.fireMenuChanged();
        }
        this.addHistory("Color Sat. Limits Set: Lower = " + srsd.getLowerLimit() + " Upper = " + srsd.getUpperLimit());
    }

    private void onDeleteAll() {
        this.data.deleteColors();
        if (this.geneClusterManager != null) {
            this.geneClusterManager.deleteAllClusters();
        }
        this.fireDataChanged();
        this.fireMenuChanged();
        this.addHistory("Deleted All Gene Clusters");
    }

    private void onDeleteAllExperimentClusters() {
        this.data.deleteExperimentColors();
        if (this.experimentClusterManager != null) {
            this.experimentClusterManager.deleteAllClusters();
        }
        this.fireDataChanged();
        this.fireMenuChanged();
        this.addHistory("Deleted All Sample Clusters");
    }

    private void selectNode(DefaultMutableTreeNode node) {
        this.tree.setSelectionPath(new TreePath(node.getPath()));
    }

    private void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.insertNodeInto(child, parent, parent.getChildCount());
        this.treeScrollPane.getHorizontalScrollBar().setValue(0);
        this.fireDataChanged();
    }

    private Color storeCluster(int[] indices, Experiment experiment, int clusterType) {
        Cluster cluster;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode clusterNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object leafInfo = clusterNode.getUserObject();
        if (!(leafInfo instanceof LeafInfo)) {
            return null;
        }
        if (path.getPathCount() < 3) {
            return null;
        }
        Color clusterColor = null;
        String clusterID = ((LeafInfo)clusterNode.getUserObject()).toString();
        DefaultMutableTreeNode algorithmNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        String algorithmName = algorithmNode.getUserObject().toString();
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                    this.addNode(this.clusterNode, genesNode);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, experimentNode);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int serNum = cluster.getSerialNumber();
            String algName = cluster.getAlgorithmName();
            if (clusterType == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
        return clusterColor;
    }

    private void storeClusterWithoutDialog(int[] clusterIndices, String source, String factor, String node, String label, String clusterDescription, int clusterType) {
        Cluster cluster;
        if (clusterType == 0) {
            cluster = this.geneClusterRepository.storeClusterWithoutDialog(clusterIndices, source, factor, node, label, clusterDescription);
            if (cluster != null) {
                this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
            }
            this.geneClusterRepository.printRepository();
        } else {
            cluster = this.experimentClusterRepository.storeClusterWithoutDialog(clusterIndices, source, factor, node, label, clusterDescription);
            if (cluster != null) {
                this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int serNum = cluster.getSerialNumber();
            String algName = cluster.getAlgorithmName();
            if (clusterType == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + node);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + node);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
    }

    private Color storeCluster(int[] indices, Experiment experiment, int clusterType, Color color) {
        Cluster cluster;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode clusterNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object leafInfo = clusterNode.getUserObject();
        if (!(leafInfo instanceof LeafInfo)) {
            return null;
        }
        if (path.getPathCount() < 3) {
            return null;
        }
        Color clusterColor = null;
        String clusterID = ((LeafInfo)clusterNode.getUserObject()).toString();
        DefaultMutableTreeNode algorithmNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        String algorithmName = algorithmNode.getUserObject().toString();
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                    this.addNode(this.clusterNode, genesNode);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, experimentNode);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int serNum = cluster.getSerialNumber();
            String algName = cluster.getAlgorithmName();
            if (clusterType == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
        return clusterColor;
    }

    private Color storeSubCluster(int[] indices, Experiment experiment, int clusterType) {
        Cluster cluster;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode clusterNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object leafInfo = clusterNode.getUserObject();
        if (!(leafInfo instanceof LeafInfo)) {
            return null;
        }
        if (path.getPathCount() < 3) {
            return null;
        }
        Color clusterColor = null;
        String clusterID = ((LeafInfo)clusterNode.getUserObject()).toString();
        DefaultMutableTreeNode algorithmNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        String algorithmName = algorithmNode.getUserObject().toString();
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeSubCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                    this.addNode(this.clusterNode, genesNode);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeSubCluster(this.resultCount - 1, algorithmName, clusterID, indices, clusterNode, experiment)) != null) {
                clusterColor = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, experimentNode);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int serNum = cluster.getSerialNumber();
            String algName = cluster.getAlgorithmName();
            if (clusterType == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
        return clusterColor;
    }

    public void storeOperationCluster(String source, String clusterID, int[] indices, boolean geneCluster) {
        ClusterAttributesDialog dialog = new ClusterAttributesDialog("Store Cluster Attributes", source, clusterID);
        if (dialog.showModal() == 0) {
            Cluster cluster;
            if (geneCluster) {
                FloatMatrix matrix = this.data.getFullExperiment().getMatrix();
                Experiment experiment = new Experiment(matrix, indices);
                ClusterRepository repository = this.getClusterRepository(0);
                cluster = new Cluster(indices, source, dialog.getLabel(), clusterID, "", dialog.getDescription(), -1, repository.takeNextClusterSerialNumber(), dialog.getColor(), experiment);
                repository.addCluster(repository.getClusterOperationsList(), cluster);
                this.geneClusterManager.addCluster(cluster);
            } else {
                Experiment experiment = this.data.getFullExperiment();
                ClusterRepository repository = this.getClusterRepository(1);
                cluster = new Cluster(indices, "Search Result", dialog.getLabel(), "Selected Samples", "", dialog.getDescription(), -1, repository.takeNextClusterSerialNumber(), dialog.getColor(), experiment);
                repository.addCluster(repository.getClusterOperationsList(), cluster);
                this.experimentClusterManager.addCluster(cluster);
            }
            if (cluster != null) {
                int serNum = cluster.getSerialNumber();
                String algName = cluster.getAlgorithmName();
                if (geneCluster) {
                    this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
                } else {
                    this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(serNum) + ", Algorithm: " + algName + ", Cluster: " + clusterID);
                }
            }
        }
        this.refreshCurrentViewer();
    }

    public boolean removeCluster(int[] indices, Experiment experiment, int clusterType) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode clusterNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object leafInfo = clusterNode.getUserObject();
        boolean removed = false;
        if (!(leafInfo instanceof LeafInfo)) {
            return removed;
        }
        if (path.getPathCount() < 3) {
            return removed;
        }
        String clusterID = ((LeafInfo)clusterNode.getUserObject()).toString();
        DefaultMutableTreeNode algorithmNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        String algorithmName = (String)algorithmNode.getUserObject();
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                return removed;
            }
            removed = this.geneClusterRepository.removeCluster(indices, algorithmName, clusterID);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return removed;
            }
            removed = this.experimentClusterRepository.removeCluster(indices, algorithmName, clusterID);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        if (removed) {
            this.fireDataChanged();
        }
        return removed;
    }

    public boolean removeSubCluster(int[] indices, Experiment experiment, int clusterType) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode clusterNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object leafInfo = clusterNode.getUserObject();
        boolean removed = false;
        if (!(leafInfo instanceof LeafInfo)) {
            return removed;
        }
        if (path.getPathCount() < 3) {
            return removed;
        }
        String clusterID = ((LeafInfo)clusterNode.getUserObject()).toString();
        DefaultMutableTreeNode algorithmNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        String algorithmName = (String)algorithmNode.getUserObject();
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                return removed;
            }
            removed = this.geneClusterRepository.removeSubCluster(indices, algorithmName, clusterID);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return removed;
            }
            removed = this.experimentClusterRepository.removeSubCluster(indices, algorithmName, clusterID);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        if (removed) {
            this.fireDataChanged();
        }
        return removed;
    }

    private void launchNewMAV(int[] indices, Experiment experiment, String label, int clusterType) {
        if (indices.length < 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "The selected cluster does not contain any members. The new viewer session has been aborted.", "New Session Abort", 2);
            return;
        }
        MultipleArrayData newData = clusterType == 0 ? this.data.getDataSubset(indices) : this.data.getDataSubset(indices, experiment.getRowMappingArrayCopy());
        Manager.createNewMultipleArrayViewer(this.menubar, newData, label);
        this.addHistory("Launch New MAV: " + label);
    }

    private void openClusterNode(String algorithmNode, String clusterNode) {
        DefaultMutableTreeNode node = this.findNode(algorithmNode, clusterNode);
        if (node == null) {
            return;
        }
        this.selectNode(node);
    }

    private DefaultMutableTreeNode findNode(String parent, String child) {
        Object userObject;
        int i;
        int childCount = this.analysisNode.getChildCount();
        DefaultMutableTreeNode curr = this.analysisNode;
        DefaultMutableTreeNode target = null;
        for (i = 0; i < childCount; ++i) {
            curr = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            userObject = curr.getUserObject();
            if (userObject instanceof String && ((String)userObject).equals(parent)) {
                target = curr;
                break;
            }
            if (!(userObject instanceof LeafInfo) || !((LeafInfo)userObject).toString().equals(parent)) continue;
            target = curr;
            break;
        }
        if (target == null) {
            return null;
        }
        childCount = target.getChildCount();
        for (i = 0; i < childCount; ++i) {
            curr = (DefaultMutableTreeNode)target.getChildAt(i);
            userObject = curr.getUserObject();
            if (userObject instanceof String && ((String)userObject).equals(child)) {
                target = curr;
                break;
            }
            if (!(userObject instanceof LeafInfo) || !((LeafInfo)userObject).toString().equals(parent)) continue;
            target = curr;
            break;
        }
        if (target != curr) {
            return null;
        }
        return curr;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public DefaultMutableTreeNode getNode(Object object) {
        return this.tree.getNode(object);
    }

    public float[] initSortedValues(FloatMatrix m) {
        float[] vals = m.getColumnPackedCopy();
        QSort qsort = new QSort(vals, 1);
        vals = qsort.getSorted();
        int numberNaN = 0;
        for (int i = 0; i < vals.length && Float.isNaN(vals[i]); ++i) {
            ++numberNaN;
        }
        int validN = vals.length - numberNaN;
        float[] values = new float[validN];
        for (int i = 0; i < values.length; ++i) {
            values[i] = vals[i + numberNaN];
        }
        return values;
    }

    public float getMedian() {
        float median = this.sortedValues.length % 2 == 0 ? (this.sortedValues[this.sortedValues.length / 2] + this.sortedValues[this.sortedValues.length / 2 + 1]) / 2.0f : this.sortedValues[this.sortedValues.length / 2 + 1];
        return median;
    }

    public float getMaxScale() {
        int index = (int)Math.floor((double)this.sortedValues.length * 0.8);
        float max = this.sortedValues[index];
        return max;
    }

    public void fireDataLoaded(ISlideData[] features, IChipAnnotation chipAnnotation, int dataType) {
        block16: {
            DecimalFormat oneDecimalFormat = new DecimalFormat();
            oneDecimalFormat.setMaximumFractionDigits(1);
            if (features == null || features.length < 1) {
                return;
            }
            this.data.addFeatures(features);
            this.data.setDataType(dataType);
            chipAnnotation.setDataType(new Integer(dataType).toString());
            this.data.setChipAnnotation(chipAnnotation);
            if (this.data.getFieldNames() != null && this.data.getFeaturesCount() > 0) {
                this.menubar.addLabelMenuItems(this.data.getFieldNames(), null);
                this.menubar.addExperimentLabelMenuItems(this.getSlideNameKeyVectorUnion(features));
                ((MultipleArrayCanvas)this.viewer).addSortMenuItems(this.data.getFieldNames());
                this.menubar.setLabelIndex(0);
                if (this.data.getDataType() == 2 || this.data.getDataType() == 4 || this.data.getDataType() == 5 || this.data.getDataType() == 3) {
                    this.menubar.addAffyFilterMenuItems();
                }
                if (this.data.isCGHData()) {
                    this.loadCytoBandFile();
                    this.manager.initCghAnalysiActions(new CGHAlgorithmFactory());
                    this.menubar.addCGHMenus();
                    this.mainframe.validate();
                }
            }
            try {
                this.sortedValues = this.initSortedValues(this.data.getExperiment().getMatrix());
                if (this.data.getDataType() == 2) {
                    this.menubar.setMinRatioScale(0.0f);
                    this.menubar.setMidRatioValue(this.getMedian());
                    this.menubar.setMaxRatioScale(this.getMaxScale());
                    this.data.setDataType(2);
                }
                if (this.data.getDataType() == 6) {
                    this.menubar.setMinRatioScale(0.0f);
                    this.menubar.setMidRatioValue(this.getMedian());
                    this.menubar.setMaxRatioScale(this.getMaxScale());
                }
            }
            catch (OutOfMemoryError oome) {
                if (this.data.getDataType() != 2) break block16;
                this.menubar.setMinRatioScale(0.0f);
                this.menubar.setMidRatioValue(1000.0f);
                this.menubar.setMaxRatioScale(500.0f);
                this.data.setDataType(2);
            }
        }
        if (TMEV.getDataType() == 2 && this.data.getDataType() == 2 && !this.menubar.get_affyNormAdded()) {
            this.menubar.addAffyNormMenuItems();
        }
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.data.setUseMainData(true);
        ((LeafInfo)this.mainViewerNode.getUserObject()).setSelectedDataSource(true);
        this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
        this.tree.repaint();
        if (this.data.isCGHData()) {
            this.ExperimentsLoaded();
            this.onFlankingRegionDeterminationChanged();
        }
        this.setMaxCY3AndCY5();
        this.systemEnable(1003);
        this.viewer.onSelected(this.framework);
        this.fireMenuChanged();
        this.fireDataChanged();
        this.fireHeaderChanged();
        String[] featureNames = new String[features.length];
        for (int i = 0; i < features.length; ++i) {
            featureNames[i] = features[i].getSlideFileName();
            if (i == 0) {
                this.addHistory("Load Data File: " + featureNames[i]);
                continue;
            }
            if (featureNames[i].equals(featureNames[i - 1])) break;
            this.addHistory("Load Data File: " + featureNames[i]);
        }
        if (features.length > 1) {
            this.addHistory(features.length + " samples loaded.");
        } else {
            this.addHistory("1 sample loaded.");
        }
        if (features.length > 0) {
            this.addHistory(features[0].getSize() + " genes loaded.");
        }
        this.toolbar.enableRNASeq(this.data.getDataType() == 6);
        this.menubar.enableRNASeq(this.data.getDataType() == 6);
        this.initMainViewAndClusterManager();
    }

    public void initMainViewAndClusterManager() {
        DefaultMutableTreeNode experViewer = new DefaultMutableTreeNode();
        experViewer.setUserObject(new LeafInfo("Expression Image", (IViewer)new ExperimentViewer(this.framework)));
        CentroidViewer centroidViewer = new CentroidViewer(this.framework);
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.framework);
        ExperimentClusterTableViewer sampleTabViewer = new ExperimentClusterTableViewer(this.framework);
        if (this.experimentClusterRepository == null) {
            this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
            this.data.setExperimentClusterRepository(this.experimentClusterRepository);
        }
        if (this.experimentClusterManager == null) {
            this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
            DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
            this.addNode(this.clusterNode, experimentNode);
        }
        if (this.geneClusterRepository == null) {
            this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
            this.data.setGeneClusterRepository(this.geneClusterRepository);
        }
        if (this.geneClusterManager == null) {
            this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
            DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
            this.addNode(this.clusterNode, genesNode);
        }
        this.mainViewerNode.add(experViewer);
        this.mainViewerNode.add(new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 0))));
        this.mainViewerNode.add(new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 1))));
        this.mainViewerNode.add(new DefaultMutableTreeNode(new LeafInfo("Sample Table View", (IViewer)sampleTabViewer, (Object)new Integer(0))));
        this.mainViewerNode.add(new DefaultMutableTreeNode(new LeafInfo("Gene Table View", (IViewer)tabViewer, (Object)new Integer(0))));
        this.tree.expandPath(new TreePath(this.clusterNode.getPath()));
        this.tree.setSelectionRow(1);
        this.tree.updateUI();
        this.tree.repaint();
    }

    private Vector getSlideNameKeyVectorUnion(ISlideData[] features) {
        Vector<String> fullKeyVector = new Vector<String>();
        for (int i = 0; i < features.length; ++i) {
            Vector<String> keyVector = features[i].getSlideDataKeys();
            for (int j = 0; j < keyVector.size(); ++j) {
                String key = keyVector.elementAt(j);
                if (fullKeyVector.contains(key)) continue;
                fullKeyVector.addElement(key);
            }
        }
        return fullKeyVector;
    }

    public void setDataLoadersEnabled(boolean enabled) {
        this.menubar.setDataLoadersEnabled(enabled);
        this.fireMenuChanged();
    }

    public void loadData(FileLoadInfo fileLoadInfo) {
        SuperExpressionFileLoader loader = new SuperExpressionFileLoader(this, fileLoadInfo);
    }

    private void onClearData() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure? This cannot be undone!", "Delete all loaded data", 2) == 0) {
            this.removeChildren(this.mainViewerNode);
            this.clusterNode.removeAllChildren();
            this.experimentClusterManager = null;
            this.geneClusterManager = null;
            this.analysisNode.removeAllChildren();
            this.scriptNode.removeAllChildren();
            this.historyLog = new HistoryViewer();
            this.tree.updateUI();
            this.tree.repaint();
            this.systemDisable(1003);
            this.data = new MultipleArrayData();
            this.initSessionMetaData();
            this.viewer.onSelected(this.framework);
        }
    }

    private void loadData() {
        SuperExpressionFileLoader loader = new SuperExpressionFileLoader(this);
    }

    protected ClusterRepository getClusterRepository(int clusterType) {
        if (clusterType == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if (this.geneClusterManager == null) {
                this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                DefaultMutableTreeNode genesNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                this.addNode(this.clusterNode, genesNode);
            }
            return this.geneClusterRepository;
        }
        if (this.experimentClusterRepository == null) {
            this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
            this.data.setExperimentClusterRepository(this.experimentClusterRepository);
        }
        if (this.experimentClusterManager == null) {
            this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
            DefaultMutableTreeNode experimentNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
            this.addNode(this.clusterNode, experimentNode);
        }
        return this.experimentClusterRepository;
    }

    protected ResultTree getResultTree() {
        return this.tree;
    }

    private void search() {
        SearchDialog dialog = new SearchDialog(this.getFrame(), this.data.getFieldNames(), this.data.getSlideNameKeyArray());
        if (dialog.showModal() == 0) {
            AlgorithmData searchParameters = dialog.getSearchCriteria();
            AlgorithmParameters params = searchParameters.getParams();
            boolean geneSearch = params.getBoolean("gene-search");
            boolean caseSens = params.getBoolean("case-sensitive");
            boolean fullTerm = params.getBoolean("full-term");
            String searchTerm = params.getString("search-term");
            String[] fields = searchParameters.getStringArray("field-names");
            ResultTree resultTree = this.framework.getResultTree();
            int[] indices = this.data.search(searchParameters);
            if (indices.length > 0) {
                Vector result = resultTree.findViewerCollection(indices, searchParameters.getParams().getBoolean("gene-search"));
                if (result != null) {
                    Vector primaryNodes = (Vector)result.elementAt(0);
                    Hashtable expViewHash = (Hashtable)result.elementAt(1);
                    Hashtable tableViewHash = (Hashtable)result.elementAt(2);
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Search Result Shortcuts");
                    for (int i = 0; i < primaryNodes.size(); ++i) {
                        root.add((DefaultMutableTreeNode)primaryNodes.elementAt(i));
                    }
                    JTree tree = new JTree(root);
                    tree.setCellRenderer(resultTree.getCellRenderer());
                    SearchResultDialog resultDialog = new SearchResultDialog(this.framework, searchParameters, tree, expViewHash, tableViewHash, indices);
                    resultDialog.showModal();
                } else {
                    SearchResultDialog resultDialog = new SearchResultDialog(this.framework, searchParameters, indices);
                    resultDialog.showModal();
                }
            } else {
                if (geneSearch) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No genes matching the search criteria were found.", "Empty Search Result", 1);
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No samples matching the search criteria were found.", "Empty Search Result", 1);
                }
                return;
            }
        }
    }

    private void refreshCurrentViewer() {
    }

    private void onImportList(int clusterType) {
        this.onImportList(clusterType, null);
    }

    private void onImportList(int clusterType, String[] genelist) {
        this.onImportList(clusterType, genelist, null, true, null);
    }

    public void onImportList(int clusterType, String[] genelist, String identifier, boolean askUser, String label) {
        ClusterRepository cr = this.getClusterRepository(clusterType);
        Cluster cluster = askUser ? cr.createClusterFromList(genelist) : cr.storeClusterQuietlyFromList(genelist, identifier, label, "");
        String source = genelist != null ? "Gaggle Broadcast" : "List Import";
        if (cluster != null) {
            if (clusterType == 0) {
                this.geneClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Gene Cluster: Serial #: " + cluster.getSerialNumber() + ", Source: " + source);
            } else {
                this.experimentClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Sample Cluster: Serial #: " + cluster.getSerialNumber() + ", Source: " + source);
            }
            this.refreshCurrentViewer();
        }
    }

    private void onBinImportList(int clusterType) {
        ClusterRepository cr = this.getClusterRepository(clusterType);
        ArrayList<Cluster> clusterArray = cr.binCreateClusters();
        if (clusterArray == null) {
            return;
        }
        for (int i = 0; i < clusterArray.size(); ++i) {
            if (clusterArray == null) continue;
            if (clusterType == 0) {
                this.geneClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Gene Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Binned Cluster");
            } else {
                this.experimentClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Sample Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Binned Cluster");
            }
            this.refreshCurrentViewer();
        }
    }

    private void onAutoCluster(int clusterType) {
        ClusterRepository cr = this.getClusterRepository(clusterType);
        ArrayList<Cluster> clusterArray = cr.autoCreateClusters();
        for (int i = 0; i < clusterArray.size(); ++i) {
            if (clusterArray == null) continue;
            if (clusterType == 0) {
                this.geneClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Gene Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Auto Cluster");
            } else {
                this.experimentClusterManager.onRepositoryChanged(cr);
                this.addHistory("Save Sample Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Auto Cluster");
            }
            this.refreshCurrentViewer();
        }
    }

    private void onAutoImportList(int clusterType, int index) {
        ClusterRepository cr = this.getClusterRepository(clusterType);
        ArrayList<Cluster> clusterArray = cr.autoCreateClusters(index);
        if (clusterArray != null) {
            for (int i = 0; i < clusterArray.size(); ++i) {
                if (clusterType == 0) {
                    this.geneClusterManager.onRepositoryChanged(cr);
                    this.addHistory("Save Gene Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Auto Cluster");
                } else {
                    this.experimentClusterManager.onRepositoryChanged(cr);
                    this.addHistory("Save Sample Cluster: Serial #: " + clusterArray.get(i).getSerialNumber() + ", Source: Auto Cluster");
                }
                this.refreshCurrentViewer();
            }
        }
    }

    private void appendSampleAnnotation() {
        String msg = "<html><center><h1>Import Sample Annotation</h1></center>";
        msg = msg + "The sample annotation file should be a tab-delimited text file containing one header row for annotation labels (field names).";
        msg = msg + "The file may contain multiple columns of annotation with each column containing a header entry that indicates the nature of the annotation.";
        msg = msg + "The annotation for each sample is organized in rows corresponding to the order of the loaded samples.";
        msg = msg + "If annotation is missing for a sample the entry in that sample row may be left blank.  Please see the manual appendix on file formats for more information. </html>";
        HTMLMessageFileChooser dialog = new HTMLMessageFileChooser((Frame)this.getFrame(), "Sample Annotation File Selection", msg, TMEV.getDataPath(), true);
        dialog.setApproveButtonText("Load");
        dialog.setSize(500, 600);
        if (dialog.showModal() == 0) {
            File file = dialog.getSelectedFile();
            try {
                if (this.data.addNewSampleLabels(this.getFrame(), file)) {
                    this.menubar.replaceExperimentLabelMenuItems(this.data.getSlideNameKeyArray());
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.getFrame(), "Error processing sample annotation file. Check file format.", "Sample Annotation Input Error", 0);
            }
        }
    }

    private void appendGeneAnnotation() {
        String msg = "<html><center><h1>Import Gene Annotation</h1></center>";
        msg = msg + "Please select an annotation file to import.  The file should contain a column that can be used ";
        msg = msg + "to map annotation in the file to the proper genes.  After file selection you will be asked to identify ";
        msg = msg + "a key from the data and from the input file to be used to insure proper mapping of annotation. ";
        msg = msg + "Note that this file format should conform the MeV annotation file format conventions (.ann) file ";
        msg = msg + "described in the appendix of the manual</html>";
        HTMLMessageFileChooser dialog = new HTMLMessageFileChooser((Frame)this.getFrame(), "Gene Annotation File Selection", msg, TMEV.getDataPath(), true);
        dialog.setFileFilter((FileFilter)new AnnFileFilter());
        dialog.setApproveButtonText("Load");
        dialog.setSize(500, 600);
        if (dialog.showModal() == 0) {
            File file = dialog.getSelectedFile();
            try {
                AnnFileParser parser = new AnnFileParser();
                parser.loadFile(file);
                String[][] annMatrix = null;
                if (!parser.isAnnFileLoaded()) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Error processing gene annotation file. Please check file format.", "Sample Annotation Input Error", 0);
                    return;
                }
                Vector headerVector = parser.getColumnHeaders();
                annMatrix = parser.getDataMatrix(true);
                String[] dataFieldNames = this.data.getFieldNames();
                String[] fieldNamesWithUID = new String[dataFieldNames.length + 1];
                fieldNamesWithUID[0] = "UID";
                for (int i = 0; i < dataFieldNames.length; ++i) {
                    fieldNamesWithUID[i + 1] = dataFieldNames[i];
                }
                GeneAnnotationImportDialog importDialog = new GeneAnnotationImportDialog(this.getFrame(), fieldNamesWithUID, annMatrix[0]);
                if (importDialog.showModal() == 0) {
                    String[] newFields = importDialog.getSelectedAnnotationFields();
                    int updateCount = this.data.addNewGeneAnnotation(annMatrix, importDialog.getDataAnnotationKey(), importDialog.getFileAnnotationKey(), newFields);
                    if (updateCount > 0) {
                        this.data.getSlideMetaData().appendFieldNames(newFields);
                        this.menubar.replaceLabelMenuItems(this.data.getFieldNames());
                        String historyMsg = "New Gene Annotation\n";
                        historyMsg = historyMsg + "Annotation File = " + file.getAbsolutePath() + "\n";
                        historyMsg = historyMsg + "New Annotation Fields: ";
                        for (int i = 0; i < newFields.length; ++i) {
                            historyMsg = historyMsg + newFields[i];
                            if (i >= newFields.length - 1) continue;
                            historyMsg = historyMsg + ", ";
                        }
                        this.addHistory(historyMsg);
                        JOptionPane.showMessageDialog(this.getFrame(), "<html>Gene annotation has been successfully added.<br>Check the history node for field information.</html>", "Append Gene Annotation", 1);
                    } else {
                        String eMsg = "<html>Gene annotation addition has failed.  The identifying keys in the loaded data (" + importDialog.getDataAnnotationKey() + ")<br>";
                        eMsg = eMsg + "and the keys in the file (" + importDialog.getFileAnnotationKey() + ") did not have any matches.<br<br>The new annotation could not be mapped to the data.</html>";
                        JOptionPane.showMessageDialog(this.getFrame(), eMsg, "Append Gene Annotation", 1);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getFrame(), "Error processing gene annotation file. Please check file format.", "Sample Annotation Input Error", 0);
                e.printStackTrace();
            }
        }
    }

    private void appendResourcererAnnotation() {
        String msg = "<html><center><h1>Import Gene Annotation</h1></center>";
        msg = msg + "Please select an annotation file to import.  The file should contain a column that can be used ";
        msg = msg + "to map annotation in the file to the proper genes.  After file selection you will be asked to identify ";
        msg = msg + "a key from the data and from the input file to be used to ensure proper mapping of annotation. ";
        msg = msg + "Note that this file format should conform the MeV Resourcerer annotation file format conventions (.txt) file ";
        msg = msg + "described in the appendix of the manual</html>";
        GBA gba = new GBA();
        JPanel annotationPanel = new JPanel();
        annotationPanel.setLayout(new GridBagLayout());
        annotationPanel.setBorder(new EtchedBorder());
        this.adh = new AnnotationDownloadHandler(this.framework);
        if (this.framework.getData().isAnnotationLoaded()) {
            annotationPanel.setVisible(false);
            this.adh.setOptionalMessage("Annotation is already loaded for array " + this.framework.getData().getChipAnnotation().getChipType());
            this.adh.setAnnFilePath(this.framework.getData().getChipAnnotation().getAnnFileName());
        }
        this.adh.addListener(new EventListener());
        annotationPanel = this.adh.getAnnotationLoaderPanel(gba);
        this.adh.setDownloadEnabled(!this.framework.getData().isAnnotationLoaded());
        HTMLMessageFileChooser dialog = new HTMLMessageFileChooser((Frame)this.getFrame(), "Gene Annotation File Selection", msg, annotationPanel, true);
        dialog.setSize(new Dimension(640, 450));
        if (dialog.showModal() == 0) {
            this.processAnnotationFile();
        }
    }

    public void processAnnotationFile() {
        try {
            String[] dataFieldNames = this.framework.getData().getFieldNames();
            AnnotationFileReader reader = AnnotationFileReader.createAnnotationFileReader(this.getAnnotationFile());
            GeneAnnotationImportDialog importDialog = new GeneAnnotationImportDialog(new JFrame(), dataFieldNames, reader.getAvailableAnnotations());
            if (importDialog.showModal() == 0) {
                this.data.addResourcererGeneAnnotation(importDialog.getDataAnnotationKey(), reader.getAffyAnnotation());
                this.data.chipAnnotation = reader.getAffyChipAnnotation();
                this.menubar.replaceLabelMenuItems(this.data.getFieldNames());
                String historyMsg = "New Gene Annotation\n";
                historyMsg = historyMsg + "Annotation File = " + this.getAnnotationFile().getAbsolutePath() + "\n";
                historyMsg = historyMsg + "New Annotation Fields: ";
                this.addHistory(historyMsg);
                JOptionPane.showMessageDialog(this.getFrame(), "<html>Gene annotation has been successfully added.<br>Check the history node for field information.</html>", "Append Gene Annotation", 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.framework.getData().setAnnotationLoaded(true);
    }

    private File getAnnotationFile() {
        return new File(this.adh.getAnnFilePath());
    }

    public boolean isAnnotationSelected() {
        return this.adh.isAnnotationSelected();
    }

    private void appendResourcererGeneAnnotation() {
        String msg = "<html><center><h1>Import Gene Annotation</h1></center>";
        msg = msg + "Please select an annotation file to import.  The file should contain a column that can be used ";
        msg = msg + "to map annotation in the file to the proper genes.  After file selection you will be asked to identify ";
        msg = msg + "a key from the data and from the input file to be used to ensure proper mapping of annotation. ";
        msg = msg + "Note that this file format should conform the MeV Resourcerer annotation file format conventions (.txt) file ";
        msg = msg + "described in the appendix of the manual</html>";
        HTMLMessageFileChooser dialog = new HTMLMessageFileChooser((Frame)this.getFrame(), "Gene Annotation File Selection", msg, TMEV.getDataPath(), true);
        dialog.setFileFilter((FileFilter)new AnnFileFilter());
        dialog.setApproveButtonText("Load");
        dialog.setSize(500, 600);
        if (dialog.showModal() == 0) {
            File file = dialog.getSelectedFile();
            try {
                String[] dataFieldNames = this.data.getFieldNames();
                AnnotationFileReader reader = AnnotationFileReader.createAnnotationFileReader(file);
                GeneAnnotationImportDialog importDialog = new GeneAnnotationImportDialog(this.getFrame(), dataFieldNames, reader.getAvailableAnnotations());
                if (importDialog.showModal() == 0) {
                    this.data.addResourcererGeneAnnotation(importDialog.getDataAnnotationKey(), reader.getAffyAnnotation());
                    this.menubar.replaceLabelMenuItems(this.data.getFieldNames());
                    String historyMsg = "New Gene Annotation\n";
                    historyMsg = historyMsg + "Annotation File = " + file.getAbsolutePath() + "\n";
                    historyMsg = historyMsg + "New Annotation Fields: ";
                    this.addHistory(historyMsg);
                    JOptionPane.showMessageDialog(this.getFrame(), "<html>Gene annotation has been successfully added.<br>Check the history node for field information.</html>", "Append Gene Annotation", 1);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getFrame(), "Error processing gene annotation file. Please check file format.", "Sample Annotation Input Error", 0);
                e.printStackTrace();
            }
        }
    }

    public void onSetShowFlankingRegions(boolean show) {
        this.menubar.setShowFlankingRegions(show);
        this.fireMenuChanged();
    }

    private void onChangeCghElementLength(double length) {
        this.menubar.setCghElementLength(length);
        this.fireMenuChanged();
    }

    private void onChangeCghElementLengthOther() {
        String s = JOptionPane.showInputDialog(new JFrame(), "Enter Element Length", "Element Length", -1);
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            int val = Integer.parseInt(s);
            this.onChangeCghElementLength(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Input Must Be An Integer", "Number Format Error", -1);
        }
    }

    private void onChangeCghElementWidth(int width) {
        this.menubar.setCghElementWidth(width);
        this.fireMenuChanged();
    }

    private void onChangeCghElementWidthOther() {
        String s = JOptionPane.showInputDialog(new JFrame(), "Enter Element Width", "Element Width", -1);
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            int val = Integer.parseInt(s);
            this.onChangeCghElementWidth(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Input Must Be An Integer", "Number Format Error", -1);
        }
    }

    private void onChangeCghDisplayType(int displayType) {
        this.menubar.setCghDisplayType(displayType);
        this.fireMenuChanged();
        this.setCurrentViewer(this.getCurrentViewer());
    }

    private void onChangeDisplayLabelType(int displayLabelType) {
        this.menubar.setCghDisplayLabelType(displayLabelType);
        this.fireMenuChanged();
    }

    public void onSetClonePThresh() {
        SingleValueSelectorDialog dlg = new SingleValueSelectorDialog(this.framework.getFrame(), this.menubar.getCloneValueMenu().getClonePThresh() + "");
        if (dlg.showModal() == 0) {
            String value = dlg.getValue();
            try {
                float val = Float.parseFloat(value);
                this.menubar.setClonePThresh(val);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Input Must Be An Number", "Number Format Error", -1);
            }
            this.fireThresholdsChanged();
        }
    }

    private void fireThresholdsChanged() {
        this.onThresholdsChanged();
        IViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return;
        }
        this.doViewLayout();
    }

    public void onThresholdsChanged() {
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        this.data.onCopyDeterminationChanged(menu);
        this.onFlankingRegionDeterminationChanged();
    }

    public void onFlankingRegionDeterminationChanged() {
        int flankingRegionType = this.framework.getCghCloneValueMenu().getFlankingRegionType();
        this.calculateFlankingRegions(flankingRegionType);
    }

    public void calculateFlankingRegions(int flankingRegionType) {
        FlankingRegionCalculator flCalc = new FlankingRegionCalculator();
        flCalc.setExperiments(this.data.getFeaturesList());
        flCalc.setData(this.data);
        flCalc.setCopyDeterminationType(flankingRegionType);
        flCalc.calculateFlankingRegions();
    }

    private void onSetCircleViewerBackground() {
        Color newColor = JColorChooser.showDialog(new JFrame(), "Choose Background Color", Color.black);
        this.menubar.setCircleViewerBackgroundColor(newColor);
        this.fireMenuChanged();
    }

    private void onChangeCghDisplayOrder() {
        CGHDisplayOrderChanger changer = new CGHDisplayOrderChanger(this.data, this.framework.getFrame(), true);
        changer.setVisible(true);
        if (changer.isCancelled()) {
            return;
        }
        this.fireDataChanged();
    }

    private void onDeleteSample() {
        System.out.println("CGH onDeleteSample. Code ready not validated");
    }

    private void deleteSample(int sampleIndex) {
        int[] indicesOrder = this.data.getSamplesOrder();
        int deletedSampleIndex = indicesOrder[sampleIndex];
        this.data.getFeaturesList().remove(deletedSampleIndex);
        int[] newIndicesOrder = new int[indicesOrder.length - 1];
        int curIndex = 0;
        for (int i = 0; i < indicesOrder.length; ++i) {
            if (i == sampleIndex) continue;
            newIndicesOrder[curIndex] = indicesOrder[i] > deletedSampleIndex ? indicesOrder[i] - 1 : indicesOrder[i];
            ++curIndex;
        }
        this.data.setSamplesOrder(newIndicesOrder);
    }

    private void onClearAnnotations() {
        this.data.setAnnotations(new ICGHDataRegion[0][0]);
        this.fireDataChanged();
    }

    public void onChangeCloneValueType(int cloneValueType) {
        this.menubar.setCloneValueType(cloneValueType);
        this.fireCloneValuesChanged();
    }

    public void onChangeFlankingRegionType(int flankingRegionType) {
        this.menubar.setFlankingRegionType(flankingRegionType);
        this.onFlankingRegionDeterminationChanged();
        this.fireCloneValuesChanged();
    }

    private void onCghSetThresholds() {
        ICGHCloneValueMenu menu = this.menubar.getCloneValueMenu();
        CGHThresholdSetter setter = new CGHThresholdSetter(this.getFrame(), menu.getAmpThresh(), menu.getDelThresh(), menu.getAmpThresh2Copy(), menu.getDelThresh2Copy());
        if (setter.showModal() == 0) {
            this.menubar.setAmpThresh(setter.getAmpThresh());
            this.menubar.setDelThresh(setter.getDelThresh());
            this.menubar.setAmpThresh2Copy(setter.getAmpThresh2Copy());
            this.menubar.setDelThresh2Copy(setter.getDelThresh2Copy());
            this.fireThresholdsChanged();
        }
    }

    private void onRenameNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node.getParent() == null) {
            return;
        }
        if (node.getUserObject() instanceof LeafInfo) {
            String name = JOptionPane.showInputDialog(this.getFrame(), "Enter New Name", node.toString());
            if (name != null && name.length() > 0) {
                ((LeafInfo)node.getUserObject()).setName(name);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
            }
        } else if (node.getUserObject() instanceof String) {
            String name;
            String oldName = (String)node.getUserObject();
            String oldAppend = "";
            if (oldName.indexOf(58) != -1) {
                oldAppend = oldName.substring(oldName.indexOf(58) + 1);
                oldName = oldName.substring(0, oldName.indexOf(58));
            }
            if ((name = JOptionPane.showInputDialog(this.getFrame(), "Append to " + oldName + ":", oldAppend)) != null && name.length() > 0) {
                node.setUserObject(oldName + ": " + name);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
            }
        }
    }

    private void addDataView(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        if (!this.mainViewerNode.getAllowsChildren()) {
            this.mainViewerNode.setAllowsChildren(true);
            treeModel.insertNodeInto(node, this.mainViewerNode, this.mainViewerNode.getChildCount());
            this.mainViewerNode.setAllowsChildren(false);
        } else {
            treeModel.insertNodeInto(node, this.mainViewerNode, this.mainViewerNode.getChildCount());
        }
        TreeSelectionModel selModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(node.getPath());
        selModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private void onCghAnalysis(Action action) {
        String className = (String)action.getValue("command-parameter");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(className, true, cl);
            NumberOfAlterationsCalculator gui = (NumberOfAlterationsCalculator)clazz.newInstance();
            DefaultMutableTreeNode result = gui.execute(this.framework);
            this.addAnalysisResult(result);
        }
        catch (ClassCastException e) {
            System.out.println("Error: org.tigr.microarray.mev.cluster.gui.IClusterGUI interface is expected.");
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
        catch (Exception e) {
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, e);
        }
    }

    public void onDataChanged() {
        this.fireDataChanged();
    }

    public void onCloneValuesChanged() {
        this.fireCloneValuesChanged();
    }

    private void fireCloneValuesChanged() {
        IViewer viewer = this.getCurrentViewer();
        if (viewer instanceof ICGHViewer) {
            ((ICGHViewer)viewer).onCloneValuesChanged(this.framework.getCghCloneValueMenu());
            this.doViewLayout();
        }
    }

    private void onShowHeader(boolean show) {
        if (show) {
            this.getCurrentViewer().getHeaderComponent().setVisible(show);
            this.viewScrollPane.getColumnHeader().setVisible(show);
        } else {
            this.getCurrentViewer().getHeaderComponent().setVisible(show);
            this.viewScrollPane.getColumnHeader().setVisible(show);
        }
    }

    public void onChromosomeSelected(EventObject eventObj) {
        int chromosomeIndex = (Integer)eventObj.getSource();
        TreeNode selectedNode = this.mainViewerNode.getChildAt(1).getChildAt(chromosomeIndex);
        this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)selectedNode).getPath()));
    }

    public void CloneDistributionsLoaded() {
        System.out.println("onCloneDistributionsLoaded ");
    }

    protected void onCGHClose() {
    }

    public MultipleArrayMenubar getMenubar() {
        return this.menubar;
    }

    public void setMenubar(MultipleArrayMenubar menubar) {
    }

    private Vector initializeViews() {
        DefaultMutableTreeNode experimentViews = new DefaultMutableTreeNode(new LeafInfo("Experiment Views"), true);
        DefaultMutableTreeNode chromosomeViews = new DefaultMutableTreeNode(new LeafInfo("Chromosome Views"), true);
        for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
            CGHCircleViewerPanel circlePanel = new CGHCircleViewerPanel(new CGHCircleViewerModel(this.framework));
            circlePanel.setExperimentIndex(i);
            circlePanel.setBackground(Color.darkGray);
            circlePanel.setDrsListener((EventListener)this.manager.getListener());
            String name = this.data.getSampleName(i);
            DefaultMutableTreeNode circleViewerNode = new DefaultMutableTreeNode(new LeafInfo(name, (IViewer)circlePanel), false);
            experimentViews.add(circleViewerNode);
        }
        CGHPositionGraphCombinedHeader combinedHeader = new CGHPositionGraphCombinedHeader(new Insets(0, 0, 0, 0));
        for (int i = 0; i < this.data.getNumChromosomes(); ++i) {
            CGHPositionGraphDataModel posModel = new CGHPositionGraphDataModel(this.framework, i);
            CGHAnnotationsModel annotationsModel = new CGHAnnotationsModel(this.framework, i);
            CGHPositionGraphViewer posGraphViewer = new CGHPositionGraphViewer(this.framework, combinedHeader);
            posGraphViewer.setPositionGraphModel(posModel);
            posGraphViewer.setAnnotationsModel(annotationsModel);
            posGraphViewer.setCytoBandsModel(this.framework.getCytoBandsModel());
            posGraphViewer.setDrsListener((EventListener)this.manager.getListener());
            String name = CGHUtility.convertChromToLongString(i + 1, this.data.getCGHSpecies());
            DefaultMutableTreeNode chromosomeViewerNode = new DefaultMutableTreeNode(new LeafInfo(name, (IViewer)posGraphViewer), false);
            chromosomeViews.add(chromosomeViewerNode);
        }
        Vector<DefaultMutableTreeNode> viewerNodes = new Vector<DefaultMutableTreeNode>(2);
        viewerNodes.add(experimentViews);
        viewerNodes.add(chromosomeViews);
        return viewerNodes;
    }

    public void DisplayDataValues(EventObject eventObj) {
        CGHDataRegionInfo dataRegionInfo = (CGHDataRegionInfo)eventObj.getSource();
        CGHDataValuesDisplay display = new CGHDataValuesDisplay(this.framework.getFrame(), true);
        display.setData(this.data);
        display.setDataRegionInfo(dataRegionInfo);
        display.createTextDocument();
        display.setVisible(true);
    }

    public void searchForGene() {
        String geneName = JOptionPane.showInputDialog(this.framework.getFrame(), "", "Enter Gene Name", -1);
        if (geneName == null || geneName.length() == 0) {
            return;
        }
        GeneDataSet geneDataSet = new GeneDataSet();
        geneDataSet.loadGeneDataByGeneName(geneName, this.data.getCGHSpecies());
        Vector vecGeneData = geneDataSet.getGeneData();
        this.showGeneDataDlg(vecGeneData);
    }

    public void ShowGenes(EventObject eventObj) {
        System.out.println("Show Genes in Region");
        CGHDataRegionInfo dataRegionInfo = (CGHDataRegionInfo)eventObj.getSource();
        ICGHDataRegion dataRegion = dataRegionInfo.getDataRegion();
        DataRegionGeneData geneDataSet = new DataRegionGeneData(dataRegion);
        geneDataSet.loadGeneData(this.data.getCGHSpecies());
        Vector vecGeneData = geneDataSet.getGeneData();
        this.showGeneDataDlg(vecGeneData);
    }

    private void showGeneDataDlg(Vector vecGeneData) {
        GeneAmplifications amps = new GeneAmplifications(this.framework);
        amps.setData(this.data);
        GeneDeletions dels = new GeneDeletions(this.framework);
        dels.setData(this.data);
        Iterator it = vecGeneData.iterator();
        Vector<AlterationRegion> alterationRegions = new Vector<AlterationRegion>();
        while (it.hasNext()) {
            AlterationRegion alterationRegion = new AlterationRegion();
            ICGHDataRegion dataRegion = (ICGHDataRegion)it.next();
            alterationRegion.setDataRegion(dataRegion);
            alterationRegion.setNumDeletions(dels.getNumAlterations(dataRegion));
            alterationRegion.setNumAmplifications(amps.getNumAlterations(dataRegion));
            alterationRegion.setNumSamples(this.data.getFeaturesCount());
            alterationRegions.add(alterationRegion);
        }
        NumberOfDeletionsAmpilficationsDataModel dataModel = new NumberOfDeletionsAmpilficationsDataModel();
        dataModel.setAlterationRegions(alterationRegions.toArray(new AlterationRegion[alterationRegions.size()]));
        NumberOfAlterationsViewer viewer = new NumberOfAlterationsViewer();
        viewer.setData(this.data);
        viewer.addDrsListener((EventListener)this.manager.getListener());
        viewer.setDataModel(dataModel);
        JDialog dlg = new JDialog(this.framework.getFrame(), "Gene Alterations");
        dlg.getContentPane().add(viewer);
        dlg.setJMenuBar((JMenuBar)viewer.getHeaderComponent());
        dlg.setSize(1000, 500);
        GuiUtil.center(dlg);
        dlg.setVisible(true);
    }

    public void ShowBrowser(EventObject eventObj) {
        int browserCloneValues;
        CGHTableDataModel tableModel;
        CGHChartDataModel chartModel;
        CGHDataRegionInfo dataRegionInfo = (CGHDataRegionInfo)eventObj.getSource();
        int experimentIndex = dataRegionInfo.getExperimentIndex();
        ICGHDataRegion dataRegion = dataRegionInfo.getDataRegion();
        int chromosomeIndex = dataRegion.getChromosomeIndex();
        if (this.data.isHasDyeSwap()) {
            chartModel = new CGHChartDataModelDyeSwap(this.framework, experimentIndex, chromosomeIndex);
            tableModel = new CGHTableDataModelDyeSwap(this.framework, experimentIndex, chromosomeIndex);
            browserCloneValues = TMEV.browserDefaultDyeSwapValue;
        } else {
            chartModel = new CGHChartDataModelNoDyeSwap(this.framework, experimentIndex, chromosomeIndex);
            tableModel = new CGHTableDataModelNoDyeSwap(this.framework, experimentIndex, chromosomeIndex);
            browserCloneValues = TMEV.browserDefaultNoDyeSwapValue;
        }
        CGHBrowser browser = new CGHBrowser(this.data, experimentIndex, chromosomeIndex, chartModel, tableModel, browserCloneValues, this.data.isHasDyeSwap());
        browser.show();
        browser.setSelectedRegion(dataRegion);
    }

    public void AnnotationsSelected(EventObject eventObj) {
        ICGHDataRegion[][] annotationRegions = (ICGHDataRegion[][])eventObj.getSource();
        int chromIndex = this.getMinChromosomeIndex(annotationRegions);
        if (chromIndex != -1) {
            this.fireChromosomeSelected(new EventObject(new Integer(chromIndex)));
        }
    }

    public int getMinChromosomeIndex(ICGHDataRegion[][] annotationRegions) {
        for (int i = 0; i < annotationRegions.length; ++i) {
            if (annotationRegions[i].length <= 0) continue;
            return i;
        }
        return -1;
    }

    private void fireChromosomeSelected(EventObject eventObject) {
        this.onChromosomeSelected(eventObject);
    }

    public void ExperimentsLoaded() {
        this.menubar.initCloneValuesMenu(this.data.isHasDyeSwap());
        this.menubar.enableCloneDistributions(this.data.hasCloneDistribution(), this.data.isLog2Data());
        ICGHCloneValueMenu menu = this.framework.getCghCloneValueMenu();
        this.data.onCopyDeterminationChanged(menu);
        Vector viewerNodes = this.initializeViews();
        this.removeChildren(this.mainViewerNode);
        Iterator it = viewerNodes.iterator();
        while (it.hasNext()) {
            this.addDataView((DefaultMutableTreeNode)it.next());
        }
        this.tree.repaint();
    }

    private void loadCytoBandFile() {
        CytoBands cytoBands = new CytoBands();
        File cytoBandsFile = null;
        if (this.data.getCGHSpecies() == 0) {
            cytoBandsFile = new File("data/CGH/Hs_CytoBands.txt");
        } else if (this.data.getCGHSpecies() == 1) {
            cytoBandsFile = new File("data/CGH/Mm_CytoBands.txt");
        }
        cytoBands.loadAllCytoBands(cytoBandsFile, this.data.getCGHSpecies());
        this.cytoBandsModel = new CytoBandsModel(cytoBands);
    }

    protected void removeChildren(DefaultMutableTreeNode removeNode) {
        while (removeNode.getChildCount() > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)removeNode.getFirstChild();
            if (node == null || node.getParent() == null) {
                return;
            }
            this.fireOnCloseEvent(node);
            TreePath parentPath = new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath());
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
            this.tree.getSelectionModel().setSelectionPath(parentPath);
            this.tree.scrollPathToVisible(parentPath);
        }
    }

    private void initSessionMetaData() {
        this.smd = new SessionMetaData();
        this.smd.setSaveDate(new Date());
        this.smd.setJREVersion(System.getProperty("java.version"));
        this.smd.setJVMVersion(System.getProperty("java.vm.version"));
        this.smd.setMevMajorVersion(4);
        this.smd.setMevMinorVersion(1);
        this.smd.setMevMicroVersion(1);
        this.smd.setBeta(false);
    }

    public IResourceManager getResourceManager() {
        return TMEV.getResourceManager();
    }

    public File getSupportFile(ISupportFileDefinition def) throws SupportFileAccessError {
        return this.framework.getSupportFile(def, true);
    }

    public Hashtable<ISupportFileDefinition, File> getSupportFiles(Collection<ISupportFileDefinition> defs) throws SupportFileAccessError {
        return this.framework.getSupportFiles(defs, true);
    }

    public Hashtable<ISupportFileDefinition, File> getMultipleSupportFiles(IMultiSupportFileDefinition def) throws SupportFileAccessError {
        return this.framework.getMultipleSupportFiles(def);
    }

    public boolean hasSupportFile(ISupportFileDefinition def) {
        return this.framework.hasSupportFile(def);
    }

    public boolean isResourceManagerAvailable() {
        return this.framework.isResourceManagerAvailable();
    }

    public String getCurrentSpecies() {
        try {
            String loadedAnnotationSpeciesName = this.data.getGaggleOrganismName();
            if (loadedAnnotationSpeciesName != null && !loadedAnnotationSpeciesName.equalsIgnoreCase("na") && !loadedAnnotationSpeciesName.equalsIgnoreCase("unknown")) {
                return loadedAnnotationSpeciesName;
            }
            return this.askUserForSpeciesName("");
        }
        catch (Exception e) {
            return this.askUserForSpeciesName("");
        }
    }

    public String askUserForSpeciesName(String currentName) {
        GetSpeciesDialog gsd = new GetSpeciesDialog(this.getFrame(), currentName);
        String speciesName = gsd.showModal();
        if (speciesName == null) {
            return "unknown";
        }
        if (gsd.saveSpeciesName()) {
            this.data.setGaggleOrganismName(speciesName);
        }
        return speciesName;
    }

    public void setIDF(MageIDF idfObj) {
        this.data.setIDF(idfObj);
    }

    private class FrameworkImpl
    implements IFramework {
        private FrameworkImpl() {
        }

        public IData getData() {
            return MultipleArrayViewer.this.getData();
        }

        public JFrame getJFrame() {
            return MultipleArrayViewer.this.mainframe;
        }

        public AlgorithmFactory getAlgorithmFactory() {
            return MultipleArrayViewer.this.getAlgorithmFactory();
        }

        public IDisplayMenu getDisplayMenu() {
            return MultipleArrayViewer.this.menubar.getDisplayMenu();
        }

        public IDistanceMenu getDistanceMenu() {
            return MultipleArrayViewer.this.menubar.getDistanceMenu();
        }

        public Frame getFrame() {
            return MultipleArrayViewer.this.getFrame();
        }

        public void setContentLocation(int x, int y) {
            MultipleArrayViewer.this.setContentLocation(x, y);
        }

        public void displaySlideElementInfo(int feature, int probe) {
            MultipleArrayViewer.this.displaySlideElementInfo(feature, probe);
        }

        public String getStatusText() {
            return MultipleArrayViewer.this.getStatusText();
        }

        public void setStatusText(String text) {
            MultipleArrayViewer.this.setStatusText(text);
        }

        public Object getUserObject() {
            return MultipleArrayViewer.this.getUserObject();
        }

        public void setTreeNode(DefaultMutableTreeNode node) {
            MultipleArrayViewer.this.selectNode(node);
        }

        public void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
            MultipleArrayViewer.this.addNode(parent, child);
        }

        public Color storeCluster(int[] indices, Experiment experiment, int clusterType) {
            return MultipleArrayViewer.this.storeCluster(indices, experiment, clusterType);
        }

        public void storeClusterWithoutDialog(int[] clusterIndices, String source, String factor, String node, String label, String clusterDescription, int clusterType) {
            MultipleArrayViewer.this.storeClusterWithoutDialog(clusterIndices, source, factor, node, label, clusterDescription, clusterType);
        }

        public Color storeCluster(int[] indices, Experiment experiment, int clusterType, Color color) {
            return MultipleArrayViewer.this.storeCluster(indices, experiment, clusterType, color);
        }

        public void autoStoreClusters(int clusterType, int index) {
            MultipleArrayViewer.this.onAutoImportList(clusterType, index);
        }

        public Color storeSubCluster(int[] indices, Experiment experiment, int clusterType) {
            return MultipleArrayViewer.this.storeSubCluster(indices, experiment, clusterType);
        }

        public boolean removeSubCluster(int[] indices, Experiment experiment, int clusterType) {
            return MultipleArrayViewer.this.removeSubCluster(indices, experiment, clusterType);
        }

        public boolean removeCluster(int[] indices, Experiment experiment, int clusterType) {
            return MultipleArrayViewer.this.removeCluster(indices, experiment, clusterType);
        }

        public void launchNewMAV(int[] indices, Experiment experiment, String label, int clusterType) {
            MultipleArrayViewer.this.launchNewMAV(indices, experiment, label, clusterType);
        }

        public void openClusterNode(String algorithmNode, String clusterID) {
            MultipleArrayViewer.this.openClusterNode(algorithmNode, clusterID);
        }

        public ClusterRepository getClusterRepository(int clusterType) {
            return MultipleArrayViewer.this.getClusterRepository(clusterType);
        }

        public DefaultMutableTreeNode getCurrentNode() {
            return MultipleArrayViewer.this.getCurrentNode();
        }

        public DefaultMutableTreeNode getNode(Object object) {
            return MultipleArrayViewer.this.getNode(object);
        }

        public void addHistory(String historyEvent) {
            MultipleArrayViewer.this.addHistory(historyEvent);
        }

        public ResultTree getResultTree() {
            return MultipleArrayViewer.this.getResultTree();
        }

        public void addAnalysisResult(DefaultMutableTreeNode resultNode) {
            MultipleArrayViewer.this.addAnalysisResult(resultNode);
        }

        public void refreshCurrentViewer() {
            MultipleArrayViewer.this.refreshCurrentViewer();
        }

        public void storeOperationCluster(String source, String clusterID, int[] indices, boolean geneCluster) {
            MultipleArrayViewer.this.storeOperationCluster(source, clusterID, indices, geneCluster);
        }

        public ICGHDisplayMenu getCghDisplayMenu() {
            return MultipleArrayViewer.this.menubar.getCghDisplayMenu();
        }

        public ICGHCloneValueMenu getCghCloneValueMenu() {
            return MultipleArrayViewer.this.menubar.getCloneValueMenu();
        }

        public Rectangle getViewerBounds() {
            return MultipleArrayViewer.this.viewScrollPane.getViewportBorderBounds();
        }

        public CytoBandsModel getCytoBandsModel() {
            return MultipleArrayViewer.this.cytoBandsModel;
        }

        public void broadcastGeneClusters(Cluster[] clusters) {
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            String fieldname = MultipleArrayViewer.this.data.getFieldNames()[MultipleArrayViewer.this.getMenubar().getDisplayMenu().getLabelIndex()];
            ClusterWorker cw = new ClusterWorker(this.getClusterRepository(0));
            int[] indices = cw.getUniqueIndices(clusters);
            DataMatrix dm = gt.createMatrix(indices, fieldname, MultipleArrayViewer.this.data.getChipAnnotation().getSpeciesName(), clusters[0].getAlgorithmName());
            int rowCount = dm.getRowCount();
            if (rowCount > 100) {
                String title = "Broadcast matrix warning";
                String msg = "Do you really wish to broadcast " + rowCount + " records?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            MultipleArrayViewer.this.gooseImpl.doBroadcastMatrix(dm, null);
        }

        public void broadcastGeneClusterToGenomeBrowser(Experiment experiment, int[] rows, int[] columns) {
            String genomeBrowserName;
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            ArrayList<Integer> goodLocations = new ArrayList<Integer>();
            String[] chrLocations = MultipleArrayViewer.this.data.getAnnotationList("CHR_LOCATION", rows);
            for (int i = 0; i < chrLocations.length; ++i) {
                if (!GenomeBrowserWebstart.isCompleteChrLocation((String)chrLocations[i])) continue;
                goodLocations.add(rows[i]);
            }
            if (goodLocations.size() < rows.length) {
                int[] filteredIndices = new int[goodLocations.size()];
                int j = 0;
                for (Integer i : goodLocations) {
                    filteredIndices[j] = i;
                    ++j;
                }
                rows = filteredIndices;
            }
            if (rows.length <= 0) {
                JOptionPane.showMessageDialog(new JFrame(), "No chromosomal location data is loaded for this selection.\nThe genome browser cannot map this data without chromosomal coordinate information.", "No chromosomal coordinate information", 0);
                return;
            }
            DataMatrix dm = gt.createMatrix(rows, "CHR_LOCATION", MultipleArrayViewer.this.data.getChipAnnotation().getSpeciesName(), null);
            int rowCount = dm.getRowCount();
            if (rowCount > 100) {
                String title = "Broadcast matrix warning";
                String msg = "Do you really wish to broadcast " + rowCount + " records?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            if ((genomeBrowserName = MultipleArrayViewer.this.gooseImpl.getGenomeBrowserGoose(dm.getSpecies())) == null) {
                return;
            }
            MultipleArrayViewer.this.gooseImpl.doBroadcastMatrix(dm, genomeBrowserName);
        }

        public void broadcastGeneCluster(Experiment experiment, int[] rows, int[] columns) {
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            String fieldname = MultipleArrayViewer.this.data.getFieldNames()[MultipleArrayViewer.this.getMenubar().getDisplayMenu().getLabelIndex()];
            DataMatrix dm = gt.createMatrix(rows, fieldname, MultipleArrayViewer.this.data.getChipAnnotation().getSpeciesName(), null);
            int rowCount = dm.getRowCount();
            if (rowCount > 100) {
                String title = "Broadcast matrix warning";
                String msg = "Do you really wish to broadcast " + rowCount + " records?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            MultipleArrayViewer.this.gooseImpl.doBroadcastMatrix(dm, null);
        }

        public void broadcastNamelist(Cluster[] clusters) {
            ClusterWorker cw = new ClusterWorker(this.getClusterRepository(0));
            int[] indices = cw.getUniqueIndices(clusters);
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            Namelist nl = gt.createNamelist(MultipleArrayViewer.this.data.getExperiment(), indices);
            int rowCount = nl.getNames().length;
            if (rowCount > 100) {
                String title = "Broadcast names warning";
                String msg = "Do you really wish to broadcast " + rowCount + " records?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            MultipleArrayViewer.this.gooseImpl.doBroadcastNamelist(nl);
        }

        public void broadcastNamelist(Experiment e, int[] rows) {
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            Namelist nl = gt.createNamelist(e, rows);
            int rowCount = nl.getNames().length;
            if (rowCount > 100) {
                String title = "Broadcast names warning";
                String msg = "Do you really wish to broadcast " + rowCount + " records?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            MultipleArrayViewer.this.gooseImpl.doBroadcastNamelist(nl);
        }

        public void broadcastNetwork(Vector<int[]> interactions, Vector<String> types, Vector<Boolean> directionals) {
            GaggleTranslater gt = new GaggleTranslater(MultipleArrayViewer.this);
            Network nt = gt.createNetwork(interactions, types, directionals);
            int networkSize = nt.getNodes().length;
            if (networkSize > 100) {
                String title = "Broadcast names warning";
                String msg = "Do you really wish to broadcast " + networkSize + " nodes?";
                int dialogResult = JOptionPane.showConfirmDialog(MultipleArrayViewer.this, msg, title, 0);
                if (dialogResult != 0) {
                    return;
                }
            }
            this.broadcastNet(nt);
        }

        public void broadcastNet(Network nt) {
            MultipleArrayViewer.this.gooseImpl.doBroadcastNetwork(nt);
        }

        public boolean isGaggleConnected() {
            return MultipleArrayViewer.this.gooseImpl.isConnected();
        }

        public boolean requestGaggleConnect() {
            return MultipleArrayViewer.this.gooseImpl.connectToGaggle();
        }

        public File getSupportFile(ISupportFileDefinition def) throws SupportFileAccessError {
            return this.getSupportFile(def, true);
        }

        public File getSupportFile(ISupportFileDefinition def, boolean getOnline) throws SupportFileAccessError {
            if (this.isResourceManagerAvailable()) {
                return TMEV.getResourceManager().getSupportFile(def, true);
            }
            throw new SupportFileAccessError("ResourceManager is not available");
        }

        public Hashtable<ISupportFileDefinition, File> getMultipleSupportFiles(IMultiSupportFileDefinition def) throws SupportFileAccessError {
            if (this.isResourceManagerAvailable()) {
                return TMEV.getResourceManager().getMultipleSupportFiles(def);
            }
            throw new SupportFileAccessError("ResourceManager is not available");
        }

        public boolean hasSupportFile(ISupportFileDefinition def) {
            if (this.isResourceManagerAvailable()) {
                return TMEV.getResourceManager().fileIsInRepository(def);
            }
            return false;
        }

        public boolean isResourceManagerAvailable() {
            return TMEV.getResourceManager() != null;
        }

        public IResourceManager getResourceManager() {
            return TMEV.getResourceManager();
        }

        public Hashtable<ISupportFileDefinition, File> getSupportFiles(Collection<ISupportFileDefinition> defs, boolean getOnline) throws SupportFileAccessError {
            return TMEV.getResourceManager().getSupportFiles(defs, getOnline);
        }
    }

    private class EventListener
    extends MouseAdapter
    implements GaggleListener,
    ActionListener,
    TreeSelectionListener,
    KeyListener,
    WindowListener,
    Serializable,
    IDataRegionSelectionListener,
    ICGHListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("command-close")) {
                MultipleArrayViewer.this.onClose();
            } else if (command.equals("command-clear-data")) {
                MultipleArrayViewer.this.onClearData();
            } else if (command.equals("command-load-file")) {
                MultipleArrayViewer.this.onLoadFile();
            } else if (!command.equals("command-load-expression")) {
                if (command.equals("command-load-directory")) {
                    this.onLoadDirectory();
                } else if (command.equals("command-load")) {
                    MultipleArrayViewer.this.loadData();
                } else if (command.equals("command-load-cluster")) {
                    MultipleArrayViewer.this.onLoadCluster();
                } else if (command.equals("command-load-stanford")) {
                    MultipleArrayViewer.this.onLoadStanford();
                } else if (command.equals("command-load-db")) {
                    MultipleArrayViewer.this.onLoadDatabase();
                } else if (command.equals("toggle-abbr-expt-names-cmd")) {
                    MultipleArrayViewer.this.data.toggleExptNameLength();
                    MultipleArrayViewer.this.fireDataChanged();
                    MultipleArrayViewer.this.fireMenuChanged();
                    MultipleArrayViewer.this.fireHeaderChanged();
                    MultipleArrayViewer.this.doViewLayout();
                } else if (command.equals("display-label-cmd")) {
                    MultipleArrayViewer.this.onLabelChanged((Action)event.getSource());
                } else if (command.equals("display-experiment-label-cmd")) {
                    MultipleArrayViewer.this.onExperimentLabelChanged((Action)event.getSource());
                } else if (command.equals("add-new-experiment-label")) {
                    MultipleArrayViewer.this.onExperimentLabelAdded();
                } else if (command.equals("add-new-idf-label")) {
                    MultipleArrayViewer.this.onIDFFieldsAdded();
                } else if (command.equals("display-10x10-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(10, 10);
                } else if (command.equals("display-20x5-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(20, 5);
                } else if (command.equals("display-50x10-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(50, 10);
                } else if (command.equals("display-5x2-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(5, 2);
                } else if (command.equals("display-other-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged();
                } else if (command.equals("default-font")) {
                    MultipleArrayViewer.this.onFontChanged("monospaced");
                } else if (command.equals("times-new-roman-font")) {
                    MultipleArrayViewer.this.onFontChanged("Times New Roman");
                } else if (command.equals("arial-font")) {
                    MultipleArrayViewer.this.onFontChanged("Arial");
                } else if (command.equals("sansserif")) {
                    MultipleArrayViewer.this.onFontChanged("sansserif");
                } else if (command.equals("serif")) {
                    MultipleArrayViewer.this.onFontChanged("serif");
                } else if (command.equals("helvetica")) {
                    MultipleArrayViewer.this.onFontChanged("Helvetica");
                } else if (command.equals("courier")) {
                    MultipleArrayViewer.this.onFontChanged("Courier");
                } else if (command.equals("font-size-default")) {
                    this.onFontSizeChanged(0);
                } else if (command.equals("font-size-8")) {
                    this.onFontSizeChanged(8);
                } else if (command.equals("font-size-12")) {
                    this.onFontSizeChanged(12);
                } else if (command.equals("font-size-16")) {
                    this.onFontSizeChanged(16);
                } else if (command.equals("font-size-20")) {
                    this.onFontSizeChanged(20);
                } else if (command.equals("font-size-fit")) {
                    this.onFontSizeChanged(-1);
                } else if (command.equals("display-green-red-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(5);
                } else if (command.equals("display-blue-yellow-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(6);
                } else if (command.equals("display-rainbow-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(8);
                } else if (command.equals("display-custom-color-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(7);
                } else if (command.equals("display-accessible-color-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(10);
                } else if (command.equals("display-color-gradient-cmd")) {
                    MultipleArrayViewer.this.onColorGradientChange(((JCheckBoxMenuItem)event.getSource()).isSelected());
                } else if (command.equals("display-draw-borders-cmd")) {
                    MultipleArrayViewer.this.onDrawBorders();
                } else if (command.equals("compact-clusters-cmd")) {
                    MultipleArrayViewer.this.onCompactClusters();
                } else if (command.equals("show-rects-cmd")) {
                    MultipleArrayViewer.this.onShowRects();
                } else if (command.equals("auto-arrange-colors-cmd")) {
                    MultipleArrayViewer.this.onAutoArrangeColors();
                } else if (command.equals("system-info-cmd")) {
                    MultipleArrayViewer.this.onSystemInfo();
                } else if (command.equals("default-distances-cmd")) {
                    MultipleArrayViewer.this.onDefaultDistance();
                } else if (command.equals("total-intensity-cmd")) {
                    MultipleArrayViewer.this.onNormalize(1);
                } else if (command.equals("linear-regression-cmd")) {
                    MultipleArrayViewer.this.onNormalize(3);
                } else if (command.equals("ratio-statistics-cmd")) {
                    MultipleArrayViewer.this.onNormalize(5);
                } else if (command.equals("iterative-log-cmd")) {
                    MultipleArrayViewer.this.onNormalize(6);
                } else if (command.equals("total-intensity-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(101);
                } else if (command.equals("linear-regression-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(103);
                } else if (command.equals("ratio-statistics-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(105);
                } else if (command.equals("iterative-log-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(106);
                } else if (command.equals("no-normalization-cmd")) {
                    MultipleArrayViewer.this.onNormalize(0);
                } else if (command.equals("command-save-image")) {
                    MultipleArrayViewer.this.onSaveImage();
                } else if (command.equals("command-print-image")) {
                    MultipleArrayViewer.this.onPrintImage();
                } else if (command.equals("analysis-command")) {
                    MultipleArrayViewer.this.onAnalysis((Action)event.getSource());
                } else if (command.equals("default-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(0);
                } else if (command.equals("pearson-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(1);
                } else if (command.equals("pearson-uncentered-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(6);
                } else if (command.equals("pearson-squared-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(7);
                } else if (command.equals("cosine-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(2);
                } else if (command.equals("covariance-value-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(3);
                } else if (command.equals("euclidean-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(4);
                } else if (command.equals("average-dot-product-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(5);
                } else if (command.equals("manhattan-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(8);
                } else if (command.equals("mutual-information-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(11);
                } else if (command.equals("spearman-rank-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(9);
                } else if (command.equals("kendalls-tau-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(10);
                } else if (command.equals("absolute-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceAbsolute(((AbstractButton)event.getSource()).isSelected());
                } else if (command.equals("delete-node-cmd")) {
                    MultipleArrayViewer.this.onDeleteNode();
                } else if (command.equals("rename-node-cmd")) {
                    MultipleArrayViewer.this.onRenameNode();
                } else if (command.equals("use-percentage-cutoffs-cmd")) {
                    MultipleArrayViewer.this.applyPercentageCutoffs();
                } else if (command.equals("use-present-call-cmd")) {
                    MultipleArrayViewer.this.applyPresentCallFilter();
                } else if (command.equals("use-genepixflags-cmd")) {
                    MultipleArrayViewer.this.applyGenePixFlagsFilter();
                } else if (command.equals("use-gcos-percentage-cutoff-cmd")) {
                    MultipleArrayViewer.this.applyGCOSPercentageFilter();
                } else if (command.equals("use-pvalue-percentage-cutoff-cmd")) {
                    MultipleArrayViewer.this.applyPvaluePercentageFilter();
                } else if (command.equals("use-lower-cutoffs-cmd")) {
                    MultipleArrayViewer.this.applyLowerCutoffs();
                } else if (command.equals("use-variance-filter-cmd")) {
                    MultipleArrayViewer.this.applyVarianceFilter();
                } else if (command.equals("import-gene-list-command")) {
                    MultipleArrayViewer.this.onImportList(0);
                } else if (command.equals("import-sample-list-command")) {
                    MultipleArrayViewer.this.onImportList(1);
                } else if (command.equals("bin-import-gene-list-command")) {
                    MultipleArrayViewer.this.onBinImportList(0);
                } else if (command.equals("bin-import-sample-list-command")) {
                    MultipleArrayViewer.this.onBinImportList(1);
                } else if (command.equals("auto-import-gene-list-command")) {
                    MultipleArrayViewer.this.onAutoCluster(0);
                } else if (command.equals("auto-import-sample-list-command")) {
                    MultipleArrayViewer.this.onAutoCluster(1);
                } else if (command.equals("cdna-low-intensity-cmd")) {
                    MultipleArrayViewer.this.applyLowerCutoffs();
                } else if (command.equals("oligen-low-intensity-cmd")) {
                    MultipleArrayViewer.this.applySingleLowerCutoffs();
                } else if (command.equals("rama-cmd")) {
                    MultipleArrayViewer.this.onRama();
                } else if (command.equals("rama-doc-cmd")) {
                    MultipleArrayViewer.this.onRamaDoc();
                } else if (command.equals("set-detection-filter-cmd")) {
                    MultipleArrayViewer.this.onSetDetectionFilter();
                } else if (command.equals("set-fold-filter-cmd")) {
                    MultipleArrayViewer.this.onSetFoldFilter();
                } else if (command.equals("use-detection-filter-cmd")) {
                    MultipleArrayViewer.this.onUseDetectionFilter((AbstractButton)event.getSource());
                } else if (command.equals("use-fold-filter-cmd")) {
                    MultipleArrayViewer.this.onUseFoldFilter((AbstractButton)event.getSource());
                } else if (command.equals("divide-genes-median-cmd")) {
                    MultipleArrayViewer.this.onDivideGenesMedian();
                } else if (command.equals("divide-genes-mean-cmd")) {
                    MultipleArrayViewer.this.onDivideGenesMean();
                } else if (command.equals("log2-transform-cmd")) {
                    MultipleArrayViewer.this.onLog2Transform();
                } else if (command.equals("unlog2-transform-cmd")) {
                    MultipleArrayViewer.this.onUnLog2Transform();
                } else if (command.equals("normalize-spots-cmd")) {
                    MultipleArrayViewer.this.onNormalizeSpots();
                } else if (command.equals("divide-spots-rms-cmd")) {
                    MultipleArrayViewer.this.onDivideSpotsRMS();
                } else if (command.equals("divide-spots-sd-cmd")) {
                    MultipleArrayViewer.this.onDivideSpotsSD();
                } else if (command.equals("mean-center-spots-cmd")) {
                    MultipleArrayViewer.this.onMeanCenterSpots();
                } else if (command.equals("median-center-spots-cmd")) {
                    MultipleArrayViewer.this.onMedianCenterSpots();
                } else if (command.equals("digital-spots-cmd")) {
                    MultipleArrayViewer.this.onDigitalSpots();
                } else if (command.equals("normalize-experiments-cmd")) {
                    MultipleArrayViewer.this.onNormalizeExperiments();
                } else if (command.equals("divide-experiments-rms-cmd")) {
                    MultipleArrayViewer.this.onDivideExperimentsRMS();
                } else if (command.equals("divide-experiments-sd-cmd")) {
                    MultipleArrayViewer.this.onDivideExperimentsSD();
                } else if (command.equals("mean-center-experiments-cmd")) {
                    MultipleArrayViewer.this.onMeanCenterExperiments();
                } else if (command.equals("median-center-experiments-cmd")) {
                    MultipleArrayViewer.this.onMedianCenterExperiments();
                } else if (command.equals("digital-experiments-cmd")) {
                    MultipleArrayViewer.this.onDigitalExperiments();
                } else if (command.equals("log10-to-log2-cmd")) {
                    MultipleArrayViewer.this.onLog10toLog2();
                } else if (command.equals("log2-to-log10-cmd")) {
                    MultipleArrayViewer.this.onLog2toLog10();
                } else if (command.equals("adjust-intensities-0-cmd")) {
                    MultipleArrayViewer.this.onAdjustIntensities((AbstractButton)event.getSource());
                } else if (command.equals("command-save-matrix")) {
                    MultipleArrayViewer.this.onSaveMatrix();
                } else if (command.equals("display-set-ratio-scale-cmd")) {
                    MultipleArrayViewer.this.onSetRatioScale();
                } else if (command.equals("delete-all-experiments-cmd")) {
                    MultipleArrayViewer.this.onDeleteAllExperimentClusters();
                } else if (command.equals("delete-all-cmd")) {
                    MultipleArrayViewer.this.onDeleteAll();
                } else if (command.equals("command-load-analysis")) {
                    MultipleArrayViewer.this.loadAnalysis();
                } else if (command.equals("command-save-analysis")) {
                    MultipleArrayViewer.this.saveAnalysis();
                } else if (command.equals("command-save-analysis-as")) {
                    MultipleArrayViewer.this.saveAnalysisAs();
                } else if (command.equals("command-new-script")) {
                    MultipleArrayViewer.this.onNewScript();
                } else if (command.equals("command-load-script")) {
                    MultipleArrayViewer.this.onLoadScript();
                } else if (command.equals("search-cmd")) {
                    MultipleArrayViewer.this.search();
                } else if (command.equals("append-sample-annotation-command")) {
                    MultipleArrayViewer.this.appendSampleAnnotation();
                } else if (command.equals("append-gene-annotation-command")) {
                    MultipleArrayViewer.this.appendGeneAnnotation();
                } else if (command.equals("import-resourcerer-gene-annotation-command")) {
                    MultipleArrayViewer.this.appendResourcererAnnotation();
                } else if (command.equalsIgnoreCase("got-annotation-file")) {
                    MultipleArrayViewer.this.processAnnotationFile();
                } else if (command.equals("change-species-name-command")) {
                    MultipleArrayViewer.this.askUserForSpeciesName(MultipleArrayViewer.this.data.getGaggleOrganismName());
                } else if (command.equals("load-clone-distributions-from-file")) {
                    JOptionPane.showMessageDialog(null, "Called load-clone-distributions-from-file", "alert", 1);
                } else if (command.equals("show-flanking-regions")) {
                    MultipleArrayViewer.this.onSetShowFlankingRegions(((AbstractButton)event.getSource()).isSelected());
                } else if (command.equals("cgh-element-length-5")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(5.0);
                } else if (command.equals("cgh-element-length-10")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(10.0);
                } else if (command.equals("cgh-element-length-20")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(20.0);
                } else if (command.equals("cgh-element-length-50")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(50.0);
                } else if (command.equals("cgh-element-length-100")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(100.0);
                } else if (command.equals("cgh-element-length-other")) {
                    MultipleArrayViewer.this.onChangeCghElementLengthOther();
                } else if (command.equals("cgh-element-length-fit")) {
                    MultipleArrayViewer.this.onChangeCghElementLength(-1.0);
                } else if (command.equals("cgh-element-width-5")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(5);
                } else if (command.equals("cgh-element-width-10")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(10);
                } else if (command.equals("cgh-element-width-20")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(20);
                } else if (command.equals("cgh-element-width-50")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(50);
                } else if (command.equals("cgh-element-width-100")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(100);
                } else if (command.equals("cgh-element-width-other")) {
                    MultipleArrayViewer.this.onChangeCghElementWidthOther();
                } else if (command.equals("cgh-element-width-fit")) {
                    MultipleArrayViewer.this.onChangeCghElementWidth(-1);
                } else if (command.equals("cgh-display-type-combined")) {
                    MultipleArrayViewer.this.onChangeCghDisplayType(0);
                } else if (command.equals("cgh-display-type-separated")) {
                    MultipleArrayViewer.this.onChangeCghDisplayType(1);
                } else if (command.equals("cgh-display-order")) {
                    MultipleArrayViewer.this.onChangeCghDisplayOrder();
                } else if (command.equals("cgh-delete-sample")) {
                    MultipleArrayViewer.this.onDeleteSample();
                } else if (command.equals("cgh-display-label-wsl-id")) {
                    MultipleArrayViewer.this.onChangeDisplayLabelType(0);
                } else if (command.equals("cgh-display-label-alias")) {
                    MultipleArrayViewer.this.onChangeDisplayLabelType(1);
                } else if (command.equals("cgh-display-label-id1")) {
                    MultipleArrayViewer.this.onChangeDisplayLabelType(2);
                } else if (command.equals("cgh-set-thresholds")) {
                    MultipleArrayViewer.this.onCghSetThresholds();
                } else if (command.equals("cgh-clear-annotations")) {
                    MultipleArrayViewer.this.onClearAnnotations();
                } else if (command.equals("cgh-analysis-command")) {
                    MultipleArrayViewer.this.onCghAnalysis((Action)event.getSource());
                } else if (command.equals("find-gene")) {
                    MultipleArrayViewer.this.searchForGene();
                } else if (command.equals("circle-viewer-background")) {
                    MultipleArrayViewer.this.onSetCircleViewerBackground();
                } else if (!command.equals("compare-experiments")) {
                    if (command.equals("clone-ratio-discrete-determination")) {
                        MultipleArrayViewer.this.onChangeCloneValueType(0);
                    } else if (command.equals("clone-ratio-log-invert-average")) {
                        MultipleArrayViewer.this.onChangeCloneValueType(1);
                    } else if (command.equals("clone-ratio-log-clone-distribution")) {
                        MultipleArrayViewer.this.onChangeCloneValueType(2);
                    } else if (command.equals("clone-value-threshold-or-clone-distribution")) {
                        MultipleArrayViewer.this.onChangeCloneValueType(3);
                    } else if (command.equals("flanking-regions-by-threshold")) {
                        MultipleArrayViewer.this.onChangeFlankingRegionType(0);
                    } else if (command.equals("flanking-regions-by-log-clone-distribution")) {
                        MultipleArrayViewer.this.onChangeFlankingRegionType(1);
                    } else if (command.equals("flanking-regions-by-threshold-or-clone-distribution")) {
                        MultipleArrayViewer.this.onChangeFlankingRegionType(2);
                    } else if (command.equals("show-header")) {
                        MultipleArrayViewer.this.onShowHeader(((AbstractButton)event.getSource()).isSelected());
                    } else if (command.equals("clone-p-thresh")) {
                        MultipleArrayViewer.this.onSetClonePThresh();
                    } else if (command.equals("rename-node-cmd")) {
                        MultipleArrayViewer.this.onRenameNode();
                    } else if (command.equals("connect-to-gaggle")) {
                        MultipleArrayViewer.this.gooseImpl.connectToGaggle();
                    } else if (command.equals("disconnect-from-gaggle")) {
                        MultipleArrayViewer.this.gooseImpl.disconnectFromGaggle();
                    } else if (command.equals("select-target-goose-cmd")) {
                        MultipleArrayViewer.this.onChangeGaggleTarget((Action)event.getSource());
                    } else if (command.equals("show-goose-cmd")) {
                        MultipleArrayViewer.this.onShowGoose((Action)event.getSource());
                    } else if (command.equals("genome-annotation-command")) {
                        this.onGenomeAnnotation();
                    } else {
                        System.out.println("unhandled command = " + command);
                    }
                }
            }
        }

        private void onFontSizeChanged(int size) {
            MultipleArrayViewer.this.menubar.setNewFontSize(size);
            MultipleArrayViewer.this.fireMenuChanged();
        }

        private void onGenomeAnnotation() {
            GenomeAnnoDialog dlg = new GenomeAnnoDialog(new JFrame(), MultipleArrayViewer.this.data.getFieldNames());
            if (dlg.showModal() == 0) {
                System.out.println("ok");
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            MultipleArrayViewer.this.onNodeChanged(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            TreePath selPath = MultipleArrayViewer.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            MultipleArrayViewer.this.tree.setSelectionPaths(new TreePath[]{selPath});
            JPopupMenu popup = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject instanceof LeafInfo) {
                popup = ((LeafInfo)userObject).getJPopupMenu();
            }
            if (selPath.getPathCount() > 2) {
                if (node.getParent() == MultipleArrayViewer.this.clusterNode) {
                    return;
                }
                if (popup == null) {
                    popup = new JPopupMenu();
                    if (userObject instanceof LeafInfo) {
                        IViewer viewerObj = ((LeafInfo)userObject).getViewer();
                        if (viewerObj == null) {
                            popup.add(this.createDeleteMenuItem());
                        } else if (viewerObj instanceof IViewer && viewerObj.getClusters() != null && viewerObj.getExperiment() != null && viewerObj.getViewerType() != -1) {
                            popup.add(this.createDeleteMenuItem());
                        }
                    } else {
                        popup.add(this.createDeleteMenuItem());
                        if (node.getDepth() != 0 && node.getLevel() == 2 && node.getParent().toString().equals("Analysis Results")) {
                            popup.add(this.createRenameMenuItem());
                        }
                    }
                } else if (!this.isContainsDeleteItem(popup)) {
                    popup.addSeparator();
                    popup.add(this.createDeleteMenuItem());
                }
            }
            if (popup != null) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private JMenuItem createDeleteMenuItem() {
            JMenuItem menuItem = new JMenuItem("Delete");
            menuItem.setActionCommand("delete-node-cmd");
            menuItem.addActionListener(this);
            return menuItem;
        }

        private JMenuItem createRenameMenuItem() {
            JMenuItem menuItem = new JMenuItem("Rename Node");
            menuItem.setActionCommand("rename-node-cmd");
            menuItem.addActionListener(this);
            return menuItem;
        }

        private boolean isContainsDeleteItem(JPopupMenu popup) {
            Component[] components = popup.getComponents();
            int i = components.length;
            while (--i >= 0) {
                if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals("delete-node-cmd")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MultipleArrayViewer.this.onClose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void onShowBrowser(EventObject eventObj) {
            MultipleArrayViewer.this.ShowBrowser(eventObj);
        }

        @Override
        public void onDisplayDataValues(EventObject eventObj) {
            MultipleArrayViewer.this.DisplayDataValues(eventObj);
        }

        @Override
        public void onShowGenes(EventObject eventObj) {
            MultipleArrayViewer.this.ShowGenes(eventObj);
        }

        @Override
        public void onAnnotationsSelected(EventObject eventObj) {
            MultipleArrayViewer.this.AnnotationsSelected(eventObj);
        }

        @Override
        public void onDataChanged() {
            MultipleArrayViewer.this.fireDataChanged();
        }

        @Override
        public void onCloneValuesChanged() {
            MultipleArrayViewer.this.fireCloneValuesChanged();
        }

        @Override
        public void onChromosomeSelected(EventObject eventObj) {
            MultipleArrayViewer.this.fireChromosomeSelected(eventObj);
        }

        @Override
        public void onCloneDistributionsLoaded() {
            MultipleArrayViewer.this.CloneDistributionsLoaded();
        }

        @Override
        public void onExperimentsLoaded() {
            MultipleArrayViewer.this.ExperimentsLoaded();
        }

        protected void onLoadDirectory() {
            this.onLoadDirectory();
        }

        @Override
        public void onUpdateConnected(boolean isConnected) {
            if (isConnected) {
                try {
                    MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(0).setEnabled(false);
                    MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(1).setEnabled(true);
                    MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(2).setEnabled(true);
                    MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(3).setEnabled(true);
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(0).setEnabled(true);
                MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(1).setEnabled(false);
                MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(2).setEnabled(false);
                MultipleArrayViewer.this.getMenubar().gaggleMenu.getMenuComponent(3).setEnabled(false);
            }
        }

        @Override
        public void onExit() {
            MultipleArrayViewer.this.mainframe.dispose();
        }

        @Override
        public void onHide() {
            MultipleArrayViewer.this.mainframe.setVisible(false);
        }

        @Override
        public void onShow() {
            MultipleArrayViewer.this.mainframe.toFront();
            MiscUtil.setJFrameAlwaysOnTop((JFrame)MultipleArrayViewer.this.mainframe, (boolean)true);
            MultipleArrayViewer.this.mainframe.setVisible(true);
            MiscUtil.setJFrameAlwaysOnTop((JFrame)MultipleArrayViewer.this.mainframe, (boolean)false);
        }

        @Override
        public void onNameChange(String newGooseName) {
            MultipleArrayViewer.this.mainframe.setTitle(newGooseName);
        }

        @Override
        public void onUpdate(String[] gooseNames) {
            MultipleArrayViewer.this.getMenubar().replaceGaggleTargetMenuItems(gooseNames);
        }

        @Override
        public void nameListReceived(String[] names, String identifier, boolean interactive, String label) {
            final String[] nl = names;
            final String id = identifier;
            final boolean iactive = interactive;
            final String lab = label;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MultipleArrayViewer.this.onImportList(0, nl, id, iactive, lab);
                }
            });
            thread.start();
        }

        @Override
        public void expressionDataReceived(ISlideData[] slideDataArray, IChipAnnotation chipAnno, int dataType) {
            if (MultipleArrayViewer.this.getData().getFeaturesCount() <= 0) {
                MultipleArrayViewer.this.fireDataLoaded(slideDataArray, chipAnno, dataType);
            }
        }
    }
}

