/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.tigr.microarray.mev.action.ActionManager;

public class MultipleArrayToolbar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    boolean tempDeletion = true;
    Action actiontester;
    int totalModules;
    ActionManager manager;
    SteppedComboBox[] steppedComboArray;
    SteppedComboBox cghSteppedComboBox;
    ImageIcon comboIcon;
    String[] category = new String[]{"Clustering", "Statistics", "Classification", "Data Reduction", "Meta Analysis", "Visualization", "Miscellaneous"};
    ImageIcon[] categoryIcon = new ImageIcon[this.category.length];
    ImageIcon[] disabledCategoryIcon = new ImageIcon[this.category.length];

    public MultipleArrayToolbar(ActionManager manager) {
        this.addAlgorithmActions(manager);
    }

    private void addAlgorithmActions(ActionManager manager) {
        int i;
        this.manager = manager;
        this.totalModules = 0;
        this.steppedComboArray = new SteppedComboBox[this.category.length];
        int index = 0;
        this.categoryIcon[0] = manager.getIcon("Clustering_1.gif");
        this.disabledCategoryIcon[0] = manager.getIcon("Clustering_1gry.gif");
        this.categoryIcon[1] = manager.getIcon("Statistics_1.gif");
        this.disabledCategoryIcon[1] = manager.getIcon("Statistics_1gry.gif");
        this.categoryIcon[2] = manager.getIcon("Classification_1.gif");
        this.disabledCategoryIcon[2] = manager.getIcon("Classification_1gry.gif");
        this.categoryIcon[3] = manager.getIcon("Data_Reduction_1.gif");
        this.disabledCategoryIcon[3] = manager.getIcon("Data_Reduction_1gry.gif");
        this.categoryIcon[4] = manager.getIcon("Meta_Analysis_1.gif");
        this.disabledCategoryIcon[4] = manager.getIcon("Meta_Analysis_1gry.gif");
        this.categoryIcon[5] = manager.getIcon("Visualization_1.gif");
        this.disabledCategoryIcon[5] = manager.getIcon("Visualization_1gry.gif");
        this.categoryIcon[6] = manager.getIcon("Miscellaneous_1.gif");
        this.disabledCategoryIcon[6] = manager.getIcon("Miscellaneous_1gry.gif");
        for (i = 0; i < this.category.length; ++i) {
            this.steppedComboArray[i] = new SteppedComboBox();
            ComboListener comboListener = new ComboListener();
            this.steppedComboArray[i].addActionListener(comboListener);
            this.steppedComboArray[i].setMaximumRowCount(20);
            this.steppedComboArray[i].addItem(this.disabledCategoryIcon[i]);
        }
        index = 0;
        for (i = 0; i < this.category.length; ++i) {
            Action action;
            while ((action = manager.getAction("analysis-action" + String.valueOf(index))) != null) {
                if (action.getValue("category").equals(this.category[i])) {
                    this.steppedComboArray[i].addItem((ImageIcon)action.getValue("LargeIcon"));
                    this.steppedComboArray[i].setActionCommand("analysis-command");
                    this.steppedComboArray[i].putClientProperty("categoryIconExists", true);
                    this.steppedComboArray[i].putClientProperty("categoryIcon", this.categoryIcon[i]);
                    ++this.totalModules;
                }
                ++index;
            }
            ComboBoxRenderer renderer = new ComboBoxRenderer();
            this.steppedComboArray[i].setSelectedIndex(0);
            this.steppedComboArray[i].setRenderer(renderer);
            int preferredWidth = this.steppedComboArray[i].getPreferredSize().width;
            this.steppedComboArray[i].setPreferredSize(new Dimension(50, this.steppedComboArray[i].getPreferredSize().height));
            this.steppedComboArray[i].setMinimumSize(new Dimension(0, 0));
            this.steppedComboArray[i].setPopupWidth(preferredWidth);
            this.add(this.steppedComboArray[i]);
            this.addSeparator();
            index = 0;
        }
    }

    public void addCGHComboBox() {
        this.cghSteppedComboBox = new SteppedComboBox();
        ComboListener comboListener = new ComboListener();
        this.cghSteppedComboBox.addActionListener(comboListener);
        this.cghSteppedComboBox.setMaximumRowCount(100);
        this.cghSteppedComboBox.addItem("CGH Analysis");
        int index = 0;
        while (this.manager.getAction("cgh-analysis-action" + String.valueOf(index)) != null) {
            this.cghSteppedComboBox.addItem((String)this.manager.getActionNames().get("cgh-analysis-name" + String.valueOf(index)));
            ++index;
        }
        ComboBoxRenderer renderer = new ComboBoxRenderer();
        this.cghSteppedComboBox.setSelectedIndex(0);
        this.cghSteppedComboBox.setRenderer(renderer);
        int preferredWidth = this.cghSteppedComboBox.getPreferredSize().width;
        this.cghSteppedComboBox.setPreferredSize(new Dimension(50, this.cghSteppedComboBox.getPreferredSize().height));
        this.cghSteppedComboBox.setMinimumSize(new Dimension(0, 0));
        this.cghSteppedComboBox.setPopupWidth(preferredWidth);
    }

    @Override
    public JButton add(Action a) {
        JButton button = super.add(a);
        button.setActionCommand((String)a.getValue("ActionCommandKey"));
        button.setIcon((Icon)a.getValue("LargeIcon"));
        button.setFocusPainted(false);
        return button;
    }

    private AbstractButton[] getButtons(String command) {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof AbstractButton) || !((AbstractButton)components[i]).getActionCommand().equals(command)) continue;
            list.add(components[i]);
        }
        return list.toArray(new AbstractButton[list.size()]);
    }

    private void setEnable(String command, boolean enable) {
        AbstractButton[] buttons = this.getButtons(command);
        if (buttons == null || buttons.length < 1) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setEnabled(enable);
        }
    }

    public void systemDisable(int state) {
        switch (state) {
            case 1000: {
                this.setEnable("command-load-db", false);
                this.setEnable("command-load-file", false);
                this.setEnable("command-load-expression", false);
                this.setEnable("command-load-directory", false);
                break;
            }
            case 1003: {
                this.setEnable("command-load-db", false);
                this.setEnable("command-save-image", false);
                this.setEnable("command-print-image", false);
                this.setEnable("analysis-command", false);
                for (int i = 0; i < this.steppedComboArray.length; ++i) {
                    this.steppedComboArray[i].setEnabled(false);
                    this.steppedComboArray[i].insertItemAt(this.disabledCategoryIcon[i], 0);
                    this.steppedComboArray[i].removeItemAt(1);
                }
                break;
            }
            case 1001: {
                this.setEnable("command-load-db", false);
                break;
            }
            case 1002: {
                this.setEnable("command-load-db", false);
            }
        }
    }

    public void systemEnable(int state) {
        switch (state) {
            case 1000: {
                this.setEnable("command-load-file", true);
                this.setEnable("command-load-directory", true);
                this.setEnable("command-load-expression", true);
                break;
            }
            case 1003: {
                this.setEnable("command-save-image", true);
                this.setEnable("command-print-image", true);
                this.setEnable("analysis-command", true);
                for (int i = 0; i < this.steppedComboArray.length; ++i) {
                    this.steppedComboArray[i].setEnabled(true);
                    this.steppedComboArray[i].insertItemAt(this.categoryIcon[i], 0);
                    this.steppedComboArray[i].removeItemAt(1);
                }
                this.repaint();
                break;
            }
            case 1001: {
                break;
            }
            case 1002: {
                this.setEnable("command-load-db", true);
            }
        }
    }

    public void enableRNASeq(boolean isRNASeq) {
        int index = 0;
        ArrayList<String> removedModules = new ArrayList<String>();
        if (isRNASeq) {
            removedModules.add("BN");
            removedModules.add("LM");
        } else {
            removedModules.add("EDGER");
            removedModules.add("DESEQ");
            removedModules.add("DEGSEQ");
        }
        while (index < this.totalModules) {
            Action action = this.manager.getAction("analysis-action" + String.valueOf(index));
            if (removedModules.contains(action.getValue("Name"))) {
                for (int i = 0; i < this.category.length; ++i) {
                    if (!action.getValue("category").equals(this.category[i])) continue;
                    this.steppedComboArray[i].removeItem((ImageIcon)action.getValue("LargeIcon"));
                }
            }
            ++index;
        }
    }

    public class SteppedComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        protected int popupWidth;

        public SteppedComboBox(ComboBoxModel aModel) {
            super(aModel);
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
        }

        public SteppedComboBox(Object[] items) {
            super(items);
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
        }

        public SteppedComboBox() {
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
        }

        public SteppedComboBox(Vector items) {
            super(items);
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
        }

        public void setPopupWidth(int width) {
            this.popupWidth = width;
        }

        public Dimension getPopupSize() {
            Dimension size = this.getSize();
            if (this.popupWidth < 1) {
                this.popupWidth = size.width;
            }
            return new Dimension(this.popupWidth, size.height);
        }
    }

    class SteppedComboBoxUI
    extends MetalComboBoxUI {
        SteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                public void show() {
                    MultipleArrayToolbar.this.tempDeletion = true;
                    if (this.comboBox.getClientProperty("categoryIconExists") == Boolean.valueOf(true)) {
                        this.comboBox.removeItemAt(0);
                        this.comboBox.putClientProperty("categoryIconExists", false);
                    }
                    MultipleArrayToolbar.this.tempDeletion = false;
                    Dimension popupSize = ((SteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    this.list.clearSelection();
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.comboBox.setFocusable(false);
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon image;
            String title;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            int i = 0;
            boolean header = false;
            boolean cghAnalysis = false;
            while (value != MultipleArrayToolbar.this.manager.getAction("analysis-action" + String.valueOf(i)).getValue("LargeIcon")) {
                if (MultipleArrayToolbar.this.manager.getAction("analysis-action" + String.valueOf(++i)) != null) continue;
                if (MultipleArrayToolbar.this.manager.getAction("cgh-analysis-action" + String.valueOf(index)) != null) {
                    cghAnalysis = true;
                }
                header = true;
                break;
            }
            if (header) {
                title = " ";
                this.setBorder(null);
                image = (ImageIcon)value;
            } else {
                image = (ImageIcon)value;
                title = (String)MultipleArrayToolbar.this.manager.getActionNames().get("analysis-name" + String.valueOf(i));
                this.setBorder(BorderFactory.createLineBorder(Color.gray));
            }
            if (cghAnalysis) {
                image = (ImageIcon)MultipleArrayToolbar.this.manager.getActionNames().get("cgh-small-icon" + String.valueOf(i));
            }
            this.setIcon(image);
            this.setText(title);
            this.setFont(list.getFont());
            return this;
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            if (cb == MultipleArrayToolbar.this.cghSteppedComboBox) {
                if (cb.getSelectedIndex() == 0) {
                    return;
                }
                int index = 0;
                while ((String)MultipleArrayToolbar.this.manager.getActionNames().get("cgh-analysis-name" + String.valueOf(index)) != (String)cb.getItemAt(cb.getSelectedIndex())) {
                    ++index;
                }
                MultipleArrayToolbar.this.actiontester = MultipleArrayToolbar.this.manager.getAction("cgh-analysis-action" + String.valueOf(index));
                MultipleArrayToolbar.this.manager.forwardAction(new ActionEvent(MultipleArrayToolbar.this.actiontester, e.getID(), (String)MultipleArrayToolbar.this.actiontester.getValue("ActionCommandKey")));
                cb.setSelectedIndex(0);
                return;
            }
            if (cb.getSelectedIndex() < 0 || MultipleArrayToolbar.this.tempDeletion) {
                cb.setSelectedIndex(0);
                return;
            }
            int index = 0;
            while (MultipleArrayToolbar.this.manager.getAction("analysis-action" + String.valueOf(index)).getValue("LargeIcon") != cb.getItemAt(cb.getSelectedIndex())) {
                if (++index < MultipleArrayToolbar.this.totalModules) continue;
                return;
            }
            MultipleArrayToolbar.this.actiontester = MultipleArrayToolbar.this.manager.getAction("analysis-action" + String.valueOf(index));
            MultipleArrayToolbar.this.manager.forwardAction(new ActionEvent(MultipleArrayToolbar.this.actiontester, e.getID(), (String)MultipleArrayToolbar.this.actiontester.getValue("ActionCommandKey")));
            cb.putClientProperty("categoryIconExists", true);
            cb.insertItemAt((ImageIcon)cb.getClientProperty("categoryIcon"), 0);
            cb.setSelectedIndex(0);
        }
    }
}

