/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.action.DefaultAction;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;

public class MultipleArrayMenubar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private DisplayMenu displayMenu = new DisplayMenu();
    private DistanceMenu distanceMenu = new DistanceMenu();
    private JMenu normalizationMenu;
    private JMenu labelMenu;
    private JMenu expLabelSelectionMenu;
    private JMenu adjustMenu;
    private JMenu filterMenu;
    private JMenu clusterMenu;
    private JMenuItem searchMenu;
    private ButtonGroup labelGroup;
    private ActionListener listener;
    private boolean affyNormAdded = false;
    private ButtonGroup experimentLabelGroup;
    JMenu fileMenu;
    JMenuItem loadDataMenuItem;
    JMenuItem loadAnalysisItem;
    JMenuItem clearDataItem;
    private JMenu cloneValuesMenu;
    private JMenu cghDispMenu;
    private JMenu cghAnalysisMenu;
    private JMenu helpMenu;
    CGHDisplayMenu cghDisplayMenu = new CGHDisplayMenu();
    CGHCloneValueMenu cghCloneValueMenu = new CGHCloneValueMenu();
    JMenu gaggleMenu;
    JMenu targetMenu;
    JMenu showMenu;
    ButtonGroup targetGooseNameGroup;
    ButtonGroup showtargetGooseNameGroup;
    private ActionManager actionManager;
    private String userFont = "monospaced";
    private int userFontSize = 0;
    private JMenu analysisMenu;

    public MultipleArrayMenubar(ActionManager manager) {
        this.listener = manager.getListener();
        this.actionManager = manager;
        this.fileMenu = new JMenu("File");
        this.loadDataMenuItem = this.createJMenuItem(manager.getAction("action-load"));
        this.fileMenu.add(this.loadDataMenuItem);
        this.fileMenu.addSeparator();
        this.loadAnalysisItem = this.createJMenuItem(manager.getAction("action-load-analysis"));
        this.fileMenu.add(this.loadAnalysisItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-save-analysis")));
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-save-analysis-as")));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-new-script")));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-load-script")));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-save-matrix")));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-save-image")));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-print-image")));
        this.fileMenu.addSeparator();
        this.clearDataItem = this.createJMenuItem(manager.getAction("action-clear-data"));
        this.fileMenu.add(this.clearDataItem);
        this.fileMenu.add(this.createJMenuItem(manager.getAction("action-close")));
        this.add(this.fileMenu);
        this.adjustMenu = new JMenu("Adjust Data");
        JMenu spotMenu = new JMenu("Gene/Row Adjustments");
        spotMenu.add(this.createJMenuItem("Normalize Genes/Rows", "normalize-spots-cmd", this.listener));
        spotMenu.add(this.createJMenuItem("Divide Genes/Rows by RMS", "divide-spots-rms-cmd", this.listener));
        spotMenu.add(this.createJMenuItem("Divide Genes/Rows by SD", "divide-spots-sd-cmd", this.listener));
        spotMenu.add(this.createJMenuItem("Mean Center Genes/Rows", "mean-center-spots-cmd", this.listener));
        spotMenu.add(this.createJMenuItem("Median Center Genes/Rows", "median-center-spots-cmd", this.listener));
        spotMenu.add(this.createJMenuItem("Digitalize Genes/Rows", "digital-spots-cmd", this.listener));
        this.adjustMenu.add(spotMenu);
        this.adjustMenu.addSeparator();
        JMenu sampMenu = new JMenu("Sample/Column Adjustments");
        sampMenu.add(this.createJMenuItem("Normalize Samples/Columns", "normalize-experiments-cmd", this.listener));
        sampMenu.add(this.createJMenuItem("Divide Samples/Columns by RMS", "divide-experiments-rms-cmd", this.listener));
        sampMenu.add(this.createJMenuItem("Divide Samples/Columns by SD", "divide-experiments-sd-cmd", this.listener));
        sampMenu.add(this.createJMenuItem("Mean Center Samples/Columns", "mean-center-experiments-cmd", this.listener));
        sampMenu.add(this.createJMenuItem("Median Center Samples/Columns", "median-center-experiments-cmd", this.listener));
        sampMenu.add(this.createJMenuItem("Digitalize Samples/Columns", "digital-experiments-cmd", this.listener));
        this.adjustMenu.add(sampMenu);
        this.adjustMenu.addSeparator();
        JMenu logMenu = new JMenu("Log Transformations");
        logMenu.add(this.createJMenuItem("Log2 Transform", "log2-transform-cmd", this.listener));
        logMenu.add(this.createJMenuItem("UnLog2 Transform", "unlog2-transform-cmd", this.listener));
        logMenu.add(this.createJMenuItem("Log10 to Log2", "log10-to-log2-cmd", this.listener));
        logMenu.add(this.createJMenuItem("Log2 to Log10", "log2-to-log10-cmd", this.listener));
        this.adjustMenu.add(logMenu);
        this.adjustMenu.addSeparator();
        this.filterMenu = new JMenu("Data Filters");
        JMenu lowIntensityMenu = new JMenu("Low Intensity Cutoff Filter");
        lowIntensityMenu.add(manager.getAction("cdna-low-intensity-action"));
        lowIntensityMenu.add(manager.getAction("oligen-low-intensity-action"));
        this.filterMenu.add(lowIntensityMenu);
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Affymetrix detection call Noise Filter", "use-gcos-percentage-cutoff-cmd", this.listener));
        this.filterMenu.add(this.createJMenuItem("Affymetrix P-value Filter", "use-pvalue-percentage-cutoff-cmd", this.listener));
        this.filterMenu.add(this.createJMenuItem("Bioconductor detection call Noise Filter", "use-present-call-cmd", this.listener));
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("GenePix Flags Filter", "use-genepixflags-cmd", this.listener));
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Percentage Cutoff Filter", "use-percentage-cutoffs-cmd", this.listener));
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Variance Filter", "use-variance-filter-cmd", this.listener));
        this.adjustMenu.add(this.filterMenu);
        this.adjustMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.normalizationMenu = new JMenu("Normalization");
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Total Intensity", "total-intensity-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Linear Regression", "linear-regression-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Ratio Statistics", "ratio-statistics-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Iterative Log", "iterative-log-cmd", this.listener, buttonGroup));
        this.normalizationMenu.addSeparator();
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("No Normalization", "no-normalization-cmd", this.listener, buttonGroup, true));
        this.adjustMenu.add(this.normalizationMenu);
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Adjust Intensities of '0'", "adjust-intensities-0-cmd", this.listener, true));
        this.add(this.adjustMenu);
        buttonGroup = new ButtonGroup();
        JMenu distanceMenu = new JMenu("Metrics");
        distanceMenu.add(this.createJRadioButtonMenuItem("Default Distance", "default-distance-cmd", this.listener, buttonGroup, true));
        distanceMenu.addSeparator();
        distanceMenu.add(this.createJRadioButtonMenuItem("Euclidean Distance", "euclidean-distance-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Manhattan Distance", "manhattan-distance-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Average Dot Product", "average-dot-product-cmd", this.listener, buttonGroup));
        distanceMenu.addSeparator();
        distanceMenu.add(this.createJRadioButtonMenuItem("Pearson Correlation", "pearson-correlation-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Pearson Uncentered", "pearson-uncentered-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Pearson Squared", "pearson-squared-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Cosine Correlation", "cosine-correlation-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Covariance Value", "covariance-value-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Spearman Rank Correlation", "spearman-rank-correlation-cmd", this.listener, buttonGroup));
        distanceMenu.addSeparator();
        distanceMenu.add(this.createJRadioButtonMenuItem("Kendall's Tau", "kendalls-tau-cmd", this.listener, buttonGroup));
        distanceMenu.add(this.createJRadioButtonMenuItem("Mutual Information", "mutual-information-cmd", this.listener, buttonGroup));
        distanceMenu.addSeparator();
        distanceMenu.add(this.createJCheckBoxMenuItem("Absolute distance", "absolute-distance-cmd", this.listener, false));
        this.add(distanceMenu);
        this.analysisMenu = new JMenu("Analysis");
        this.addAnalysisMenu(this.analysisMenu, manager);
        this.add(this.analysisMenu);
        JMenu displayMenu = new JMenu("Display");
        JMenu expLabelMenu = new JMenu("Sample/Column Labels");
        this.expLabelSelectionMenu = new JMenu("Select Sample Label");
        expLabelMenu.add(this.expLabelSelectionMenu);
        expLabelMenu.addSeparator();
        expLabelMenu.add(this.createJMenuItem("Edit Labels/Reorder Samples", "add-new-experiment-label", this.listener));
        expLabelMenu.add(this.createJMenuItem("Abbr. Sample Names", "toggle-abbr-expt-names-cmd", this.listener));
        expLabelMenu.add(this.createJMenuItem("Edit / Display IDF Fields", "add-new-idf-label", this.listener));
        this.experimentLabelGroup = new ButtonGroup();
        displayMenu.add(expLabelMenu);
        this.labelMenu = new JMenu("Gene/Row Labels");
        this.labelGroup = new ButtonGroup();
        displayMenu.add(this.labelMenu);
        displayMenu.addSeparator();
        JMenu colorSchemeMenu = new JMenu("Color Scheme");
        colorSchemeMenu.add(this.createJMenuItem("Green-Black-Red Scheme", "display-green-red-scheme-cmd", this.listener));
        colorSchemeMenu.add(this.createJMenuItem("Blue-Black-Yellow Scheme", "display-blue-yellow-scheme-cmd", this.listener));
        colorSchemeMenu.add(this.createJMenuItem("Rainbow Scheme", "display-rainbow-scheme-cmd", this.listener));
        colorSchemeMenu.addSeparator();
        colorSchemeMenu.add(this.createJMenuItem("Custom Color Scheme", "display-custom-color-scheme-cmd", this.listener));
        colorSchemeMenu.addSeparator();
        colorSchemeMenu.add(this.createJMenuItem("Accessible Color Scheme", "display-accessible-color-scheme-cmd", this.listener));
        colorSchemeMenu.addSeparator();
        colorSchemeMenu.add(this.createJCheckBoxMenuItem("Use Color Gradient on Graphs", "display-color-gradient-cmd", this.listener));
        displayMenu.add(colorSchemeMenu);
        displayMenu.add(this.createJMenuItem("Set Color Scale Limits", "display-set-ratio-scale-cmd", this.listener));
        displayMenu.addSeparator();
        JMenu sizeMenu = new JMenu("Set Element Size");
        buttonGroup = new ButtonGroup();
        sizeMenu.add(this.createJRadioButtonMenuItem("5 x 2", "display-5x2-cmd", this.listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("10 x 10", "display-10x10-cmd", this.listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("20 x 5", "display-20x5-cmd", this.listener, buttonGroup, true));
        sizeMenu.add(this.createJRadioButtonMenuItem("50 x 10", "display-50x10-cmd", this.listener, buttonGroup));
        sizeMenu.add(this.createJRadioButtonMenuItem("Custom", "display-other-cmd", this.listener, buttonGroup));
        displayMenu.add(sizeMenu);
        JMenu fontTypeMenu = new JMenu("Set Font Type");
        buttonGroup = new ButtonGroup();
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Default", "default-font", this.listener, buttonGroup, true));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Arial", "arial-font", this.listener, buttonGroup));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Courier", "courier", this.listener, buttonGroup));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Helvetica", "helvetica", this.listener, buttonGroup));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Sans Serif", "sansserif", this.listener, buttonGroup));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Serif", "serif", this.listener, buttonGroup));
        fontTypeMenu.add(this.createJRadioButtonMenuItem("Times New Roman", "times-new-roman-font", this.listener, buttonGroup));
        displayMenu.add(fontTypeMenu);
        JMenu fontSizeMenu = new JMenu("Set Font Size");
        buttonGroup = new ButtonGroup();
        fontSizeMenu.add(this.createJRadioButtonMenuItem("Default", "font-size-default", this.listener, buttonGroup, true));
        fontSizeMenu.add(this.createJRadioButtonMenuItem("8", "font-size-8", this.listener, buttonGroup));
        fontSizeMenu.add(this.createJRadioButtonMenuItem("12", "font-size-12", this.listener, buttonGroup));
        fontSizeMenu.add(this.createJRadioButtonMenuItem("16", "font-size-16", this.listener, buttonGroup));
        fontSizeMenu.add(this.createJRadioButtonMenuItem("20", "font-size-20", this.listener, buttonGroup));
        fontSizeMenu.add(this.createJRadioButtonMenuItem("Fit", "font-size-fit", this.listener, buttonGroup));
        displayMenu.add(fontSizeMenu);
        displayMenu.add(this.createJCheckBoxMenuItem("Draw Borders", "display-draw-borders-cmd", this.listener, false));
        displayMenu.addSeparator();
        JMenu clusteringMenu = new JMenu("Cluster Viewing Options");
        clusteringMenu.add(this.createJCheckBoxMenuItem("Compact Cluster Color Groups", "compact-clusters-cmd", this.listener, false));
        clusteringMenu.add(this.createJCheckBoxMenuItem("Show Mouse Rectangles", "show-rects-cmd", this.listener, true));
        clusteringMenu.add(this.createJCheckBoxMenuItem("Auto-Arrange Cluster Colors", "auto-arrange-colors-cmd", this.listener, false));
        displayMenu.add(clusteringMenu);
        this.add(displayMenu);
        JMenu utilMenu = new JMenu("Utilities");
        this.searchMenu = this.createJMenuItem(manager.getAction("search-action"));
        utilMenu.add(this.searchMenu);
        utilMenu.addSeparator();
        this.clusterMenu = new JMenu("Cluster Utilities");
        JMenu importMenu = new JMenu("Manual Cluster Import");
        importMenu.add(manager.getAction("import-gene-list-action"));
        importMenu.add(manager.getAction("import-sample-list-action"));
        this.clusterMenu.add(importMenu);
        JMenu binImportMenu = new JMenu("Binned Cluster Import");
        binImportMenu.add(manager.getAction("bin-import-gene-list-action"));
        binImportMenu.add(manager.getAction("bin-import-sample-list-action"));
        this.clusterMenu.add(binImportMenu);
        JMenu autoImportMenu = new JMenu("Automatic Cluster Import");
        autoImportMenu.add(manager.getAction("auto-import-gene-list-action"));
        autoImportMenu.add(manager.getAction("auto-import-sample-list-action"));
        this.clusterMenu.add(autoImportMenu);
        this.clusterMenu.addSeparator();
        this.clusterMenu.add(manager.getAction("delete-all-action"));
        this.clusterMenu.add(manager.getAction("delete-all-experiments-action"));
        utilMenu.add(this.clusterMenu);
        utilMenu.addSeparator();
        utilMenu.add(manager.getAction("append-gene-annotation-action"));
        utilMenu.add(manager.getAction("import-resourcerer-gene-annotation-action"));
        utilMenu.add(manager.getAction("append-sample-annotation-action"));
        utilMenu.add(manager.getAction("change-species-name-action"));
        this.targetGooseNameGroup = new ButtonGroup();
        this.showtargetGooseNameGroup = new ButtonGroup();
        this.gaggleMenu = new JMenu("Gaggle");
        this.gaggleMenu.setIcon(this.actionManager.getIcon("gaggle_icon_16.gif"));
        this.gaggleMenu.add(manager.getAction("gaggle-connect"));
        this.gaggleMenu.add(manager.getAction("gaggle-disconnect"));
        this.targetMenu = new JMenu("Broadcast Target");
        this.showMenu = new JMenu("Show Goose");
        JMenuItem notargets = new JMenuItem("No Broadcast Targets");
        JMenuItem noGeese = new JMenuItem("No Geese Available");
        notargets.setEnabled(false);
        noGeese.setEnabled(false);
        this.targetMenu.add(notargets);
        this.showMenu.add(noGeese);
        this.gaggleMenu.add(this.targetMenu);
        this.gaggleMenu.add(this.showMenu);
        this.gaggleMenu.getMenuComponent(1).setEnabled(false);
        utilMenu.add(this.gaggleMenu);
        this.add(utilMenu);
    }

    public MultipleArrayMenubar(MultipleArrayMenubar origMenubar, ActionManager manager) {
        this(manager);
        IDisplayMenu origDisplayMenu = origMenubar.getDisplayMenu();
        this.setColorSchemeIndex(origDisplayMenu.getColorScheme());
        Dimension dim = origDisplayMenu.getElementSize();
        this.setElementSize(dim.width, dim.height);
        this.setAntiAliasing(origDisplayMenu.isAntiAliasing());
        this.setTracing(origDisplayMenu.isTracing());
        this.setLabelIndex(origDisplayMenu.getLabelIndex());
        this.setPaletteStyle(origDisplayMenu.getPaletteStyle());
        this.setGRScale(origDisplayMenu.isGRScale());
        this.setDrawBorders(origDisplayMenu.isDrawingBorder());
        this.setCompactClusters(origDisplayMenu.isCompactClusters());
        this.setShowRects(origDisplayMenu.isShowRects());
        this.setAutoArrangeColors(origDisplayMenu.isAutoArrangeColors());
        this.setMaxRatioScale(origDisplayMenu.getMaxRatioScale());
        this.setMinRatioScale(origDisplayMenu.getMinRatioScale());
        this.setMidRatioValue(origDisplayMenu.getMidRatioValue());
        this.setColorGradientState(origDisplayMenu.getColorGradientState());
        this.setNegativeGradientImage(origDisplayMenu.getNegativeGradientImage());
        this.setPositiveGradientImage(origDisplayMenu.getPositiveGradientImage());
        this.setUseDoubleGradient(origDisplayMenu.getUseDoubleGradient());
        this.addLabelMenuItems(origMenubar.getLabelMenuItems(), null);
        IDistanceMenu origDistanceMenu = origMenubar.getDistanceMenu();
        this.setDistanceAbsolute(origDistanceMenu.isAbsoluteDistance());
        this.setDistanceFunction(origDistanceMenu.getDistanceFunction());
    }

    public void setDataLoadersEnabled(boolean enabled) {
        this.loadDataMenuItem.setEnabled(enabled);
        this.loadAnalysisItem.setEnabled(enabled);
        this.clearDataItem.setEnabled(enabled);
    }

    public void synchronizeSettings(MultipleArrayMenubar origMenuBar) {
        JMenu origMenu = origMenuBar.getMenu(2);
        JMenu menu = this.getMenu(2);
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component menuObject = menu.getMenuComponent(i);
            Component origMenuObject = origMenu.getMenuComponent(i);
            if (origMenuObject instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)menuObject).setSelected(((JRadioButtonMenuItem)origMenuObject).isSelected());
                continue;
            }
            if (!(origMenuObject instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)menuObject).setSelected(((JCheckBoxMenuItem)origMenuObject).isSelected());
        }
        origMenu = origMenuBar.getMenu(4);
        menu = this.getMenu(4);
        int numComponents = origMenu.getMenuComponentCount();
        for (int i = 0; i < numComponents; ++i) {
            Component origComp = origMenu.getMenuComponent(i);
            Component comp = menu.getMenuComponent(i);
            if (origComp instanceof JMenu) {
                this.syncMenus((JMenu)origComp, (JMenu)comp);
                continue;
            }
            if (origComp instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)comp).setSelected(((JRadioButtonMenuItem)origComp).isSelected());
                continue;
            }
            if (!(origComp instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)comp).setSelected(((JCheckBoxMenuItem)origComp).isSelected());
        }
    }

    private void syncMenus(JMenu origMenu, JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component menuObject = menu.getMenuComponent(i);
            Component origMenuObject = origMenu.getMenuComponent(i);
            if (origMenuObject instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)menuObject).setSelected(((JRadioButtonMenuItem)origMenuObject).isSelected());
                continue;
            }
            if (origMenuObject instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)menuObject).setSelected(((JCheckBoxMenuItem)origMenuObject).isSelected());
                continue;
            }
            if (!(origMenuObject instanceof JMenu)) continue;
            this.syncMenus((JMenu)origMenuObject, (JMenu)menuObject);
        }
    }

    public void systemEnable(int state) {
        switch (state) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-stanford", true);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-analysis", true);
                this.setEnableMenuItem("File", "command-save-analysis-as", true);
                this.setEnableMenuItem("File", "command-save-matrix", true);
                this.setEnableMenuItem("File", "command-save-image", true);
                this.setEnableMenuItem("File", "command-new-script", true);
                this.setEnableMenuItem("File", "command-load-script", true);
                this.setEnableMenuItem("File", "command-print-image", true);
                this.setEnableMenu("Adjust Data", true);
                this.setEnableMenu("Normalization", true);
                this.setEnableMenu("Metrics", true);
                this.setEnableMenu("Utilities", true);
                this.setEnableMenu("Analysis", true);
                this.setEnableMenu("Display", true);
                this.setEnableMenu("Sort", true);
                this.clusterMenu.setEnabled(true);
                this.searchMenu.setEnabled(true);
                break;
            }
            case 101: {
                this.setEnableMenuItem("File", "command-save-analysis", true);
                this.setEnableMenuItem("File", "command-save-analysis-as", true);
            }
            case 1001: {
                break;
            }
            case 1002: {
                this.setEnableMenuItem("File", "command-load-db", true);
            }
        }
    }

    public void systemDisable(int state) {
        switch (state) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                this.setEnableMenuItem("File", "command-load-file", false);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                this.setEnableMenuItem("File", "command-load-directory", false);
                this.setEnableMenuItem("File", "command-load-stanford", false);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                this.setEnableMenuItem("File", "command-save-matrix", false);
                this.setEnableMenuItem("File", "command-save-image", false);
                this.setEnableMenuItem("File", "command-print-image", false);
                this.setEnableMenu("Adjust Data", false);
                this.setEnableMenu("Normalization", false);
                this.setEnableMenu("Metrics", false);
                this.clusterMenu.setEnabled(false);
                this.searchMenu.setEnabled(false);
                break;
            }
            case 1001: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                break;
            }
            case 1002: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
            }
        }
        this.setEnableMenu("Analysis", false);
        this.setEnableMenu("Display", false);
        this.setEnableMenu("Sort", false);
    }

    public void enableNormalizationMenu(boolean enable) {
        this.normalizationMenu.setEnabled(enable);
    }

    private void addLabelMenuItems(JMenu menu, ActionManager manager, ButtonGroup buttonGroup) {
        Action action;
        int index = -1;
        while ((action = manager.getAction("display--label-action" + String.valueOf(index))) != null) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            buttonGroup.add(item);
            if (index < 1) {
                item.setSelected(true);
                String indexStr = (String)action.getValue("command-parameter");
                this.displayMenu.labelIndex = Integer.parseInt(indexStr);
            }
            menu.add(item);
            ++index;
        }
    }

    public String[] getLabelMenuItems() {
        Vector<String> temp = new Vector<String>();
        Enumeration<AbstractButton> labels = this.labelGroup.getElements();
        while (labels.hasMoreElements()) {
            JRadioButtonMenuItem aButton = (JRadioButtonMenuItem)labels.nextElement();
            temp.add(aButton.getText());
        }
        String[] temp2 = new String[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            temp2[i] = (String)temp.get(i);
        }
        return temp2;
    }

    public void addExperimentLabelMenuItems(Vector<String> fieldNames) {
        for (int i = 0; i < fieldNames.size(); ++i) {
            DefaultAction action = new DefaultAction(this.actionManager, "Label by " + fieldNames.elementAt(i), "display-experiment-label-cmd");
            action.putValue("command-parameter", fieldNames.elementAt(i));
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            this.experimentLabelGroup.add(item);
            if (i == 0) {
                item.setSelected(true);
            }
            this.expLabelSelectionMenu.add(item);
        }
    }

    public void addNewExperimentLabelMenuItem(String label) {
        DefaultAction action = new DefaultAction(this.actionManager, "Label by " + label, "display-experiment-label-cmd");
        action.putValue("command-parameter", label);
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        this.experimentLabelGroup.add(item);
        this.expLabelSelectionMenu.add(item);
    }

    public void replaceGaggleTargetMenuItems(String[] gooseNames) {
        this.targetMenu.removeAll();
        this.showMenu.removeAll();
        for (int i = 0; i < gooseNames.length; ++i) {
            String cmd = gooseNames[i];
            DefaultAction action = new DefaultAction(this.actionManager, cmd, "select-target-goose-cmd");
            action.putValue("command-parameter", gooseNames[i]);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            this.targetGooseNameGroup.add(item);
            this.targetMenu.add(item);
            item.setSelected(false);
            DefaultAction action1 = new DefaultAction(this.actionManager, cmd, "show-goose-cmd");
            action1.putValue("command-parameter", gooseNames[i]);
            JRadioButtonMenuItem item1 = new JRadioButtonMenuItem(action1);
            this.showtargetGooseNameGroup.add(item1);
            this.showMenu.add(item1);
            item1.setSelected(false);
            if (i != 0) continue;
            item.setSelected(true);
            item1.setSelected(true);
        }
    }

    public void replaceExperimentLabelMenuItems(String[] fieldNames) {
        this.expLabelSelectionMenu.removeAll();
        for (int i = 0; i < fieldNames.length; ++i) {
            String cmd = "Label by " + fieldNames[i];
            DefaultAction action = new DefaultAction(this.actionManager, cmd, "display-experiment-label-cmd");
            action.putValue("command-parameter", fieldNames[i]);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            this.experimentLabelGroup.add(item);
            this.expLabelSelectionMenu.add(item);
            item.setSelected(false);
            if (i != 0) continue;
            item.setSelected(true);
        }
    }

    public void replaceLabelMenuItems(String[] fieldNames) {
        this.labelMenu.removeAll();
        this.labelGroup = new ButtonGroup();
        for (int i = 0; i < fieldNames.length; ++i) {
            DefaultAction action = new DefaultAction(this.actionManager, "Label by " + fieldNames[i], "display-label-cmd");
            action.putValue("command-parameter", String.valueOf(i));
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            this.labelGroup.add(item);
            if (i == 0) {
                item.setSelected(true);
            }
            this.labelMenu.add(item);
        }
    }

    public void addAffyFilterMenuItems() {
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Set Detection Filter", "set-detection-filter-cmd", this.listener));
        this.filterMenu.add(this.createJCheckBoxMenuItem("Use Detection Filter", "use-detection-filter-cmd", this.listener));
        this.filterMenu.add(this.createJMenuItem("Set Fold Filter", "set-fold-filter-cmd", this.listener));
        this.filterMenu.add(this.createJCheckBoxMenuItem("Use Fold Filter", "use-fold-filter-cmd", this.listener));
    }

    public void addAffyNormMenuItems() {
        this.adjustMenu.addSeparator();
        JMenu menu = new JMenu("Affymetrix Adjustments");
        menu.add(this.createJMenuItem("Divide Genes by Median", "divide-genes-median-cmd", this.listener));
        menu.add(this.createJMenuItem("Divide Genes by Mean", "divide-genes-mean-cmd", this.listener));
        this.adjustMenu.add(menu);
        this.set_affyNormAddded(true);
    }

    public void addSortMenuItems(String[] fieldNames) {
    }

    public void replaceSortMenuItems(String[] fieldNames) {
    }

    private void addAnalysisMenu(JMenu menu, ActionManager manager) {
        String[] category = new String[]{"Clustering", "Statistics", "Classification", "Data Reduction", "Meta Analysis", "Visualization", "Miscellaneous"};
        for (int i = 0; i < category.length; ++i) {
            menu.add(this.createJMenuItem(category[i], manager));
        }
    }

    public IDisplayMenu getDisplayMenu() {
        return this.displayMenu;
    }

    public IDistanceMenu getDistanceMenu() {
        return this.distanceMenu;
    }

    private JMenuItem createJMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setActionCommand((String)action.getValue("ActionCommandKey"));
        return item;
    }

    private JMenu createJMenuItem(String category, ActionManager manager) {
        Action action;
        int index = 0;
        JMenu item = new JMenu(category);
        while ((action = manager.getAction("analysis-action" + String.valueOf(index))) != null) {
            if (action.getValue("category").equals(category)) {
                item.add(this.createJMenuItem(action));
            }
            ++index;
        }
        return item;
    }

    private JMenuItem createJMenuItem(String name, String command, ActionListener listener) {
        JMenuItem item = new JMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, ActionListener listener, boolean isSelected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, ActionListener listener) {
        return this.createJCheckBoxMenuItem(name, command, listener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, ActionListener listener, ButtonGroup buttonGroup, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        if (buttonGroup != null) {
            buttonGroup.add(item);
        }
        return item;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, ActionListener listener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(name, command, listener, buttonGroup, false);
    }

    private JMenu getJMenu(String name) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu jmenu = this.getMenu(i);
            if (jmenu == null || !jmenu.getText().equals(name)) continue;
            return jmenu;
        }
        return null;
    }

    private JMenuItem getJMenuItem(String menu_name, String item_command) {
        JMenu menu = this.getJMenu(menu_name);
        if (menu == null) {
            return null;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.getActionCommand().equals(item_command)) continue;
            return item;
        }
        return null;
    }

    private void setEnableMenu(String name, boolean enable) {
        JMenu menu = this.getJMenu(name);
        if (menu == null) {
            return;
        }
        menu.setEnabled(enable);
    }

    private void setEnableMenuItem(String menu_name, String item_command, boolean enable) {
        JMenuItem item = this.getJMenuItem(menu_name, item_command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    boolean get_affyNormAdded() {
        return this.affyNormAdded;
    }

    void set_affyNormAddded(boolean set) {
        this.affyNormAdded = set;
    }

    void setLabelIndex(int index) {
        this.displayMenu.labelIndex = index;
    }

    void setElementSize(int width, int height) {
        this.displayMenu.elementSize.setSize(width, height);
    }

    void setPaletteStyle(int style) {
        this.displayMenu.paletteStyle = style;
    }

    void setTracing(boolean tracing) {
        this.displayMenu.tracing = tracing;
    }

    void setDrawBorders(boolean drawBorders) {
        this.displayMenu.drawBorders = drawBorders;
    }

    void setCompactClusters(boolean compactClusters) {
        this.displayMenu.compactClusters = compactClusters;
    }

    void setShowRects(boolean showRects) {
        this.displayMenu.showRects = showRects;
    }

    void setAutoArrangeColors(boolean arrangeColors) {
        this.displayMenu.arrangeColors = arrangeColors;
    }

    void setAntiAliasing(boolean antialiasing) {
        this.displayMenu.antialiasing = antialiasing;
    }

    void setGRScale(boolean grscale) {
        this.displayMenu.grscale = grscale;
    }

    void setDistanceAbsolute(boolean absolute) {
        this.distanceMenu.absolute = absolute;
    }

    void setDistanceFunction(int function) {
        this.distanceMenu.function = function;
    }

    void setMinRatioScale(float scale) {
        this.displayMenu.minRatioScale = scale;
    }

    void setMaxRatioScale(float scale) {
        this.displayMenu.maxRatioScale = scale;
    }

    void setMidRatioValue(float value) {
        this.displayMenu.midRatioValue = value;
    }

    void setMaxCY3Scale(float scale) {
        this.displayMenu.maxCY3Scale = scale;
    }

    void setMaxCY5Scale(float scale) {
        this.displayMenu.maxCY5Scale = scale;
    }

    void setPositiveGradientImage(BufferedImage image) {
        this.displayMenu.currentPositiveColorImage = image;
    }

    void setNegativeGradientImage(BufferedImage image) {
        this.displayMenu.currentNegativeColorImage = image;
    }

    void setColorSchemeIndex(int index) {
        this.displayMenu.colorScheme = index;
        switch (this.displayMenu.colorScheme) {
            case 10: {
                break;
            }
            case 5: {
                this.displayMenu.currentNegativeColorImage = this.displayMenu.negGreenColorImage;
                this.displayMenu.currentPositiveColorImage = this.displayMenu.posRedColorImage;
                break;
            }
            case 6: {
                this.displayMenu.currentNegativeColorImage = this.displayMenu.negBlueColorImage;
                this.displayMenu.currentPositiveColorImage = this.displayMenu.posYellowColorImage;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.displayMenu.currentPositiveColorImage = this.displayMenu.rainbowImage;
            }
        }
    }

    int getColorScheme() {
        return this.displayMenu.getColorScheme();
    }

    public BufferedImage getPositiveGradientImage() {
        return this.displayMenu.getPositiveGradientImage();
    }

    public BufferedImage getNegativeGradientImage() {
        return this.displayMenu.getNegativeGradientImage();
    }

    public boolean getColorGradientState() {
        return this.displayMenu.getColorGradientState();
    }

    public void setColorGradientState(boolean state) {
        this.displayMenu.setColorGradientState(state);
    }

    public void setNormalizedButtonState(int index) {
        JRadioButtonMenuItem button = (JRadioButtonMenuItem)this.normalizationMenu.getMenuComponent(index);
        button.setSelected(true);
    }

    public void setUseDoubleGradient(boolean useDouble) {
        this.displayMenu.setUseDoubleGradient(useDouble);
    }

    public void addLabelMenuItems(String[] fieldNames, String[] annoFields) {
        JRadioButtonMenuItem item;
        DefaultAction action;
        String prefix = "Label by ";
        for (int i = 0; i < fieldNames.length; ++i) {
            String thisFieldName = fieldNames[i];
            if (thisFieldName.startsWith(prefix)) {
                thisFieldName = thisFieldName.substring(prefix.length()).trim();
            }
            action = new DefaultAction(this.actionManager, "Label by " + thisFieldName, "display-label-cmd");
            action.putValue("command-parameter", String.valueOf(i));
            item = new JRadioButtonMenuItem(action);
            this.labelGroup.add(item);
            if (i == 0) {
                item.setSelected(true);
            }
            this.labelMenu.add(item);
        }
        if (annoFields != null) {
            for (int i = 0; i < annoFields.length; ++i) {
                String thisAnnoField = annoFields[i];
                if (thisAnnoField.startsWith(prefix)) {
                    thisAnnoField = thisAnnoField.substring(prefix.length()).trim();
                }
                action = new DefaultAction(this.actionManager, "Label by " + thisAnnoField, "display-label-cmd");
                action.putValue("command-parameter", String.valueOf(i + fieldNames.length));
                item = new JRadioButtonMenuItem(action);
                this.labelGroup.add(item);
                this.labelMenu.add(item);
            }
        }
    }

    public void addCGHMenus2() {
        System.out.println("In addCGHMenus2()");
        this.cloneValuesMenu = new JMenu("CloneValues");
        this.add(this.cloneValuesMenu);
        this.setCloneValueType(TMEV.defaultCloneValue);
        this.setFlankingRegionType(TMEV.defaultFlankingRegionValue);
        this.initCloneValuesMenu(this.cloneValuesMenu, this.listener, false, this.cghCloneValueMenu.getCloneValueType(), this.cghCloneValueMenu.getFlankingRegionType());
        this.cghDispMenu = new JMenu("CGH Display");
        this.cghDispMenu.add(this.createJCheckBoxMenuItem("Flanking Regions", "show-flanking-regions", this.listener, false));
        this.cghDispMenu.addSeparator();
        JMenu cghSizeMenu = new JMenu("Element Length");
        ButtonGroup buttonGroup = new ButtonGroup();
        cghSizeMenu.add(this.createJRadioButtonMenuItem("5", "cgh-element-length-5", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("10", "cgh-element-length-10", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("20", "cgh-element-length-20", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("50", "cgh-element-length-50", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("100", "cgh-element-length-100", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("Other", "cgh-element-length-other", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("Fit", "cgh-element-length-fit", this.listener, buttonGroup, true));
        this.cghDispMenu.add(cghSizeMenu);
        JMenu widthMenu = new JMenu("Element Width");
        buttonGroup = new ButtonGroup();
        widthMenu.add(this.createJRadioButtonMenuItem("5", "cgh-element-width-5", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("10", "cgh-element-width-10", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("20", "cgh-element-width-20", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("50", "cgh-element-width-50", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("100", "cgh-element-width-100", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("Other", "cgh-element-width-other", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("Fit", "cgh-element-width-fit", this.listener, buttonGroup, true));
        this.cghDispMenu.add(widthMenu);
        this.cghDispMenu.addSeparator();
        JMenu displayTypeMenu = new JMenu("Display Type");
        buttonGroup = new ButtonGroup();
        displayTypeMenu.add(this.createJRadioButtonMenuItem("Mixed", "cgh-display-type-combined", this.listener, buttonGroup, true));
        displayTypeMenu.add(this.createJRadioButtonMenuItem("Separated", "cgh-display-type-separated", this.listener, buttonGroup));
        this.cghDispMenu.add(displayTypeMenu);
        this.cghDispMenu.addSeparator();
        this.cghDispMenu.add(this.createJMenuItem("Display Order", "cgh-display-order", this.listener));
        this.cghDispMenu.add(this.createJCheckBoxMenuItem("Show Header", "show-header", this.listener, true));
        this.cghDispMenu.addSeparator();
        this.cghDispMenu.add(this.createJMenuItem("Clear Annotations", "cgh-clear-annotations", this.listener));
        this.add(this.cghDispMenu);
        this.cghAnalysisMenu = new JMenu("CGH Analysis");
        this.addCghAnalysisMenu(this.cghAnalysisMenu, this.actionManager);
        this.cghAnalysisMenu.addSeparator();
        this.cghAnalysisMenu.add(this.createJMenuItem("Find Gene", "find-gene", this.listener));
        this.add(this.cghAnalysisMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(this.createJMenuItem("Default Distances", "default-distances-cmd", this.listener));
        this.helpMenu.add(this.createJMenuItem("Support Tree Legend", "show-supporttree-legend-command", this.listener));
        this.add(this.helpMenu);
        this.setDefaultValues();
    }

    public void addCGHMenus() {
        System.out.println("In addCGHMenus()");
        this.cloneValuesMenu = new JMenu("CloneValues");
        this.add(this.cloneValuesMenu);
        this.setCloneValueType(TMEV.defaultCloneValue);
        this.setFlankingRegionType(TMEV.defaultFlankingRegionValue);
        this.initCloneValuesMenu(this.cloneValuesMenu, this.listener, false, this.cghCloneValueMenu.getCloneValueType(), this.cghCloneValueMenu.getFlankingRegionType());
        JMenu dispMenu = this.getJMenu("Display");
        dispMenu.addSeparator();
        dispMenu.add(this.createJCheckBoxMenuItem("Flanking Regions", "show-flanking-regions", this.listener, false));
        dispMenu.addSeparator();
        JMenu cghSizeMenu = new JMenu("Element Length");
        ButtonGroup buttonGroup = new ButtonGroup();
        cghSizeMenu.add(this.createJRadioButtonMenuItem("5", "cgh-element-length-5", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("10", "cgh-element-length-10", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("20", "cgh-element-length-20", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("50", "cgh-element-length-50", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("100", "cgh-element-length-100", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("Other", "cgh-element-length-other", this.listener, buttonGroup));
        cghSizeMenu.add(this.createJRadioButtonMenuItem("Fit", "cgh-element-length-fit", this.listener, buttonGroup, true));
        dispMenu.add(cghSizeMenu);
        JMenu widthMenu = new JMenu("Element Width");
        buttonGroup = new ButtonGroup();
        widthMenu.add(this.createJRadioButtonMenuItem("5", "cgh-element-width-5", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("10", "cgh-element-width-10", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("20", "cgh-element-width-20", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("50", "cgh-element-width-50", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("100", "cgh-element-width-100", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("Other", "cgh-element-width-other", this.listener, buttonGroup));
        widthMenu.add(this.createJRadioButtonMenuItem("Fit", "cgh-element-width-fit", this.listener, buttonGroup, true));
        dispMenu.add(widthMenu);
        dispMenu.addSeparator();
        JMenu displayTypeMenu = new JMenu("Display Type");
        buttonGroup = new ButtonGroup();
        displayTypeMenu.add(this.createJRadioButtonMenuItem("Mixed", "cgh-display-type-combined", this.listener, buttonGroup, true));
        displayTypeMenu.add(this.createJRadioButtonMenuItem("Separated", "cgh-display-type-separated", this.listener, buttonGroup));
        dispMenu.add(displayTypeMenu);
        dispMenu.addSeparator();
        dispMenu.add(this.createJMenuItem("Display Order", "cgh-display-order", this.listener));
        dispMenu.add(this.createJCheckBoxMenuItem("Show Header", "show-header", this.listener, true));
        dispMenu.addSeparator();
        dispMenu.add(this.createJMenuItem("Clear Annotations", "cgh-clear-annotations", this.listener));
        this.cghAnalysisMenu = new JMenu("CGH Analysis");
        this.addCghAnalysisMenu(this.cghAnalysisMenu, this.actionManager);
        this.cghAnalysisMenu.addSeparator();
        this.cghAnalysisMenu.add(this.createJMenuItem("Find Gene", "find-gene", this.listener));
        this.add(this.cghAnalysisMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(this.createJMenuItem("Default Distances", "default-distances-cmd", this.listener));
        this.helpMenu.add(this.createJMenuItem("Support Tree Legend", "show-supporttree-legend-command", this.listener));
        this.add(this.helpMenu);
        this.setDefaultValues();
    }

    protected void addCghAnalysisMenu(JMenu menu, ActionManager manager) {
        Action action;
        int index = 0;
        while ((action = manager.getAction("cgh-analysis-action" + String.valueOf(index))) != null) {
            menu.add(this.createJMenuItem(action));
            ++index;
        }
    }

    protected void setDefaultValues() {
        this.setMinRatioScale(-1.0f);
        this.setMaxRatioScale(1.0f);
    }

    public void enableCloneDistributions(boolean CloneDistState, boolean log2state) {
        this.setEnableMenuItem("CloneValues", "clone-ratio-discrete-determination", !log2state);
        this.setEnableMenuItem("CloneValues", "clone-ratio-log-clone-distribution", CloneDistState);
        this.setEnableMenuItem("CloneValues", "clone-value-threshold-or-clone-distribution", CloneDistState);
        this.setEnableMenuItem("CloneValues", "flanking-regions-by-log-clone-distribution", CloneDistState);
        this.setEnableMenuItem("CloneValues", "flanking-regions-by-threshold-or-clone-distribution", CloneDistState);
        this.setEnableMenuItem("CloneValues", "clone-p-thresh", CloneDistState);
    }

    public void setShowFlankingRegions(boolean show) {
        this.cghDisplayMenu.setShowFlankingRegions(show);
    }

    public void setCghElementLength(double elementLength) {
        this.cghDisplayMenu.setUnitLength(elementLength);
    }

    public void setCghElementWidth(int elementWidth) {
        this.cghDisplayMenu.setElementWidth(elementWidth);
    }

    public void setCghDisplayType(int displayType) {
        this.cghDisplayMenu.setDisplayType(displayType);
    }

    public ICGHDisplayMenu getCghDisplayMenu() {
        return this.cghDisplayMenu;
    }

    public void setAmpThresh(float thresh) {
        this.cghCloneValueMenu.setAmpThresh(thresh);
    }

    public void setDelThresh(float thresh) {
        this.cghCloneValueMenu.setDelThresh(thresh);
    }

    public void setAmpThresh2Copy(float thresh) {
        this.cghCloneValueMenu.setAmpThresh2Copy(thresh);
    }

    public void setDelThresh2Copy(float thresh) {
        this.cghCloneValueMenu.setDelThresh2Copy(thresh);
    }

    public void setCircleViewerBackgroundColor(Color circleViewerBackgroundColor) {
        this.cghDisplayMenu.circleViewerBackgroundColor = circleViewerBackgroundColor;
    }

    public ICGHCloneValueMenu getCloneValueMenu() {
        return this.cghCloneValueMenu;
    }

    public void setClonePThresh(float clonePThresh) {
        this.cghCloneValueMenu.setClonePThresh(clonePThresh);
    }

    public void setFlankingRegionType(int flankingRegionsType) {
        this.cghCloneValueMenu.setFlankingRegionType(flankingRegionsType);
    }

    public void setCloneValueType(int cloneValueType) {
        this.cghCloneValueMenu.setCloneValueType(cloneValueType);
    }

    public void setCghDisplayLabelType(int displayLabelType) {
        this.cghDisplayMenu.setDisplayLabelType(displayLabelType);
    }

    public void initCloneValuesMenu(boolean hasDyeSwap) {
        JMenu cloneMenu = this.getJMenu("CloneValues");
        cloneMenu.removeAll();
        ICGHCloneValueMenu cloneValuesMenu = this.getCloneValueMenu();
        this.setCloneValueType(TMEV.defaultCloneValue);
        this.setFlankingRegionType(TMEV.defaultFlankingRegionValue);
        if (hasDyeSwap) {
            this.initCloneValuesMenuDyeSwap(cloneMenu, this.listener, cloneValuesMenu.getCloneValueType(), cloneValuesMenu.getFlankingRegionType());
        } else {
            this.initCloneValuesMenuNoDyeSwap(cloneMenu, this.listener, cloneValuesMenu.getCloneValueType(), cloneValuesMenu.getFlankingRegionType());
        }
    }

    public void initCloneValuesMenu(JMenu cloneValuesMenu, ActionListener listener, boolean hasDyeSwap, int cloneValueType, int flankingRegionType) {
        cloneValuesMenu.removeAll();
        if (hasDyeSwap) {
            this.initCloneValuesMenuDyeSwap(cloneValuesMenu, listener, cloneValueType, flankingRegionType);
        } else {
            this.initCloneValuesMenuNoDyeSwap(cloneValuesMenu, listener, cloneValueType, flankingRegionType);
        }
    }

    public void initCloneValuesMenuDyeSwap(JMenu cloneValuesMenu, ActionListener listener, int cloneValueType, int flankingRegionType) {
        ButtonGroup buttonGroup = new ButtonGroup();
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Clone Ratio Threshold", "clone-ratio-discrete-determination", listener, buttonGroup, cloneValueType == 0));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Log Invert Average", "clone-ratio-log-invert-average", listener, buttonGroup, cloneValueType == 1));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Log Clone Distribution", "clone-ratio-log-clone-distribution", listener, buttonGroup, cloneValueType == 2));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Ratio Threshold or Clone Distribution", "clone-value-threshold-or-clone-distribution", listener, buttonGroup, cloneValueType == 3));
        cloneValuesMenu.addSeparator();
        buttonGroup = new ButtonGroup();
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Flanking Regions By Threshold", "flanking-regions-by-threshold", listener, buttonGroup, flankingRegionType == 0));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Flanking Regions By Clone Distribution", "flanking-regions-by-log-clone-distribution", listener, buttonGroup, flankingRegionType == 1));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Threshold or Clone Distribution", "flanking-regions-by-threshold-or-clone-distribution", listener, buttonGroup, flankingRegionType == 2));
        cloneValuesMenu.addSeparator();
        cloneValuesMenu.add(this.createJMenuItem("Clone P Threshold", "clone-p-thresh", listener));
        cloneValuesMenu.add(this.createJMenuItem("Set Thresholds", "cgh-set-thresholds", listener));
    }

    public void initCloneValuesMenuNoDyeSwap(JMenu cloneValuesMenu, ActionListener listener, int cloneValueType, int flankingRegionType) {
        ButtonGroup buttonGroup = new ButtonGroup();
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Clone Ratio Threshold", "clone-ratio-discrete-determination", listener, buttonGroup, cloneValueType == 0));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Log Value", "clone-ratio-log-invert-average", listener, buttonGroup, cloneValueType == 1));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Log Clone Distribution", "clone-ratio-log-clone-distribution", listener, buttonGroup, cloneValueType == 2));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Ratio Threshold or Clone Distribution", "clone-value-threshold-or-clone-distribution", listener, buttonGroup, cloneValueType == 3));
        cloneValuesMenu.addSeparator();
        buttonGroup = new ButtonGroup();
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Flanking Regions By Threshold", "flanking-regions-by-threshold", listener, buttonGroup, flankingRegionType == 0));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Flanking Regions By Clone Distribution", "flanking-regions-by-log-clone-distribution", listener, buttonGroup, flankingRegionType == 1));
        cloneValuesMenu.add(this.createJRadioButtonMenuItem("Threshold or Clone Distribution", "flanking-regions-by-threshold-or-clone-distribution", listener, buttonGroup, flankingRegionType == 2));
        cloneValuesMenu.addSeparator();
        cloneValuesMenu.add(this.createJMenuItem("Clone P Threshold", "clone-p-thresh", listener));
        cloneValuesMenu.add(this.createJMenuItem("Set Thresholds", "cgh-set-thresholds", listener));
    }

    public void setNewFont(String newFont) {
        this.userFont = newFont;
    }

    public void setNewFontSize(int size) {
        this.userFontSize = size;
    }

    public void enableRNASeq(boolean isRNASeq) {
        int menuCount = this.analysisMenu.getItemCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu jm = (JMenu)this.analysisMenu.getItem(i);
            int itemCount = jm.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                JMenuItem item = jm.getItem(j);
                if (isRNASeq) {
                    if (item.getText().equalsIgnoreCase("BN")) {
                        item.setEnabled(false);
                    }
                    if (!item.getText().equalsIgnoreCase("LM")) continue;
                    item.setEnabled(false);
                    continue;
                }
                if (item.getText().equalsIgnoreCase("EDGER")) {
                    item.setEnabled(false);
                }
                if (item.getText().equalsIgnoreCase("DESEQ")) {
                    item.setEnabled(false);
                }
                if (!item.getText().equalsIgnoreCase("DEGSEQ")) continue;
                item.setEnabled(false);
            }
        }
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    protected class CGHCloneValueMenu
    implements ICGHCloneValueMenu {
        private int cloneValueType = TMEV.defaultCloneValue;
        private int flankingRegionType = TMEV.defaultFlankingRegionValue;
        private float ampThresh = 0.8f;
        private float delThresh = -0.8f;
        private float ampThresh2Copy = 1.0f;
        private float delThresh2Copy = -1.0f;
        private float clonePThresh = 0.85f;

        public int getCloneValueType() {
            return this.cloneValueType;
        }

        public void setCloneValueType(int cloneValueType) {
            this.cloneValueType = cloneValueType;
        }

        public float getClonePThresh() {
            return this.clonePThresh;
        }

        public void setClonePThresh(float clonePThresh) {
            this.clonePThresh = clonePThresh;
        }

        public float getAmpThresh() {
            return this.ampThresh;
        }

        public void setAmpThresh(float ampThresh) {
            this.ampThresh = ampThresh;
        }

        public float getDelThresh() {
            return this.delThresh;
        }

        public void setDelThresh(float delThresh) {
            this.delThresh = delThresh;
        }

        public float getAmpThresh2Copy() {
            return this.ampThresh2Copy;
        }

        public void setAmpThresh2Copy(float ampThresh2Copy) {
            this.ampThresh2Copy = ampThresh2Copy;
        }

        public float getDelThresh2Copy() {
            return this.delThresh2Copy;
        }

        public void setDelThresh2Copy(float delThresh2Copy) {
            this.delThresh2Copy = delThresh2Copy;
        }

        public int getFlankingRegionType() {
            return this.flankingRegionType;
        }

        public void setFlankingRegionType(int flankingRegionType) {
            this.flankingRegionType = flankingRegionType;
        }
    }

    private class CGHDisplayMenu
    implements ICGHDisplayMenu {
        private boolean showFlankingRegions = false;
        private double unitLength = -1.0;
        private int elementWidth = -1;
        private int displayType;
        private int displayLabelType = 0;
        Color circleViewerBackgroundColor = Color.black;

        private CGHDisplayMenu() {
        }

        public boolean isShowFlankingRegions() {
            return this.showFlankingRegions;
        }

        public void setShowFlankingRegions(boolean showFlankingRegions) {
            this.showFlankingRegions = showFlankingRegions;
        }

        public double getUnitLength() {
            return this.unitLength;
        }

        public void setUnitLength(double unitLength) {
            this.unitLength = unitLength == -1.0 ? unitLength : unitLength / 1000000.0;
        }

        public int getElementWidth() {
            return this.elementWidth;
        }

        public void setElementWidth(int elementWidth) {
            this.elementWidth = elementWidth;
        }

        public int getDisplayType() {
            return this.displayType;
        }

        public void setDisplayType(int displayType) {
            this.displayType = displayType;
        }

        public Color getCircleViewerBackgroundColor() {
            return this.circleViewerBackgroundColor;
        }

        public void setCircleViewerBackgroundColor(Color circleViewerBackgroundColor) {
            this.circleViewerBackgroundColor = circleViewerBackgroundColor;
        }

        public int getDisplayLabelType() {
            return this.displayLabelType;
        }

        public void setDisplayLabelType(int displayLabelType) {
            this.displayLabelType = displayLabelType;
        }
    }

    private class DistanceMenu
    implements IDistanceMenu {
        private boolean absolute = false;
        private int function = 0;

        private DistanceMenu() {
        }

        public boolean isAbsoluteDistance() {
            return this.absolute;
        }

        public int getDistanceFunction() {
            return this.function;
        }

        public String getFunctionName(int function) {
            String name;
            switch (function) {
                case 1: {
                    name = "Pearson Correlation";
                    break;
                }
                case 2: {
                    name = "Cosine Correlation";
                    break;
                }
                case 3: {
                    name = "Covariance";
                    break;
                }
                case 4: {
                    name = "Euclidean Distance";
                    break;
                }
                case 5: {
                    name = "Average Dot Product";
                    break;
                }
                case 6: {
                    name = "Pearson Uncentered";
                    break;
                }
                case 7: {
                    name = "Pearson Squared";
                    break;
                }
                case 8: {
                    name = "Manhattan Distance";
                    break;
                }
                case 9: {
                    name = "Spearman Rank Correlation";
                    break;
                }
                case 10: {
                    name = "Kendall's Tau";
                    break;
                }
                case 11: {
                    name = "Mutual Information";
                    break;
                }
                default: {
                    name = "not defined";
                }
            }
            return name;
        }
    }

    private class DisplayMenu
    implements IDisplayMenu {
        private final Dimension elementSize = new Dimension(20, 5);
        private int labelIndex;
        private int paletteStyle = 4;
        private boolean tracing = false;
        private boolean drawBorders = false;
        private boolean compactClusters = false;
        private boolean showRects = false;
        private boolean arrangeColors = false;
        private boolean antialiasing = true;
        private boolean grscale = true;
        private boolean useColorGradient = false;
        private float minRatioScale = -3.0f;
        private float maxRatioScale = 3.0f;
        private float midRatioValue = 0.0f;
        private float maxCY3Scale = 0.0f;
        private float maxCY5Scale = 0.0f;
        private int colorScheme = 5;
        private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
        private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
        private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
        private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
        private BufferedImage rainbowImage = this.createRainbowImage();
        private boolean useDoubleGradient = true;
        BufferedImage currentNegativeColorImage = this.negGreenColorImage;
        BufferedImage currentPositiveColorImage = this.posRedColorImage;

        private DisplayMenu() {
        }

        public int getPaletteStyle() {
            return this.paletteStyle;
        }

        public boolean isGRScale() {
            return this.grscale;
        }

        public Dimension getElementSize() {
            return this.elementSize;
        }

        public boolean getUseDoubleGradient() {
            return this.useDoubleGradient;
        }

        public void setUseDoubleGradient(boolean useDouble) {
            this.useDoubleGradient = useDouble;
        }

        public boolean isDrawingBorder() {
            return this.drawBorders;
        }

        public boolean isCompactClusters() {
            return this.compactClusters;
        }

        public boolean isShowRects() {
            return this.showRects;
        }

        public boolean isAutoArrangeColors() {
            return this.arrangeColors;
        }

        public boolean isTracing() {
            return this.tracing;
        }

        public boolean isAntiAliasing() {
            return this.antialiasing;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }

        public float getMaxRatioScale() {
            return this.maxRatioScale;
        }

        public float getMinRatioScale() {
            return this.minRatioScale;
        }

        public float getMidRatioValue() {
            return this.midRatioValue;
        }

        public float getMaxCY3Scale() {
            return this.maxCY3Scale;
        }

        public float getMaxCY5Scale() {
            return this.maxCY5Scale;
        }

        public int getColorScheme() {
            return this.colorScheme;
        }

        public String getUserFont() {
            return MultipleArrayMenubar.this.userFont;
        }

        public int getUserFontSize() {
            return MultipleArrayMenubar.this.userFontSize;
        }

        public BufferedImage getPositiveGradientImage() {
            return this.currentPositiveColorImage;
        }

        public BufferedImage getNegativeGradientImage() {
            return this.currentNegativeColorImage;
        }

        public BufferedImage createGradientImage(Color color1, Color color2) {
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics = image.createGraphics();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
            graphics.setPaint(gp);
            graphics.drawRect(0, 0, 255, 1);
            return image;
        }

        public boolean getColorGradientState() {
            return this.useColorGradient;
        }

        public void setColorGradientState(boolean state) {
            this.useColorGradient = state;
        }

        private BufferedImage createRainbowImage() {
            Vector palette = this.buildPalette();
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics = image.createGraphics();
            this.drawScale(graphics, palette);
            return image;
        }

        private void drawScale(Graphics2D g, Vector palette) {
            for (int i = 0; i < palette.size(); ++i) {
                g.setColor((Color)palette.elementAt(i));
                g.fillRect(i, 0, 1, 1);
            }
        }

        private Vector buildPalette() {
            Vector<Color> palette = new Vector<Color>(256);
            Color newColor = new Color(0, 0, 0);
            palette.addElement(newColor);
            for (int i = 1; i < 256; ++i) {
                i = 255 - i;
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                if (i < 33) {
                    r = 255.0;
                } else if (i > 32 && i < 108) {
                    r = Math.abs(255.0 * Math.cos((double)(i - 32) * Math.PI / 151.0));
                } else if (i > 107) {
                    r = 0.0;
                }
                if (i < 5) {
                    g = 0.0;
                } else if (i > 4 && i < 101) {
                    g = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 189.0));
                } else if (i > 100 && i < 229) {
                    g = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 294.0));
                } else if (i > 230) {
                    g = 0.0;
                }
                if (i < 72) {
                    b = 0.0;
                } else if (i > 71 && i < 200) {
                    b = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 256.0));
                } else if (i > 199) {
                    b = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 175.0));
                }
                newColor = new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                palette.addElement(newColor);
                i = 255 - i;
            }
            return palette;
        }
    }
}

