/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;

public class MultipleArrayHeader
extends JPanel {
    private IData data;
    private Insets insets;
    private int contentWidth;
    private int elementWidth = 20;
    private boolean isAntiAliasing = true;
    private boolean isTracing = false;
    private int tracespace;
    private final int RECT_HEIGHT = 15;
    BufferedImage negColorImage;
    BufferedImage posColorImage;
    private float maxValue;
    private float minValue;
    private float midValue;
    private boolean useDoubleGradient = true;
    private String userFont = "monospaced";
    private int userFontSize;

    public MultipleArrayHeader(Insets insets, int tracespace) {
        this.setBackground(Color.white);
        this.insets = insets;
        this.tracespace = tracespace;
        this.maxValue = 3.0f;
        this.minValue = -3.0f;
        this.midValue = 0.0f;
    }

    public void setData(IData data) {
        this.data = data;
        this.updateSize();
        this.repaint();
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.updateSize();
        this.repaint();
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
        this.repaint();
    }

    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public void setMinAndMaxRatios(float min, float max) {
        this.minValue = min;
        this.maxValue = max;
        this.repaint();
    }

    public void setMinAndMaxAndMidRatios(float min, float mid, float max) {
        this.minValue = min;
        this.midValue = mid;
        this.maxValue = max;
        this.repaint();
    }

    public void setNegativeAndPositiveColorImages(BufferedImage neg, BufferedImage pos) {
        this.negColorImage = neg;
        this.posColorImage = pos;
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int width) {
        if (this.userFontSize == 0) {
            if (width > 16) {
                width = 16;
            }
        } else if (this.userFontSize != -1) {
            width = this.userFontSize;
        }
        this.setFont(new Font(this.userFont, 0, width));
    }

    void updateSize() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        int size = this.data.getFeaturesCount();
        for (int feature = 0; feature < size; ++feature) {
            String name = this.data.getSampleName(feature);
            maxHeight = Math.max(maxHeight, hfm.stringWidth(name));
        }
        this.setSize(this.contentWidth, maxHeight + 10 + this.RECT_HEIGHT + hfm.getHeight());
        this.setPreferredSize(new Dimension(this.contentWidth, maxHeight + 10 + this.RECT_HEIGHT + hfm.getHeight()));
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.data == null || this.data.getFeaturesCount() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        int width = !this.isTracing ? this.data.getFeaturesCount() * this.elementWidth : (this.data.getFeaturesCount() - 1) * (this.elementWidth + this.getSpacing()) + this.elementWidth;
        if (this.useDoubleGradient) {
            g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
            g.drawImage(this.posColorImage, (int)((float)width / 2.0f) + this.insets.left, 0, (int)((double)width / 2.0), 15, null);
        } else {
            g.drawImage(this.posColorImage, this.insets.left, 0, width, 15, null);
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.black);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
        int textWidth = hfm.stringWidth(String.valueOf(this.midValue));
        if (this.useDoubleGradient) {
            g.drawString(String.valueOf(this.midValue), (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, 15 + fHeight);
        }
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        this.drawColumnHeaders(g);
    }

    private void drawColumnHeaders(Graphics2D g) {
        int size = this.data.getFeaturesCount();
        if (size == 0) {
            return;
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        g.rotate(-1.5707963267948966);
        for (int feature = 0; feature < size; ++feature) {
            String name = this.data.getSampleName(feature);
            g.drawString(name, this.insets.bottom - this.getSize().height + 5, this.insets.left + descent + (this.elementWidth + this.getSpacing()) * feature + this.elementWidth / 2);
        }
        g.rotate(1.5707963267948966);
    }

    public void setUserFont(String font) {
        this.userFont = font;
    }

    public void setUserFontSize(int userFontSize) {
        this.userFontSize = userFontSize;
    }
}

