/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import cern.jet.math.Arithmetic;
import cern.jet.stat.Probability;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.beans.PersistenceDelegate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.IChipAnnotation;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.annotation.MevChipAnnotation;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.CGHCopyNumberCalculator;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.CGHCopyNumberCalculatorNoDyeSwap;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegions;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegionsComparator;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.Cluster.Experiment.BacClonesExperimentParameters;
import org.tigr.microarray.mev.cgh.CGHDataObj.Cluster.Experiment.CGHExperiment;
import org.tigr.microarray.mev.cgh.CGHDataObj.Cluster.Experiment.DataRegionsExperimentParameters;
import org.tigr.microarray.mev.cgh.CGHDataObj.Cluster.Experiment.GenesExperimentParameters;
import org.tigr.microarray.mev.cgh.CGHDataObj.Distribution;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.GeneDataSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.IterativeLogMCNormInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.LinRegNormInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.RatioStatsNormInitDialog;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.persistence.MultipleArrayDataPersistenceDelegate;
import org.tigr.microarray.mev.persistence.MultipleArrayDataState;
import org.tigr.microarray.mev.sampleannotation.MageIDF;
import org.tigr.microarray.util.Adjustment;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.midas.engine.Parameter;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class MultipleArrayData
implements IData {
    private ArrayList featuresList = new ArrayList();
    private ArrayList indicesList = new ArrayList();
    private ArrayList spotColors = new ArrayList();
    private int[] colorIndices;
    private ArrayList experimentColors = new ArrayList();
    private int[] experimentColorIndices;
    private Experiment experiment = null;
    private int dataType;
    private float maxCy3 = 0.0f;
    private float maxCy5 = 0.0f;
    private float maxRatio = 0.0f;
    private float minRatio = 0.0f;
    private float percentageCutoff = 0.0f;
    private boolean usePercentageCutoff = false;
    private boolean usePvaluePercentageCutoff = false;
    private boolean usePresentCallCutoff = false;
    private boolean useGCOSPercentCutoff = false;
    private boolean useVarianceFilter = false;
    private float lowerCY3Cutoff = 0.0f;
    private float lowerCY5Cutoff = 0.0f;
    private boolean useLowerCutoffs = false;
    private float genePixCutoff = 80.0f;
    private boolean useGenePixCutoffs = false;
    private Progress progressBar;
    private boolean normalizationAbort = false;
    private DetectionFilter detectionFilter;
    private FoldFilter foldFilter;
    private boolean useDetectionFilter = false;
    private boolean dfSet = false;
    private boolean ffSet = false;
    private boolean useFoldFilter = false;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository expClusterRepository;
    int logState = 1;
    private boolean isMedianIntensities = false;
    private boolean useMainData = true;
    private Experiment alternateExperiment = null;
    MultipleArrayDataState mads;
    IChipAnnotation chipAnnotation;
    ArrayList clones = new ArrayList();
    int[][] chromosomeIndices = new int[24][];
    int[] samplesOrder;
    int cloneValueType;
    Distribution[] cloneDistributions;
    CGHCopyNumberCalculator copyNumberCalculator;
    ICGHDataRegion[][] annotations = new ICGHDataRegion[0][0];
    boolean hasDyeSwap = false;
    public boolean CGHData = false;
    public boolean log2Data = false;
    public int CGH_SPECIES = -100;
    public boolean hasCloneDistribution = false;
    public String gaggleOrganismName;
    public MageIDF IDFObject = new MageIDF();

    public MultipleArrayData() {
        this.mads = new MultipleArrayDataState();
        this.chipAnnotation = new MevChipAnnotation();
    }

    public MultipleArrayData(Experiment experiment, Boolean useMainData, Experiment alternateExperiment, Float percentageCutoff, Boolean usePercentageCutoffs, Boolean useVarianceFilter, Boolean useDetectionFilter, Boolean useFoldFilter, Boolean dfSet, Boolean ffSet, DetectionFilter df, FoldFilter ff, Boolean isMedianIntensities, Boolean useLowerCutoffs, Float lowerCY3Cutoff, Float lowerCY5Cutoff, ArrayList experimentColors, ArrayList spotColors, String currentSampleLabelKey, ArrayList featuresList, Integer dataType, int[] samplesOrder, Boolean hasDyeSwap, Boolean CGHData, Boolean log2Data, ArrayList clones, Integer cgh_Sp, MultipleArrayDataState mads) {
        this.mads = mads;
        this.experiment = experiment;
        this.setFeaturesList(featuresList);
        this.alternateExperiment = alternateExperiment;
        this.useMainData = useMainData;
        this.percentageCutoff = percentageCutoff.floatValue();
        this.usePercentageCutoff = usePercentageCutoffs;
        this.useVarianceFilter = useVarianceFilter;
        this.useDetectionFilter = useDetectionFilter;
        this.useFoldFilter = useFoldFilter;
        this.samplesOrder = samplesOrder;
        this.dfSet = dfSet;
        if (dfSet.booleanValue()) {
            this.detectionFilter = df;
        }
        this.ffSet = ffSet;
        if (ffSet.booleanValue()) {
            this.foldFilter = ff;
        }
        this.isMedianIntensities = isMedianIntensities;
        this.useLowerCutoffs = useLowerCutoffs;
        this.lowerCY3Cutoff = lowerCY3Cutoff.floatValue();
        this.lowerCY5Cutoff = lowerCY5Cutoff.floatValue();
        this.experimentColors = experimentColors;
        this.spotColors = spotColors;
        this.setSampleLabelKey(currentSampleLabelKey);
        try {
            this.setDataType(dataType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasDyeSwap = hasDyeSwap;
        this.CGHData = CGHData;
        this.log2Data = log2Data;
        this.clones = clones;
        this.CGH_SPECIES = cgh_Sp;
        this.loadMADS(mads);
    }

    public MultipleArrayData(Experiment experiment, Boolean useMainData, Experiment alternateExperiment, Float percentageCutoff, Boolean usePercentageCutoffs, Boolean useVarianceFilter, Boolean useDetectionFilter, Boolean useFoldFilter, Boolean dfSet, Boolean ffSet, DetectionFilter df, FoldFilter ff, Boolean isMedianIntensities, Boolean useLowerCutoffs, Float lowerCY3Cutoff, Float lowerCY5Cutoff, ArrayList experimentColors, ArrayList spotColors, String currentSampleLabelKey, ArrayList featuresList, Integer dataType, int[] samplesOrder, Boolean hasDyeSwap, Boolean CGHData, Boolean log2Data, ArrayList clones, Integer cgh_Sp, int[][] chromosomeIndices, Integer cloneValueType, MultipleArrayDataState mads) {
        this(experiment, useMainData, alternateExperiment, percentageCutoff, usePercentageCutoffs, useVarianceFilter, useDetectionFilter, useFoldFilter, dfSet, ffSet, df, ff, isMedianIntensities, useLowerCutoffs, lowerCY3Cutoff, lowerCY5Cutoff, experimentColors, spotColors, currentSampleLabelKey, featuresList, dataType, samplesOrder, hasDyeSwap, CGHData, log2Data, clones, cgh_Sp, mads);
        this.chromosomeIndices = chromosomeIndices;
        this.cloneValueType = cloneValueType;
    }

    public MultipleArrayData(Experiment experiment, Boolean useMainData, Experiment alternateExperiment, Float percentageCutoff, Boolean usePercentageCutoffs, Boolean useVarianceFilter, Boolean useDetectionFilter, Boolean useFoldFilter, Boolean dfSet, Boolean ffSet, DetectionFilter df, FoldFilter ff, Boolean isMedianIntensities, Boolean useLowerCutoffs, Float lowerCY3Cutoff, Float lowerCY5Cutoff, ArrayList experimentColors, ArrayList spotColors, String currentSampleLabelKey, ArrayList featuresList, Integer dataType, int[] samplesOrder, Boolean hasDyeSwap, Boolean CGHData, Boolean log2Data, ArrayList clones, Integer cgh_Sp, int[][] chromosomeIndices, Integer cloneValueType, MultipleArrayDataState mads, IChipAnnotation chipAnnotation) {
        this(experiment, useMainData, alternateExperiment, percentageCutoff, usePercentageCutoffs, useVarianceFilter, useDetectionFilter, useFoldFilter, dfSet, ffSet, df, ff, isMedianIntensities, useLowerCutoffs, lowerCY3Cutoff, lowerCY5Cutoff, experimentColors, spotColors, currentSampleLabelKey, featuresList, dataType, samplesOrder, hasDyeSwap, CGHData, log2Data, clones, cgh_Sp, chromosomeIndices, cloneValueType, mads);
        this.setChipAnnotation(chipAnnotation);
    }

    private void loadMADS(MultipleArrayDataState mads) {
        this.mads = mads;
        this.setMaxCy3(mads.getMaxCY3());
        this.setMaxCy5(mads.getMaxCY5());
    }

    public MultipleArrayDataState getMultipleArrayDataState() {
        return this.mads;
    }

    public void setChipAnnotation(IChipAnnotation annot) {
        if (annot == null) {
            this.chipAnnotation = new MevChipAnnotation();
        }
        this.chipAnnotation = annot;
    }

    public IChipAnnotation getChipAnnotation() {
        if (this.chipAnnotation == null) {
            this.chipAnnotation = new MevChipAnnotation();
        }
        return this.chipAnnotation;
    }

    public void setGaggleOrganismName(String name) {
        this.gaggleOrganismName = name;
    }

    public String getGaggleOrganismName() {
        if (this.gaggleOrganismName != null) {
            return this.gaggleOrganismName;
        }
        return this.chipAnnotation.getSpeciesName();
    }

    public void setFeaturesList(ArrayList list) {
        this.featuresList = list;
        for (int i = 0; i < this.featuresList.size(); ++i) {
            this.indicesList.add(this.createIndices((ISlideData)this.featuresList.get(i)));
        }
        this.updateSpotColors();
        this.updateExperimentColors();
        this.experiment = this.createExperiment();
    }

    public void setGeneClusterRepository(ClusterRepository rep) {
        this.geneClusterRepository = rep;
    }

    public void setExperimentClusterRepository(ClusterRepository rep) {
        this.expClusterRepository = rep;
    }

    public void setUseMainData(boolean useMainDataSelection) {
        this.useMainData = useMainDataSelection;
        if (this.useMainData) {
            this.alternateExperiment = null;
        }
    }

    public boolean getUseMainData() {
        return this.useMainData;
    }

    public void setAlternateExperiment(Experiment e) {
        this.alternateExperiment = e;
    }

    public Experiment getAlternateExperiment() {
        return this.alternateExperiment;
    }

    public void setLogState(int state) {
        this.logState = state;
    }

    public int getLogState() {
        return this.logState;
    }

    public void constructAndSetAlternateExperiment(Experiment coreExperiment, int[] clusterIndices, int clusterType) {
        int[] origRowIndices = coreExperiment.getRowMappingArrayCopy();
        int[] origColIndices = coreExperiment.getColumnIndicesCopy();
        FloatMatrix coreMatrix = coreExperiment.getMatrix();
        if (clusterType == 0) {
            FloatMatrix newMatrix = new FloatMatrix(clusterIndices.length, origColIndices.length);
            int[] newRowIndices = new int[clusterIndices.length];
            for (int row = 0; row < clusterIndices.length; ++row) {
                for (int col = 0; col < origColIndices.length; ++col) {
                    newMatrix.set(row, col, coreMatrix.get(clusterIndices[row], col));
                }
                newRowIndices[row] = origRowIndices[clusterIndices[row]];
            }
            this.setAlternateExperiment(new Experiment(newMatrix, origColIndices, newRowIndices));
            this.useMainData = false;
        } else {
            FloatMatrix newMatrix = new FloatMatrix(origRowIndices.length, clusterIndices.length);
            int[] newColIndices = new int[clusterIndices.length];
            boolean colCount = false;
            for (int col = 0; col < clusterIndices.length; ++col) {
                for (int row = 0; row < origRowIndices.length; ++row) {
                    newMatrix.set(row, col, coreMatrix.get(row, clusterIndices[col]));
                }
                newColIndices[col] = origColIndices[clusterIndices[col]];
            }
            this.setAlternateExperiment(new Experiment(newMatrix, newColIndices, origRowIndices));
            this.useMainData = false;
        }
    }

    public int getFeaturesCount() {
        return this.featuresList.size();
    }

    public int getFeaturesSize() {
        if (this.featuresList.size() == 0) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getSize();
    }

    public ArrayList getFeaturesList() {
        return this.featuresList;
    }

    public float getPercentageCutoff() {
        return this.percentageCutoff;
    }

    public void setPercentageCutoff(float value) {
        this.percentageCutoff = value;
        if (this.isPercentageCutoff()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setPvaluePercentageCutoff(float value) {
        this.percentageCutoff = value;
        if (this.isPvaluePercentageCutoff()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setPresenCallCutoff(float value) {
        this.percentageCutoff = value;
        if (this.isPresentCallCutoff()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setVarianceFilter(Properties props) {
        this.mads.setVarianceFilterProps(props);
        this.useVarianceFilter = props.getProperty("Filter Enabled").equals("true");
        this.experiment = this.createExperiment();
    }

    public void setUsePercentageCutoff(boolean value) {
        if (this.usePercentageCutoff == value) {
            return;
        }
        this.usePercentageCutoff = value;
        this.experiment = this.createExperiment();
    }

    public void setUsePvaluePercentageCutoff(boolean value) {
        if (this.usePvaluePercentageCutoff == value) {
            return;
        }
        this.usePvaluePercentageCutoff = value;
        this.experiment = this.createExperiment();
    }

    public void setUsePresentCutoff(boolean value) {
        if (this.usePresentCallCutoff == value) {
            return;
        }
        this.usePresentCallCutoff = value;
        this.experiment = this.createExperiment();
    }

    public void setUseGCOSPercentageCutoff(boolean value) {
        if (this.useGCOSPercentCutoff == value) {
            return;
        }
        this.useGCOSPercentCutoff = value;
        this.experiment = this.createExperiment();
    }

    public void setUseGenePixCutoff(boolean value) {
        if (this.useGenePixCutoffs == value) {
            return;
        }
        this.useGenePixCutoffs = value;
        this.experiment = this.createExperiment();
    }

    public void setUseDetectionFilter(boolean value) {
        if (this.useDetectionFilter == value) {
            return;
        }
        this.useDetectionFilter = value;
        this.experiment = this.createExperiment();
    }

    public void setUseFoldFilter(boolean value) {
        if (this.useFoldFilter == value) {
            return;
        }
        this.useFoldFilter = value;
        this.experiment = this.createExperiment();
    }

    public void setdfSet(boolean b) {
        this.dfSet = b;
    }

    public boolean getdfSet() {
        return this.dfSet;
    }

    public void setffSet(boolean b) {
        this.ffSet = b;
    }

    public boolean getffSet() {
        return this.ffSet;
    }

    public boolean isDetectionFilter() {
        return this.useDetectionFilter;
    }

    public boolean isFoldFilter() {
        return this.useFoldFilter;
    }

    public boolean isGenePixFilter() {
        return this.useGenePixCutoffs;
    }

    public DetectionFilter getDetectionFilter() {
        return this.detectionFilter;
    }

    public FoldFilter getFoldFilter() {
        return this.foldFilter;
    }

    public void setDetectionFilter(DetectionFilter filter) {
        this.detectionFilter = filter;
        if (this.isDetectionFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setGenePixCutoff(float value) {
        this.useGenePixCutoffs = true;
        this.percentageCutoff = value;
        if (this.isGenePixFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setFoldFilter(FoldFilter filter) {
        this.foldFilter = filter;
        if (this.isFoldFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public String getDetection(int column, int row) {
        if (this.featuresList.size() == 0) {
            return "";
        }
        return ((ISlideData)this.featuresList.get(column)).getDetection(row);
    }

    public float getPvalue(int column, int row) {
        if (this.featuresList.size() == 0) {
            return 0.0f;
        }
        return ((ISlideData)this.featuresList.get(column)).getPvalue(row);
    }

    public int getGenePixFlags(int column, int row) {
        if (this.featuresList.size() == 0) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(column)).getGenePixFlags(row);
    }

    public boolean isPercentageCutoff() {
        return this.usePercentageCutoff;
    }

    public boolean isPvaluePercentageCutoff() {
        return this.usePvaluePercentageCutoff;
    }

    public boolean isPresentCallCutoff() {
        return this.usePresentCallCutoff;
    }

    public boolean isGCOSPercentCutoff() {
        return this.useGCOSPercentCutoff;
    }

    public boolean isVarianceFilter() {
        return this.useVarianceFilter;
    }

    public float getLowerCY3Cutoff() {
        return this.lowerCY3Cutoff;
    }

    public void setMedianIntensities(boolean areMedians) {
        this.isMedianIntensities = areMedians;
    }

    public boolean areMedianIntensities() {
        return this.isMedianIntensities;
    }

    public void setLowerCutoffs(float lowerCY3, float lowerCY5) {
        this.lowerCY3Cutoff = lowerCY3;
        this.lowerCY5Cutoff = lowerCY5;
        if (this.isLowerCutoffs()) {
            this.experiment = this.createExperiment();
        }
    }

    public float getLowerCY5Cutoff() {
        return this.lowerCY5Cutoff;
    }

    public void setUseLowerCutoffs(boolean value) {
        if (this.useLowerCutoffs == value) {
            return;
        }
        this.useLowerCutoffs = value;
        this.experiment = this.createExperiment();
    }

    public boolean isLowerCutoffs() {
        return this.useLowerCutoffs;
    }

    public float getCY3(int column, int row) {
        ISlideData slideData = (ISlideData)this.featuresList.get(column);
        return slideData.getCY3(row);
    }

    public float getCY5(int column, int row) {
        ISlideData slideData = (ISlideData)this.featuresList.get(column);
        return slideData.getCY5(row);
    }

    public float getRatio(int column, int row, int logState) {
        ISlideData slideData = (ISlideData)this.featuresList.get(column);
        logState = this.logState;
        return slideData.getRatio(row, logState);
    }

    public String getSampleName(int column) {
        return ((ISlideData)this.featuresList.get(column)).getSlideDataName();
    }

    public void setSampleLabelKey(String key) {
        for (int i = 0; i < this.featuresList.size(); ++i) {
            ((ISlideData)this.featuresList.get(i)).setDataLabelKey(key);
        }
    }

    public String getFullSampleName(int column) {
        return ((ISlideData)this.featuresList.get(column)).getFullSlideDataName();
    }

    public Vector getSlideDataNameKeys(int column) {
        return ((ISlideData)this.featuresList.get(column)).getSlideDataKeys();
    }

    public Vector getSlideNameKeyVectorUnion() {
        Vector<String> fullKeyVector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector<String> keyVector = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (int j = 0; j < keyVector.size(); ++j) {
                String key = keyVector.elementAt(j);
                if (fullKeyVector.contains(key)) continue;
                fullKeyVector.addElement(key);
            }
        }
        return fullKeyVector;
    }

    public Vector getSampleAnnotationFieldNames() {
        Vector<String> fullKeyVector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector<String> keyVector = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (int j = 0; j < keyVector.size(); ++j) {
                String key = keyVector.elementAt(j);
                if (fullKeyVector.contains(key)) continue;
                fullKeyVector.addElement(key);
            }
        }
        return fullKeyVector;
    }

    public String[] getSlideNameKeyArray() {
        Vector<String> fullKeyVector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector<String> keyVector = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (int j = 0; j < keyVector.size(); ++j) {
                String key = keyVector.elementAt(j);
                if (fullKeyVector.contains(key)) continue;
                fullKeyVector.addElement(key);
            }
        }
        String[] keys = new String[fullKeyVector.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)fullKeyVector.elementAt(i);
        }
        return keys;
    }

    public void addNewExperimentLabel(String key, String[] values) {
        for (int i = 0; i < this.featuresList.size(); ++i) {
            this.getFeature(i).addNewSampleLabel(key, values[i]);
        }
    }

    public boolean addNewSampleLabels(Frame parent, File file) throws IOException {
        int sampleCount = this.getFeaturesCount();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        boolean readingFirstRow = true;
        String[] annKeys = null;
        Vector<String[]> data = new Vector<String[]>();
        int annCnt = 0;
        int rowCnt = 0;
        Hashtable<String, String[]> annotation = new Hashtable<String, String[]>();
        String line = reader.readLine();
        StringTokenizer stok = new StringTokenizer(line, "\t");
        annKeys = new String[stok.countTokens()];
        for (int i = 0; i < annKeys.length; ++i) {
            annKeys[i] = stok.nextToken();
        }
        int fieldCount = annKeys.length;
        while ((line = reader.readLine()) != null) {
            stok = new StringTokenizer(line, "\t");
            annCnt = 0;
            String[] annotationRow = new String[fieldCount];
            while (stok.hasMoreTokens()) {
                annotationRow[annCnt] = stok.nextToken();
                ++annCnt;
            }
            annotation.put(annotationRow[0], annotationRow);
            data.add(annotationRow);
            ++rowCnt;
        }
        for (int i = 0; i < this.featuresList.size(); ++i) {
            ISlideData thisSlide = this.getFeature(i);
            String thisSlideFileName = thisSlide.getSampleAnnotation().getAnnotation("Default Slide Name");
            if (annotation.containsKey(thisSlideFileName)) {
                for (int j = 0; j < annKeys.length; ++j) {
                    String thisAnnotationValue = ((String[])annotation.get(thisSlideFileName))[j];
                    thisSlide.addNewSampleLabel(annKeys[j], thisAnnotationValue);
                }
                continue;
            }
            System.out.println("No annotation for " + thisSlideFileName);
        }
        return true;
    }

    public int addNewGeneAnnotation(String[][] annMatrix, String dataKey, String annFileKey, String[] fieldsToAppend) {
        ISlideDataElement sde;
        int row;
        int keyCol;
        int updateCount = 0;
        for (keyCol = 0; keyCol < annMatrix[0].length && !annMatrix[0][keyCol].equals(annFileKey); ++keyCol) {
        }
        if (keyCol > annMatrix[0].length) {
            return updateCount;
        }
        String[] fieldNames = this.getFieldNames();
        int dataKeyCol = -1;
        if (!dataKey.equals("UID")) {
            for (dataKeyCol = 0; dataKeyCol < fieldNames.length && !dataKey.equals(fieldNames[dataKeyCol]); ++dataKeyCol) {
            }
        }
        if (dataKeyCol > fieldNames.length) {
            return updateCount;
        }
        Hashtable<String, String[]> annotationHash = new Hashtable<String, String[]>();
        if (fieldsToAppend.length == annMatrix[0].length) {
            for (int row2 = 1; row2 < annMatrix.length; ++row2) {
                annotationHash.put(annMatrix[row2][keyCol], annMatrix[row2]);
            }
        } else {
            Vector<String> testVector = new Vector<String>();
            for (int i = 0; i < fieldsToAppend.length; ++i) {
                testVector.add(fieldsToAppend[i]);
            }
            int subsetIndex = 0;
            for (int row3 = 1; row3 < annMatrix.length; ++row3) {
                subsetIndex = 0;
                String[] annSubset = new String[fieldsToAppend.length];
                for (int fieldIndex = 0; fieldIndex < annMatrix[0].length; ++fieldIndex) {
                    if (!testVector.contains(annMatrix[0][fieldIndex])) continue;
                    annSubset[subsetIndex] = annMatrix[row3][fieldIndex];
                    ++subsetIndex;
                }
                annotationHash.put(annMatrix[row3][keyCol], annSubset);
            }
        }
        ISlideData slideData = (ISlideData)((Object)this.getSlideMetaData());
        int rows = this.getFeaturesSize();
        String dataID = "";
        for (row = 0; row < rows; ++row) {
            sde = slideData.getSlideDataElement(row);
            dataID = dataKeyCol == -1 ? sde.getUID() : this.getElementAnnotation(row, dataKey)[0];
            if (!annotationHash.containsKey(dataID)) continue;
            ++updateCount;
        }
        if (updateCount > 0) {
            for (row = 0; row < rows; ++row) {
                sde = slideData.getSlideDataElement(row);
                dataID = dataKeyCol == -1 ? sde.getUID() : sde.getFieldAt(dataKeyCol);
                String[] newFields = (String[])annotationHash.get(dataID);
                if (newFields != null) {
                    sde.setExtraFields(newFields);
                    ++updateCount;
                    continue;
                }
                sde.setExtraFields(new String[annMatrix[0].length]);
            }
        }
        return updateCount;
    }

    public void addResourcererGeneAnnotation(String dataKey, Hashtable annotationHash) {
        boolean updateCount = false;
        String[] fieldNames = this.getFieldNames();
        int dataKeyCol = -1;
        for (dataKeyCol = 0; dataKeyCol < fieldNames.length && !dataKey.equals(fieldNames[dataKeyCol]); ++dataKeyCol) {
        }
        ISlideData slideData = (ISlideData)((Object)this.getSlideMetaData());
        int rows = this.getFeaturesSize();
        String dataID = "";
        for (int row = 0; row < rows; ++row) {
            MevAnnotation mevAnno;
            ISlideDataElement sde = slideData.getSlideDataElement(row);
            String cloneName = dataID = this.getElementAnnotation(row, dataKey)[0];
            if (annotationHash.size() == 0) continue;
            if ((MevAnnotation)annotationHash.get(cloneName) != null) {
                mevAnno = (MevAnnotation)annotationHash.get(cloneName);
                sde.setElementAnnotation(mevAnno);
                continue;
            }
            mevAnno = new MevAnnotation();
            mevAnno.setCloneID(cloneName);
            sde.setElementAnnotation(mevAnno);
        }
        this.setAnnotationLoaded(true);
        slideData.getSlideMetaData().updateFilledAnnFields();
    }

    public String getElementAttribute(int row, int attr) {
        String[] allResults = this.getElementAnnotation(row, this.getFieldNames()[attr]);
        String annotationConcatenated = allResults == null || allResults.length < 1 ? "NA" : allResults[0];
        for (int i = 1; i < allResults.length; ++i) {
            annotationConcatenated = annotationConcatenated + "///" + allResults[i];
        }
        return annotationConcatenated;
    }

    public String[] getElementAnnotation(int row, String attr) {
        return ((ISlideData)this.featuresList.get(0)).getSlideMetaData().getAnnotationValue(row, attr);
    }

    public String[][] getElementAnnotation(int[] rows, String attr) {
        String[][] _temp = new String[rows.length][];
        for (int i = 0; i < _temp.length; ++i) {
            _temp[i] = ((ISlideData)this.featuresList.get(0)).getSlideMetaData().getAnnotationValue(rows[i], attr);
        }
        return _temp;
    }

    public AnnoAttributeObj getElementAnnotationObject(int row, String attr) {
        if (this.featuresList.size() == 0) {
            return null;
        }
        ISlideData slideData = (ISlideData)this.featuresList.get(0);
        return slideData.getSlideMetaData().getAnnotationObj(row, attr);
    }

    public String getUniqueId(int row) {
        return this.getElementAttribute(row, TMEV.getUniqueIDIndex());
    }

    public String getGeneName(int row) {
        return this.getElementAttribute(row, TMEV.getNameIndex());
    }

    public String[] getFieldNames() {
        return ((ISlideData)this.featuresList.get(0)).getSlideMetaData().getFieldNames();
    }

    public String[] getAllFilledAnnotationFields() {
        return ((ISlideData)this.featuresList.get(0)).getSlideMetaData().getFieldNames();
    }

    public int getProbeRow(int column, int row) {
        ISlideMetaData meta = this.getFeature(column).getSlideMetaData();
        return meta.getRow(row);
    }

    public int getProbeColumn(int column, int row) {
        ISlideMetaData meta = this.getFeature(column).getSlideMetaData();
        return meta.getColumn(row);
    }

    public Color[] getGeneColorArray(int index) {
        return this.geneClusterRepository.getColors(index);
    }

    public Color[] getSampleColorArray(int index) {
        return this.expClusterRepository.getColors(index);
    }

    public boolean isColorOverlap(int index, Color color, Color c, boolean isGeneCR) {
        if (isGeneCR) {
            return this.geneClusterRepository.isColorOverlap(index, color, c);
        }
        return this.expClusterRepository.isColorOverlap(index, color, c);
    }

    public String getClusterLabel(int index, boolean gene) {
        if (gene) {
            if (this.geneClusterRepository == null) {
                return null;
            }
            if (this.geneClusterRepository.getCluster(index) == null) {
                return null;
            }
            return this.geneClusterRepository.getCluster(index).getClusterLabel();
        }
        if (this.expClusterRepository == null) {
            return null;
        }
        if (this.expClusterRepository.getCluster(index) == null) {
            return null;
        }
        return this.expClusterRepository.getCluster(index).getClusterLabel();
    }

    public int getVisibleClusters() {
        if (this.geneClusterRepository == null) {
            return 0;
        }
        return this.geneClusterRepository.getVisibleClusters();
    }

    public int getVisibleCluster(Color color, boolean gene) {
        if (gene) {
            if (this.geneClusterRepository == null) {
                return 0;
            }
            int i = 0;
            do {
                if (++i <= this.geneClusterRepository.getClusterSerialCounter()) continue;
                return 0;
            } while (this.geneClusterRepository.getCluster(i) == null || this.geneClusterRepository.getCluster(i).getClusterColor() != color);
            return i;
        }
        if (this.expClusterRepository == null) {
            return 0;
        }
        int i = 0;
        do {
            if (++i <= this.expClusterRepository.getClusterSerialCounter()) continue;
            return 0;
        } while (this.expClusterRepository.getCluster(i) == null || this.expClusterRepository.getCluster(i).getClusterColor() != color);
        return i;
    }

    public Color[] getColors() {
        this.updateSpotColors();
        Color[] colors = new Color[this.spotColors.size()];
        return this.spotColors.toArray(colors);
    }

    public ArrayList getSpotColors() {
        return this.spotColors;
    }

    public void setSpotColors(ArrayList sp) {
        this.spotColors = sp;
    }

    public Color getProbeColor(int row) {
        if (this.geneClusterRepository == null) {
            return null;
        }
        return this.geneClusterRepository.getColor(row);
    }

    public void updateSpotColors() {
        this.colorIndices = new int[this.getFeaturesSize()];
        this.spotColors = new ArrayList();
        int count = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            Color color = this.geneClusterRepository == null ? null : this.geneClusterRepository.getColor(i);
            if (color == null) {
                this.colorIndices[i] = -1;
                continue;
            }
            int index = this.spotColors.indexOf(color);
            if (index < 0) {
                this.spotColors.add(color);
                this.colorIndices[i] = count++;
                continue;
            }
            this.colorIndices[i] = index;
        }
    }

    public void updateExperimentColors() {
        this.experimentColorIndices = new int[this.getFeaturesCount()];
        this.experimentColors = new ArrayList();
        int count = 0;
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            Color color = this.expClusterRepository == null ? null : this.expClusterRepository.getColor(i);
            if (color == null) {
                this.experimentColorIndices[i] = -1;
                continue;
            }
            int index = this.experimentColors.indexOf(color);
            if (index < 0) {
                this.experimentColors.add(color);
                this.experimentColorIndices[i] = count++;
                continue;
            }
            this.experimentColorIndices[i] = index;
        }
    }

    public int[] getColorIndices() {
        this.updateSpotColors();
        return this.colorIndices;
    }

    public int[] getExperimentColorIndices() {
        this.updateExperimentColors();
        return this.experimentColorIndices;
    }

    public void setColorIndices(int[] ci) {
        this.colorIndices = ci;
    }

    public void setExperimentColorIndices(int[] eci) {
        this.experimentColorIndices = eci;
    }

    public void setProbesColor(int[] rows, Color color) {
        int colorIndex;
        if (color == null) {
            colorIndex = -1;
        } else {
            colorIndex = this.spotColors.indexOf(color);
            if (colorIndex < 0) {
                colorIndex = this.spotColors.size();
                this.spotColors.add(color);
            }
        }
        for (int i = 0; i < rows.length; ++i) {
            this.colorIndices[rows[i]] = colorIndex;
        }
        this.removeUnusedColors();
    }

    public int getProbeColorIndex(int row) {
        return this.colorIndices[row];
    }

    public int getColoredProbesCount(int colorIndex) {
        int count = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            if (this.colorIndices[i] != colorIndex) continue;
            ++count;
        }
        return count;
    }

    public Color getExperimentColor(int index) {
        if (this.expClusterRepository == null) {
            return null;
        }
        return this.expClusterRepository.getColor(index);
    }

    public void setExperimentColor(int[] indices, Color color) {
        int colorIndex;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        if (color == null) {
            colorIndex = -1;
        } else {
            colorIndex = this.experimentColors.indexOf(color);
            if (colorIndex < 0) {
                colorIndex = this.experimentColors.size();
                this.experimentColors.add(color);
            }
        }
        for (int i = 0; i < indices.length; ++i) {
            this.experimentColorIndices[indices[i]] = colorIndex;
        }
        this.removeUnusedExperimentColors();
    }

    public void setExperimentColors(Color[] ec) {
        ArrayList<Color> al = new ArrayList<Color>(ec.length);
        for (int i = 0; i < al.size(); ++i) {
            al.set(i, ec[i]);
        }
        this.experimentColors = al;
    }

    public int getColoredExperimentsCount(int colorIndex) {
        int count = 0;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            if (this.experimentColorIndices[i] != colorIndex) continue;
            ++count;
        }
        return count;
    }

    public Color[] getExperimentColors() {
        this.updateExperimentColors();
        Color[] colors = new Color[this.experimentColors.size()];
        return this.experimentColors.toArray(colors);
    }

    public int getExperimentColorIndex(int col) {
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        return this.experimentColorIndices[col];
    }

    public void clearExperimentColor(int index) {
        if (index > this.experimentColorIndices.length) {
            return;
        }
        this.experimentColors.remove(this.experimentColorIndices[index]);
        this.experimentColorIndices[index] = -1;
    }

    public void clearExperimentColors(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            this.clearExperimentColor(indices[i]);
        }
    }

    public void deleteExperimentColors() {
        this.experimentColors.clear();
        this.experimentColorIndices = this.createExperimentColorIndices();
    }

    private int[] createExperimentColorIndices() {
        int[] indices = new int[this.featuresList.size()];
        for (int i = 0; i < this.featuresList.size(); ++i) {
            indices[i] = -1;
        }
        return indices;
    }

    private void removeUnusedColors() {
        int size;
        int i = size = this.spotColors.size();
        while (--i >= 0) {
            boolean unused = true;
            int j = this.colorIndices.length;
            while (--j >= 0) {
                if (this.colorIndices[j] != i) continue;
                unused = false;
                break;
            }
            if (!unused) continue;
            this.spotColors.remove(i);
            j = this.colorIndices.length;
            while (--j >= 0) {
                if (this.colorIndices[j] <= i) continue;
                int n = j;
                this.colorIndices[n] = this.colorIndices[n] - 1;
            }
        }
    }

    private void removeUnusedExperimentColors() {
        int size;
        int i = size = this.experimentColors.size();
        while (--i >= 0) {
            boolean unused = true;
            int j = this.experimentColorIndices.length;
            while (--j >= 0) {
                if (this.experimentColorIndices[j] != i) continue;
                unused = false;
                break;
            }
            if (!unused) continue;
            this.experimentColors.remove(i);
            j = this.experimentColorIndices.length;
            while (--j >= 0) {
                if (this.experimentColorIndices[j] <= i) continue;
                int n = j;
                this.experimentColorIndices[n] = this.experimentColorIndices[n] - 1;
            }
        }
    }

    public void deleteColors() {
        this.spotColors.clear();
        if (this.colorIndices != null) {
            this.colorIndices = this.createColorIndices(this.colorIndices.length);
        }
    }

    private int[] createIndices(ISlideData slideData) {
        int[] indices = new int[slideData.getSize()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    void addFeature(ISlideData slideData) {
        this.featuresList.add(slideData);
        slideData.setDataType(this.dataType);
        this.indicesList.add(this.createIndices(slideData));
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(slideData.getSize());
        }
        this.updateMaxValues(slideData);
    }

    void addFeatures(ISlideData[] slideData) {
        slideData[0].getSlideMetaData().updateFilledAnnFields();
        for (int i = 0; i < slideData.length; ++i) {
            this.featuresList.add(slideData[i]);
            slideData[i].setDataType(this.dataType);
            this.indicesList.add(this.createIndices(slideData[i]));
            this.updateMaxValues(slideData[i]);
        }
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(slideData[0].getSize());
        }
    }

    private int[] createColorIndices(int size) {
        int[] indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = -1;
        }
        return indices;
    }

    private void updateMaxValues(ISlideData slideData) {
        float value = slideData.getMaxCY3();
        if (value > this.maxCy3) {
            this.setMaxCY3(value);
        }
        if ((value = slideData.getMaxCY5()) > this.maxCy5) {
            this.setMaxCY5(value);
        }
        this.updateMaxMinRatios(slideData);
    }

    ISlideMetaData getSlideMetaData() {
        if (this.featuresList.size() > 0) {
            return ((ISlideData)this.featuresList.get(0)).getSlideMetaData();
        }
        return null;
    }

    public ISlideData getFeature(int column) {
        return (ISlideData)this.featuresList.get(column);
    }

    public ISlideDataElement getSlideDataElement(int column, int row) {
        ISlideData slideData = this.getFeature(column);
        return slideData.getSlideDataElement(row);
    }

    void setNonZero(boolean value) {
        this.resetMaxValues();
        int size = this.getFeaturesCount();
        for (int i = 0; i < size; ++i) {
            ISlideData slideData = this.getFeature(i);
            slideData.setNonZero(value);
            this.updateMaxValues(slideData);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String normalize(int mode, MultipleArrayViewer viewer) {
        LinRegNormInitDialog dialog;
        this.resetMaxValues();
        int size = this.getFeaturesCount();
        Properties properties = new Properties();
        new Parameter();
        if (mode == 0) {
            for (int feature = 0; feature < size; ++feature) {
                ISlideData slideData = this.getFeature(feature);
                slideData.applyNormalization(0, properties);
                this.updateMaxValues(slideData);
            }
            this.experiment = this.createExperiment();
            return "normalized";
        }
        if (mode == 3) {
            dialog = new LinRegNormInitDialog();
            if (dialog.showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Float.toString(dialog.getSD()));
            properties.setProperty("mode", dialog.getMode());
            dialog.dispose();
        } else if (mode == 4 || mode == 5) {
            dialog = new RatioStatsNormInitDialog();
            if (dialog.showModal() != 0) return "no_change";
            properties.setProperty("confidence-interval", Integer.toString(dialog.getCI()));
            dialog.dispose();
        } else if (mode == 6) {
            dialog = new IterativeLogMCNormInitDialog();
            if (dialog.showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Float.toString(dialog.getSD()));
            dialog.dispose();
        }
        Normalizer normalizer = new Normalizer(mode, properties, size, viewer);
        normalizer.runNormalization();
        this.experiment = this.createExperiment();
        if (this.normalizationAbort) return "process_abort_reset";
        return "normalized";
    }

    void normalizeList(int mode) {
        this.resetMaxValues();
        int size = this.getFeaturesCount();
        for (int i = 0; i < size; ++i) {
            ISlideData slideData = this.getFeature(i);
            slideData.applyNormalizationList(mode);
            this.updateMaxValues(slideData);
        }
        this.experiment = this.createExperiment();
    }

    public int[] getSortedIndices(int column) {
        return (int[])this.indicesList.get(column);
    }

    private Experiment createExperiment() {
        int featuresSize = this.featuresList.size();
        if (featuresSize < 1) {
            return null;
        }
        int probesSize = this.getFeature(0).getSize();
        Experiment experiment = null;
        int[] features = null;
        int[] probes = null;
        if (this.getDataType() == 6 || this.isLowerCutoffs() || this.isGenePixFilter() || this.isPercentageCutoff() || this.isPvaluePercentageCutoff() || this.isPresentCallCutoff() || this.isGCOSPercentCutoff() || this.isVarianceFilter() || this.getDataType() == 2 && (this.isDetectionFilter() || this.isFoldFilter())) {
            probes = this.createCutoffGeneList(featuresSize, probesSize);
            experiment = this.createExperiment(featuresSize, probes);
        } else {
            features = this.createDefaultFeatures(featuresSize, probesSize);
            experiment = this.createExperiment(features, probesSize);
        }
        return experiment;
    }

    private int[] createDefaultFeatures(int featuresSize, int probesSize) {
        int[] features = new int[featuresSize];
        for (int i = 0; i < featuresSize; ++i) {
            features[i] = i;
        }
        return features;
    }

    private int[] createCutoffFeatures(int featuresSize, int probesSize) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean criteria = true;
        int percentageCount = 0;
        for (int feature = 0; feature < featuresSize; ++feature) {
            ISlideData slideData = this.getFeature(feature);
            for (int probe = 0; probe < probesSize; ++probe) {
                float cy3 = slideData.getCY3(probe);
                float cy5 = slideData.getCY5(probe);
                if (this.isLowerCutoffs() && (cy3 < this.lowerCY3Cutoff || cy5 < this.lowerCY5Cutoff)) {
                    criteria = false;
                    break;
                }
                if (!this.isPercentageCutoff() || !(cy3 > 0.0f) || !(cy5 > 0.0f)) continue;
                ++percentageCount;
            }
            if (criteria && this.isPercentageCutoff() && (float)percentageCount / (float)probesSize * 100.0f < this.percentageCutoff) {
                criteria = false;
            }
            if (!criteria) continue;
            list.add(new Integer(feature));
        }
        int[] features = new int[list.size()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = (Integer)list.get(i);
        }
        return features;
    }

    private int[] filterAbsentCall(int generows, float percentage) throws IOException {
        String currentLine;
        int counter = 0;
        int tag = 0;
        int[] list = new int[generows + 1];
        boolean head = true;
        String[] fields = this.getFieldNames();
        BufferedReader reader = new BufferedReader(new FileReader(fields[this.getFieldNames().length - 1]));
        StringSplitter ss = new StringSplitter('\t');
        while ((currentLine = reader.readLine()) != null) {
            counter = 0;
            ss.init(currentLine);
            if (head) {
                head = false;
                continue;
            }
            for (int i = 0; i < ss.countTokens(); ++i) {
                if (ss.nextToken().compareTo("A") != 0) continue;
                ++counter;
            }
            if ((float)(counter * 100 / ss.countTokens()) > percentage) {
                list[tag] = 1;
            }
            ++tag;
        }
        reader.close();
        return list;
    }

    private int[] createCutoffGeneList(int featuresSize, int probesSize) {
        ISlideData[] slideData = new ISlideData[featuresSize];
        ArrayList list = new ArrayList();
        boolean lowerCutoffCriterion = true;
        boolean percentageCutoffCriterion = true;
        boolean varianceFilterCutoffCriterion = true;
        boolean detectionCriterion = true;
        boolean foldCriterion = true;
        boolean presentCallCutoffCriterion = true;
        boolean genePixCutoffCriterion = true;
        boolean GCOSCutoffCriterion = true;
        boolean pvaluepercentageCutoffCriterion = true;
        int[] mas5CallList = new int[slideData.length];
        int pvaluepercentCount = 0;
        int percentageCount = 0;
        boolean absentCount = false;
        int percentCount = 0;
        int genepixCount = 0;
        int[] tagList = new int[probesSize];
        if (this.isPresentCallCutoff()) {
            try {
                tagList = this.filterAbsentCall(probesSize, this.percentageCutoff);
            }
            catch (IOException e) {
                System.out.print("Call file wrong");
            }
        }
        for (int i = 0; i < slideData.length; ++i) {
            slideData[i] = this.getFeature(i);
        }
        for (int probe = 0; probe < probesSize; ++probe) {
            int j;
            float[] cy3 = new float[featuresSize];
            float[] cy5 = new float[featuresSize];
            String[] detection = new String[featuresSize];
            float[] pvalue = new float[featuresSize];
            float[] flags = new float[featuresSize];
            pvaluepercentCount = 0;
            percentageCount = 0;
            percentCount = 0;
            absentCount = false;
            genepixCount = 0;
            lowerCutoffCriterion = true;
            percentageCutoffCriterion = true;
            detectionCriterion = true;
            foldCriterion = true;
            presentCallCutoffCriterion = true;
            GCOSCutoffCriterion = true;
            pvaluepercentageCutoffCriterion = true;
            genePixCutoffCriterion = true;
            if (tagList[probe] == 1) {
                presentCallCutoffCriterion = false;
            }
            for (j = 0; j < cy3.length; ++j) {
                cy3[j] = slideData[j].getCY3(probe);
                cy5[j] = slideData[j].getCY5(probe);
                detection[j] = this.getDetection(j, probe);
                pvalue[j] = this.getPvalue(j, probe);
                flags[j] = this.getGenePixFlags(j, probe);
            }
            if (this.isGenePixFilter()) {
                for (j = 0; j < cy3.length; ++j) {
                    if (!(flags[j] < 0.0f)) continue;
                    ++genepixCount;
                }
                if ((float)genepixCount / (float)featuresSize * 100.0f > this.percentageCutoff) {
                    genePixCutoffCriterion = false;
                }
            }
            if (this.isLowerCutoffs()) {
                for (j = 0; j < cy3.length; ++j) {
                    if (!(cy3[j] < this.lowerCY3Cutoff) && !(cy5[j] < this.lowerCY5Cutoff)) continue;
                    lowerCutoffCriterion = false;
                    break;
                }
            }
            if (this.isPercentageCutoff()) {
                for (j = 0; j < cy3.length; ++j) {
                    if (!(cy3[j] > 0.0f && cy5[j] > 0.0f) && (this.dataType != 1 || Float.isNaN(cy5[j]))) continue;
                    ++percentageCount;
                }
                if ((float)percentageCount / (float)featuresSize * 100.0f < this.percentageCutoff) {
                    percentageCutoffCriterion = false;
                }
            }
            if (this.isGCOSPercentCutoff()) {
                for (j = 0; j < cy3.length; ++j) {
                    detection[j] = this.getDetection(j, probe);
                    if (detection[j].compareTo("A") != 0 && detection[j].compareTo("a") != 0) continue;
                    ++percentCount;
                }
                if ((float)percentCount / (float)featuresSize * 100.0f > this.percentageCutoff) {
                    GCOSCutoffCriterion = false;
                }
            }
            if (this.isDetectionFilter()) {
                detectionCriterion = this.detectionFilter.keep_gene(detection);
            }
            if (this.isFoldFilter()) {
                foldCriterion = this.foldFilter.keep_gene(cy5);
            }
            if (this.isPvaluePercentageCutoff()) {
                for (j = 0; j < cy3.length; ++j) {
                    pvalue[j] = this.getPvalue(j, probe);
                    if (!((double)pvalue[j] > 0.01)) continue;
                    ++pvaluepercentCount;
                }
                if ((float)pvaluepercentCount / (float)featuresSize * 100.0f > 20.0f) {
                    pvaluepercentageCutoffCriterion = false;
                }
            }
            if (!lowerCutoffCriterion || !pvaluepercentageCutoffCriterion || !percentageCutoffCriterion || !GCOSCutoffCriterion || !presentCallCutoffCriterion || !detectionCriterion || !genePixCutoffCriterion || !foldCriterion) continue;
            list.add(new Integer(probe));
        }
        Object retainBasedOnSD = null;
        if (this.isVarianceFilter()) {
            list = this.imposeVarianceFilter(list);
        }
        int[] retainedProbes = new int[list.size()];
        for (int i = 0; i < retainedProbes.length; ++i) {
            retainedProbes[i] = (Integer)list.get(i);
        }
        return retainedProbes;
    }

    private float[] getStandardDeviations() {
        int numGenes = this.getFeaturesSize();
        int numSamples = this.getFeaturesCount();
        float[] vars = new float[numGenes];
        float[] sds = new float[numGenes];
        boolean[] retentionList = new boolean[numGenes];
        for (int i = 0; i < numGenes; ++i) {
            float val;
            int j;
            int validN = 0;
            float sum = 0.0f;
            float sse = 0.0f;
            for (j = 0; j < numSamples; ++j) {
                val = this.getRatio(j, i, this.logState);
                if (Float.isNaN(val)) continue;
                sum += val;
                ++validN;
            }
            if (validN <= 0) {
                sds[i] = -1.0f;
                continue;
            }
            float mean = sum / (float)validN++;
            for (j = 0; j < numSamples; ++j) {
                val = this.getRatio(j, i, this.logState);
                if (Float.isNaN(val)) continue;
                sse = (float)((double)sse + Math.pow(val - mean, 2.0));
            }
            sds[i] = validN > 0 ? (float)Math.sqrt(sse / (float)validN) : 0.0f;
        }
        return sds;
    }

    public ArrayList imposeVarianceFilter(ArrayList listOfIndices) {
        String mode = this.mads.getVarianceFilterProps().getProperty("Filter Mode");
        float[] sds = this.getStandardDeviations();
        boolean[] retentionList = new boolean[sds.length];
        ArrayList<Integer> newList = new ArrayList<Integer>();
        if (mode.equals("sd value mode")) {
            float sdCut = Float.parseFloat(this.mads.getVarianceFilterProps().getProperty("Value"));
            for (int i = 0; i < sds.length; ++i) {
                if (!(sds[i] >= sdCut) || !listOfIndices.contains(new Integer(i))) continue;
                newList.add(new Integer(i));
            }
        } else if (mode.equals("percent mode")) {
            float percent = Float.parseFloat(this.mads.getVarianceFilterProps().getProperty("Value"));
            QSort sorter = new QSort(sds);
            float[] sortedSDs = sorter.getSorted();
            int[] origOrder = sorter.getOrigIndx();
            int targetSize = (int)((float)listOfIndices.size() * (percent / 100.0f));
            for (int i = origOrder.length - 1; i >= 0 && newList.size() < targetSize; --i) {
                if (!listOfIndices.contains(new Integer(origOrder[i]))) continue;
                newList.add(new Integer(origOrder[i]));
            }
        } else {
            int targetSize = Integer.parseInt(this.mads.getVarianceFilterProps().getProperty("Value"));
            QSort sorter = new QSort(sds);
            float[] sortedSDs = sorter.getSorted();
            int[] origOrder = sorter.getOrigIndx();
            for (int i = origOrder.length - 1; i >= 0 && newList.size() < targetSize; --i) {
                if (!listOfIndices.contains(new Integer(origOrder[i]))) continue;
                newList.add(new Integer(origOrder[i]));
            }
        }
        return newList;
    }

    private Experiment createExperiment(int[] columns, int rows) {
        FloatMatrix fm = new FloatMatrix(rows, columns.length);
        float[][] matrix = fm.A;
        for (int i = 0; i < columns.length; ++i) {
            ISlideData sd = (ISlideData)this.featuresList.get(columns[i]);
            int row = rows;
            while (--row >= 0) {
                fm.A[row][columns[i]] = sd.getRatio(row, this.logState);
            }
        }
        return new Experiment(fm, columns);
    }

    private Experiment createExperiment(int columns, int[] rows) {
        FloatMatrix fm = new FloatMatrix(rows.length, columns);
        int[] columnArray = new int[columns];
        float[][] matrix = fm.A;
        for (int i = 0; i < columns; ++i) {
            columnArray[i] = i;
            ISlideData sd = (ISlideData)this.featuresList.get(i);
            for (int j = 0; j < rows.length; ++j) {
                fm.A[j][i] = sd.getRatio(rows[j], this.logState);
            }
        }
        return new Experiment(fm, columnArray, rows);
    }

    public int getNormalizationState() {
        if (this.featuresList == null || this.featuresList.size() < 1) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getNormalizedState();
    }

    public MultipleArrayData getDataSubset(int[] indices) {
        ISlideMetaData metaData = null;
        MultipleArrayData data = new MultipleArrayData();
        int normalizedState = this.getNormalizationState();
        if (indices.length < 1) {
            return null;
        }
        for (int slide = 0; slide < this.getFeaturesCount(); ++slide) {
            ISlideDataElement sde;
            int index;
            int spot;
            String name;
            ISlideData slideData;
            if (slide == 0) {
                slideData = new SlideData();
                name = this.getSampleName(slide);
                if (name.endsWith("...")) {
                    this.toggleExptNameLength();
                    slideData.setSlideDataLabels(this.getFeature(slide).getSlideDataKeys(), this.getFeature(slide).getSlideDataLabels());
                    ((SlideData)slideData).setSlideFileName(this.getSampleName(slide));
                    this.toggleExptNameLength();
                } else {
                    slideData.setSlideDataLabels(this.getFeature(slide).getSlideDataKeys(), this.getFeature(slide).getSlideDataLabels());
                    ((SlideData)slideData).setSlideFileName(this.getSampleName(slide));
                }
                for (spot = 0; spot < indices.length; ++spot) {
                    index = indices[spot];
                    sde = this.getSlideDataElement(slide, index).clone();
                    slideData.addSlideDataElement(sde);
                }
                metaData = (ISlideMetaData)((Object)slideData);
                metaData.clearFieldNames();
                metaData.setFieldNames(this.getFieldNames());
            } else {
                slideData = new FloatSlideData(metaData);
                ((FloatSlideData)slideData).createCurrentIntensityArrays();
                name = this.getSampleName(slide);
                if (name.endsWith("...")) {
                    this.toggleExptNameLength();
                    slideData.setSlideDataLabels(this.getFeature(slide).getSlideDataKeys(), this.getFeature(slide).getSlideDataLabels());
                    ((FloatSlideData)slideData).setSlideFileName(this.getSampleName(slide));
                    this.toggleExptNameLength();
                } else {
                    slideData.setSlideDataLabels(this.getFeature(slide).getSlideDataKeys(), this.getFeature(slide).getSlideDataLabels());
                    ((FloatSlideData)slideData).setSlideFileName(this.getSampleName(slide));
                }
                for (spot = 0; spot < indices.length; ++spot) {
                    index = indices[spot];
                    sde = this.getSlideDataElement(slide, index);
                    ((FloatSlideData)slideData).setIntensities(spot, sde.getTrueIntensity(0), sde.getTrueIntensity(1));
                    ((FloatSlideData)slideData).setCurrentIntensities(spot, sde.getCurrentIntensity()[0], sde.getCurrentIntensity()[1]);
                }
            }
            slideData.setNormalizedState(normalizedState);
            data.addFeature(slideData);
            data.setDataType(this.dataType);
        }
        data.setChipAnnotation(this.getChipAnnotation());
        data.setAnnotationLoaded(this.isAnnotationLoaded());
        return data;
    }

    public MultipleArrayData getDataSubset(int[] columnIndices, int[] rowIndices) {
        ISlideMetaData metaData = (ISlideMetaData)this.featuresList.get(0);
        MultipleArrayData data = new MultipleArrayData();
        int normalizedState = this.getNormalizationState();
        if (columnIndices.length < 1 || rowIndices.length < 1) {
            return null;
        }
        for (int slide = 0; slide < columnIndices.length; ++slide) {
            ISlideDataElement sde;
            int spot;
            String name;
            ISlideData slideData;
            int slideIndex = columnIndices[slide];
            if (slideIndex == 0) {
                slideData = new SlideData();
                name = this.getSampleName(slideIndex);
                if (name.endsWith("...")) {
                    this.toggleExptNameLength();
                    slideData.setSlideDataLabels(this.getFeature(slideIndex).getSlideDataKeys(), this.getFeature(slideIndex).getSlideDataLabels());
                    ((SlideData)slideData).setSlideFileName(this.getSampleName(slideIndex));
                    this.toggleExptNameLength();
                } else {
                    slideData.setSlideDataLabels(this.getFeature(slideIndex).getSlideDataKeys(), this.getFeature(slideIndex).getSlideDataLabels());
                    ((SlideData)slideData).setSlideFileName(this.getSampleName(slideIndex));
                }
                for (spot = 0; spot < rowIndices.length; ++spot) {
                    sde = new SlideDataElement(this.getSlideDataElement(slideIndex, rowIndices[spot]));
                    slideData.addSlideDataElement(sde);
                }
                metaData = (ISlideMetaData)((Object)slideData);
                metaData.clearFieldNames();
                metaData.setFieldNames(this.getFieldNames());
            } else {
                slideData = new FloatSlideData(metaData);
                ((FloatSlideData)slideData).createCurrentIntensityArrays();
                name = this.getSampleName(slideIndex);
                if (name.endsWith("...")) {
                    this.toggleExptNameLength();
                    slideData.setSlideDataLabels(this.getFeature(slideIndex).getSlideDataKeys(), this.getFeature(slideIndex).getSlideDataLabels());
                    ((FloatSlideData)slideData).setSlideFileName(this.getSampleName(slideIndex));
                    this.toggleExptNameLength();
                } else {
                    slideData.setSlideDataLabels(this.getFeature(slideIndex).getSlideDataKeys(), this.getFeature(slideIndex).getSlideDataLabels());
                    ((FloatSlideData)slideData).setSlideFileName(this.getSampleName(slideIndex));
                }
                for (spot = 0; spot < rowIndices.length; ++spot) {
                    sde = this.getSlideDataElement(slideIndex, rowIndices[spot]);
                    ((FloatSlideData)slideData).setIntensities(spot, sde.getTrueIntensity(0), sde.getTrueIntensity(1));
                    ((FloatSlideData)slideData).setCurrentIntensities(spot, sde.getCurrentIntensity()[0], sde.getCurrentIntensity()[1]);
                }
            }
            slideData.setNormalizedState(normalizedState);
            data.addFeature(slideData);
        }
        data.setDataType(this.dataType);
        return data;
    }

    private void resetMaxValues() {
        this.setMaxCY3(0.0f);
        this.setMaxCY5(0.0f);
        this.setMaxRatio(0.0f);
        this.setMinRatio(0.0f);
    }

    private void updateMaxMinRatios(ISlideData slideData) {
        float min = this.minRatio;
        float max = this.maxRatio;
        int features = this.featuresList.size();
        int probes = ((ISlideData)this.featuresList.get(0)).getSize();
        for (int probe = 0; probe < probes; ++probe) {
            float value = slideData.getRatio(probe, this.logState);
            max = Math.max(max, value);
            min = Math.min(min, value);
        }
        this.setMaxRatio(max);
        this.setMinRatio(max);
    }

    public void toggleExptNameLength() {
        if (this.getFeaturesCount() < 1) {
            return;
        }
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            this.getFeature(i).toggleNameLength();
        }
    }

    void sort(int style) {
        SlideDataSorter sorter = new SlideDataSorter();
        if (style == 9001) {
            for (int i = 0; i < this.featuresList.size(); ++i) {
                sorter.setSlideData((ISlideData)this.featuresList.get(i));
                sorter.sort((int[])this.indicesList.get(i), style);
            }
        } else {
            if (this.featuresList.size() < 1) {
                return;
            }
            sorter.setSlideData((ISlideData)this.featuresList.get(0));
            int[] src = (int[])this.indicesList.get(0);
            sorter.sort(src, style);
            for (int i = 1; i < this.featuresList.size(); ++i) {
                int[] dst = (int[])this.indicesList.get(i);
                System.arraycopy(src, 0, dst, 0, src.length);
            }
        }
    }

    public Experiment getFullExperiment() {
        int featuresSize = this.getFeaturesCount();
        int probesSize = this.getFeaturesSize();
        int[] features = this.createDefaultFeatures(featuresSize, probesSize);
        Experiment experiment = this.createExperiment(features, probesSize);
        return experiment;
    }

    public Experiment getExperiment() {
        if (this.useMainData) {
            return this.experiment;
        }
        return this.alternateExperiment;
    }

    private void setMaxCY3(float value) {
        this.maxCy3 = value;
    }

    private void setMaxCY5(float value) {
        this.maxCy5 = value;
    }

    public float getMaxCY3() {
        return this.maxCy3;
    }

    public float getMaxCY5() {
        return this.maxCy5;
    }

    private void setMaxRatio(float value) {
        this.maxRatio = value;
    }

    private void setMinRatio(float value) {
        this.minRatio = value;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public float getMinRatio() {
        return this.minRatio;
    }

    void log2Transform() {
        Adjustment.log2Transform(this.experiment.getMatrix());
    }

    void unlog2Transform() {
        Adjustment.unlog2Transform(this.experiment.getMatrix());
    }

    void normalizeSpots() {
        Adjustment.normalizeSpots(this.experiment.getMatrix());
    }

    void divideSpotsRMS() {
        Adjustment.divideSpotsRMS(this.experiment.getMatrix());
    }

    void divideSpotsSD() {
        Adjustment.divideSpotsSD(this.experiment.getMatrix());
    }

    void divideGenesMedian() {
        Adjustment.divideGenesMedian(this.experiment.getMatrix());
    }

    void divideGenesMean() {
        Adjustment.divideGenesMean(this.experiment.getMatrix());
    }

    void meanCenterSpots() {
        Adjustment.meanCenterSpots(this.experiment.getMatrix());
    }

    void medianCenterSpots() {
        Adjustment.medianCenterSpots(this.experiment.getMatrix());
    }

    void digitalSpots() {
        Adjustment.digitalSpots(this.experiment.getMatrix());
    }

    void normalizeExperiments() {
        Adjustment.normalizeExperiments(this.experiment.getMatrix());
    }

    void divideExperimentsRMS() {
        Adjustment.divideExperimentsRMS(this.experiment.getMatrix());
    }

    void divideExperimentsSD() {
        Adjustment.divideExperimentsSD(this.experiment.getMatrix());
    }

    void meanCenterExperiments() {
        Adjustment.meanCenterExperiments(this.experiment.getMatrix());
    }

    void medianCenterExperiments() {
        Adjustment.medianCenterExperiments(this.experiment.getMatrix());
    }

    void digitalExperiments() {
        Adjustment.digitalExperiments(this.experiment.getMatrix());
    }

    void log10toLog2() {
        Adjustment.log10toLog2(this.experiment.getMatrix());
    }

    void log2toLog10() {
        Adjustment.log2toLog10(this.experiment.getMatrix());
    }

    private static float getGeneMean(float[] row) {
        float mean = 0.0f;
        for (int i = 0; i < row.length; ++i) {
            mean += row[i];
        }
        return mean / (float)row.length;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int type) {
        this.dataType = type;
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            ISlideData slideData = this.getFeature(i);
            slideData.setDataType(type);
        }
        this.logState = this.dataType == 1 || this.dataType == 2 || this.dataType == 6 ? 0 : 1;
        if (this.dataType == 2) {
            this.convertToAffy();
        }
        if (this.getFeaturesCount() > 0) {
            this.experiment = this.createExperiment();
        }
    }

    private void convertToAffy() {
        SlideData ismd = new SlideData(this.getFeature(0));
        Vector allSlideDataElements = ismd.getAllElements();
        for (int i = 0; i < allSlideDataElements.size(); ++i) {
            ISlideDataElement sde = (ISlideDataElement)allSlideDataElements.get(i);
            if (sde instanceof AffySlideDataElement) continue;
            AffySlideDataElement asde = new AffySlideDataElement(sde);
            allSlideDataElements.remove(i);
            allSlideDataElements.add(i, asde);
        }
    }

    public int[] search(AlgorithmData criteria) {
        int[] indices;
        String annot;
        int annotIndex;
        int n;
        int i;
        String[] fullFieldNames;
        AlgorithmParameters params = criteria.getParams();
        boolean geneSearch = params.getBoolean("gene-search");
        boolean caseSens = params.getBoolean("case-sensitive");
        boolean fullTerm = params.getBoolean("full-term");
        String searchTerm = params.getString("search-term");
        String upperSearchString = searchTerm.toUpperCase();
        String[] fields = criteria.getStringArray("field-names");
        boolean hit = false;
        Vector<Object> fieldIndices = new Vector<Object>();
        Vector<Integer> indexVector = new Vector<Integer>();
        Hashtable keys = new Hashtable();
        if (this.getFeaturesCount() < 1 || this.getFeaturesSize() < 1) {
            return new int[0];
        }
        if (geneSearch && this.isAnnotationLoaded()) {
            int j;
            int i2;
            fullFieldNames = this.getAllFilledAnnotationFields();
            block0: for (i = 0; i < fields.length; ++i) {
                for (int j2 = 0; j2 < fullFieldNames.length; ++j2) {
                    if (!fields[i].equals(fullFieldNames[j2])) continue;
                    fieldIndices.addElement(fullFieldNames[j2]);
                    continue block0;
                }
            }
            n = this.getFeaturesSize();
            ISlideData slide = this.getFeature(0);
            for (i2 = 0; i2 < n; ++i2) {
                hit = false;
                for (j = 0; j < fieldIndices.size(); ++j) {
                    String fieldName = (String)fieldIndices.elementAt(j);
                    String[] annotation = this.getElementAnnotation(i2, fieldName);
                    if (fullTerm) {
                        if (caseSens) {
                            if (!annotation[0].equals(searchTerm)) continue;
                            hit = true;
                            continue;
                        }
                        if (!annotation[0].equalsIgnoreCase(searchTerm)) continue;
                        hit = true;
                        break;
                    }
                    if (caseSens) {
                        if (annotation[0].indexOf(searchTerm) == -1) continue;
                        hit = true;
                        break;
                    }
                    if (annotation[0].toUpperCase().indexOf(upperSearchString) == -1) continue;
                    hit = true;
                    break;
                }
                if (!hit) continue;
                indexVector.addElement(new Integer(i2));
            }
            if (this.getFieldNames().length != 0) {
                fieldIndices.clear();
                fullFieldNames = this.getFieldNames();
                block4: for (i2 = 0; i2 < fields.length; ++i2) {
                    for (j = 0; j < fullFieldNames.length; ++j) {
                        if (!fields[i2].equals(fullFieldNames[j])) continue;
                        fieldIndices.addElement(new Integer(j));
                        continue block4;
                    }
                }
                n = this.getFeaturesSize();
                slide = this.getFeature(0);
                for (i2 = 0; i2 < n; ++i2) {
                    hit = false;
                    for (j = 0; j < fieldIndices.size(); ++j) {
                        annotIndex = (Integer)fieldIndices.elementAt(j);
                        annot = this.getElementAttribute(i2, annotIndex);
                        if (fullTerm) {
                            if (caseSens) {
                                if (!annot.equals(searchTerm)) continue;
                                hit = true;
                                continue;
                            }
                            if (!annot.equalsIgnoreCase(searchTerm)) continue;
                            hit = true;
                            break;
                        }
                        if (caseSens) {
                            if (annot.indexOf(searchTerm) == -1) continue;
                            hit = true;
                            break;
                        }
                        if (annot.toUpperCase().indexOf(upperSearchString) == -1) continue;
                        hit = true;
                        break;
                    }
                    if (!hit) continue;
                    indexVector.addElement(new Integer(i2));
                }
            }
            indices = new int[indexVector.size()];
            for (i2 = 0; i2 < indices.length; ++i2) {
                indices[i2] = (Integer)indexVector.elementAt(i2);
            }
        }
        if (geneSearch && !this.isAnnotationLoaded()) {
            int i3;
            fullFieldNames = this.getFieldNames();
            block9: for (i = 0; i < fields.length; ++i) {
                for (int j = 0; j < fullFieldNames.length; ++j) {
                    if (!fields[i].equals(fullFieldNames[j])) continue;
                    fieldIndices.addElement(new Integer(j));
                    continue block9;
                }
            }
            n = this.getFeaturesSize();
            ISlideData slide = this.getFeature(0);
            for (i3 = 0; i3 < n; ++i3) {
                hit = false;
                for (int j = 0; j < fieldIndices.size(); ++j) {
                    annotIndex = (Integer)fieldIndices.elementAt(j);
                    annot = this.getElementAttribute(i3, annotIndex);
                    if (fullTerm) {
                        if (caseSens) {
                            if (!annot.equals(searchTerm)) continue;
                            hit = true;
                            continue;
                        }
                        if (!annot.equalsIgnoreCase(searchTerm)) continue;
                        hit = true;
                        break;
                    }
                    if (caseSens) {
                        if (annot.indexOf(searchTerm) == -1) continue;
                        hit = true;
                        break;
                    }
                    if (annot.toUpperCase().indexOf(upperSearchString) == -1) continue;
                    hit = true;
                    break;
                }
                if (!hit) continue;
                indexVector.addElement(new Integer(i3));
            }
            indices = new int[indexVector.size()];
            for (i3 = 0; i3 < indices.length; ++i3) {
                indices[i3] = (Integer)indexVector.elementAt(i3);
            }
        } else {
            int i4;
            n = this.getFeaturesCount();
            for (i4 = 0; i4 < n; ++i4) {
                hit = false;
                Hashtable sampleNameHash = this.getFeature(i4).getSlideDataLabels();
                for (int j = 0; j < fields.length; ++j) {
                    annot = (String)sampleNameHash.get(fields[j]);
                    if (annot == null) continue;
                    if (fullTerm) {
                        if (caseSens) {
                            if (!annot.equals(searchTerm)) continue;
                            hit = true;
                            break;
                        }
                        if (!annot.equalsIgnoreCase(searchTerm)) continue;
                        hit = true;
                        break;
                    }
                    if (caseSens) {
                        if (annot.indexOf(searchTerm) == -1) continue;
                        hit = true;
                        break;
                    }
                    if (annot.toUpperCase().indexOf(upperSearchString) == -1) continue;
                    hit = true;
                    break;
                }
                if (!hit) continue;
                indexVector.addElement(new Integer(i4));
            }
            indices = new int[indexVector.size()];
            for (i4 = 0; i4 < indices.length; ++i4) {
                indices[i4] = (Integer)indexVector.elementAt(i4);
            }
        }
        return indices;
    }

    public String[][] getSampleAnnotationMatrix() {
        String[] s = this.getSlideNameKeyArray();
        String[][] m = new String[this.getFeaturesCount()][s.length];
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < this.getFeaturesCount(); ++j) {
                m[j][i] = this.getSampleAnnotation(j, s[i]);
            }
        }
        return m;
    }

    public String[] getAnnotationList(String fieldName, int[] indices) {
        String[] annot = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            String thisAnnot;
            annot[i] = thisAnnot = this.getElementAnnotation(indices[i], fieldName)[0];
        }
        return annot;
    }

    public String[] getAnnotationList(String fieldName) {
        int[] indices = new int[this.experiment.getNumberOfGenes()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return this.getAnnotationList(fieldName, indices);
    }

    public String getSampleAnnotation(int column, String key) {
        if (this.getFeature(0).isSampleAnnotationLoaded()) {
            return this.getFeature(column).getSampleAnnotation().getAnnotation(key);
        }
        return (String)this.getFeature(column).getSlideDataLabels().get(key);
    }

    public void setCGHCopyNumberCalculator() {
        this.copyNumberCalculator = new CGHCopyNumberCalculator(this);
    }

    public CGHCopyNumberCalculator getCGHCopyNumberCalculator() {
        return this.copyNumberCalculator;
    }

    public int getFeaturesSize(int chromosome) {
        return this.chromosomeIndices[chromosome][1] - this.chromosomeIndices[chromosome][0];
    }

    public float getCY3(int column, int row, int chromosome) {
        return this.getCY3(column, this.chromosomeIndices[chromosome][0] + row);
    }

    public float getCY5(int column, int row, int chromosome) {
        return this.getCY5(column, this.chromosomeIndices[chromosome][0] + row);
    }

    public String getElementAttribute(int row, int attr, int chromosome) {
        return this.getCloneAt(row).getName();
    }

    public int getNumChromosomes() {
        return this.chromosomeIndices.length;
    }

    public int getNumDataPointsInChrom(int chromosome) {
        return this.chromosomeIndices[chromosome][1] - this.chromosomeIndices[chromosome][0];
    }

    public int getCloneIndex(int relativeIndex, int chromosome) {
        return this.chromosomeIndices[chromosome][0] + relativeIndex;
    }

    public int getRelativeIndex(int cloneIndex, int chromosome) {
        return cloneIndex - this.chromosomeIndices[chromosome][0];
    }

    public int[][] getChromosomeIndices() {
        return this.chromosomeIndices;
    }

    public void setChromosomeIndices(int[][] chromosomeIndices) {
        this.chromosomeIndices = chromosomeIndices;
        System.out.println("Chr Indices.len : " + chromosomeIndices.length + ", " + chromosomeIndices[0].length);
    }

    public int getChromosomeStartIndex(int chromosomeIndex) {
        return this.chromosomeIndices[chromosomeIndex][0];
    }

    public void setChromosomeStartIndex(int chromosomeIndex, int val) {
        this.chromosomeIndices[chromosomeIndex][0] = val;
    }

    public int getChromosomeEndIndex(int chromosomeIndex) {
        return this.chromosomeIndices[chromosomeIndex][1];
    }

    public void setChromosomeEndIndex(int chromosomeIndex, int val) {
        this.chromosomeIndices[chromosomeIndex][1] = val;
    }

    public CGHClone getCloneAt(int index) {
        return (CGHClone)this.clones.get(index);
    }

    public CGHClone getCloneAt(int index, int chromosome) {
        return this.getCloneAt(this.getCloneIndex(index, chromosome));
    }

    public CGHClone[] getClonesWithinIndices(int stIndex, int endIndex, int chromosome) {
        CGHClone[] clones = new CGHClone[endIndex - stIndex];
        int i = 0;
        int index = stIndex;
        while (index <= endIndex) {
            clones[i] = this.getCloneAt(this.getCloneIndex(index, chromosome));
            ++index;
            ++i;
        }
        return clones;
    }

    public CGHClone[] getClonesWithinIndices(int stIndex, int endIndex, String experiment, int chromosome) {
        CGHClone[] clones = new CGHClone[endIndex - stIndex + 1];
        int exprCol = this.getExperimentIndex(experiment);
        int i = 0;
        int index = stIndex;
        while (index <= endIndex) {
            clones[i] = this.getCloneAt(this.getCloneIndex(index, chromosome - 1));
            float ratio = this.getRatio(exprCol, index, 1);
            clones[i].setRatio(ratio);
            ++index;
            ++i;
        }
        return clones;
    }

    public int getExperimentIndex(String expr) {
        ArrayList featuresList = this.getFeaturesList();
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            if (!name.equals(expr)) continue;
            return column;
        }
        return -1;
    }

    public int getNumFlankingRegions(int experimentIndex, int chromosomeIndex) {
        return ((ISlideData)this.featuresList.get(experimentIndex)).getNumFlankingRegions(chromosomeIndex);
    }

    public void setFlankingRegions(int experimentIndex, Vector[] flankingRegions) {
        ((ISlideData)this.featuresList.get(experimentIndex)).setFlankingRegions(flankingRegions);
    }

    public void setSamplesOrder(int[] samplesOrder) {
        this.samplesOrder = samplesOrder;
    }

    public int[] getSamplesOrder() {
        return this.samplesOrder;
    }

    public float getValue(int experiment, int clone, int chromosome) {
        return this.getValue(experiment, this.getCloneIndex(clone, chromosome));
    }

    public float getValue(int experiment, int clone) {
        if (this.cloneValueType == 0) {
            return this.getCopyNumberDetermination(experiment, clone);
        }
        if (this.cloneValueType == 1) {
            return this.getRatio(experiment, clone, this.logState);
        }
        if (this.cloneValueType == 2) {
            return this.getCopyNumberDeterminationByLogCloneDistribution(experiment, clone);
        }
        if (this.cloneValueType == 3) {
            return this.getCopyNumberDeterminationByThresholdOrCloneDistribution(experiment, clone);
        }
        return Float.NaN;
    }

    public int getCloneValueType() {
        return this.cloneValueType;
    }

    public void setCloneValueType(int valType) {
        this.cloneValueType = valType;
    }

    public float getLogAverageInvertedValue(int experiment, int clone) {
        if (!this.hasDyeSwap) {
            return this.getRatio(experiment, clone, 1);
        }
        float cy3Ratio = this.getCY3(experiment, clone);
        float cy5Ratio = this.getCY5(experiment, clone);
        if (cy3Ratio == -10.0f || cy5Ratio == -10.0f) {
            return Float.NaN;
        }
        if (cy3Ratio == 0.0f || cy5Ratio == 0.0f) {
            return Float.NaN;
        }
        try {
            float ratio = (float)(Arithmetic.log2((double)cy3Ratio) - Arithmetic.log2((double)cy5Ratio)) / 2.0f;
            return ratio;
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public void onCopyDeterminationChanged(ICGHCloneValueMenu menu) {
        this.cloneValueType = menu.getCloneValueType();
        System.out.println("Print onCopyDeterminationChanged().this.cloneValueType " + this.cloneValueType);
        this.copyNumberCalculator.onCopyDeterminationChanged(menu);
    }

    public int getCopyNumberDetermination(int experiment, int clone) {
        return this.copyNumberCalculator.getCopyNumberDetermination(experiment, clone);
    }

    public int getCopyNumberDetermination(int experiment, int clone, int chromosome) {
        return this.copyNumberCalculator.getCopyNumberDetermination(experiment, clone, chromosome);
    }

    public int getCopyNumberDeterminationByLogCloneDistribution(int experiment, int clone) {
        return this.copyNumberCalculator.getCopyNumberDeterminationByLogCloneDistribution(experiment, clone);
    }

    public int getCopyNumberDeterminationByThresholdOrCloneDistribution(int experiment, int clone) {
        return this.copyNumberCalculator.getCopyNumberDeterminationByThresholdOrCloneDistribution(experiment, clone);
    }

    public float getPValueByLogCloneDistribution(int experiment, int clone) {
        double ratio = this.getRatio(experiment, clone, this.logState);
        Distribution dist = this.getDistributionAt(clone);
        if (dist == null) {
            return Float.NaN;
        }
        double mean = dist.getMean();
        double sd = dist.getSd();
        double z = (ratio - mean) / sd;
        double p = Probability.normal((double)z);
        return (float)p;
    }

    public Distribution[] getCloneDistributions() {
        return this.cloneDistributions;
    }

    public void setCloneDistributions(Distribution[] cloneDistributions) {
        this.cloneDistributions = cloneDistributions;
    }

    public Distribution getDistributionAt(int index) {
        try {
            return this.cloneDistributions[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    public Experiment createExperiment(Object results) {
        if (results instanceof BacClonesExperimentParameters) {
            return this.createBacClonesExperiment((BacClonesExperimentParameters)results);
        }
        if (results instanceof GenesExperimentParameters) {
            return this.createGenesExperiment((GenesExperimentParameters)results);
        }
        if (results instanceof DataRegionsExperimentParameters) {
            return this.createDataRegionsExperiment((DataRegionsExperimentParameters)results);
        }
        return null;
    }

    private int getNumSelectedDataPoints(int[] chromosomeIndices) {
        int numBacs = 0;
        for (int i = 0; i < chromosomeIndices.length; ++i) {
            if (chromosomeIndices[i] == -1) {
                return this.getFeaturesSize();
            }
            numBacs += this.getNumDataPointsInChrom(chromosomeIndices[i]);
        }
        return numBacs;
    }

    public int[] createDefaultColumns() {
        int[] defaultCols = new int[this.getFeaturesCount()];
        for (int i = 0; i < defaultCols.length; ++i) {
            defaultCols[i] = i;
        }
        return defaultCols;
    }

    public boolean isMissingData(int row) {
        for (int col = 0; col < this.getFeaturesCount(); ++col) {
            if (!Float.isNaN(this.getRatio(row, col, this.logState))) continue;
            return true;
        }
        return false;
    }

    private CGHExperiment createBacClonesExperiment(BacClonesExperimentParameters parameters) {
        if (parameters.isIncludeMissingBacs()) {
            return this.createBacClonesExperimentAllValues(parameters);
        }
        return this.createBacClonesExperimentNoMissing(parameters);
    }

    private CGHExperiment createBacClonesExperimentAllValues(BacClonesExperimentParameters parameters) {
        int[] chromosomeIndices = parameters.getChromosomeIndices();
        int numSelectedBacs = this.getNumSelectedDataPoints(chromosomeIndices);
        if (numSelectedBacs == this.getFeaturesSize()) {
            return this.createBacClonesExperimentAllValuesAllChromosomes();
        }
        float[][] fmData = new float[numSelectedBacs][this.getFeaturesCount()];
        String[] annotations = new String[numSelectedBacs];
        int counter = 0;
        for (int chrom = 0; chrom < chromosomeIndices.length; ++chrom) {
            int chromosomeIndex = chromosomeIndices[chrom];
            for (int cloneIndex = 0; cloneIndex < this.getNumDataPointsInChrom(chromosomeIndex); ++cloneIndex) {
                for (int col = 0; col < this.getFeaturesCount(); ++col) {
                    fmData[counter][col] = this.getRatio(this.getCloneIndex(cloneIndex, chromosomeIndex), col, this.logState);
                    annotations[counter] = this.getCloneAt(cloneIndex, chromosomeIndex).getName();
                }
                ++counter;
            }
        }
        FloatMatrix fm = new FloatMatrix(fmData);
        CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
        return exp;
    }

    private CGHExperiment createBacClonesExperimentAllValuesAllChromosomes() {
        float[][] fmData = new float[this.getFeaturesSize()][this.getFeaturesCount()];
        String[] annotations = new String[this.getFeaturesSize()];
        for (int row = 0; row < this.getFeaturesSize(); ++row) {
            for (int col = 0; col < this.getFeaturesCount(); ++col) {
                fmData[row][col] = this.getRatio(row, col, this.logState);
                annotations[row] = this.getCloneAt(row).getName();
            }
        }
        FloatMatrix fm = new FloatMatrix(fmData);
        CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
        return exp;
    }

    private CGHExperiment createBacClonesExperimentNoMissing(BacClonesExperimentParameters parameters) {
        int col;
        int[] chromosomeIndices = parameters.getChromosomeIndices();
        int numSelectedBacs = this.getNumSelectedDataPoints(chromosomeIndices);
        if (numSelectedBacs == this.getFeaturesSize()) {
            return this.createBacClonesExperimentAllChromosomesNoMissing();
        }
        float[][] fmDataTmp = new float[numSelectedBacs][this.getFeaturesCount()];
        String[] annotationsTmp = new String[numSelectedBacs];
        int counter = 0;
        for (int chrom = 0; chrom < chromosomeIndices.length; ++chrom) {
            int chromosomeIndex = chromosomeIndices[chrom];
            for (int cloneIndex = 0; cloneIndex < this.getNumDataPointsInChrom(chromosomeIndex); ++cloneIndex) {
                if (this.isMissingData(this.getCloneIndex(cloneIndex, chromosomeIndex))) continue;
                for (col = 0; col < this.getFeaturesCount(); ++col) {
                    fmDataTmp[counter][col] = this.getRatio(this.getCloneIndex(cloneIndex, chromosomeIndex), col, this.logState);
                    annotationsTmp[counter] = this.getCloneAt(cloneIndex, chromosomeIndex).getName();
                }
                ++counter;
            }
        }
        float[][] fmData = new float[counter][this.getFeaturesCount()];
        String[] annotations = new String[counter];
        for (int row = 0; row < counter; ++row) {
            for (col = 0; col < this.getFeaturesCount(); ++col) {
                fmData[row][col] = fmDataTmp[row][col];
                annotations[row] = annotationsTmp[row];
            }
        }
        FloatMatrix fm = new FloatMatrix(fmData);
        CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
        return exp;
    }

    private CGHExperiment createBacClonesExperimentAllChromosomesNoMissing() {
        float[][] fmDataTmp = new float[this.getFeaturesSize()][this.getFeaturesCount()];
        String[] annotationsTmp = new String[this.getFeaturesSize()];
        int counter = 0;
        for (int row = 0; row < this.getFeaturesSize(); ++row) {
            if (this.isMissingData(row)) continue;
            for (int col = 0; col < this.getFeaturesCount(); ++col) {
                fmDataTmp[counter][col] = this.getRatio(row, col, this.logState);
                annotationsTmp[counter] = this.getCloneAt(counter).getName();
            }
            ++counter;
        }
        float[][] fmData = new float[counter][this.getFeaturesCount()];
        String[] annotations = new String[counter];
        for (int row = 0; row < counter; ++row) {
            for (int col = 0; col < this.getFeaturesCount(); ++col) {
                fmData[row][col] = fmDataTmp[row][col];
                annotations[row] = annotationsTmp[row];
            }
        }
        FloatMatrix fm = new FloatMatrix(fmData);
        CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
        return exp;
    }

    private CGHExperiment createGenesExperiment(GenesExperimentParameters parameters) {
        File genesFile = parameters.getGenesFile();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(genesFile));
            Vector<String> geneNames = new Vector<String>();
            while ((line = reader.readLine()) != null) {
                geneNames.add(line);
            }
            GeneDataSet geneDataSet = new GeneDataSet();
            geneDataSet.loadGeneDataByGeneNames(geneNames, this.getCGHSpecies());
            Vector geneData = geneDataSet.getGeneData();
            float[][] fmData = new float[geneData.size()][this.getFeaturesCount()];
            String[] annotations = new String[geneData.size()];
            for (int row = 0; row < geneData.size(); ++row) {
                for (int col = 0; col < this.getFeaturesCount(); ++col) {
                    fmData[row][col] = this.getExperimentGeneValue((IGeneData)geneData.get(row), col);
                    annotations[row] = ((IGeneData)geneData.get(row)).getName();
                }
            }
            FloatMatrix fm = new FloatMatrix(fmData);
            CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
            return exp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private float getExperimentGeneValue(IGeneData geneData, int experiment) {
        int geneStart = geneData.getStart();
        int geneEnd = geneData.getStop();
        if (geneData.getChromosomeIndex() < 0) {
            System.out.println("Gene " + geneData.getName() + " Chrom = " + geneData.getChromosomeIndex());
            return 0.0f;
        }
        ISlideData featureData = (ISlideData)this.getFeaturesList().get(experiment);
        Vector[] allFrs = featureData.getFlankingRegions();
        Vector chromFrs = allFrs[geneData.getChromosomeIndex()];
        for (FlankingRegion fr : chromFrs) {
            int frStart = fr.getStart();
            int frStop = fr.getStop();
            if ((geneStart >= frStop || geneStart <= frStart) && (geneEnd >= frStop || geneStart <= frStart)) continue;
            if (fr.getType() == 1) {
                return -1.0f;
            }
            if (fr.getType() != 0) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    private CGHExperiment createDataRegionsExperiment(DataRegionsExperimentParameters parameters) {
        int[] chromosomeIndices = parameters.getChromosomeIndices();
        Vector dataRegions = new Vector();
        dataRegions.addAll(this.getDataRegionsValues(1, chromosomeIndices));
        dataRegions.addAll(this.getDataRegionsValues(0, chromosomeIndices));
        float[][] fmData = new float[dataRegions.size()][this.getFeaturesCount()];
        String[] annotations = new String[dataRegions.size()];
        for (int row = 0; row < fmData.length; ++row) {
            fmData[row] = ((AlterationRegion)dataRegions.get(row)).getAlteredExperimentValues();
            annotations[row] = ((AlterationRegion)dataRegions.get(row)).getName();
        }
        FloatMatrix fm = new FloatMatrix(fmData);
        CGHExperiment exp = new CGHExperiment(fm, this.createDefaultColumns(), annotations);
        return exp;
    }

    public Vector getDataRegionsValues(int flankingRegionType, int[] chromosomeIndices) {
        Vector allAlterationRegions = new Vector();
        for (int curChrom = 0; curChrom < chromosomeIndices.length; ++curChrom) {
            int chromIndex = chromosomeIndices[curChrom];
            AlterationRegions curAlterationRegions = new AlterationRegions(chromIndex);
            Vector<Object> curFlankingRegions = new Vector<Object>(this.getFeaturesCount());
            Iterator featuresIt = this.getFeaturesList().iterator();
            while (featuresIt.hasNext()) {
                Vector curFrs = ((ISlideData)featuresIt.next()).getFlankingRegions()[chromIndex];
                curFlankingRegions.add(curFrs.clone());
            }
            int[] indices = new int[this.getFeaturesCount()];
            for (int i = 0; i < this.getFeaturesCount(); ++i) {
                indices[i] = 0;
            }
            boolean more = true;
            while (more) {
                Vector expRegions;
                int i;
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    Vector expRegions2 = (Vector)curFlankingRegions.get(i2);
                    while (indices[i2] < expRegions2.size() && ((FlankingRegion)expRegions2.get(indices[i2])).getType() != flankingRegionType) {
                        int n = i2;
                        indices[n] = indices[n] + 1;
                    }
                }
                int minStartIndex = this.getMinStartIndex(curFlankingRegions, indices);
                int minEndIndex = this.getMinEndIndex(curFlankingRegions, indices, minStartIndex);
                for (i = 0; i < indices.length; ++i) {
                    expRegions = (Vector)curFlankingRegions.get(i);
                    if (indices[i] >= expRegions.size()) continue;
                    FlankingRegion fr = (FlankingRegion)expRegions.get(indices[i]);
                    int start = fr.getStart();
                    int stop = fr.getStop();
                    if (start != minStartIndex) continue;
                    AlterationRegion curAlterationRegion = curAlterationRegions.getAlterationRegion(minStartIndex, minEndIndex, flankingRegionType, this.getFeaturesCount());
                    curAlterationRegion.incrementAlterations();
                    curAlterationRegion.getAlteredExperimentValues()[i] = flankingRegionType == 0 ? 1.0f : -1.0f;
                    if (stop == minEndIndex) {
                        int n = i;
                        indices[n] = indices[n] + 1;
                        continue;
                    }
                    FlankingRegion tmp = new FlankingRegion(minEndIndex, fr.getStop(), flankingRegionType, chromIndex);
                    expRegions.set(indices[i], tmp);
                }
                more = false;
                for (i = 0; i < indices.length; ++i) {
                    expRegions = (Vector)curFlankingRegions.get(i);
                    if (indices[i] >= expRegions.size()) continue;
                    more = true;
                }
            }
            allAlterationRegions.addAll(curAlterationRegions.getAlterationRegions());
        }
        Collections.sort(allAlterationRegions, new AlterationRegionsComparator());
        return allAlterationRegions;
    }

    private int getMinStartIndex(Vector flankingRegions, int[] indices) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            Vector expRegions = (Vector)flankingRegions.get(i);
            if (indices[i] >= expRegions.size()) continue;
            min = Math.min(min, ((FlankingRegion)expRegions.get(indices[i])).getStart());
        }
        return min;
    }

    private int getMinEndIndex(Vector flankingRegions, int[] indices, int minStartIndex) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < indices.length; ++i) {
            Vector expRegions = (Vector)flankingRegions.get(i);
            if (indices[i] >= expRegions.size()) continue;
            int start = ((FlankingRegion)expRegions.get(indices[i])).getStart();
            if (start == minStartIndex) {
                start = ((FlankingRegion)expRegions.get(indices[i])).getStop();
            }
            min = Math.min(min, start);
        }
        return min;
    }

    public ArrayList getClones() {
        return this.clones;
    }

    public void setClones(ArrayList clones) {
        this.clones = clones;
    }

    public ICGHDataRegion[][] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ICGHDataRegion[][] annotations) {
        this.annotations = annotations;
    }

    public boolean isHasDyeSwap() {
        return this.hasDyeSwap;
    }

    public void setHasDyeSwap(boolean hasDyeSwap) {
        this.hasDyeSwap = hasDyeSwap;
        this.copyNumberCalculator = hasDyeSwap ? new CGHCopyNumberCalculator(this) : new CGHCopyNumberCalculatorNoDyeSwap(this);
    }

    public void setCGHData() {
        this.CGHData = true;
    }

    public boolean isCGHData() {
        return this.CGHData;
    }

    public void setLog2Data(boolean isLog2) {
        this.log2Data = isLog2;
    }

    public boolean isLog2Data() {
        return this.log2Data;
    }

    public void setCGHSpecies(int species) {
        this.CGH_SPECIES = species == 0 ? 0 : (species == 1 ? 1 : -100);
    }

    public int getCGHSpecies() {
        return this.CGH_SPECIES;
    }

    public void setHasCloneDistribution(boolean cloneDistribution) {
        this.hasCloneDistribution = cloneDistribution;
    }

    public boolean hasCloneDistribution() {
        return this.hasCloneDistribution;
    }

    public float getChromWidth(int chr) {
        float width = 0.0f;
        int st = this.getChromosomeStartIndex(chr - 1);
        int end = this.getChromosomeEndIndex(chr - 1);
        width = this.getCloneAt(end).getStop() - this.getCloneAt(st).getStart();
        return width;
    }

    public String getCurrentSampleLabelKey() {
        return ((ISlideData)this.featuresList.get(0)).getSampleLabelKey();
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new MultipleArrayDataPersistenceDelegate();
    }

    public ClusterRepository getExperimentClusterRepository() {
        return this.expClusterRepository;
    }

    public ClusterRepository getGeneClusterRepository() {
        return this.geneClusterRepository;
    }

    public MultipleArrayData(boolean useMainData) {
        this.useMainData = useMainData;
    }

    public Experiment getAltExperiment() {
        return this.alternateExperiment;
    }

    public ArrayList getExperimentColorsSaved() {
        return this.experimentColors;
    }

    public float getMaxCy3() {
        return this.maxCy3;
    }

    public void setMaxCy3(float maxCy3) {
        this.maxCy3 = maxCy3;
    }

    public float getMaxCy5() {
        return this.maxCy5;
    }

    public void setMaxCy5(float maxCy5) {
        this.maxCy5 = maxCy5;
    }

    public boolean isAnnotationLoaded() {
        return this.mads.isAnnotationLoaded();
    }

    public void setAnnotationLoaded(boolean isAnnotationLoaded) {
        this.mads.setAnnotationLoaded(isAnnotationLoaded);
    }

    public boolean isSampleAnnotationLoaded() {
        return this.mads.isSampleAnnotationLoaded;
    }

    public void setSampleAnnotationLoaded(boolean isAnnLoaded) {
        this.mads.setSampleAnnotationLoaded(isAnnLoaded);
    }

    public MageIDF getIDFObject() {
        return this.mads.getMageIDFObject();
    }

    public void setIDF(MageIDF idfObj) {
        this.IDFObject = idfObj;
        this.mads.setMageIDFObject(idfObj);
    }

    private class NormalizationListener
    extends DialogListener {
        private NormalizationListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                MultipleArrayData.this.normalizationAbort = true;
                MultipleArrayData.this.progressBar.dispose();
            }
        }

        public void windowClosing(WindowEvent e) {
            MultipleArrayData.this.normalizationAbort = true;
            MultipleArrayData.this.progressBar.dispose();
        }
    }

    private class Normalizer {
        Properties properties;
        int mode;
        int size;
        MultipleArrayViewer viewer;

        public Normalizer(int mode, Properties properties, int size, MultipleArrayViewer viewer) {
            this.mode = mode;
            this.properties = properties;
            this.size = size;
            this.viewer = viewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runNormalization() {
            try {
                ISlideData slideData;
                int feature;
                MultipleArrayData.this.normalizationAbort = false;
                MultipleArrayData.this.progressBar = new Progress(new Frame(), "Normalization Progress", (DialogListener)new NormalizationListener());
                MultipleArrayData.this.progressBar.show();
                MultipleArrayData.this.progressBar.setUnits(this.size);
                MultipleArrayData.this.progressBar.setValue(0);
                for (feature = 0; feature < this.size; ++feature) {
                    MultipleArrayData.this.progressBar.setValue(feature);
                    MultipleArrayData.this.progressBar.setDescription("Normalizing Experiment " + Integer.toString(feature));
                    MultipleArrayData.this.progressBar.repaint();
                    slideData = MultipleArrayData.this.getFeature(feature);
                    if (MultipleArrayData.this.normalizationAbort) break;
                    slideData.applyNormalization(this.mode, this.properties);
                    this.viewer.fireDataChanged();
                    MultipleArrayData.this.updateMaxValues(slideData);
                }
                if (MultipleArrayData.this.normalizationAbort) {
                    MultipleArrayData.this.progressBar.setVisible(false);
                    MultipleArrayData.this.progressBar.dispose();
                    for (feature = 0; feature < this.size; ++feature) {
                        slideData = MultipleArrayData.this.getFeature(feature);
                        slideData.applyNormalization(0, this.properties);
                        MultipleArrayData.this.updateMaxValues(slideData);
                    }
                }
                MultipleArrayData.this.progressBar.dispose();
            }
            catch (Exception exception) {}
        }
    }
}

