/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayHeader;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.Thumbnail;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class MultipleArrayCanvas
extends JPanel
implements IViewer,
Scrollable {
    private static final int TRACE_SPACE = 50;
    private static final int GREENRED = 2;
    private static final int OVERLAY = 3;
    private static final int RATIOSPLIT = 4;
    private MultipleArrayHeader header;
    private Thumbnail thumbnail;
    private boolean isShowThumbnail = false;
    private IFramework framework;
    private IData data;
    private Insets insets;
    private int maxLabelWidth = 0;
    private boolean useDoubleGradient = true;
    private int paletteStyle = 4;
    private boolean isGRScale = true;
    private boolean isDrawBorders;
    private boolean isTracing;
    private boolean isAntiAliasing = true;
    private Dimension elementSize = new Dimension();
    private int labelIndex = -1;
    private boolean drawChain = false;
    private int[] chain;
    private int features;
    private int probes;
    private float maxCY3;
    private float maxCY5;
    private float maxRatio;
    private float minRatio;
    private float midRatio;
    public static Color missingColor = Color.gray;
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private int xOffset = 10;
    private JPopupMenu popup;
    private JMenu sortMenu;
    private ButtonGroup sortGroup;
    private Listener listener;
    private boolean oneValueData;
    private JRadioButtonMenuItem expressionBarItem;
    private JRadioButtonMenuItem overlayItem;
    private JCheckBoxMenuItem absoluteColorCheckBoxItem;
    private JLabel emptyMacLabel;
    private String emptyMacLabelText = "";
    private String userFont;

    public MultipleArrayCanvas() {
    }

    public MultipleArrayCanvas(IFramework framework, Insets insets) {
        this.framework = framework;
        this.setBackground(Color.white);
        this.insets = insets;
        this.header = new MultipleArrayHeader(insets, 50);
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.thumbnail = new Thumbnail(framework, this.listener);
        this.negColorImage = framework.getDisplayMenu().getNegativeGradientImage();
        this.posColorImage = framework.getDisplayMenu().getPositiveGradientImage();
        this.header.setNegativeAndPositiveColorImages(this.negColorImage, this.posColorImage);
        this.popup = this.createPopupMenu(this.listener);
    }

    private void setDefaultLabel() {
        if (this.emptyMacLabel == null) {
            this.emptyMacLabelText = this.framework.isGaggleConnected() ? "Use the File menu to load data from text files or a saved analysis file, or broadcast a matrix from the Gaggle network." : "Use the File menu to load data from text files or a saved analysis file. Use the Utilities menu to connect to the Gaggle network";
            this.emptyMacLabel = new JLabel(this.emptyMacLabelText);
        }
        this.add(this.emptyMacLabel);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        if (this.data != null && this.data.getDataType() == 1 || this.data.getDataType() == 2 || this.data.getDataType() == 6) {
            this.expressionBarItem.setEnabled(false);
            this.overlayItem.setEnabled(false);
        }
        IDisplayMenu menu = framework.getDisplayMenu();
        this.setUserFont(menu.getUserFont());
        this.header.setUserFont(menu.getUserFont());
        this.setUserFontSize(menu.getUserFontSize());
        this.header.setUserFontSize(menu.getUserFontSize());
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.maxCY3 = menu.getMaxCY3Scale();
        this.maxCY5 = menu.getMaxCY5Scale();
        this.maxRatio = menu.getMaxRatioScale();
        this.minRatio = menu.getMinRatioScale();
        this.midRatio = menu.getMidRatioValue();
        this.header.setMinAndMaxAndMidRatios(this.minRatio, this.midRatio, this.maxRatio);
        this.header.setData(this.data);
        this.onMenuChanged(menu);
        this.onDataChanged(this.data);
        if (this.isShowThumbnail) {
            this.thumbnail.show();
        }
    }

    public void onDataChanged(IData data) {
        this.data = data;
        if (data == null || data.getFeaturesSize() <= 0) {
            this.probes = 0;
            this.features = 0;
            this.setDefaultLabel();
            this.thumbnail.onDataChanged(data);
        } else {
            if (this.emptyMacLabel != null) {
                this.remove(this.emptyMacLabel);
            }
            this.features = data.getFeaturesCount();
            this.probes = data.getFeaturesSize();
            this.setDrawChain(false);
            this.updateSize();
            this.header.setData(data);
            this.thumbnail.onDataChanged(data);
        }
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.isDrawBorders = menu.isDrawingBorder();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        Dimension newSize = menu.getElementSize();
        this.elementSize = new Dimension(newSize);
        this.setUserFont(menu.getUserFont());
        this.header.setUserFont(menu.getUserFont());
        this.setUserFontSize(menu.getUserFontSize());
        this.header.setUserFontSize(menu.getUserFontSize());
        this.maxCY3 = menu.getMaxCY3Scale();
        this.maxCY5 = menu.getMaxCY5Scale();
        this.maxRatio = menu.getMaxRatioScale();
        this.minRatio = menu.getMinRatioScale();
        this.midRatio = menu.getMidRatioValue();
        this.header.setMinAndMaxAndMidRatios(this.minRatio, this.midRatio, this.maxRatio);
        this.negColorImage = menu.getNegativeGradientImage();
        this.posColorImage = menu.getPositiveGradientImage();
        this.header.setNegativeAndPositiveColorImages(this.negColorImage, this.posColorImage);
        this.updateSize();
        this.isAntiAliasing = menu.isAntiAliasing();
        this.labelIndex = menu.getLabelIndex();
        this.setFont(new Font(this.userFont, 0, this.elementSize.height));
        this.updateSize();
        this.header.setTracing(this.isTracing);
        this.header.setElementWidth(this.elementSize.width);
        this.thumbnail.onMenuChanged(menu);
    }

    private void setUserFontSize(int userFontSize) {
    }

    public void onDeselected() {
        this.thumbnail.hide();
    }

    private void setUserFont(String font) {
        this.userFont = font;
    }

    public void onClosed() {
        this.thumbnail.dispose();
    }

    public void onShowThumbnail() {
        this.isShowThumbnail = true;
        this.thumbnail.show();
    }

    public boolean isThumbnailEnabled() {
        return this.data.getFeaturesCount() > 0;
    }

    public BufferedImage getImage() {
        return null;
    }

    private void updateSize() {
        this.updateMaxLabelWidth();
        int width = this.insets.left + this.getXSize() + this.insets.right + this.getMaxLabelWidth() + 20;
        int height = this.insets.top + this.getYSize() + this.insets.bottom;
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.header.setContentWidth(this.getSize().width);
    }

    @Override
    public void paint(Graphics g1D) {
        g1D.setColor(Color.white);
        super.paint(g1D);
        if (this.elementSize.getHeight() < 1.0) {
            return;
        }
        g1D.setColor(Color.black);
        if (this.features == 0 || this.framework == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawColumns(g2D);
    }

    private void drawColumns(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.probes);
        int left = this.getLeftIndex(bounds.x);
        int right = this.getRightIndex(bounds.x + bounds.width, this.features);
        for (int column = left; column < right; ++column) {
            this.drawColumn(g, column, top, bottom);
        }
        if (this.isDrawChain()) {
            this.drawChain(g, Color.magenta, this.getChain(), left, right);
        }
        if (right >= this.features && this.labelIndex >= 0) {
            this.drawLabels(g, top, bottom);
        }
    }

    private void drawColumn(Graphics2D g, int column, int top, int bottom) {
        int[] indices = this.data.getSortedIndices(column);
        for (int row = top; row < bottom; ++row) {
            this.drawSlideDataElement(g, row, column, indices);
        }
    }

    private boolean isMissingValue(int row, int column) {
        boolean missing = false;
        FloatMatrix matrix = this.data.getExperiment().getMatrix();
        if (Float.isNaN(matrix.get(row, column))) {
            missing = true;
        }
        return missing;
    }

    private void drawSlideDataElement(Graphics g, int row, int column, int[] indices) {
        float cy3 = this.data.getCY3(column, indices[row]);
        float cy5 = this.data.getCY5(column, indices[row]);
        switch (this.paletteStyle) {
            case 3: {
                int x = this.insets.left + column * (this.elementSize.width + this.getSpacing());
                int y = this.insets.top + row * this.elementSize.height;
                Color color = this.getOverlayColor(cy3, cy5);
                g.setColor(color);
                g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
                break;
            }
            case 4: {
                float ratio = this.data.getRatio(column, indices[row], 1);
                g.setColor(this.getColor(ratio));
                g.fillRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, this.elementSize.width, this.elementSize.height);
                break;
            }
            case 2: {
                if (cy3 <= 0.0f && cy5 <= 0.0f) {
                    g.setColor(missingColor);
                    g.fillRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, this.elementSize.width, this.elementSize.height);
                    break;
                }
                int adjust = (int)((float)this.elementSize.width * cy3 / (cy3 + cy5));
                g.setColor(this.getNegativeColor(cy3));
                g.fillRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, adjust, this.elementSize.height);
                g.setColor(this.getPositiveColor(cy5));
                g.fillRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()) + adjust, this.insets.top + row * this.elementSize.height, this.elementSize.width - adjust, this.elementSize.height);
            }
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(this.getXPos(column), this.getYPos(row) + this.insets.top, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midRatio ? this.minRatio : this.maxRatio;
            int colorIndex = (int)(255.0f * (value - this.midRatio) / (maximum - this.midRatio));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midRatio ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxRatio - this.minRatio;
            int colorIndex = value <= this.minRatio ? 0 : (value >= this.maxRatio ? 255 : (int)((value - this.minRatio) / span * 255.0f));
            rgb = this.posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    private Color getNegativeColor(float cy3) {
        float fraction = cy3 / this.maxCY3;
        int rgb = 0;
        int colorIndex = (int)(255.0f * cy3 / this.maxCY3);
        colorIndex = Math.min(colorIndex, 255);
        rgb = this.isGRScale ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.negColorImage.getRGB(0, 0);
        return new Color(rgb);
    }

    private Color getPositiveColor(float cy5) {
        float fraction = cy5 / this.maxCY3;
        int rgb = 0;
        int colorIndex = (int)(255.0f * cy5 / this.maxCY5);
        colorIndex = Math.min(colorIndex, 255);
        rgb = this.isGRScale ? this.posColorImage.getRGB(colorIndex, 0) : this.posColorImage.getRGB(255, 0);
        return new Color(rgb);
    }

    private Color getOverlayColor(float cy3, float cy5) {
        Color negColor = this.getNegativeColor(cy3);
        Color posColor = this.getPositiveColor(cy5);
        double negFraction = cy3 / (cy3 + cy5);
        double posFraction = cy5 / (cy3 + cy5);
        int r = negColor.getRed() + posColor.getRed();
        r = r < 256 ? r : 255;
        int g = negColor.getGreen() + posColor.getGreen();
        g = g < 256 ? g : 255;
        int b = negColor.getBlue() + posColor.getBlue();
        b = b < 256 ? b : 255;
        return new Color(r, g, b);
    }

    private BufferedImage getOverlayImage(float cy3, float cy5) {
        Color negColor = this.getNegativeColor(cy3);
        Color posColor = this.getPositiveColor(cy5);
        BufferedImage bi = new BufferedImage(this.elementSize.width, this.elementSize.height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2.setColor(negColor);
        g2.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        g2.setColor(posColor);
        g2.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        return bi;
    }

    private void setDrawChain(boolean drawChain) {
        this.drawChain = drawChain;
        this.repaint();
    }

    private boolean isDrawChain() {
        return this.drawChain;
    }

    private void setChain(int[] chain) {
        this.chain = chain;
    }

    private void doChain(int row, int column) {
        this.setChain(this.createChain(row, column));
    }

    private int[] getChain() {
        return this.chain;
    }

    private int[] createChain(int row, int column) {
        int[] indices = this.data.getSortedIndices(column);
        int trueColumn = this.data.getProbeColumn(column, indices[row]);
        int trueRow = this.data.getProbeRow(column, indices[row]);
        int[] positions = new int[this.data.getFeaturesCount()];
        int size = this.data.getFeaturesSize();
        block0: for (int feature = 0; feature < positions.length; ++feature) {
            if (feature == column) {
                positions[column] = row;
                continue;
            }
            indices = this.data.getSortedIndices(feature);
            for (int probe = 0; probe < size; ++probe) {
                if (this.data.getProbeColumn(feature, indices[probe]) != trueColumn || this.data.getProbeRow(feature, indices[probe]) != trueRow) continue;
                positions[feature] = probe;
                continue block0;
            }
        }
        return positions;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return 50;
        }
        return 0;
    }

    private int getXSize() {
        return this.features * this.elementSize.width + (this.features - 1) * this.getSpacing();
    }

    private int getYSize() {
        return this.probes * this.elementSize.height;
    }

    private void updateMaxLabelWidth() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        if (this.labelIndex < 0) {
            this.maxLabelWidth = fm.stringWidth("");
            return;
        }
        double maxWidth = 0.0;
        int SIZE = this.data.getFeaturesSize();
        for (int i = 0; i < SIZE; ++i) {
            String label;
            if (this.data.getFieldNames().length > 0 && this.labelIndex > this.data.getFieldNames().length - 1) {
                String prefix = "Label by ";
                String attr = this.getMenuLabel(this.labelIndex).substring(prefix.length()).trim();
                String[] _temp = this.data.getElementAnnotation(i, attr);
                label = _temp.length > 1 ? this.data.getElementAnnotationObject(i, attr).toString() : _temp[0];
            } else {
                label = this.data.getElementAttribute(i, this.labelIndex);
            }
            maxWidth = Math.max(maxWidth, (double)fm.stringWidth(label));
        }
        this.maxLabelWidth = (int)maxWidth;
    }

    private int getMaxLabelWidth() {
        return this.maxLabelWidth;
    }

    private void drawLabels(Graphics2D g, int top, int bottom) {
        g.setColor(Color.black);
        int[] indices = this.data.getSortedIndices(0);
        if (this.labelIndex > this.data.getFieldNames().length - 1 && this.data.getFieldNames().length > 0) {
            for (int probe = top; probe < bottom; ++probe) {
                String prefix = "Label by ";
                String attr = this.getMenuLabel(this.labelIndex).substring(prefix.length()).trim();
                String[] _temp = this.data.getElementAnnotation(indices[probe], attr);
                String label = _temp.length > 1 ? this.data.getElementAnnotation(indices[probe], attr)[0] : _temp[0];
                if (label == null) continue;
                g.drawString(label, this.insets.left + this.getXSize() + this.insets.right, this.insets.top + (probe + 1) * this.elementSize.height - 1);
            }
        } else {
            for (int probe = top; probe < bottom; ++probe) {
                String label = this.data.getElementAttribute(indices[probe], this.labelIndex);
                if (label == null) continue;
                g.drawString(label, this.insets.left + this.getXSize() + this.insets.right, this.insets.top + (probe + 1) * this.elementSize.height - 1);
            }
        }
    }

    private String[] getMenuLabels() {
        MultipleArrayMenubar menuBar = (MultipleArrayMenubar)this.framework.getJFrame().getJMenuBar();
        String[] labels = menuBar.getLabelMenuItems();
        return labels;
    }

    private String getMenuLabel(int index) {
        return this.getMenuLabels()[index];
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < this.insets.left) {
            return 0;
        }
        return (left - this.insets.left) / (this.elementSize.width + this.getSpacing());
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = right / (this.elementSize.width + this.getSpacing()) + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    private void drawLink(Graphics2D g, int row1, int col1, int row2, int col2, Color color) {
        double yPos1 = (double)row1 + 0.5;
        double yPos2 = (double)row2 + 0.5;
        g.setColor(color);
        g.drawLine(this.insets.left + this.elementSize.width + col1 * (this.elementSize.width + this.getSpacing()), this.insets.top + (int)(yPos1 * (double)this.elementSize.height), this.insets.left + col2 * (this.elementSize.width + this.getSpacing()) - 1, this.insets.top + (int)(yPos2 * (double)this.elementSize.height));
    }

    private float getGreenValue(float cy3) {
        if (this.isGRScale) {
            float color = Math.abs(cy3 / this.maxCY3);
            return color > 1.0f ? 1.0f : color;
        }
        if (cy3 == 0.0f) {
            return 0.0f;
        }
        return 1.0f;
    }

    private float getRedValue(float cy5) {
        if (this.isGRScale) {
            float color = Math.abs(cy5 / this.maxCY5);
            return color > 1.0f ? 1.0f : color;
        }
        if (cy5 == 0.0f) {
            return 0.0f;
        }
        return 1.0f;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.features - 1;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.probes - 1;
    }

    private int findColumn(int targetx) {
        int columnSize = this.elementSize.width + this.getSpacing();
        if (targetx >= this.features * columnSize - this.getSpacing() + this.insets.left || targetx < this.insets.left) {
            return -1;
        }
        return (targetx - this.insets.left) / columnSize;
    }

    private int findRow(int targety) {
        int ySize = this.probes * this.elementSize.height;
        if ((targety -= this.insets.top) >= ySize || targety < 0) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private int getXPos(int column) {
        return column * (this.elementSize.width + this.getSpacing()) + this.insets.left;
    }

    private int getYPos(int row) {
        return row * this.elementSize.height;
    }

    private void drawColoredBoxAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        g.drawRect(this.insets.left + column * (this.elementSize.width + this.getSpacing()), this.insets.top + row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawChain(Graphics2D g, Color color, int[] chain, int left, int right) {
        for (int column = left; column < right; ++column) {
            this.drawColoredBoxAt(g, chain[column], column, color);
        }
        int last = right == chain.length ? right - 1 : right;
        for (int column = left; column < last; ++column) {
            this.drawLink(g, chain[column], column, chain[column + 1], column + 1, color);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int i) {
    }

    public int getExperimentID() {
        return 0;
    }

    public int getViewerType() {
        return -1;
    }

    private JPopupMenu createPopupMenu(Listener listener) {
        JPopupMenu menu = new JPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem("Color Gradient View", true);
        buttonGroup.add(item);
        item.setActionCommand("palette 4");
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        this.expressionBarItem = new JRadioButtonMenuItem("Expression Bar View");
        buttonGroup.add(this.expressionBarItem);
        this.expressionBarItem.setActionCommand("palette 2");
        this.expressionBarItem.addActionListener(listener);
        menu.add(this.expressionBarItem);
        this.absoluteColorCheckBoxItem = new JCheckBoxMenuItem("Use Absolute Bar Colors", true);
        this.absoluteColorCheckBoxItem.setActionCommand("use-absolute-bar-colors");
        this.absoluteColorCheckBoxItem.setEnabled(false);
        this.absoluteColorCheckBoxItem.addActionListener(listener);
        menu.add(this.absoluteColorCheckBoxItem);
        menu.addSeparator();
        this.overlayItem = new JRadioButtonMenuItem("Color Overlay View");
        buttonGroup.add(this.overlayItem);
        this.overlayItem.setActionCommand("palette 3");
        this.overlayItem.addActionListener(listener);
        menu.add(this.overlayItem);
        menu.addSeparator();
        this.sortGroup = new ButtonGroup();
        this.sortMenu = new JMenu("Sort Main View");
        item = new JRadioButtonMenuItem("Restore Load Order");
        item.addActionListener(listener);
        item.setActionCommand("sort 9000");
        this.sortGroup.add(item);
        this.sortMenu.add(item);
        item = new JRadioButtonMenuItem("Sort by Ratio");
        item.addActionListener(listener);
        item.setActionCommand("sort 9001");
        this.sortGroup.add(item);
        this.sortMenu.add(item);
        ((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(0)).setSelected(true);
        if (this.data != null && this.data.getFieldNames() != null) {
            this.addSortMenuItems(this.data.getFieldNames());
        }
        menu.add(this.sortMenu);
        return menu;
    }

    private JMenuItem createJMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setActionCommand((String)action.getValue("ActionCommandKey"));
        return item;
    }

    private JMenuItem createJMenuItem(String name, String command, ActionListener listener) {
        JMenuItem item = new JMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, ActionListener listener, boolean isSelected) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        return item;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String command, ActionListener listener) {
        return this.createJCheckBoxMenuItem(name, command, listener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, ActionListener listener, ButtonGroup buttonGroup, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        item.setSelected(isSelected);
        if (buttonGroup != null) {
            buttonGroup.add(item);
        }
        return item;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String command, ActionListener listener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(name, command, listener, buttonGroup, false);
    }

    public void addSortMenuItems(String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Sort by " + fieldNames[i]);
            item.setActionCommand("sort " + Integer.toString(i));
            item.addActionListener(this.listener);
            this.sortGroup.add(item);
            this.sortMenu.add(item);
        }
    }

    private void onSort(int style) {
        if (this.data instanceof MultipleArrayData) {
            ((MultipleArrayData)this.data).sort(style);
        }
        this.onDataChanged(this.data);
    }

    public Expression getExpression() {
        return null;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        JViewport viewport = null;
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            viewport = (JViewport)parent;
        }
        if (viewport != null) {
            int prefHeight = this.getPreferredSize().height;
            int viewportHeight = viewport.getSize().height;
            return prefHeight < viewportHeight;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        JViewport viewport = null;
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            viewport = (JViewport)parent;
        }
        if (viewport != null) {
            int prefWidth = this.getPreferredSize().width;
            int viewportWidth = viewport.getSize().width;
            return prefWidth < viewportWidth;
        }
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int orientation, int direction) {
        Insets insets;
        Container parent = this.getParent();
        JViewport viewport = null;
        if (parent != null && parent instanceof JViewport) {
            viewport = (JViewport)parent;
        }
        if ((insets = this.getInsets()) == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int returnVal = orientation == 0 ? (viewport != null ? viewport.getSize().width - insets.left - insets.right : 1) : (viewport != null ? viewport.getSize().height - insets.top - insets.bottom : 1);
        return returnVal;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int orientation, int direction) {
        int returnVal = orientation == 0 ? this.elementSize.width : this.elementSize.height;
        return returnVal;
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener,
    WindowListener,
    ActionListener {
        private int oldRow = -1;
        private int oldColumn = -1;

        @Override
        public void mousePressed(MouseEvent event) {
            MultipleArrayCanvas.this.requestFocus();
            if (event.isPopupTrigger()) {
                MultipleArrayCanvas.this.popup.show(MultipleArrayCanvas.this, event.getX(), event.getY());
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = MultipleArrayCanvas.this.findColumn(event.getX());
            int row = MultipleArrayCanvas.this.findRow(event.getY());
            if (!MultipleArrayCanvas.this.isLegalPosition(row, column)) {
                return;
            }
            if (!event.isShiftDown()) {
                int[] indices = MultipleArrayCanvas.this.data.getSortedIndices(column);
                MultipleArrayCanvas.this.framework.displaySlideElementInfo(column, indices[row]);
                return;
            }
            MultipleArrayCanvas.this.doChain(row, column);
            MultipleArrayCanvas.this.setDrawChain(true);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (MultipleArrayCanvas.this.features == 0 || event.isShiftDown()) {
                return;
            }
            int column = MultipleArrayCanvas.this.findColumn(event.getX());
            int row = MultipleArrayCanvas.this.findRow(event.getY());
            if (this.isCurrentPosition(row, column)) {
                return;
            }
            Graphics g = null;
            if (MultipleArrayCanvas.this.isLegalPosition(row, column)) {
                g = MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawColoredBoxAt(g, row, column, Color.white);
            }
            if (MultipleArrayCanvas.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g = g != null ? g : MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawSlideDataElement(g, this.oldRow, this.oldColumn, MultipleArrayCanvas.this.data.getSortedIndices(this.oldColumn));
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                MultipleArrayCanvas.this.popup.show(MultipleArrayCanvas.this, event.getX(), event.getY());
                return;
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (MultipleArrayCanvas.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawSlideDataElement(g, this.oldRow, this.oldColumn, MultipleArrayCanvas.this.data.getSortedIndices(this.oldColumn));
                g.dispose();
            }
            this.setOldPosition(-1, -1);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (event.getKeyCode() == 16 && MultipleArrayCanvas.this.isDrawChain()) {
                MultipleArrayCanvas.this.setDrawChain(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MultipleArrayCanvas.this.isShowThumbnail = false;
            MultipleArrayCanvas.this.thumbnail.hide();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String command = actionEvent.getActionCommand();
            if (command.indexOf("sort") != -1) {
                String indexString = command.substring(5);
                MultipleArrayCanvas.this.onSort(Integer.parseInt(indexString));
            } else if (command.indexOf("palette") != -1) {
                MultipleArrayCanvas.this.paletteStyle = Integer.parseInt(command.substring(8));
                if (MultipleArrayCanvas.this.paletteStyle == 2) {
                    MultipleArrayCanvas.this.absoluteColorCheckBoxItem.setEnabled(true);
                    MultipleArrayCanvas.this.isGRScale = !MultipleArrayCanvas.this.absoluteColorCheckBoxItem.isSelected();
                } else {
                    MultipleArrayCanvas.this.isGRScale = true;
                    MultipleArrayCanvas.this.absoluteColorCheckBoxItem.setEnabled(false);
                }
                MultipleArrayCanvas.this.repaint();
            } else if (command.equals("use-absolute-bar-colors")) {
                MultipleArrayCanvas.this.isGRScale = !MultipleArrayCanvas.this.absoluteColorCheckBoxItem.isSelected();
                MultipleArrayCanvas.this.repaint();
            }
        }
    }
}

